/*************************************************************************
 *
 *  $RCSfile: basapp.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <baspch.hxx>

#pragma hdrstop

#include <sfxiiter.hxx>
#include <basapp.hxx>
#include <basapp.hrc>

#include <basicide.hxx>
#include <basicide.hrc>
#include <basicsh.hxx>

#include <basic.hxx>
#include <basrdll.hxx>

#include <sfxitems.hxx>
#include <srchitem.hxx>

#include <editdll.hxx>

BasicIDEApplication aBasicIDEApplication;

#define SFX_TYPEMAP
#define BasicIDEApplication
#include <basappsl.hxx>

SFX_IMPL_INTERFACE( BasicIDEApplication, SfxApplication, ResId(0,NULL) )
{
}

BasicIDEApplication::BasicIDEApplication() : SfxApplication( "IDE", SFX_FEATURE_BASIC_IDE )
{
//	pVCBrowser = 0;
	pBasicIDE = 0;
}

BasicIDEApplication::~BasicIDEApplication()
{
}

void BasicIDEApplication::Main( int nArgs, char*pArgs[] )
{
	EditDLL			aEditDll;
	SiDLL		 	aSiDLL;
	BasicDLL     	aBasicDLL;
	BasicIDEDLL	 	aIDEDLL;
	SvxDialogDll 	aDlgDll;

	SetAppName( "IDETest" );
	SetName( "IDETest" );
//	aSiDLL.SetURLHdl( LINK(this, BasicIDEApplication, URLButtonHdl ));

	String aResMgrName( "ide" );
	aResMgrName += String( SOLARUPD );
	ResMgr* pDefResMgr = ResMgr::CreateResMgr(
		aResMgrName, GetpApp()->GetAppInternational().GetLanguage() );
	Resource::SetResManager( pDefResMgr );


	SfxApplication::Main( nArgs, pArgs );

	Resource::SetResManager( 0 );

	delete pDefResMgr;
}

void BasicIDEApplication::Execute( SfxRequest& rReq )
{
	switch( rReq.GetSlot() )
	{
		case SID_NEWDOCDIRECT:
		{
			if ( !pBasicIDE->IsCreated() )
			{
				pBasicIDE->Create();
			}
			else
				InfoBox( 0, "Es kann nur eine geben..." ).Execute();
		}
		break;
		case SID_BASICIDE_CHOOSEMACRO:
		{
			BasicIDE::ChooseMacro();
		}
		break;
//		case SID_SEARCHANDREPLACE:
//		{
//			SFX_DISPATCHER().Execute( SID_SEARCH_DLG );
//		}
//		break;
		case SID_BASICIDE_CHOOSEMACROONLY:
		{
			BasicIDE::ChooseMacro( FALSE, TRUE );
		}
		break;
		case SID_BASICIDE_APPEAR:
		{
			pBasicIDE->Create();
			pBasicIDE->Appear();
		}
		break;
/*
		case SID_SHOW_BROWSER:
		{
			BOOL bBrwThere = FALSE;

			if( !pVCBrowser )
			{
				pVCBrowser = new SvxVCBrowser( GetAppWindow() );

//!!!!!!!!!!!!!! HACK
				GetAppWindow()->SetData( pVCBrowser );

				// Jetzt noch schoen positionieren
				Point aAppPos = GetAppWindow()->GetPosPixel();
				Size  aAppSize= GetAppWindow()->GetSizePixel();
				Size  aBrwSize= pVCBrowser->GetSizePixel();

				// Mittig am rechten Rand des App-Windows
				Point aPos;
				aPos.X() = aAppPos.X() + aAppSize.Width() -
						   aBrwSize.Width() - 20;
				aPos.Y() = aAppPos.Y() + (aAppSize.Height()>>1) -
						   (aBrwSize.Height()>>1);

				if( aPos.X() < 20 )
					aPos.X() = 20;
				if( aPos.Y() < 20 )
					aPos.Y() = 20;

				pVCBrowser->SetPosPixel( aPos );

				pVCBrowser->Show();

				SfxViewShell* pShell = SfxViewShell::Current();

				if( pShell && pShell->IsA( TYPE( BasicIDEShell )) )
					pVCBrowser->Update( ((BasicIDEShell*)pShell)->GetCurDlgView() );
			}
			else
			{
				delete pVCBrowser;
				pVCBrowser = NULL;

//!!!!!!!!!!!!!! HACK
				GetAppWindow()->SetData( NULL );
			}

			rReq.Done();
		}
		break;
*/
		default:
		break;
	}
}

void BasicIDEApplication::GetState(SfxItemSet &rSet)
{
	SfxWhichIter aIter(rSet);
	for ( USHORT nWh = aIter.FirstWhich(); 0 != nWh; nWh = aIter.NextWhich() )
	{
		switch ( nWh )
		{
			case SID_SEARCH_ITEM:
			{
				InfoBox( 0, String( "SID_SEARCH_ITEM" ) ).Execute();
				rSet.Put( SvxSearchItem( SID_SEARCH_ITEM ) );
			}
			break;
			case SID_SHOW_BROWSER:
			{
//				rSet.Put( SfxBoolItem( SID_SHOW_BROWSER, pVCBrowser ? TRUE : FALSE ) );
			}
			break;
		}
	}
}

StatusBar* BasicIDEApplication::CreateStatusBar()
{
	StatusBar* pStatusBar = new StatusBar(GetAppWindow(), WinBits(WB_BORDER|WB_SVLOOK) );
	pStatusBar->InsertItem( SID_CONTEXT, pStatusBar->GetTextSize(
		String().Fill( 64, 'x' ) ).Width() );
	pStatusBar->InsertItem( SID_MOUSEPOS, pStatusBar->GetTextSize(
		String("9999:9999") ).Width() );
	pStatusBar->InsertItem( SID_CURRENTTIME, pStatusBar->GetTextSize(
		String("::") + pApp->GetAppInternational().GetTime( Time() ) ).Width() );
	pStatusBar->InsertItem( SID_CURRENTDATE, pStatusBar->GetTextSize(
		String("::") + pApp->GetAppInternational().GetDate( Date() ) ).Width() );
	return pStatusBar;
}

void BasicIDEApplication::Init( int nArgs, char* pArgs[] )
{
	BasicIDEApplication::RegisterInterface();
	pBasicIDE = new BasicIDE;

	TbxControls::RegisterControl( SID_CHOOSE_CONTROLS );
	SvxSearchDialogWrapper::RegisterChildWindow();

}

void BasicIDEApplication::Exit()
{
//	delete pVCBrowser;
	delete pBasicIDE;

//!!!!!!!!!!!!!! HACK
	GetAppWindow()->SetData( NULL );
}

SfxMacro* BasicIDEApplication::CreateMacro() const
{
	return BasicIDE::CreateMacro();
	return 0;
}




