/*************************************************************************
 *
 *  $RCSfile: msocximex.hxx,v $
 *
 *  $Revision: 1.8.206.3 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/09 12:46:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MSOCXIMEX_HXX
#define _MSOCXIMEX_HXX

#ifndef _SVSTOR_HXX
#include <so3/svstor.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#include <vector>
#ifndef C2U
#define C2U(cChar)	rtl::OUString::createFromAscii(cChar)
#endif

namespace com{namespace sun{namespace star{
        namespace drawing{
                class XDrawPage;
                class XShape;
                class XShapes;
        }
        namespace form{
                class XFormComponent;
        }
        namespace lang{
                class XMultiServiceFactory;
        }
        namespace container{
                class XIndexContainer;
                class XNameContainer;
        }
        namespace beans{
                class XPropertySet;
        }
        namespace text{
                class XText;
        }
        namespace awt{
                struct Size;
				class XControlModel;
        }
        namespace uno{
                class XComponentContext;
        }

}}}

class OCX_Control;
class SfxObjectShell;
class SwPaM;

class TypeName
{
public:
    String msName;
    sal_uInt16 mnType;
    sal_Int32 mnLeft;
    sal_Int32 mnTop;
    TypeName(sal_Char *pName, sal_uInt32 nLen, sal_uInt16 nType,
        sal_Int32 nLeft, sal_Int32 nTop);
};


class SvxMSConvertOCXControls
{
public:
    SvxMSConvertOCXControls( SfxObjectShell *pDSh,SwPaM *pP );

	//Reads a control from the given storage, constructed shape in pShapeRef
	sal_Bool ReadOCXStream( SvStorageRef& rSrc1,
		com::sun::star::uno::Reference<
		com::sun::star::drawing::XShape > *pShapeRef=0,
		BOOL bFloatingCtrl=false );


	//Excel has a nasty kludged mechanism for this, read
	//the comments in the source to follow it
	sal_Bool ReadOCXExcelKludgeStream(SvStorageStreamRef& rSrc1,
		com::sun::star::uno::Reference <
		com::sun::star::drawing::XShape > *pShapeRef,BOOL bFloatingCtrl);


	//Writes the given Uno Control into the given storage

	static sal_Bool WriteOCXStream(SvStorageRef &rSrc1,
		const com::sun::star::uno::Reference<
		com::sun::star::awt::XControlModel > &rControlModel,
		const com::sun::star::awt::Size& rSize,String &rName);

	//Excel has a nasty kludged mechanism for this, read
	//the comments in the source to follow it
	static sal_Bool WriteOCXExcelKludgeStream(SvStorageStreamRef& rContents,
		const com::sun::star::uno::Reference<
		com::sun::star::awt::XControlModel > &rControlModel,
		const com::sun::star::awt::Size &rSize, String &rName);

	//Generate an OCX converter based on the OLE2 name
	static OCX_Control *OCX_Factory(const String &rId);

	//Generate an OCX converter based on the StarOffice UNO id
	static OCX_Control *OCX_Factory( const com::sun::star::uno::Reference<
		com::sun::star::awt::XControlModel > &rControlModel,
		String &rId,String &rName);

	virtual sal_Bool InsertControl(
		const com::sun::star::uno::Reference<
		com::sun::star::form::XFormComponent > &rFComp,
		const com::sun::star::awt::Size& rSize,
		com::sun::star::uno::Reference<
		com::sun::star::drawing::XShape > *pShape,

		BOOL bFloatingCtrl ) {return sal_False;}

	/*begin: Backwards compatability with office 95 import, modify later*/
	const com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory > & GetServiceFactory();

	sal_uInt16 GetEditNum() { return ++nEdit; }
	sal_uInt16 GetCheckboxNum() { return ++nCheckbox; }
	/*end: Backwards compatability*/
protected:
	const com::sun::star::uno::Reference< com::sun::star::drawing::XShapes > &
		GetShapes();

	const com::sun::star::uno::Reference<
		com::sun::star::container::XIndexContainer > & 	GetFormComps();

	SfxObjectShell *pDocSh;
	SwPaM *pPaM;

	// gecachte Interfaces
	com::sun::star::uno::Reference< com::sun::star::drawing::XDrawPage >
		xDrawPage;
	com::sun::star::uno::Reference< com::sun::star::drawing::XShapes >
		xShapes;
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > 		xServiceFactory;

	// das einzige Formular
	com::sun::star::uno::Reference< com::sun::star::container::XIndexContainer >
		xFormComps;

	sal_uInt16 nEdit;
	sal_uInt16 nCheckbox;

	virtual const com::sun::star::uno::Reference<
		com::sun::star::drawing::XDrawPage > & GetDrawPage();
};

class OCX_FontData
{
public:
	OCX_FontData() : nFontNameLen(0), fBold(0), fItalic(0), fUnderline(0),
		fStrike(0), nFontSize(12), nJustification(1), pFontName(0),
        bHasAlign(false), bHasFont(true) {}
	~OCX_FontData()
    {
		if (pFontName)
		delete [] pFontName;
	}
	sal_Bool Read(SvStorageStream *pS);
	void Import(com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet > &rPropSet);

	sal_Bool Export(SvStorageStreamRef &rContent,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet);

	sal_uInt16 nIdentifier;
	sal_uInt16 nFixedAreaLen;
	sal_uInt8 pBlockFlags[4];

	sal_uInt32 nFontNameLen;

	sal_uInt8   fBold:1;
	sal_uInt8   fItalic:1;
	sal_uInt8   fUnderline:1;
	sal_uInt8   fStrike:1;
	sal_uInt8   fUnknown1:4;

	sal_uInt8   nUnknown2;
	sal_uInt8   nUnknown3;
	sal_uInt8   nUnknown4;

	sal_uInt32  nFontSize;
	sal_uInt16 nLanguageID;
	sal_uInt8   nJustification;
    sal_uInt16  nFontWeight;

	char *pFontName;
	void SetHasAlign(sal_Bool bIn) {bHasAlign=bIn;}
	void SetHasFont(sal_Bool bIn) {bHasFont=bIn;}
protected:
	static sal_uInt16 nStandardId;
	sal_uInt8 ExportAlign(sal_Int16 nAlign) const;
	sal_Int16 ImportAlign(sal_uInt8 nJustification) const;
private:
	sal_Bool bHasAlign;
	sal_Bool bHasFont;
};

class OCX_Control
{
public:
	OCX_Control(UniString sN) : sName(sN), bSetInDialog(false) {}
	sal_Bool FullRead(SvStorageStream *pS)
	{
        bool bRead = Read(pS);
        bool bReadFontData = ReadFontData(pS);
        return bRead && bReadFontData;
	};
	virtual sal_Bool Read(SvStorageStream *pS);
    virtual sal_Bool ReadFontData(SvStorageStream *pS);
    // --> OD 2005-04-18 #i39439# - method has to be virtual - as it was till
    // changes for issue #110008# -, because it's overloaded in the WW8 filter
    virtual sal_Bool Import(const com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >  &rServiceFactory,
		com::sun::star::uno::Reference<
		com::sun::star::form::XFormComponent > &rFComp,
		com::sun::star::awt::Size &rSz);
	sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::container::XNameContainer>
        &rDialog, const TypeName& rItem);
	virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet)
    {return sal_False;}


	//Export exports a control as an OLE style storage stream tree
	virtual sal_Bool Export(SvStorageRef &rObj,
	const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize) {return sal_False;}

	//WriteContents writes the contents of a contents stream, for
	//the Excel export you cannot use Export, only WriteContents instead
	virtual sal_Bool WriteContents(SvStorageStreamRef &rObj,
	const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize) {return sal_False;}

    void SetInDialog(bool bState) { bSetInDialog = bState; }
    bool GetInDialog() { return bSetInDialog; }

	sal_Bool ReadAndImport(SvStorageStream *pS,
		com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >  &rSF,
		com::sun::star::uno::Reference<
		com::sun::star::form::XFormComponent > &rFComp,
		com::sun::star::awt::Size &rSz)
	{
		if (Read(pS))
			return Import(rSF,rFComp,rSz);
		return sal_False;
	}
	virtual ~OCX_Control();

    static void FillSystemColors();

	sal_uInt32 nWidth;
	sal_uInt32 nHeight;
	UniString sName;
	OCX_FontData aFontData;
protected:
	sal_uInt32 ImportColor(sal_uInt32 nColorCode) const;
	sal_uInt32 ExportColor(sal_uInt32 nColorCode) const;
	sal_uInt32 SwapColor(sal_uInt32 nColorCode) const;
	sal_Int16 ImportBorder(sal_uInt16 nSpecialEffect,sal_uInt16 nBorderStyle)
		const;
	sal_uInt8 ExportBorder(sal_uInt16 nBorder,sal_uInt8 &rBorderStyle) const;
    bool bSetInDialog;
	static sal_uInt16 nStandardId;
	static sal_uInt8 __READONLY_DATA aObjInfo[4];
    rtl::OUString msFormType;
    rtl::OUString msDialogType;
private:
	static sal_uInt32 pColor[25];
};

class OCX_ModernControl : public OCX_Control
{
public:
	OCX_ModernControl(UniString sN) : OCX_Control(sN),
	fEnabled(1), fLocked(0), fBackStyle(1), fColumnHeads(0), fIntegralHeight(1),
	fMatchRequired(0), fAlignment(1), fDragBehaviour(0), fEnterKeyBehaviour(0),
	fEnterFieldBehaviour(0), fTabKeyBehaviour(0), fWordWrap(1),
	fSelectionMargin(1), fAutoWordSelect(1), fAutoSize(0), fHideSelection(1),
	fAutoTab(0), fMultiLine(1), nMaxLength(0), nBorderStyle(1), nScrollBars(0),
	nStyle(0), nMousePointer(0), nPasswordChar(0), nListWidth(0),
    nBoundColumn(1), nTextColumn(-1), nColumnCount(1), nListRows(8),
    nMatchEntry(2), nListStyle(0), nShowDropButtonWhen(0), nDropButtonStyle(1),
    nMultiState(0), nValueLen(0), nCaptionLen(0), nVertPos(1), nHorzPos(7),
	nSpecialEffect(2), nIcon(0), nPicture(0), nAccelerator(0), nGroupNameLen(0),
	pValue(0), pCaption(0), pGroupName(0), nIconLen(0), pIcon(0),
    nPictureLen(0), pPicture(0) {}

	virtual ~OCX_ModernControl();
	sal_Bool Read(SvStorageStream *pS);

	/*sal_uInt8 for sal_uInt8 Word Struct*/
	sal_uInt16  nIdentifier;
	sal_uInt16 	nFixedAreaLen;
	sal_uInt8	pBlockFlags[8];

	sal_uInt8	fUnknown1:1;
	sal_uInt8	fEnabled:1;
	sal_uInt8	fLocked:1;
	sal_uInt8	fBackStyle:1;
	sal_uInt8	fUnknown2:4;

	sal_uInt8	fUnknown3:2;
	sal_uInt8	fColumnHeads:1;
	sal_uInt8	fIntegralHeight:1;
	sal_uInt8	fMatchRequired:1;
	sal_uInt8	fAlignment:1;
	sal_uInt8	fUnknown4:2;

	sal_uInt8	fUnknown5:3;
	sal_uInt8	fDragBehaviour:1;
	sal_uInt8	fEnterKeyBehaviour:1;
	sal_uInt8	fEnterFieldBehaviour:1;
	sal_uInt8	fTabKeyBehaviour:1;
	sal_uInt8	fWordWrap:1;

	sal_uInt8	fUnknown6:2;
	sal_uInt8	fSelectionMargin:1;
	sal_uInt8	fAutoWordSelect:1;
	sal_uInt8	fAutoSize:1;
	sal_uInt8	fHideSelection:1;
	sal_uInt8	fAutoTab:1;
	sal_uInt8	fMultiLine:1;

	sal_uInt32	nBackColor;
	sal_uInt32	nForeColor;
	sal_uInt32 	nMaxLength;
	sal_uInt8	nBorderStyle;
	sal_uInt8	nScrollBars;
	sal_uInt8	nStyle;
	sal_uInt8	nMousePointer;
	sal_uInt8	nUnknown7;
	sal_uInt8	nPasswordChar;
	sal_uInt32	nListWidth;
	sal_uInt16	nBoundColumn;
	sal_Int16	nTextColumn;
	sal_uInt16	nColumnCount;
	sal_uInt16	nListRows;
	sal_uInt16	nUnknown8;
	sal_uInt8	nMatchEntry;
	sal_uInt8	nListStyle;
	sal_uInt8	nShowDropButtonWhen;
	sal_uInt8	nDropButtonStyle;
	sal_uInt8	nMultiState;
	sal_uInt32	nValueLen;
	sal_uInt32	nCaptionLen;

	sal_uInt16 nVertPos;
	sal_uInt16 nHorzPos;

	sal_uInt32 nBorderColor;
	sal_uInt8 nSpecialEffect;
	sal_uInt16 nIcon;
	sal_uInt16 nPicture;
	sal_uInt8 nAccelerator;
	sal_uInt8 nUnknown9;
	sal_uInt32 nGroupNameLen;
	sal_uInt32 nUnknown10;

	char *pValue;
	char *pCaption;
	char *pGroupName;

	sal_uInt8 pIconHeader[20];
	sal_uInt32 nIconLen;
	sal_uInt8 *pIcon;

	sal_uInt8 pPictureHeader[20];
	sal_uInt32 nPictureLen;
	sal_uInt8 *pPicture;
};

class OCX_Image : public OCX_Control
{
public:
	OCX_Image() : OCX_Control(C2U("Image")) {}

	/*sal_uInt8 for sal_uInt8 Word Struct*/
	sal_uInt16	nIdentifier;
	sal_uInt16	nFixedAreaLen;
	sal_uInt8	pBlockFlags[4];

	sal_uInt32	nBackColor;
	sal_uInt8	nBorderStyle;
	sal_uInt16	nSpecialEffect;

	//sal_uInt8	?
	sal_uInt8	fEnabled:1;
	//sal_uInt8	?


	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	static OCX_Control *Create() { return new OCX_Image;}
};

class OCX_UserForm : public OCX_Control
{
public:
    OCX_UserForm(const rtl::OUString &rName) :
    OCX_Control(C2U("UserForm")), nForeColor(0x80000012),
    nBackColor(0x8000000F), nChildrenA(0), fEnabled(1), fLocked(0),
    fBackStyle(1), fWordWrap(1), fAutoSize(0), nCaptionLen(0), nVertPos(1),
    nHorzPos(7), nMousePointer(0), nBorderColor(0x80000012), nChildrenB(0),
    nKeepScrollBarsVisible(3), nCycle(0), nBorderStyle(0), nSpecialEffect(0),
    nPicture(0), nPictureAlignment(2), nPictureSizeMode(0),
    bPictureTiling(false), nAccelerator(0), nIcon(0), pCaption(0),
    nScrollWidth(0), nScrollHeight(0), nIconLen(0), pIcon(0), nPictureLen(0),
    pPicture(0), nNoRecords(0), nTotalLen(0), msModName(rName)
    {
        aFontData.SetHasAlign(true);
    }

	~OCX_UserForm()
    {
		delete[] pCaption;
		delete[] pIcon;
		delete[] pPicture;
	}
	virtual sal_Bool Read(SvStorageStream *pS);
	sal_Bool Import(SvStorageStream *pS,
        const com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >  &rServiceFactory,
        com::sun::star::uno::Reference<
        com::sun::star::uno::XComponentContext> &rContext,
        com::sun::star::uno::Reference<
        com::sun::star::container::XNameContainer> &rLib);

	/*sal_uInt8 for sal_uInt8 Word Struct*/
	sal_uInt16 nIdentifier;
	sal_uInt16 nFixedAreaLen;
	sal_uInt8	pBlockFlags[4];

	sal_uInt32	nForeColor;
	sal_uInt32	nBackColor;
    sal_uInt32  nChildrenA;

	sal_uInt8	fUnknown1:1;
	sal_uInt8	fEnabled:1;
	sal_uInt8	fLocked:1;
	sal_uInt8	fBackStyle:1;
	sal_uInt8	fUnknown2:4;

	sal_uInt8	fUnknown3:8;

	sal_uInt8	fUnknown4:7;
	sal_uInt8	fWordWrap:1;

	sal_uInt8	fUnknown5:4;
	sal_uInt8	fAutoSize:1;
	sal_uInt8	fUnknown6:3;

	sal_uInt32	nCaptionLen;
	sal_uInt16  nVertPos;
	sal_uInt16  nHorzPos;
	sal_uInt8 	nMousePointer;
	sal_uInt32	nBorderColor;
    sal_uInt32  nDrawBuffer;
    sal_uInt32  nChildrenB;
    sal_uInt8   nKeepScrollBarsVisible;
    sal_uInt8   nCycle;
	sal_uInt16	nBorderStyle;
	sal_uInt16	nSpecialEffect;
	sal_uInt16	nPicture;
    sal_uInt8   nPictureAlignment;
    sal_uInt8   nPictureSizeMode;
    bool        bPictureTiling;
	sal_uInt16	nAccelerator;
	sal_uInt16	nIcon;

	char *pCaption;

	sal_uInt32 	nScrollWidth;
	sal_uInt32 	nScrollHeight;


	sal_uInt8 pIconHeader[20];
	sal_uInt32  nIconLen;
	sal_uInt8 *pIcon;

	sal_uInt8 pPictureHeader[20];
	sal_uInt32  nPictureLen;
    sal_uInt8 *pPicture;

    sal_uInt32 nNoRecords;
    sal_uInt32 nTotalLen;

    rtl::OUString msModName;

    com::sun::star::uno::Reference<com::sun::star::container::XNameContainer>
        Import(const com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory > &rServiceFactory);
private:
    std::vector<TypeName> maEntries;
};

class OCX_CheckBox : public OCX_ModernControl
{
public:
	OCX_CheckBox() : OCX_ModernControl(C2U("CheckBox"))
    {
        msFormType = C2U("com.sun.star.form.component.CheckBox");
        msDialogType = C2U("com.sun.star.awt.UnoControlCheckBoxModel");
		nBackColor = 0x00FFFFFF;
		nForeColor = 0x00000000;
	}
    virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	static OCX_Control *Create() { return new OCX_CheckBox;}
};

class OCX_OptionButton : public OCX_ModernControl
{
public:
	OCX_OptionButton() : OCX_ModernControl(C2U("OptionButton"))
	{
        msFormType = C2U("com.sun.star.form.component.RadioButton");
        msDialogType = C2U("com.sun.star.awt.UnoControlRadioButtonModel");
		nBackColor =  0x00FFFFFF;
		nForeColor =  0x00000000;
	}
    virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);

	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);


	static OCX_Control *Create() { return new OCX_OptionButton;}
};

class OCX_TextBox : public OCX_ModernControl
{
public:
	OCX_TextBox() : OCX_ModernControl(C2U("TextBox"))
    {
        msFormType = C2U("com.sun.star.form.component.TextField");
        msDialogType = C2U("com.sun.star.awt.UnoControlEditModel");
		nBackColor = 0x80000005L;
		nForeColor = 0x80000008L;
		nBorderColor = 0x80000006L;
		aFontData.SetHasAlign(true);
	}

    virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);

	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	static OCX_Control *Create() { return new OCX_TextBox;}
};

class OCX_FieldControl: public OCX_ModernControl
{
public:
	OCX_FieldControl() : OCX_ModernControl(C2U("TextBox")) {
		nBackColor = 0x80000005L;
		nForeColor = 0x80000008L;
		nBorderColor = 0x80000006L;
	}
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	static OCX_Control *Create() { return new OCX_FieldControl;}
};


class OCX_ToggleButton : public OCX_ModernControl
{
public:
	OCX_ToggleButton() : OCX_ModernControl(C2U("ToggleButton"))
    {
        msFormType = C2U("com.sun.star.form.component.CheckBox");
        msDialogType = C2U("com.sun.star.awt.UnoControlCheckBoxModel");
		nBackColor = 0x8000000F;
		nForeColor = 0x80000012;
	}
	static OCX_Control *Create() { return new OCX_ToggleButton;}

    virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);
};

class OCX_ComboBox : public OCX_ModernControl
{
public:
	OCX_ComboBox() : OCX_ModernControl(C2U("ComboBox"))
    {
        msFormType = C2U("com.sun.star.form.component.ComboBox");
        msDialogType = C2U("com.sun.star.awt.UnoControlComboBoxModel");
		nBackColor = 0x80000005;
		nForeColor = 0x80000008;
		nBorderColor = 0x80000006;
	}
	static OCX_Control *Create() { return new OCX_ComboBox;}
    virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
};

class OCX_ListBox : public OCX_ModernControl
{
public:
	OCX_ListBox() : OCX_ModernControl(C2U("ListBox"))
    {
        msFormType = C2U("com.sun.star.form.component.ListBox");
        msDialogType = C2U("com.sun.star.awt.UnoControlListBoxModel");
		nBackColor = 0x80000005;
		nForeColor = 0x80000008;
		nBorderColor = 0x80000006;
	}
	static OCX_Control *Create() { return new OCX_ListBox;}
    virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);

};

class OCX_CommandButton : public OCX_Control
{
public:
	OCX_CommandButton() : OCX_Control(String::CreateFromAscii("CommandButton")),
	nForeColor(0x80000012L), nBackColor(0x8000000FL), fEnabled(1), fLocked(0),
	fBackStyle(1), fWordWrap(1), fAutoSize(0), nCaptionLen(0), nVertPos(1),
    nHorzPos(7), nMousePointer(0), nPicture(0), nAccelerator(0), nIcon(0),
    pCaption(0), nIconLen(0), pIcon(0), nPictureLen(0), pPicture(0)
	{
        msFormType = C2U("com.sun.star.form.component.CommandButton");
        msDialogType = C2U("com.sun.star.awt.UnoControlButtonModel");
    }

	~OCX_CommandButton()
    {
		delete[] pCaption;
		delete[] pIcon;
		delete[] pPicture;
	}
	sal_Bool Read(SvStorageStream *pS);

	/*sal_uInt8 for sal_uInt8 Word Struct*/
	sal_uInt16	nIdentifier;
	sal_uInt16	nFixedAreaLen;
	sal_uInt8	pBlockFlags[4];

	sal_uInt32	nForeColor;
	sal_uInt32	nBackColor;

	sal_uInt8	fUnknown1:1;
	sal_uInt8	fEnabled:1;
	sal_uInt8	fLocked:1;
	sal_uInt8	fBackStyle:1;
	sal_uInt8	fUnknown2:4;

	sal_uInt8	fUnknown3:8;

	sal_uInt8	fUnknown4:7;
	sal_uInt8	fWordWrap:1;

	sal_uInt8	fUnknown5:4;
	sal_uInt8	fAutoSize:1;
	sal_uInt8	fUnknown6:3;

	sal_uInt32	nCaptionLen;

	sal_uInt16  nVertPos;
	sal_uInt16  nHorzPos;

	sal_uInt16 	nMousePointer;
	sal_uInt16	nPicture;
	sal_uInt16	nAccelerator;
	sal_uInt16	nIcon;

	char *pCaption;

	sal_uInt8 pIconHeader[20];
	sal_uInt32  nIconLen;
	sal_uInt8 *pIcon;

	sal_uInt8 pPictureHeader[20];
	sal_uInt32  nPictureLen;
	sal_uInt8 *pPicture;

	static OCX_Control *Create() { return new OCX_CommandButton;}

	virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);
    
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);

};

class OCX_ImageButton: public OCX_CommandButton
{
public:
	OCX_ImageButton() 
    {
		aFontData.SetHasAlign(false);
		aFontData.SetHasFont(false);
	}
	static OCX_Control *Create() { return new OCX_ImageButton;}
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);

};

class OCX_GroupBox: public OCX_Control
{
public:
	OCX_GroupBox() : OCX_Control(String::CreateFromAscii("GroupBox")) {}
	static OCX_Control *Create() { return new OCX_GroupBox;}
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);

};

class OCX_Label : public OCX_Control
{
public:
	OCX_Label() : OCX_Control(C2U("Label")), 
    nForeColor(0), nBackColor(0x8000000F), fEnabled(1), fLocked(0), 
    fBackStyle(1),fWordWrap(1), fAutoSize(0), nCaptionLen(0), nVertPos(1), 
    nHorzPos(7),nMousePointer(0), nBorderColor(0x80000006), nBorderStyle(0),
    nSpecialEffect(0), nPicture(0), nAccelerator(0), nIcon(0), pCaption(0),
    nIconLen(0), pIcon(0), nPictureLen(0), pPicture(0) 
    { 
        msFormType = C2U("com.sun.star.form.component.FixedText");
        msDialogType = C2U("com.sun.star.awt.UnoControlFixedTextModel");
        aFontData.SetHasAlign(true); 
    }

	~OCX_Label() 
    {
		delete[] pCaption;
		delete[] pIcon;
		delete[] pPicture;
	}
	sal_Bool Read(SvStorageStream *pS);

	/*sal_uInt8 for sal_uInt8 Word Struct*/
	sal_uInt16 nIdentifier;
	sal_uInt16 nFixedAreaLen;
	sal_uInt8	pBlockFlags[4];

	sal_uInt32	nForeColor;
	sal_uInt32	nBackColor;

	sal_uInt8	fUnknown1:1;
	sal_uInt8	fEnabled:1;
	sal_uInt8	fLocked:1;
	sal_uInt8	fBackStyle:1;
	sal_uInt8	fUnknown2:4;

	sal_uInt8	fUnknown3:8;

	sal_uInt8	fUnknown4:7;
	sal_uInt8	fWordWrap:1;

	sal_uInt8	fUnknown5:4;
	sal_uInt8	fAutoSize:1;
	sal_uInt8	fUnknown6:3;

	sal_uInt32	nCaptionLen;
	sal_uInt16  nVertPos;
	sal_uInt16  nHorzPos;
	sal_uInt8 	nMousePointer;
	sal_uInt32	nBorderColor;
	sal_uInt16	nBorderStyle;
	sal_uInt16	nSpecialEffect;
	sal_uInt16	nPicture;
	sal_uInt16	nAccelerator;
	sal_uInt16	nIcon;

	char *pCaption;

	sal_uInt8 pIconHeader[20];
	sal_uInt32  nIconLen;
	sal_uInt8 *pIcon;

	sal_uInt8 pPictureHeader[20];
	sal_uInt32  nPictureLen;
	sal_uInt8 *pPicture;

	static OCX_Control *Create() { return new OCX_Label;}

	virtual sal_Bool Import(com::sun::star::uno::Reference<
        com::sun::star::beans::XPropertySet> &rPropSet);
    
	sal_Bool Export(SvStorageRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);
	sal_Bool WriteContents(SvStorageStreamRef &rObj,
		const com::sun::star::uno::Reference<
		com::sun::star::beans::XPropertySet> &rPropSet,
		const com::sun::star::awt::Size& rSize);

};
#endif

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
