/*************************************************************************
 *
 *  $RCSfile: colrctrl.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: cl $ $Date: 2002/12/02 16:37:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_COLRCTRL_HXX
#define _SVX_COLRCTRL_HXX

#ifndef _SFXDOCKWIN_HXX //autogen
#include <sfx2/dockwin.hxx>
#endif
#ifndef _SFX_CHILDWIN_HXX //autogen
#include <sfx2/childwin.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

class XColorTable;
class SvData;

/*************************************************************************
|*
|* SvxColorValueSet
|*
\************************************************************************/

class SvxColorValueSet : public ValueSet, public DragSourceHelper
{
private:

	BOOL			bLeft;
	Point           aDragPosPixel;

protected:

	void            DoDrag();

	// ValueSet
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void    Command(const CommandEvent& rCEvt );

	// DragSourceHelper
	virtual void	StartDrag( sal_Int8 nAction, const Point& rPtPixel );

					DECL_STATIC_LINK(SvxColorValueSet, ExecDragHdl, void*);

public:
					SvxColorValueSet( Window* pParent, WinBits nWinStyle = WB_ITEMBORDER );
					SvxColorValueSet( Window* pParent, const ResId& rResId );

	BOOL			IsLeftButton() const { return bLeft; }
};

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Controller
|*
\************************************************************************/

class SvxColorChildWindow : public SfxChildWindow
{
 public:
	SvxColorChildWindow( Window*, USHORT, SfxBindings*,
						 SfxChildWinInfo* );

	SFX_DECL_CHILDWINDOW(SvxColorChildWindow);
};


/*************************************************************************
|*
|* SvxColorDockingWindow
|*
\************************************************************************/

class SvxColorDockingWindow : public SfxDockingWindow, public SfxListener
{
 friend class SvxColorChildWindow;

private:
	XColorTable*		pColorTable;
	SvxColorValueSet	aColorSet;
	USHORT				nLeftSlot;
	USHORT				nRightSlot;
	USHORT				nCols;
	USHORT				nLines;
	long				nCount;
	Size				aColorSize;
	Size				aItemSize;

#if _SOLAR__PRIVATE
	void				FillValueSet();
	void 				SetSize();
						DECL_LINK( SelectHdl, void * );

    /** This function is called when the window gets the focus.  It grabs
        the focus to the color value set so that it can be controlled with
        the keyboard.
    */
	virtual void GetFocus (void);
#endif


protected:
	virtual BOOL	Close();
	virtual void	Resize();
	virtual void	Resizing( Size& rSize );


public:
					SvxColorDockingWindow( SfxBindings* pBindings,
										   SfxChildWindow *pCW,
										   Window* pParent,
										   const ResId& rResId );
					~SvxColorDockingWindow();

	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							const SfxHint& rHint, const TypeId& rHintType );

	void			SetSlotIDs( USHORT nLeft, USHORT nRight )
						{ nLeftSlot = nLeft; nRightSlot = nRight; }

	virtual long	Notify( NotifyEvent& rNEvt );
};



#endif

