/*************************************************************************
 *
 *  $RCSfile: pcfgserver.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "maindlg.hxx"
#include "script.hxx"
#include "environ.hxx"

#include "pcfgserver.hxx"
#include "pcfgserver.hrc"

PageConfigServer::PageConfigServer( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage			( pParent, rResId ),
	aFTInfo1			( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2			( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3			( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aEDServername		( this, ResId(ED_SERVERNAME, rResId.GetResMgr()) ),
	aEDServerport		( this, ResId(ED_SERVERPORT, rResId.GetResMgr()) ),
	aErrNoName			( ResId(STR_ERRNONAME, rResId.GetResMgr()) ),
	aErrNoPort			( ResId(STR_ERRNOPORT, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aText );
	FreeResource();

	aText = String( aFTInfo1.GetText() );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
							UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aFTInfo1.SetText( aText );

	aEDServerport.SetStrictFormat( TRUE );

//	aEDServername.SetText( UniString(GETDLG()->GetEnv()->GetCfgServername(),osl_getThreadTextEncoding()) );
//	aEDServerport.SetText( UniString(GETDLG()->GetEnv()->GetCfgServerport(),osl_getThreadTextEncoding()) );
}

PageConfigServer::~PageConfigServer()
{
}

SvAgentPage* PageConfigServer::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageConfigServer( pParent, rResId );
}

BOOL PageConfigServer::AllowNext()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();

//	pEnv->SetCfgServername( ByteString(aEDServername.GetText(), osl_getThreadTextEncoding()) );
//	pEnv->SetCfgServerport( ByteString(aEDServerport.GetText(), osl_getThreadTextEncoding()) );

/*	if( !pEnv->GetCfgServername().Len() ) {
		ErrorBox(this, WB_OK, aErrNoName).Execute();
		return FALSE;
	}

	if( !pEnv->GetCfgServerport().Len() ) {
		ErrorBox(this, WB_OK, aErrNoPort).Execute();
		return FALSE;
	}
*/
	return TRUE;
}

