/*************************************************************************
 *
 *  $RCSfile: sdmtf.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:48:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SD_SDMTF_HXX
#define _SD_SDMTF_HXX

#ifndef _SV_GDIMTF_HXX
#include <vcl/gdimtf.hxx>
#endif

/******************************************************************************
|*
|*
|*
\******************************************************************************/

#define MARKER_NONE					((ULONG)0x00000000)
#define MARKER_START				((ULONG)0x00000001)
#define MARKER_END					((ULONG)0x00000002)
#define MARKER_PAGE					((ULONG)0x00000100)
#define	MARKER_ANIMOBJ				((ULONG)0x00000200)
#define MARKER_BACKGROUND			((ULONG)0x00000400)
#define MARKER_MTF					((ULONG)0x00000800)
#define MARKER_FIRST				((ULONG)0x00001000)
#define MARKER_SLOWOBJ				((ULONG)0x00100000)

#define	MTF_START					Marker( NULL, MARKER_MTF | MARKER_START )
#define	MTF_END						Marker( NULL, MARKER_MTF | MARKER_END )
#define FIRST_START					Marker( NULL, MARKER_FIRST | MARKER_START )
#define PAGE_START					Marker( NULL, MARKER_PAGE | MARKER_START )
#define PAGE_END					Marker( NULL, MARKER_PAGE | MARKER_END )
#define BACKOBJ_START				Marker( NULL, MARKER_BACKGROUND | MARKER_START )
#define BACKOBJ_END					Marker( NULL, MARKER_BACKGROUND | MARKER_END )
#define OBJ_START( pObj, bSlow )	Marker( pObj, MARKER_ANIMOBJ | MARKER_START | ( (bSlow) ? MARKER_SLOWOBJ : 0L ) )
#define OBJ_END( pObj, bSlow )		Marker( pObj, MARKER_ANIMOBJ | MARKER_END | ( (bSlow) ? MARKER_SLOWOBJ : 0L ) )


/******************************************************************************
|*
|*
|*
\******************************************************************************/

class Marker
{
	friend class SdMetaFile;

	void*		pObj;
	ULONG		nFlags;
	ULONG		nMtfPos;

public:

				Marker( void* _pObj = NULL, ULONG _nFlags = MARKER_NONE ) : pObj( _pObj ), nFlags( _nFlags ), nMtfPos( GDI_METAFILE_END ) {}
				~Marker() {}

	inline BOOL	operator==( const Marker& rMarker ) const { return ( ( pObj == rMarker.pObj ) && ( nFlags == rMarker.nFlags ) ); }

	BOOL		IsStart() const { return ( ( nFlags & MARKER_START ) == MARKER_START ); }
	BOOL		IsEnd() const { return ( ( nFlags & MARKER_END ) == MARKER_END ); }
	BOOL		IsObj() const { return ( ( nFlags & MARKER_ANIMOBJ ) == MARKER_ANIMOBJ ); }
	BOOL		IsSlowObj() const { return IsObj() && ( ( nFlags & MARKER_SLOWOBJ ) == MARKER_SLOWOBJ ); }
	BOOL		IsPage() const { return ( ( nFlags & MARKER_PAGE ) == MARKER_PAGE ); }
	BOOL		IsMtf() const { return ( ( nFlags & MARKER_MTF ) == MARKER_MTF ); }
	BOOL		IsBackground() const { return ( ( nFlags & MARKER_BACKGROUND ) == MARKER_BACKGROUND ); }

	BOOL		IsObjStart() const { return IsObj() && IsStart(); }
	BOOL		IsObjEnd() const { return IsObj() && IsEnd(); }

	BOOL		IsMtfStart() const { return IsMtf() && IsStart(); }
	BOOL		IsMtfEnd() const { return IsMtf() && IsEnd(); }

	BOOL		IsPageStart() const { return IsPage() && IsStart(); }
	BOOL		IsPageEnd() const { return IsPage() && IsEnd(); }

	BOOL		IsBackgroundStart() const { return IsBackground() && IsStart(); }
	BOOL		IsBackgroundEnd() const { return IsBackground() && IsEnd(); }

	ULONG		GetMtfPos() const { return nMtfPos; }
};


/******************************************************************************
|*
|*
|*
\******************************************************************************/

class FuSlideShow;
class SdrObject;

class SdMetaFile : public GDIMetaFile
{
	FuSlideShow*	pFuSlideShow;
	List*			pMarkerList;

					SdMetaFile( const SdMetaFile& ) {};

protected:

	ULONG			ImpGetMarkerPos( const Marker& rMarker );
	void			ImpPlayToNextStart( ULONG& rMarker, OutputDevice* pOut );
	void			ImpPlayToNextMarker( ULONG& rMarker, OutputDevice* pOut );
	void			ImpPlaySlowObj( ULONG& rMarker, OutputDevice* pOut );
	void			ImpSkipActualObject( ULONG& rMarker, OutputDevice* pOut );

public:

					SdMetaFile( FuSlideShow* pShow );
	virtual			~SdMetaFile();

	void			Clear();
	void			InsertMarker( const Marker& rMarker );
	BOOL			ReplaceMarker( const Marker& rMarker, const Marker& rNewMarker );
	BOOL			HasMarker( const Marker& rMarker ) const;
	void			Play( OutputDevice* pOut,
						  const Marker& rStartMarker, const Marker& rEndMarker,
						  BOOL bUseOutDevDrawMode = FALSE );
};


#endif // _SD_SDMTF_HXX


