/*************************************************************************
 *
 *  $RCSfile: schedule.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SCHEDULE_HXX
#define __SCHEDULE_HXX

#include <windows.h>
#include <winsock.h>

#ifndef __BASE_HXX
#include "base.hxx"
#endif

#ifndef __THREAD_HXX
#include "thread.hxx"
#endif

#ifndef __SEMAPHORE_HXX
#include "semaphor.hxx"
#endif

#include <mmtask.h>

class SALScheduler
{
public:
    SALThread			*mpConsumer;			// Zeiger auf den Consumer-Thread - HACK !!!
protected:
    SALThread			*mpMain;			// Zeiger auf den Main-Thread
    SALThread			*mpActive;			// Zeiger auf den aktiven Thread
    SALReadyQueue		*mpReadyQueue;		// Instanz der Queue mit den aktiven Threads
    SALThreadQueue		*mpDelayQueue;		// Instanz der Queue mit den wartenden Threads
    SALConditionQueue	*mpConditionQueue;	// Instanz der Queue mit den Condition-Queues
	SALThreadQueue		*mpTerminatedQueue;	// Instanz der Queue mit Threads, deren Stack noch gelscht werden mu
	SALThreadQueue		*mpCallbackQueue;	// Instanz der Queue mit Threads, die auf Systemcallbacks warten (Sockets, Processes)


	HTASK				mhAppTask;			// Task-Handle der Applikation
	HINSTANCE			mhAppInstance;	// Instanz-Handle der Applikation

	HTASK				mhMMTask;		// Task-Handle der MMSYSTEM.DLL
	MMTASKPROC			mlpTaskCallback;

protected:
    SALThread	*getNextReadyThread(BOOL bRotate);
    void		updateDelayQueue();
    void		updateConditionQueue();
	void		freeThreadStacks();

public:
    SALScheduler();
    virtual ~SALScheduler();

	virtual BOOL validate() const;

	void enableMMTask();
	void disableMMTask();

    void dispatch(BOOL bRotate = TRUE);
    void dispatch(SALThread *);

	SALThread *findCallbackThread(SALThread::TaskType eType, HTASK hTask);
	
    SALThread			*mainThread() {return mpMain;}
    SALThread			*activeThread() {return mpActive;}
    SALReadyQueue		*readyQueue() {return mpReadyQueue;}
    SALThreadQueue		*delayQueue() {return mpDelayQueue;}
	SALThreadQueue		*terminatedQueue() {return mpTerminatedQueue;}
    SALConditionQueue	*conditionQueue() {return mpConditionQueue;}
	SALThreadQueue		*callbackQueue() {return mpCallbackQueue;}

    static SALScheduler	*SchedulerInstance();

private:
	static SALScheduler 	*gpInstance;	// Zeiger auf die aktive Instanz

   static void * __cdecl ConsumerThread(void *);	// Der "Consumer"-Thread
	static void CALLBACK TimerProc(HWND hWnd, UINT wMsg, UINT idTimer, DWORD dwTime);

	friend void CALLBACK MMTaskMain(LPVOID pParam);
	friend void FAR PASCAL EnterMultiThread();
	friend void FAR PASCAL LeaveMultiThread();
};
#define SCHEDULER   (SALScheduler::SchedulerInstance())

#endif



