/*
 * ParameterPanel.java
 *
 * Created on August 16, 2002, 4:24 PM
 */

package org.netbeans.modules.openoffice.wizard.panels.idl;

import javax.swing.JPanel;
import org.openide.explorer.ExplorerManager;
import java.beans.PropertyChangeListener;
import org.openide.nodes.Index;
import java.beans.PropertyChangeEvent;
import org.openide.nodes.Node;
import org.openide.src.MemberElement;
import org.openide.src.FieldElement;
import org.openide.src.SourceException;
import org.openide.src.Identifier;
import org.openide.nodes.Children;

/**
 *
 * @author  Bertram Nolte
 */
public class ParameterPanel extends JPanel {

    private ElementCreator elementCreator;
    private ExplorerManager manager;
    private PropertyChangeListener managerListener;
    private Index indexableParent;
    
    /** Creates new form ParameterPanel */
    public ParameterPanel( ElementCreator elementcreator ) {
        this.elementCreator = elementcreator;
//        Index.KeysChildren c = new FieldsChildren(data.getCustomizedClass());
//        Node n = new IndexedRoot(c);
//        getExplorerManager().setRootContext(n);
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelHeader = new javax.swing.JLabel();
        jLabelParameter = new javax.swing.JLabel();
        jPanelParameter = new javax.swing.JPanel();
        jButtonNew = new javax.swing.JButton();
        jButtonDuplicate = new javax.swing.JButton();
        jButtonDelete = new javax.swing.JButton();
        jButtonUp = new javax.swing.JButton();
        jButtonDown = new javax.swing.JButton();
        jListParameter = new javax.swing.JList();
        jPanelFieldCustomizer = new javax.swing.JPanel();
        jLabelName = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jLabelType = new javax.swing.JLabel();
        jTextFieldType = new javax.swing.JTextField();
        jPanelDirectionFlag = new javax.swing.JPanel();
        jCheckBoxInFlag = new javax.swing.JCheckBox();
        jCheckBoxOutFlag = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        jLabelHeader.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("ACS_ParameterPanelHeader"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jLabelHeader, gridBagConstraints);

        jLabelParameter.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("ACS_ParameterPanelListHeader"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jLabelParameter, gridBagConstraints);

        jPanelParameter.setLayout(new java.awt.GridBagLayout());

        jButtonNew.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_New"));
        jButtonNew.setMaximumSize(new java.awt.Dimension(93, 26));
        jButtonNew.setMinimumSize(new java.awt.Dimension(93, 26));
        jButtonNew.setPreferredSize(new java.awt.Dimension(93, 26));
        jButtonNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelParameter.add(jButtonNew, gridBagConstraints);

        jButtonDuplicate.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_Duplicate"));
        jButtonDuplicate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDuplicateActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelParameter.add(jButtonDuplicate, gridBagConstraints);

        jButtonDelete.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_Delete"));
        jButtonDelete.setMaximumSize(new java.awt.Dimension(93, 26));
        jButtonDelete.setMinimumSize(new java.awt.Dimension(93, 26));
        jButtonDelete.setPreferredSize(new java.awt.Dimension(93, 26));
        jButtonDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelParameter.add(jButtonDelete, gridBagConstraints);

        jButtonUp.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_Up"));
        jButtonUp.setMaximumSize(new java.awt.Dimension(93, 26));
        jButtonUp.setMinimumSize(new java.awt.Dimension(93, 26));
        jButtonUp.setPreferredSize(new java.awt.Dimension(93, 26));
        jButtonUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUpActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelParameter.add(jButtonUp, gridBagConstraints);

        jButtonDown.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_Down"));
        jButtonDown.setMaximumSize(new java.awt.Dimension(93, 26));
        jButtonDown.setMinimumSize(new java.awt.Dimension(93, 26));
        jButtonDown.setPreferredSize(new java.awt.Dimension(93, 26));
        jButtonDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDownActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelParameter.add(jButtonDown, gridBagConstraints);

        jListParameter.setMaximumSize(new java.awt.Dimension(400, 400));
        jListParameter.setMinimumSize(new java.awt.Dimension(20, 20));
        jListParameter.setPreferredSize(new java.awt.Dimension(150, 150));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 11);
        jPanelParameter.add(jListParameter, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jPanelParameter, gridBagConstraints);

        jPanelFieldCustomizer.setLayout(new java.awt.GridBagLayout());

        jLabelName.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_ParameterName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelFieldCustomizer.add(jLabelName, gridBagConstraints);

        jTextFieldName.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelFieldCustomizer.add(jTextFieldName, gridBagConstraints);

        jLabelType.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_ParameterType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelFieldCustomizer.add(jLabelType, gridBagConstraints);

        jTextFieldType.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelFieldCustomizer.add(jTextFieldType, gridBagConstraints);

        jPanelDirectionFlag.setLayout(new java.awt.GridBagLayout());

        jPanelDirectionFlag.setBorder(new javax.swing.border.TitledBorder(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_DirectionFlag")));
        jCheckBoxInFlag.setSelected(true);
        jCheckBoxInFlag.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_CheckBoxIn"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelDirectionFlag.add(jCheckBoxInFlag, gridBagConstraints);

        jCheckBoxOutFlag.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("LBL_CheckBoxOut"));
        jPanelDirectionFlag.add(jCheckBoxOutFlag, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanelFieldCustomizer.add(jPanelDirectionFlag, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        add(jPanelFieldCustomizer, gridBagConstraints);

    }//GEN-END:initComponents

    private void jButtonDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDownActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jButtonDownActionPerformed

    private void jButtonUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUpActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jButtonUpActionPerformed

    private void jButtonDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jButtonDeleteActionPerformed

    private void jButtonDuplicateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDuplicateActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jButtonDuplicateActionPerformed

    private void jButtonNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewActionPerformed
        try {
            String stringElementName = elementCreator.createElement().getName();
            Node nodeRoot = manager.getExploredContext();
            Children children = nodeRoot.getChildren();
            Node node = children.findChild( stringElementName );

            if ( node != null ) {
                updateSelection( new Node[] { node } );
            }
        } 
        catch (SourceException ex) {
            // silently
        }
    }//GEN-LAST:event_jButtonNewActionPerformed

    public void addNotify() {
        super.addNotify();
        if (manager == null)
            manager = ExplorerManager.find(this);
        if (managerListener == null)
            managerListener = new java.beans.PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName())) {
                        updateButtons();
                    }
                    if (ExplorerManager.PROP_EXPLORED_CONTEXT.equals(evt.getPropertyName())) {
                        indexableParent = (Index)((Node)evt.getNewValue()).getCookie(Index.class);
                        updateButtons();
                    }
                }
            };
        manager.addPropertyChangeListener(managerListener);
        
        Node n = manager.getExploredContext();
        if (n != null)
            indexableParent = (Index)n.getCookie(Index.class);
        updateButtons();
    }
    
    public void removeNotify() {
        super.removeNotify();
        manager.removePropertyChangeListener(managerListener);
    }    

    private void updateButtons() {
        ExplorerManager m = manager;
        Node[] nodes = m.getSelectedNodes();   
        boolean singleSel = nodes.length == 1;

        // these buttons are valid only for single selection
        if (indexableParent != null && singleSel) {
            // If the nodes provide ReorderCookie, they can be reordered inside their parent.
            jButtonUp.setEnabled(!isFirst(nodes[0]));
            jButtonDown.setEnabled(!isLast(nodes[0]));
        } else {
            jButtonUp.setEnabled(false);
            jButtonDown.setEnabled(false);
        }
        
        boolean canRemove = false;
        for (int i = 0; i < nodes.length; i++) {
            if ((nodes[i].canDestroy()) 
                && (elementCreator.canDelete((ParameterElement)nodes[i].getCookie(ParameterElement.class)))) {
//            ) {
                canRemove = true;
                break;
            }
        }
        jButtonDelete.setEnabled(canRemove);
        jButtonDuplicate.setEnabled(singleSel);
    }

    private void updateSelection(final Node node[]) {
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
                    manager.setSelectedNodes(node);
                } catch (java.beans.PropertyVetoException ex) {
                    // silently ignore.
                }
            }
        });
    }
    
    protected boolean isFirst(Node n) {
        return indexableParent.indexOf(n) == 0;
    }

    protected boolean isLast(Node n) {
        return indexableParent.indexOf(n) == indexableParent.getNodesCount() - 1;
    }

    protected void removeNode(Node n) {
        try {
            n.destroy();
        } catch (java.io.IOException e) {
        }
    }

    protected void createNewNode(Node parent) {
        try {
            parent.getNewTypes()[0].create();
        } catch (java.io.IOException e) {
        }
    }

    static interface ElementCreator {
        public ParameterElement createElement() throws SourceException;
        public ParameterElement duplicateElement(ParameterElement el) throws SourceException;
        public void deleteElement(ParameterElement el) throws SourceException;
        public boolean canDelete(ParameterElement el);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxInFlag;
    private javax.swing.JButton jButtonDown;
    private javax.swing.JButton jButtonUp;
    private javax.swing.JPanel jPanelDirectionFlag;
    private javax.swing.JButton jButtonDuplicate;
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JCheckBox jCheckBoxOutFlag;
    private javax.swing.JList jListParameter;
    private javax.swing.JLabel jLabelParameter;
    private javax.swing.JTextField jTextFieldType;
    private javax.swing.JLabel jLabelHeader;
    private javax.swing.JLabel jLabelName;
    private javax.swing.JPanel jPanelFieldCustomizer;
    private javax.swing.JPanel jPanelParameter;
    private javax.swing.JButton jButtonDelete;
    private javax.swing.JLabel jLabelType;
    private javax.swing.JButton jButtonNew;
    // End of variables declaration//GEN-END:variables
    
}
