/*************************************************************************
 *
 *  $RCSfile: cntsupp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: th $ $Date: 2001/05/11 10:05:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STORE_STORE_HXX_
#define ENABLE_STRING_STREAM_OPERATORS
#include <store/store.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _CNTSUPP_HXX
#include "cntsupp.hxx"
#endif

/* from chaos/source/core/cntrnmgr.cxx */
#ifndef CNT_VIEW_LIST_STREAM
#define CNT_VIEW_LIST_STREAM    ".Views"
#endif

using namespace ::rtl;


//============================================================================
//
// class CntViewStorageFile_Impl
//
//============================================================================

class CntViewStorageFile_Impl
{
    String m_aFullName;
    String m_aUserStorage;
    String m_aCacheStorage;
    String m_aReferredURL;
    BOOL   m_bInitDone : 1;
    BOOL   m_bValid : 1;

private:
    void init();
    static String OwnURL2FileName( const String& rOwnURL );

public:
    CntViewStorageFile_Impl( const String& rFullName );

    BOOL   isValid();
    String getReferredURL();
    String getUserStorageFileName();
    String getCacheStorageFileName();
};

//============================================================================
//
// class CntStorageStream_Impl.
//
//============================================================================

class CntStorageStream_Impl : public SvStream
{
    store::OStoreStream m_aStream;
    sal_uInt32          m_nPos;

protected:
    virtual ULONG GetData( char* pData, ULONG nSize );
    virtual ULONG PutData( const char* pData, ULONG nSize );
    virtual ULONG SeekPos( ULONG nPos );
    virtual void  FlushData();
    virtual void  SetSize( ULONG nSize );

public:
    CntStorageStream_Impl( const store::OStoreStream& rStream )
    : m_aStream( rStream ), m_nPos( 0 ) { bIsWritable = TRUE; }

    virtual ~CntStorageStream_Impl();
};

//============================================================================
//
// CntStringList Implementation.
//
//============================================================================

// virtual
CntStringList::~CntStringList()
{
    ULONG nCount = Count();
    for ( ULONG n = 0; n < nCount; ++n )
        delete GetObject( n );
}

//============================================================================
//
// CntViewStorageFiles Implementation.
//
//============================================================================

// static
void CntViewStorageFiles::query(
                    const String& rConfigDir, CntStringList& rList )
{
    if ( !rConfigDir.Len() )
    {
        DBG_ERROR( "CntViewStorageFiles::query - Invalid directory!" );
        return;
    }

    DirEntry aDE( rConfigDir );
    if ( !aDE.Exists() )
    {
        DBG_ERROR( "CntViewStorageFiles::query - Invalid directory!" );
        return;
    }

    aDE += DirEntry( OUString::createFromAscii("rootstg.scs"));
    if ( !aDE.Exists() )
    {
        DBG_ERROR( "CntViewStorageFiles::query - rootstg.scs not found!" );
        return;
    }

    store::OStoreFile aStoreFile;
    storeError nError = aStoreFile.create( aDE.GetFull( FSYS_STYLE_HOST ),
                                           store_AccessReadOnly );
    if ( nError != store_E_None )
    {
        DBG_ERROR( "CntViewStorageFiles::query - "
                   "Error creating store file object!" );
        return;
    }

    store::OStoreStream aStoreStream;
    nError = aStoreStream.create(aStoreFile, OUString::createFromAscii("/"),
      OUString::createFromAscii(CNT_VIEW_LIST_STREAM), store_AccessReadOnly);
    if (nError != store_E_None) {
        DBG_ERROR( "CntViewStorageFiles::query - "
                   "Error creating store stream object!" );
        return;
    }

    CntStorageStream_Impl aStream( aStoreStream );

    aStream.SetBufferSize( 4096 );
    aStream.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );

    ULONG nVersion = 0;
    ULONG nCount   = 0;
    aStream >> nVersion;
    aStream >> nCount;

    for ( ULONG n = 0; n < nCount; ++n )
    {
        String aViewURL;
        String aContentType;

        aStream >> aViewURL;
        aStream >> aContentType;

        // Check, whether file decribed by aViewURL exists.
        DirEntry aDirEntry( aViewURL, FSYS_STYLE_URL  );
        if ( aDirEntry.Exists() )
            rList.Insert( new String( aViewURL ) );
    }
}

//============================================================================
//
// CntViewStorageFile_Impl Implementation.
//
//============================================================================

CntViewStorageFile_Impl::CntViewStorageFile_Impl( const String& rFullName )
: m_aFullName( rFullName ),
  m_bInitDone( FALSE ),
  m_bValid( FALSE )
{
}

//----------------------------------------------------------------------------
BOOL CntViewStorageFile_Impl::isValid()
{
    init();
    return m_bValid;
}

//----------------------------------------------------------------------------
String CntViewStorageFile_Impl::getReferredURL()
{
    init();
    return m_aReferredURL;
}

//----------------------------------------------------------------------------
String CntViewStorageFile_Impl::getUserStorageFileName()
{
    init();
    return m_aUserStorage;
}

//----------------------------------------------------------------------------
String CntViewStorageFile_Impl::getCacheStorageFileName()
{
    init();
    return m_aCacheStorage;
}

//----------------------------------------------------------------------------
void CntViewStorageFile_Impl::init()
{
    if ( m_bInitDone )
        return;

    m_bInitDone = TRUE;

    if ( !m_aFullName.Len() )
        return;

    DirEntry aDE( m_aFullName );
    if ( !aDE.Exists() )
        return;

    /////////////////////////////////////////////////////////////////////
    // Initialize storage file...
    /////////////////////////////////////////////////////////////////////

    store::OStoreFile aStoreFile;
    storeError nError = aStoreFile.create( aDE.GetFull( FSYS_STYLE_HOST ),
                                           store_AccessReadOnly );
    if ( nError != store_E_None )
        return;

    m_bValid = TRUE;

    /////////////////////////////////////////////////////////////////////
    // Read referred URL from file...
    /////////////////////////////////////////////////////////////////////

    store::OStoreStream aStoreStream;
    nError = aStoreStream.create(aStoreFile,
      OUString::createFromAscii("/"),
      OUString::createFromAscii("own.props"), store_AccessReadOnly );
    if ( nError != store_E_None )
        return;

    CntStorageStream_Impl aStream( aStoreStream );

    aStream.SetBufferSize(4096);
    aStream.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );

    sal_uInt32 nSize = 0;
    nError = aStoreStream.getSize( nSize );
    if ( nError != store_E_None )
        return;

    BYTE* pBuffer = new BYTE[ nSize ];

    aStream.Read( pBuffer, nSize );

    // Search for string ".cache:" in buffer...
    const ByteString aKey( ".cache:" );
    ULONG nPos = 0;
    while ( nPos <= ( nSize - aKey.Len() ) )
    {
        if ( ( pBuffer[ nPos     ] == '.' ) &&
             ( pBuffer[ nPos + 1 ] == 'c' ) &&
             ( pBuffer[ nPos + 2 ] == 'a' ) &&
             ( pBuffer[ nPos + 3 ] == 'c' ) &&
             ( pBuffer[ nPos + 4 ] == 'h' ) &&
             ( pBuffer[ nPos + 5 ] == 'e' ) &&
             ( pBuffer[ nPos + 6 ] == ':' ) )
        {
            // Set buffer pos to begin of persistent string data.
            // See: tools/source/stream/stream.cxx

            aStream.Seek( nPos - 2 );
            aStream >> m_aReferredURL;

            // Remove cache prefix to get the service URL.
            m_aReferredURL.Erase( 0, m_aReferredURL.Search( ':' ) + 1 );

            break;
        }

        nPos++;
    }

    delete [] pBuffer;

    if ( nPos > ( nSize - aKey.Len() ) )
        return; // Not found!

    ///////////////////////////////////////////////////////////////////////
    // Calculate cache file name from referred URL...
    ///////////////////////////////////////////////////////////////////////
    m_aCacheStorage = m_aUserStorage = OwnURL2FileName( m_aReferredURL );
}

//============================================================================
//
// CntViewStorageFile Implementation.
//
//============================================================================

CntViewStorageFile::CntViewStorageFile( const String& rFullName )
: m_pImpl( new CntViewStorageFile_Impl( rFullName ) )
{
}

//----------------------------------------------------------------------------
CntViewStorageFile::~CntViewStorageFile()
{
    delete m_pImpl;
}

//----------------------------------------------------------------------------
BOOL CntViewStorageFile::isValid()
{
    return m_pImpl->isValid();
}

//----------------------------------------------------------------------------
String CntViewStorageFile::getReferredURL()
{
    return m_pImpl->getReferredURL();
}

//----------------------------------------------------------------------------
String CntViewStorageFile::getUserStorageFileName()
{
    return m_pImpl->getCacheStorageFileName();
}

//----------------------------------------------------------------------------
String CntViewStorageFile::getCacheStorageFileName()
{
    return m_pImpl->getCacheStorageFileName();
}

//----------------------------------------------------------------------------
//static
String CntViewStorageFile_Impl::OwnURL2FileName( const String& rOwnURL )
{
    //--------------------------------------------------------------------
    //
    // !!! Code taken from chaos/source/store/cntstgnd.cxx !!!
    //
    //--------------------------------------------------------------------

    String aReferredURL( rOwnURL );

    //////////////////////////////////////////////////////////////////////
    // Check for Dummy-URL
    //////////////////////////////////////////////////////////////////////

    USHORT nLen = aReferredURL.Len();
    if ( ( nLen > 2 ) &&
         ( aReferredURL.GetChar( nLen - 3 ) == ':' ) &&
         ( aReferredURL.GetChar( nLen - 2 ) == '/' ) &&
         ( aReferredURL.GetChar( nLen - 1 ) == '/' ) )
    {
        return String();
    }

    //////////////////////////////////////////////////////////////////////
    // Construct a file name from URL ...
    //////////////////////////////////////////////////////////////////////

    INetURLObject aURLObject( aReferredURL );

    String aFileName;

    // Next part of file name: "username"
    String aUser( aURLObject.GetUser() );
    nLen = aUser.Len();
    if ( nLen )
    {
        USHORT nPos = aUser.Search( '.' );
        while ( nPos != STRING_NOTFOUND )
        {
            aUser.Erase( nPos, 1 );
            nPos = aUser.Search( '.', nPos );
        }

        // User names are generally case sensitive. So any upper-case
        // letters in name will be encoded here into storage filename.
        //
        // Conversion-scheme:
        // <uppercase letter> -> !<uppercase_letter>
        // !                  -> !!
        String aTemp;

        nLen = aUser.Len();
        for ( USHORT n = 0; n < nLen; n++ )
        {
            String aTmp( aUser.GetChar( n ) );
            if ( aTmp.CompareToAscii("%", 1) == COMPARE_EQUAL )
            {
                // Skip escape sequences.
                aTemp += String::CreateFromAscii("%");
                aTemp += aUser.GetChar( n + 1 );
                aTemp += aUser.GetChar( n + 2 );
                n += 2;
            }
            else
            {
                if ( aTmp.CompareToAscii("!", 1) == COMPARE_EQUAL)
                    aTemp += String::CreateFromAscii("!", 1);
                else
                {
                    OUString aTmpLowOU = aTmp;
                    aTmpLowOU = aTmpLowOU.toAsciiLowerCase();
                    String aTmpLow( aTmpLowOU );
                    if ( aTmpLow != aTmp )
                    {
                        aTemp += String::CreateFromAscii("!", 1);
                        aTmp = aTmpLow;
                    }
                }
                aTemp += aTmp;
            }
        }

        aUser = aTemp;
        aFileName += aUser;
    }

    // Next part of file name: "servername"
    String aHost( aURLObject.GetHost() );
    if ( aHost.Len() )
    {
        USHORT nPos = aHost.Search( '.' );
        while ( nPos != STRING_NOTFOUND )
        {
            aHost.Erase( nPos, 1 );
            nPos = aHost.Search( '.', nPos );
        }

        aFileName += aHost;

        // Next part of file name: "serverport"
        if ( aURLObject.HasPort() )
            aFileName += aURLObject.GetPort();

    }

    // Next part of file name: "protocol-tag"

    String aPrivatePath; // helper
    INetProtocol eProt = aURLObject.GetProtocol();

    // "private:" and ".component:" protocol need special handling.
    BOOL bSpecialProt = ( ( eProt == INET_PROT_PRIVATE ) ||
                          ( eProt == INET_PROT_COMPONENT ) );
    if ( bSpecialProt )
    {
        String aPath( aURLObject.GetURLPath() );

        DBG_ASSERT( aPath.Len(),
                    "OwnURL2FileName: Invalid private URL (no path)!" );

        USHORT nPos = 0;
        if ( eProt == INET_PROT_PRIVATE )
        {
            nPos = aPath.Search(String::CreateFromAscii("://"));
            if ( nPos != STRING_NOTFOUND )
                nPos += 3; // now after "://"
        }

        if ( nPos != STRING_NOTFOUND )
        {
            nPos = aPath.Search( '/', nPos );
            if ( nPos != STRING_NOTFOUND )
                aPrivatePath = aPath.Erase( nPos + 1 );
        }

        // Remove anwanted characters from path...

        // Note: URL Object does not escape slashes - so remove it manually.
        nPos = aPath.Search( '/' );
        while ( nPos != STRING_NOTFOUND )
        {
            aPath.Erase( nPos, 1 );
            nPos = aPath.Search( '/', nPos );
        }

        // Remove any ':' (cosmetic).
        nPos = aPath.Search( ':' );
        while ( nPos != STRING_NOTFOUND )
        {
            aPath.Erase( nPos, 1 );
            nPos = aPath.Search( ':', nPos );
        }

//      INetURLObject::Escape( aPath );

        aFileName += aPath;
    }
    else
    {
        String aProt( aURLObject.GetScheme( eProt ) );
        aProt.Erase( aProt.Search( ':' ) );
        aFileName += aProt;
    }

    // Next part of file name: "file extension"
    aFileName += String::CreateFromAscii(".scs");

    // Done.
    return aFileName;
}

//============================================================================
//
// CntStorageStream_Impl Implementation.
//
//============================================================================

// virtual
CntStorageStream_Impl::~CntStorageStream_Impl()
{
    Flush();
}

//----------------------------------------------------------------------------
// virtual
ULONG CntStorageStream_Impl::GetData( char* pData, ULONG nSize )
{
    sal_uInt32 nBytesRead = 0;
    m_aStream.readAt( m_nPos, pData, nSize, nBytesRead );
    m_nPos += nBytesRead;
    return nBytesRead;
}

//----------------------------------------------------------------------------
// virtual
ULONG CntStorageStream_Impl::PutData( const char* pData, ULONG nSize )
{
    sal_uInt32 nBytesWritten = 0;
    m_aStream.writeAt( m_nPos, pData, nSize, nBytesWritten );
    m_nPos += nBytesWritten;
    return nBytesWritten;
}

//----------------------------------------------------------------------------
// virtual
ULONG CntStorageStream_Impl::SeekPos( ULONG nPos )
{
    m_nPos = nPos;
    return nPos;
}

//----------------------------------------------------------------------------
// virtual
void CntStorageStream_Impl::FlushData()
{
    m_aStream.flush();
}

//----------------------------------------------------------------------------
// virtual
void CntStorageStream_Impl::SetSize( ULONG nSize )
{
    m_aStream.setSize( nSize);
}

