/*************************************************************************
 *
 *  $RCSfile: propset.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <propset.hxx>
#include <usr/ustring.hxx>

#include <usr/services.hxx>

#ifndef __STARDIV_UNO_REPOS_REGKEY_HXX__ //autogen wg. XRegistryKey
#include <stardiv/uno/repos/regkey.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif

typedef NAMESPACE_STD(hash_map)
<UString, IPropertyType*, UStringHash, UStringEqual>
PropertyTypeHashMap;

struct IPropertyTypeStaticImpl
{
	PropertyTypeHashMap m_aMap;
};

IPropertyTypeStaticImpl* IPropertyType::pImpl = 0;

IPropertyType* IPropertyType::getPropertyType( const UString& rName )
{
	if( !pImpl ) pImpl = new IPropertyTypeStaticImpl;
	PropertyTypeHashMap::iterator pItem = pImpl->m_aMap.find( rName );
	return pItem != pImpl->m_aMap.end() ? (*pItem).second : 0;
}

void IPropertyType::registerPropertyType( IPropertyType* pType )
{
	if( !pImpl ) pImpl = new IPropertyTypeStaticImpl;
	pImpl->m_aMap.insert( PropertyTypeHashMap::value_type( 
		pType->getReflection()->getName(), pType ) );
}

Reflection* OPropertyAccessor::getClassReflection()
{
	static UsrTemplateReflection<OPropertyAccessor> aRefl( 
		TypeClass_UNKNOWN, L"OPropertyAccessor" );
	return &aRefl;
}

IPropertyArrayHelper& OObjectClassBase::getPropertyArray() const
{
	OGuard aGuard( getMutex() );
	if( !m_pArray ) ((OObjectClassBase&)*this).m_pArray = 
						new OPropertyArrayHelper(
							getPropertyDescriptor(), getAccessorCount(),
							FALSE );
	return *m_pArray;
}

XPropertySetInfoRef OObjectClassBase::getPropertySetInfo() const
{
	OGuard aGuard( getMutex() );
	if( !m_xInfo.is() ) 
		((OObjectClassBase&)*this).m_xInfo = 
			OPropertySetHelper::createPropertySetInfo( getPropertyArray() );
	return m_xInfo;
}

struct OAccessorEqual
{
	BOOL operator()( const OPropertyAccessor& r1, const OPropertyAccessor& r2 ) {
		return UString( r1.m_pName ) < UString( r2.m_pName ); }
};

#if SUPD < 543
#define rtl_uString UStringImpl
#endif

void OObjectClassBase::init()
{
	Sequence<OPropertyAccessor> aAccessors;
	OObjectClassBase* pNext;
	for( OObjectClassBase* pCur = this; pCur; pCur = pNext )
	{
		pNext = 0;
		pCur->fillClassInfo( pNext, aAccessors );
		if( !m_pParent ) m_pParent = pNext;
		OPropertyAccessor* pAcc = aAccessors.getArray();
		NAMESPACE_STD(copy)( aAccessors.getConstArray(),
			  aAccessors.getConstArray() + aAccessors.getLen(),
			  NAMESPACE_STD(insert_iterator)< NAMESPACE_STD(vector)< OPropertyAccessor > >( 
				  m_aAccessors, m_aAccessors.begin() ) );
	}
	NAMESPACE_STD(sort)( m_aAccessors.begin(), m_aAccessors.end(), OAccessorEqual() );
	delete m_pDescriptors;
	m_pDescriptors = new OPropertyDescriptor[ m_aAccessors.size() ];
	INT32 nPos = 0;
	for( NAMESPACE_STD(vector)<OPropertyAccessor>::iterator aIter = m_aAccessors.begin();
		 aIter != m_aAccessors.end(); aIter++, nPos++ )
	{
		OPropertyDescriptor& rDesc = m_pDescriptors[ nPos ];
		rtl_uString* pImpl;
		pImpl = (*m_aHandles.insert( 
			OHandleHashMap::value_type( 
				UString( (*aIter).m_pName ), nPos ) ).first).first.getImpl();
		const OPropertyAccessor& rAcc = *aIter;

		const IPropertyType* pType = rAcc.getType();
		rDesc.pPropName = pImpl;
		rDesc.nAttributes = rAcc.m_nFlags;
		rDesc.nHandle = nPos;
		rDesc.pReflFunction = pType->getReflectionFunction();
	}
}

INT32 OObjectClassBase::getIndex( const UString& rName ) const
{
	OHandleHashMap::const_iterator pItem = m_aHandles.find( rName );
	return pItem != m_aHandles.end() ? (*pItem).second : -1;
}

void OObjectClassBase::setPropertyValues( 
	OPropertyObject* pObj, const Sequence<PropertyValue>& rValues ) const
{
	const PropertyValue* pValues = rValues.getConstArray();
	for( INT32 nPos = rValues.getLen(); nPos--; )
	{
		const PropertyValue& rValue = pValues[ nPos ];
		INT32 nHandle = rValue.Handle;
		if( nHandle == -1 ) nHandle = getIndex( rValue.Name );
		if( nHandle != -1 )
		{
			const OPropertyAccessor& rAcc =  m_aAccessors[ nHandle ];
			UsrAny aValue = rValue.Value;
			Reflection* pRefl = rAcc.getType()->getReflection();
			TypeClass eClass = pRefl->getTypeClass();
			TRY
			{
				if( eClass != TypeClass_UNKNOWN && eClass != TypeClass_ANY &&
					eClass != TypeClass_ENUM )
					OPropertyTypeConversion::to(
						pRefl, rValue.Value, aValue );
			}
			CATCH( IllegalArgumentException, e )
			{
			}
			END_CATCH;
			pRefl->assignObject( 
				rAcc.getPtr( pObj ), getObjectPtr( &aValue, eClass) );
		}
	}
}

Sequence<PropertyValue> OObjectClassBase::getPropertyValues( 
	OPropertyObject* pObj ) const
{
	Sequence<PropertyValue> aSeq( m_aAccessors.size() );
	PropertyValue* pData = aSeq.getArray();
	NAMESPACE_STD(vector)<OPropertyAccessor>::const_iterator aIter(
		m_aAccessors.end() );
	for( INT32 nPos = aSeq.getLen(); nPos--; )
	{
		--aIter;
		PropertyValue& rValue = pData[ nPos ];
		const OPropertyAccessor& rAcc = *aIter;
		rValue.Name = rAcc.m_pName;
		rValue.Handle = nPos;
		rValue.Attributes = rAcc.m_nFlags;
		rValue.Type = rAcc.getType()->getReflection()->getIdlClass();
		rValue.Value.set( 
			rAcc.getPtr( pObj ), rAcc.getType()->getReflection() );
	}
	return aSeq;
}

OGenericObjectClass::OGenericObjectClass() : 
	m_nOffset( (INT32)&((OGenericObject*)0)->m_nEnd ), 
	m_pGenericParent( 0 ) {}

OGenericObjectClass::OGenericObjectClass( OObjectClassBase* pParent ) : 
		m_nOffset( (INT32)&((OGenericObject*)0)->m_nEnd ), 
		m_pGenericParent( pParent ) {}

OGenericObject& OGenericObjectClass::clone( OGenericObject& rObj )
{
	OGenericObject* pRet = createInstance( );
	for( NAMESPACE_STD(vector)<OPropertyAccessor>::const_iterator aIter = 
			m_aAccessors.begin(); aIter != m_aAccessors.end(); aIter++ )
	{
		const OPropertyAccessor& rAcc = *aIter;
		rAcc.getType()->getReflection()->assignObject( 
			rAcc.getPtr( pRet ), rAcc.getPtr( &rObj ) );
	}
	return *pRet;
}

void OGenericObjectClass::addProperty( 
	const IPropertyType* pType, const UString& rName, INT16 nFlags )
{
	INT16 nAlign = pType->getAlign( );
	INT32 nSize = pType->getSize();
	m_nOffset = ( ( m_nOffset - 1 ) / nAlign + 1 ) * nAlign;
	OPropertyAccessorWithUString aProp;
	aProp.m_aName = rName;
	aProp.m_nOffset = m_nOffset;
	aProp.m_nFlags = nFlags;
	aProp.m_pType = pType;
	aProp.m_pName = aProp.m_aName;
	m_aGenericAccessors.push_back( aProp );
	m_nOffset += nSize;
}

OGenericObject* OGenericObjectClass::createInstance(  )
{
	void* pData = new char[ m_nOffset ];
	OGenericObject* pObj = new((Ss*) pData) OGenericObject( this );
	for( NAMESPACE_STD(vector)<OPropertyAccessor>::const_iterator pIter = 
			 m_aAccessors.begin(); pIter != m_aAccessors.end(); pIter++ )
	{
		const OPropertyAccessor& rAcc =  *pIter;
		rAcc.getType()->getReflection()->initObject(
			rAcc.getPtr( pObj ), 0 );
	}
	return pObj;
}

void OGenericObjectClass::fillClassInfo( 
	OObjectClassBase*& rpParentClass, 
	Sequence<OPropertyAccessor>& rProps ) const
{
	rpParentClass = m_pGenericParent;
	rProps.realloc( m_aGenericAccessors.size());
	NAMESPACE_STD(copy)( m_aGenericAccessors.begin(), m_aGenericAccessors.end(), 
		  rProps.getArray() );
}


SMART_UNO_IMPLEMENTATION( OPropertySet, OComponentHelper )

XIdlClassRef OPropertySet::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OPropertySet", 
		OComponentHelper::getStaticIdlClass(), 4,
		XPropertySet_getReflection(),
		XFastPropertySet_getReflection(),
		XPropertyAccess_getReflection(),
		XMultiPropertySet_getReflection() );
	return xClass;
}

Sequence< XIdlClassRef > OPropertySet::getIdlClasses( void )
{
	XIdlClassRef pClasses[ 1 ] = { 
		getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OPropertySet::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XPropertyAccess );
	if( OPropertySetHelper::queryInterface( aUik, rOut ) ) return TRUE;
	else return OComponentHelper::queryInterface( aUik, rOut );
}

BOOL OPropertySet::convertFastPropertyValue( 
	UsrAny & rConvertedValue, UsrAny & rOldValue, 
	INT32 nHandle, const UsrAny& rValue )
	THROWS( (IllegalArgumentException) )
{
	const OPropertyAccessor* pAcc = m_pClass->getAccessor( nHandle );
	const IPropertyType* pType = pAcc->getType();
	getFastPropertyValue( rOldValue, nHandle );
	rConvertedValue = rValue;
	Reflection* pRefl = pType->getReflection();
	TypeClass eClass = pRefl->getTypeClass();
	TRY
	{
		if( eClass != TypeClass_UNKNOWN && eClass != TypeClass_ANY &&
			eClass != TypeClass_ENUM )
			OPropertyTypeConversion::to( 
				pRefl, rValue, rConvertedValue );
	}
	CATCH( IllegalArgumentException, e )
	{
	}
	END_CATCH;
	
	if( rConvertedValue.get() &&
		!pType->equals( rConvertedValue.get(), getObjectPtr(
			&rOldValue, eClass ) ) )
		return true;
	return false;
}

void OPropertySet::setFastPropertyValue_NoBroadcast( 
	INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) )
{
	const OPropertyAccessor* pAcc = m_pClass->getAccessor( nHandle );
	Reflection* pRefl = pAcc->getType()->getReflection();
	pRefl->assignObject( pAcc->getPtr( m_pObject ), 
						 getObjectPtr( &rValue, pRefl->getTypeClass() ) );
}

void OPropertySet::getFastPropertyValue( 
	UsrAny& rValue, INT32 nHandle ) const
{
	OGuard aGuard( rMutex );
	const OPropertyAccessor* pAcc = m_pClass->getAccessor( nHandle );
	rValue = UsrAny( pAcc->getPtr( m_pObject ), 
					 pAcc->getType()->getReflection() );
}

BOOL isEqualAny( const UsrAny& rFirst, const UsrAny& rSecond )
{
	Reflection* pRefl1 = rFirst.getReflection();
	Reflection* pRefl2 = rSecond.getReflection();
	if( pRefl1 != pRefl2 ) return FALSE;
	IPropertyType* pFirst = IPropertyType::getPropertyType( 
		pRefl1->getName() );
	IPropertyType* pSecond = IPropertyType::getPropertyType( 
		pRefl2->getName() );
	if( pFirst != pSecond ) return FALSE;
	if( pFirst ) return pFirst->equals( rFirst.get(), rSecond.get() );
	else return TRUE;
}

void OPropertySet::savePropertySet( 
	const XPropertySetRef& xProp, const XRegistryKeyRef& xKey )
{
	XPropertySetInfoRef xInfo( xProp->getPropertySetInfo() );
	Sequence<Property> aProps( xInfo->getProperties() );
	const Property* pProps = aProps.getConstArray();
	INT32 nCount = aProps.getLen();
	while( nCount-- )
	{
		const Property& rProp = pProps[ nCount ];
		if( !(rProp.Attributes & PropertyAttribute_TRANSIENT ) )
		{
			XRegistryKeyRef xCur = xKey->openKey( rProp.Name );
			if( !xCur.is() ) xCur = xKey->createKey( rProp.Name );
			saveProperty( 
				xProp->getPropertyValue( rProp.Name ), rProp.Type, xCur );
		}
	}
}

void OPropertySet::saveProperty( 
	const UsrAny& rAny, const XIdlClassRef& xClass, 
	const XRegistryKeyRef& xKey )
{
	if( xClass->equals( 
		OUString_getReflection()->getIdlClass() ) )
		xKey->setStringValue( rAny.getString() );
	else if( xClass->equals(
		INT32_getReflection()->getIdlClass() ) )
		xKey->setLongValue( rAny.getINT32() );
	else if( xClass->equals(
		INT16_getReflection()->getIdlClass() ) )
		xKey->setLongValue( rAny.getINT16() );
	else if( xClass->equals(
		Sequence<UString>::getReflection()->getIdlClass() ) )
		xKey->setStringListValue( 
			*(const Sequence<UString>*)	rAny.get() );
	else if( xClass->equals(
		BOOL_getReflection()->getIdlClass() ) )
		xKey->setStringValue( rAny.getBOOL() ?  L"true" : L"false" );
	else if( xClass->getTypeClass() == TypeClass_ENUM )
	{
		//save enum
		INT32 nValue = rAny.getEnumAsINT32();
		Sequence<XIdlFieldRef> aFields = xClass->getFields();
		const XIdlFieldRef* pFields = aFields.getConstArray();
		INT32 nLen = aFields.getLen();
		UsrAny aAny;
		for( INT32 nPos = 0; nPos < nLen; nPos++ )
		{
			aAny = pFields[ nPos ]->get( aAny );
			//! usr is buggy here, we would expect an enumeration any.
			// the way it is we don't know the size to be expected
			if( nValue == aAny.getINT32() )
			{
				xKey->setStringValue( pFields[ nPos ]->getName() );
				return;
			}
		}
	}
	else if( xClass->getTypeClass() == TypeClass_ANY )
	{
		// erase old values
		Sequence<UString> aOldKeys = xKey->getKeyNames();
		const UString* pOldKeys = aOldKeys.getConstArray();
		for( INT32 nKeyPos = aOldKeys.getLen(); nKeyPos--; )
		{
			UString aName( pOldKeys[ nKeyPos ] );
			INT32 nPos = aName.len( ) - 1;
			while( nPos && aName[ nPos ] != L'/' ) nPos--;
			if( nPos >= 0 ) aName = aName.copy( nPos + 1 );
			xKey->deleteKey( aName );
		}
		XRegistryKeyRef xCur = xKey->createKey( L"Type" );
		UsrAny aType;
		aType <<= rAny.getReflection()->getIdlClass();
		saveProperty( aType, aType.getReflection()->getIdlClass(), xCur );
		xCur = xKey->createKey( L"Value" );
		saveProperty( rAny, rAny.getReflection()->getIdlClass(), xCur );
	}
	else if( xClass->getTypeClass() == TypeClass_VOID )
	{
	}
	else
	{
		XIdlClassRef xElementClass;
		if( rAny >>= xElementClass )
			xKey->setStringValue( 
				xElementClass.is() ? 
				xElementClass->getName() : UString() );
		else
		{
			// erase old values
			Sequence<UString> aOldKeys = xKey->getKeyNames();
			const UString* pOldKeys = aOldKeys.getConstArray();
			for( INT32 nKeyPos = aOldKeys.getLen(); nKeyPos--; )
			{
				UString aName( pOldKeys[ nKeyPos ] );
				INT32 nPos = aName.len( ) - 1;
				while( nPos && aName[ nPos ] != L'/' ) nPos--;
				if( nPos >= 0 ) aName = aName.copy( nPos + 1 );
				xKey->deleteKey( aName );
			}
			XIdlArrayRef xArray = xClass->getArray();
			if( xArray.is() )
			{
				// save sequence
				INT32 nLen = xArray->getLen( rAny );
				String aKeyName;
				String aItem = "ArrayElement_";
				for( INT32 nPos = 0; nPos < nLen; nPos++ )
				{
					( aKeyName = aItem ) += nPos;
					UString aPos = SHOULDBEUNICODE( aKeyName );
					XRegistryKeyRef xCur = xKey->openKey( aPos );
					if( !xCur.is() ) xCur = xKey->createKey( aPos );
					UsrAny aSaveAny = xArray->get( rAny, nPos );
					saveProperty( 
						aSaveAny, 
						aSaveAny.getReflection()->getIdlClass(), xCur );
				}
			}
			else if( xClass->getTypeClass() == TypeClass_STRUCT )
			{
				//save struct
				Sequence<XIdlFieldRef> aFields = xClass->getFields();
				const XIdlFieldRef* pFields = aFields.getConstArray();
				INT32 nLen = aFields.getLen();
				UString aName;
				for( INT32 nPos = 0; nPos < nLen; nPos++ )
				{
					aName = pFields[ nPos ]->getName();
					XRegistryKeyRef xCur = xKey->openKey( aName );
					if( !xCur.is() ) xCur = xKey->createKey( aName );
					saveProperty( 
						pFields[ nPos ]->get( rAny ), 
						pFields[ nPos ]->getType(), xCur );
				}
			}
			else THROW( RuntimeException() );
		}
	}
}

void OPropertySet::loadPropertySet( 
	const XPropertySetRef& xProp, const XRegistryKeyRef& xKey )
{
	XPropertySetInfoRef xInfo( xProp->getPropertySetInfo() );
	Sequence<Property> aProps = xInfo->getProperties();
	const Property* pProps = aProps.getConstArray();
	INT32 nPos;
	for( nPos = aProps.getLen(); nPos--; )
	{
		const Property& rProp = pProps[ nPos ];
		if( !(rProp.Attributes & PropertyAttribute_TRANSIENT ) )
		{
			XRegistryKeyRef xSubKey = xKey->openKey( rProp.Name );
			if( !xSubKey.is() ) continue;
			xProp->setPropertyValue( 
				rProp.Name, loadProperty( rProp.Type, xSubKey ) );
		}
	}
}


UsrAny OPropertySet::loadProperty( 
	const XIdlClassRef& xClass, const XRegistryKeyRef& xKey )
{
	if( xClass->equals( 
		OUString_getReflection()->getIdlClass() ) )
		return UsrAny( xKey->getStringValue() );
	else if( xClass->equals(
		INT32_getReflection()->getIdlClass() ) )
		return UsrAny( xKey->getLongValue() );
	else if( xClass->equals(
		INT16_getReflection()->getIdlClass() ) )
		return UsrAny( (INT16) xKey->getLongValue() );
	else if( xClass->equals(
		Sequence<UString>::getReflection()->getIdlClass() ) )
	{
		UsrAny aAny;
		aAny <<= xKey->getStringListValue();
		return aAny;
	}
	else if( xClass->equals( BOOL_getReflection()->getIdlClass() ) )
		return UsrAny( BOOL( 
			xKey->getStringValue() == L"true" ? TRUE : FALSE ) );
	else if( xClass->getTypeClass() == TypeClass_ENUM )
	{
		UString aValue = xKey->getStringValue();
		Sequence<XIdlFieldRef> aFields = xClass->getFields();
		const XIdlFieldRef* pFields = aFields.getConstArray();
		INT32 nLen = aFields.getLen();
		for( INT32 nPos = 0; nPos < nLen; nPos++ )
		{
			if( pFields[ nPos ]->getName() == aValue )
			{
				UsrAny aResult = pFields[ nPos ]->get( UsrAny() );
				Reflection*	getReflectionFromClass( 
					const XIdlClassRef& xIdlClass );
				aResult.setEnumAsINT32( 
					aResult.getINT32(), getReflectionFromClass(	xClass ) );
				return aResult;
			}
		}
		THROW( RuntimeException() );
	}
	else if( xClass->getTypeClass() == TypeClass_ANY )
	{
		XRegistryKeyRef xCur = xKey->openKey( L"Type" );
		if( !xCur.is() ) 		THROW( RuntimeException() );
		UsrAny aType = loadProperty( 
			XIdlClass_getReflection()->getIdlClass(), xCur );
		xCur = xKey->openKey( L"Value" );
		if( !xCur.is() ) 		THROW( RuntimeException() );
		XIdlClassRef xAnyClass;
		aType >>= xAnyClass;
		UsrAny aRet;
		aRet <<= loadProperty( xAnyClass, xCur );
		return aRet;
	}
	else if( xClass->getTypeClass() == TypeClass_VOID )
	{
		return UsrAny();
	}
	else if( xClass->equals( XIdlClass_getReflection()->getIdlClass() ) )
	{
		UString aType = xKey->getStringValue();
		XIdlClassRef xRet;
		if( aType.len() )
		{
			XIdlReflectionRef xProv( 
				getProcessServiceManager()->createInstance(
					L"stardiv.uno.CoreReflection" ), USR_QUERY );
			xRet = xProv->forName( aType );
		}
		UsrAny aRet;
		aRet <<= xRet;
		return aRet;
	}
	else
	{
		XIdlArrayRef xArray = xClass->getArray();
		if( xArray.is() )
		{
			// load sequence
			Sequence<XRegistryKeyRef> aKeys = xKey->openKeys();
			INT32 nLen = aKeys.getLen( );
			const XRegistryKeyRef* pKeys = aKeys.getConstArray();
			UsrAny aAny;
			xClass->createObject( aAny );
			xArray->realloc( aAny, nLen );
			for( INT32 nPos = 0; nPos < nLen; nPos++ )
			{
				const XRegistryKeyRef& xCur = pKeys[ nPos ];
				// determine element type
				xArray->set( aAny, nPos, loadProperty(
					((SequenceReflection*)aAny.getReflection())->
					getElementReflection()->getIdlClass(), xCur ) );
			}
			return aAny;
		}
		else if( xClass->getTypeClass() == TypeClass_STRUCT )
		{
			//load struct
			UsrAny aAny;
			xClass->createObject( aAny );
			Sequence<XIdlFieldRef> aFields = xClass->getFields();
			const XIdlFieldRef* pFields = aFields.getConstArray();
			INT32 nLen = aFields.getLen();
			UString aName;
			for( INT32 nPos = 0; nPos < nLen; nPos++ )
			{
				const XIdlFieldRef& rField = pFields[ nPos ];
				aName = rField->getName();
				XRegistryKeyRef xCur = xKey->openKey( aName );
				if( !xCur.is() ) continue;
				rField->set( aAny, loadProperty( rField->getType(), xCur ) );
			}
			return aAny;
		}
	}
	THROW( RuntimeException() );
	return UsrAny();
}

Sequence< PropertyValue > OPropertySet::getPropertyValues(void) const 
	THROWS( (UsrSystemException) )
{
	OGuard aGuard( getMutex() );
	return m_pClass->getPropertyValues( m_pObject );
}

void OPropertySet::setPropertyValues(
	const Sequence< PropertyValue >& aProps) 
	THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, 
										 WrappedTargetException, UsrSystemException) )
{
	const PropertyValue* pProps = aProps.getConstArray();
	for( INT32 nPos = aProps.getLen(); nPos--; )
		setPropertyValue( pProps[ nPos ].Name, pProps[ nPos ].Value );
}


BOOL extractInterface( const UsrAny& rAny, XInterfaceRef& xIFace, Uik aUik )
{
	if( rAny.getReflection()->getTypeClass() == TypeClass_INTERFACE )
	{
		const XInterfaceRef& xRef = *(const XInterfaceRef*)rAny.get();
		if( xRef.is() ) return xRef->queryInterface( aUik, xIFace );
		xIFace = xRef;
		return TRUE;
	}
	return FALSE;
}


