/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ui.LegendPropertyEditPanel;
import com.jrefinery.chart.ui.PlotPropertyEditPanel;
import com.jrefinery.chart.ui.TitlePropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.PaintSample;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ChartPropertyEditPanel
extends JPanel
implements ActionListener {
    private TitlePropertyEditPanel titlePropertiesPanel;
    private LegendPropertyEditPanel legendPropertiesPanel;
    private PlotPropertyEditPanel plotPropertiesPanel;
    private JCheckBox antialias;
    private PaintSample background;

    public ChartPropertyEditPanel(JFreeChart jFreeChart) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel jPanel3 = new JPanel((LayoutManager)new LCBLayout(6));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.antialias = new JCheckBox("Draw anti-aliased");
        this.antialias.setSelected(jFreeChart.getAntiAlias());
        jPanel3.add(this.antialias);
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel("Background paint:"));
        this.background = new PaintSample(jFreeChart.getBackgroundPaint());
        jPanel3.add((Component)this.background);
        JButton jButton = new JButton("Select...");
        jButton.setActionCommand("BackgroundPaint");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Series Paint:"));
        JTextField jTextField = new JTextField("No editor implemented");
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton("Edit...");
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Series Stroke:"));
        jTextField = new JTextField("No editor implemented");
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton("Edit...");
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Series Outline Paint:"));
        jTextField = new JTextField("No editor implemented");
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton("Edit...");
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Series Outline Stroke:"));
        jTextField = new JTextField("No editor implemented");
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton("Edit...");
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        Legend legend = jFreeChart.getLegend();
        Plot plot = jFreeChart.getPlot();
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (legend != null) {
            this.legendPropertiesPanel = new LegendPropertyEditPanel(legend);
            this.legendPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.addTab("Legend", this.legendPropertiesPanel);
        }
        this.plotPropertiesPanel = new PlotPropertyEditPanel(plot);
        this.plotPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jTabbedPane.addTab("Plot", this.plotPropertiesPanel);
        jTabbedPane.add("Other", jPanel);
        jPanel4.add((Component)jTabbedPane, "North");
        this.add(jPanel4);
    }

    public TitlePropertyEditPanel getTitlePropertyEditPanel() {
        return this.titlePropertiesPanel;
    }

    public LegendPropertyEditPanel getLegendPropertyEditPanel() {
        return this.legendPropertiesPanel;
    }

    public PlotPropertyEditPanel getPlotPropertyEditPanel() {
        return this.plotPropertiesPanel;
    }

    public boolean getAntiAlias() {
        return this.antialias.isSelected();
    }

    public Paint getBackgroundPaint() {
        return this.background.getPaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color color = JColorChooser.showDialog(this, "Background Color", Color.blue);
        if (color != null) {
            this.background.setPaint((Paint)color);
        }
    }

    public void updateChartProperties(JFreeChart jFreeChart) {
        if (this.legendPropertiesPanel != null) {
            this.legendPropertiesPanel.setLegendProperties(jFreeChart.getLegend());
        }
        this.plotPropertiesPanel.updatePlotProperties(jFreeChart.getPlot());
        jFreeChart.setAntiAlias(this.getAntiAlias());
        jFreeChart.setBackgroundPaint(this.getBackgroundPaint());
    }
}

