/*************************************************************************
 *
 *  $RCSfile: salrectangleutils.cxx,v $
 *
 *  $Revision: 1.2 $
 *  last change: $Author: bmahbod $ $Date: 2001/03/12 23:15:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_SALRECTANGLEUTILS_CXX

#ifndef _SV_SALRECTANGLEUTILS_HXX
	#include <salrectangleutils.hxx>
#endif

// =======================================================================

// =======================================================================

void CheckRectBounds ( const Rect  *rPortBoundsRect,
                       Rect        *rSrcRect, 
                       Rect        *rDstRect
                     )
{
	if ( rSrcRect->top < rPortBoundsRect->top )
	{
		rDstRect->top += (rPortBoundsRect->top - rSrcRect->top);
		rSrcRect->top  = rPortBoundsRect->top;
	} // if

	if ( rSrcRect->left < rPortBoundsRect->left )
	{
		rDstRect->left += (rPortBoundsRect->left - rSrcRect->left);
		rSrcRect->left  = rPortBoundsRect->left;
	} // if

	if ( rSrcRect->bottom > rPortBoundsRect->bottom )
	{

		rDstRect->bottom += (rPortBoundsRect->bottom - rSrcRect->bottom);
		rSrcRect->bottom  = rPortBoundsRect->bottom;
	} // if

	if ( rSrcRect->right > rPortBoundsRect->right )
	{
		rDstRect->right += (rPortBoundsRect->right - rSrcRect->right);
		rSrcRect->right  = rPortBoundsRect->right;
	} // if
} // CheckRectBounds

// =======================================================================

// =======================================================================

void SalTwoRect2QDDstRect ( const SalTwoRect  *pPosAry,
                            Rect              *rDstRect
                          )
{
	MacSetRect( rDstRect,
	            pPosAry->mnDestX,
	            pPosAry->mnDestY,
	            pPosAry->mnDestX + pPosAry->mnDestWidth,
	            pPosAry->mnDestY + pPosAry->mnDestHeight
	          );
} // GetSalSourceRect

// -----------------------------------------------------------------------

void SalTwoRect2QDSrcRect ( const SalTwoRect  *pPosAry,
                            Rect              *rSrcRect
                          )
{
	MacSetRect( rSrcRect, 
	            pPosAry->mnSrcX,
	            pPosAry->mnSrcY,
	            pPosAry->mnSrcX + pPosAry->mnSrcWidth,
	            pPosAry->mnSrcY + pPosAry->mnSrcHeight
	          );
} // SalTwoRect2QDSrcRect
				
// =======================================================================

// =======================================================================

void GetQDRect ( const long   nX, 
                 const long   nY,
                 const long   nWidth, 
                 const long   nHeight,
                 Rect        *rRect
               )
{
	MacSetRect( rRect,  nX, nY, nX + nWidth, nY + nHeight );
} // GetQDRect

// -----------------------------------------------------------------------

void GetTwoRectFromSalBmp( const SalBitmap  &rSalBmp,
                           SalTwoRect       *rTwoRect
                         )
{
	const long  nWidth  = rSalBmp.GetSize().Width();
	const long  nHeight = rSalBmp.GetSize().Height();

	// Get size of graphics to copy from

	rTwoRect->mnSrcX  = 0;
	rTwoRect->mnDestX = 0;
	rTwoRect->mnSrcY  = 0;
	rTwoRect->mnDestY = 0;

	rTwoRect->mnSrcWidth   = nWidth;
	rTwoRect->mnDestWidth  = nWidth;
	rTwoRect->mnSrcHeight  = nHeight;
	rTwoRect->mnDestHeight = nHeight;
} // GetTwoRectFromSalBmp
				
// =======================================================================

// =======================================================================

