/*************************************************************************
 *
 *  $RCSfile: tlog.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 16:38:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include    "tlog.hxx"


using namespace std;

// <namespace_tstutl>
namespace tstutl
{

    void getFuncStateResultStr( rtl_String** retstr, rtl_TestResult* data,
                                    rtl_funcstate fsptr, rtl_String* delim );

    void getFuncStateErrMsg( rtl_String** retstr, rtl_TestResult* data,
                                    rtl_funcstate fsptr, rtl_String* delim );

    // implementation struct
    struct TestLog::log_impl
    {
        ::osl::File*    m_logfile;              // fileobject
        ::rtl::OUString m_logname;              // name of log
        rtl_String*     m_delim;
        sal_uInt32      m_flags;
    };
    // <method_initialize>
    void TestLog::initialize( const ::rtl::OString& name, sal_uInt32 frmt,
                                                        sal_Char* delim )
    {
        pImpl = new log_impl;
        pImpl->m_logname = cnvrtPth( name );
        pImpl->m_logfile = new ::osl::File( pImpl->m_logname );
        pImpl->m_delim = 0;
        rtl_string_newFromStr( &pImpl->m_delim, delim );
        pImpl->m_flags = frmt;
    } // </method_initialize>

    void TestLog::destroy()
    {
        if ( pImpl )
        {
            pImpl->m_logfile->close();
            delete( pImpl->m_logfile );
            rtl_string_release( pImpl->m_delim );
			delete( pImpl );
            pImpl = 0;
        }
    }

    // <method_open>
    ::osl::FileBase::RC TestLog::open( sal_Bool append )
    {

        if ( pImpl )
        {
            ::osl::FileBase::RC ret;

            if ( ! append )
                ret = ::osl::File::remove( pImpl->m_logname );

            if( pImpl->m_logfile->open( OpenFlag_Write ) ==
                                                    ::osl::FileBase::E_NOENT )
                ret = pImpl->m_logfile->open( OpenFlag_Write |
                                                            OpenFlag_Create );
            else
                ret = pImpl->m_logfile->setPos( Pos_End, 0 );

            return ret;
        }
        return ( ::osl::FileBase::E_INVAL );
    } // </method_open>

    // <method_close>
    ::osl::FileBase::RC TestLog::close()
    {
        if ( pImpl )
            return pImpl->m_logfile->close();

        return ( ::osl::FileBase::E_INVAL );
    } // </method_close>

    // <method_writeRes>
    ::osl::FileBase::RC TestLog::writeRes( ::rtl::TestResult& oRes )
    {
        ::osl::FileBase::RC ret;
        rtl_TestResult* data = oRes.getData();
        rtl_TestResult_vtable* funcs = data->pFuncs;
        rtl_funcstate fsptr = funcs->funcstate( data );
        rtl_String* funcres = 0;
        rtl_String* funcerr = 0;

        rtl_String* delim   = 0;
        rtl_String* outstr  = 0;
        rtl_String* errstr  = 0;

        rtl_string_newFromStr( &delim, ";" );

        getFuncStateResultStr( &funcres, data, fsptr, delim );
        rtl_string_newFromString( &outstr,funcres );
        rtl_string_release( funcres );
        funcres = 0;

        if (  funcs->isbit( data, rtl_tres_Flag_MSG ) )
        {
            getFuncStateErrMsg( &funcerr, data, fsptr, delim );

            if ( funcerr )
            {
                rtl_string_newConcat( &outstr, outstr, funcerr );
                rtl_string_release( funcerr );
                funcerr = 0;
            }
        }

        if (  funcs->isbit( data, rtl_tres_Flag_MSG ) &&
            ! funcs->isbit( data, rtl_tres_Flag_HIS ) &&
            ! funcs->isbit( data, rtl_tres_Flag_OK ) )
        {
            fsptr = funcs->nextfuncstate( funcs->funcstate( data ) );
            while ( fsptr != funcs->funcstate( data ) )
            {

                getFuncStateErrMsg( &funcerr, data, fsptr, delim );

                if ( funcerr )
                {
                    rtl_string_newConcat( &outstr, outstr, funcerr );
                    rtl_string_release( funcerr );
                    funcerr = 0;
                }
                fsptr = funcs->nextfuncstate( fsptr );
            }
        }

        if ( funcs->isbit( data, rtl_tres_Flag_HIS ) )
        {
            fsptr = funcs->nextfuncstate( funcs->funcstate( data ) );
            while ( fsptr != funcs->funcstate( data ) )
            {
                if ( funcs->isbit( data, rtl_tres_Flag_SKIP ) &&
                            ( funcs->flags( fsptr ) & rtl_tres_Flag_OK ) )
                {
                    fsptr = funcs->nextfuncstate( fsptr );
                    continue;
                }
                rtl_String* substr  = 0;
                rtl_string_newFromStr( &substr, "\n    " );

                getFuncStateResultStr( &funcres, data, fsptr, delim );

                rtl_string_newConcat( &substr, substr, funcres );
                rtl_string_release( funcres );
                funcres = 0;

                if ( funcs->isbit( data, rtl_tres_Flag_MSG ) )
                {
                    getFuncStateErrMsg( &funcerr, data, fsptr, delim );

                    if ( funcerr )
                    {
                        rtl_string_newConcat( &substr, substr, funcerr );
                        rtl_string_release( funcerr );
                        funcerr = 0;
                    }
                }
                rtl_string_newConcat( &outstr, outstr, substr  );
                rtl_string_release( substr );
                substr = 0;

				fsptr = funcs->nextfuncstate( fsptr );
            }
        }
        rtl_String* newline = 0;
        rtl_string_newFromStr( &newline, "\n" );
        rtl_string_newConcat( &outstr, outstr, newline  );
        ret = write( rtl_string_getStr( outstr ) ,
                    funcs->isbit( data, rtl_tres_Flag_VERBOSE ),
                    ( funcs->isbit( data, rtl_tres_Flag_SKIP ) &&
                      ( funcs->isbit( data, rtl_tres_Flag_OK ))));

        rtl_string_release( outstr ); outstr = 0;
        rtl_string_release( delim ); delim = 0;
        rtl_string_release( newline ); newline = 0;

        return( ret );
    } // </method_writeRes>

    // <method_write>
    ::osl::FileBase::RC TestLog::write( const sal_Char* buf, sal_Bool v,
                                                               sal_Bool skip )
    {
        if ( ! pImpl )
        {
            if ( ! skip )
                fprintf( stderr, "%s", buf );
            return ( ::osl::FileBase::E_NOENT );
        }
        sal_uInt64 uBytes=0;
        sal_uInt32 len = ln( buf );
        const sal_Char* ptr = buf;

        if ( v )
            fprintf( stderr, "%s", buf );

        return pImpl->m_logfile->write( buf, len , uBytes );
    } // </method_write>

    ::rtl::OUString& TestLog::getName()
    {
        return pImpl->m_logname;
    }

    ::osl::File* TestLog::getFile()
    {
        return pImpl->m_logfile;
    }

    void getFuncStateResultStr( rtl_String** retstr, rtl_TestResult* data,
                                    rtl_funcstate fstate, rtl_String* delim )
    {
        rtl_TestResult_vtable* funcs    = data->pFuncs;
        rtl_funcstate sstate            = funcs->funcstate( data );
        rtl_String* pname               = funcs->name( fstate );
        rtl_String* ptr                 = 0;
        rtl_String* msec                = 0;
        sal_uInt32 mstart               = 0;
        sal_uInt32 mstop                = 0;

        rtl_string_newFromString( retstr, pname );
        rtl_string_newConcat( retstr, *retstr, delim );

        if ( ( funcs->flags( fstate ) & rtl_tres_Flag_PASSED ) ==
                                                    rtl_tres_Flag_PASSED )
            rtl_string_newFromStr( &ptr, "PASSED" );
        else
            rtl_string_newFromStr( &ptr, "SKIPPED" );

        rtl_string_newConcat( retstr, *retstr, ptr );
        rtl_string_release( ptr ); ptr = 0;


        if ( ( funcs->flags( fstate ) & rtl_tres_Flag_OK ) ==
                                                        rtl_tres_Flag_OK )
            rtl_string_newFromStr( &ptr, "#OK#" );
        else
            rtl_string_newFromStr( &ptr, "#FAILED#" );

        rtl_string_newConcat( retstr, *retstr, ptr );
        rtl_string_release( ptr ); ptr = 0;

        if ( ( funcs->flags( sstate ) & rtl_tres_Flag_TIME ) ==
                                                        rtl_tres_Flag_TIME )
        {
            sal_Char buf[32];
            rtl_str_valueOfInt32( buf, ( funcs->stop( fstate) -
                                                funcs->start( fstate) ), 10 );

            rtl_string_newFromStr( &msec, buf );

            rtl_string_newConcat( retstr, *retstr, delim );
            rtl_string_newConcat( retstr, *retstr, msec );
            rtl_string_release( msec ); msec = 0;
        }
    }

    void getFuncStateErrMsg( rtl_String** retstr, rtl_TestResult* data,
                                    rtl_funcstate fstate, rtl_String* delim )
    {
        rtl_TestResult_vtable* funcs = data->pFuncs;
        rtl_funcstate funcptr =  funcs->funcstate( data );
        rtl_cmpstate cmpptr = 0;

        cmpptr = funcs->cmpstate( fstate );

        if ( cmpptr )
        {
            while ( cmpptr && cmpptr !=
                            funcs->nextcmpstate( funcs->cmpstate( fstate ) ) )
            {
                if(! funcs->stat( cmpptr ))
                {
                    if(! *retstr )
                        rtl_string_newFromString( retstr, delim );
                    else
                        rtl_string_newConcat( retstr, *retstr, delim );

                    rtl_string_newConcat( retstr, *retstr, funcs->msg( cmpptr ) );
                }
                cmpptr = funcs->nextcmpstate( cmpptr );
            }
            if( ! funcs->stat( cmpptr ) )
            {
                if( ! *retstr )
                    rtl_string_newFromString( retstr, delim );
                else
                    rtl_string_newConcat( retstr, *retstr, delim );

                rtl_string_newConcat( retstr, *retstr, funcs->msg( cmpptr ) );
            }
        }
    }
} // </namespace_tstutl>



