/*************************************************************************
 *
 *  $RCSfile: sw3nodes.cxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/04 13:24:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#if !(defined _SVSTDARR_STRINGS_DECL && defined _SVSTDARR_BYTESTRINGS_DECL && \
	  defined _SVSTDARR_USHORTS_DECL && defined _SVSTDARR_XUB_STRLEN_DECL && \
	  defined _SVSTDARR_BOOLS_DECL)
#define _SVSTDARR_STRINGS
#define _SVSTDARR_BYTESTRINGS
#define _SVSTDARR_USHORTS
#define _SVSTDARR_XUB_STRLEN
#define _SVSTDARR_BOOLS
#include <svtools/svstdarr.hxx>
#endif

#ifndef _IPOBJ_HXX //autogen
#include <so3/ipobj.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _IMAP_HXX //autogen
#include <svtools/imap.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SVXLINKMGR_HXX
#include <svx/linkmgr.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_CSCOITEM_HXX //autogen
#include <svx/cscoitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_TSPTITEM_HXX //autogen
#include <svx/tstpitem.hxx>
#endif

#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _TXTFTN_HXX //autogen
#include <txtftn.hxx>
#endif
#ifndef _FMTURL_HXX //autogen
#include <fmturl.hxx>
#endif
#ifndef _FCHRFMT_HXX //autogen
#include <fchrfmt.hxx>
#endif
#ifndef _FMTFTN_HXX //autogen
#include <fmtftn.hxx>
#endif
#ifndef _FMTFLCNT_HXX //autogen
#include <fmtflcnt.hxx>
#endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif
#ifndef _FMTINFMT_HXX //autogen
#include <fmtinfmt.hxx>
#endif
#ifndef _TXTFLCNT_HXX //autogen
#include <txtflcnt.hxx>
#endif
#ifndef _CHARATR_HXX
#include <charatr.hxx>
#endif
#ifndef _FRMFMT_HXX //autogen
#include <frmfmt.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#ifndef _PARATR_HXX
#include <paratr.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _SW3IO_HXX
#include <sw3io.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _NDGRF_HXX
#include <ndgrf.hxx>
#endif
#ifndef _NDOLE_HXX
#include <ndole.hxx>
#endif
#ifndef _FLYPOS_HXX
#include <flypos.hxx>
#endif
#ifndef _BOOKMRK_HXX
#include <bookmrk.hxx>
#endif
#ifndef _CRYPTER_HXX
#include <crypter.hxx>
#endif
#ifndef _WRONG_HXX
#include <wrong.hxx>
#endif
#ifndef _TOX_HXX
#include <tox.hxx>
#endif
#ifndef _FMTHBSH_HXX
#include <fmthbsh.hxx>
#endif
// OD 27.06.2003 #108784#
#ifndef _DCONTACT_HXX
#include <dcontact.hxx>
#endif

// Export
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif

#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

#define URL_DECODE 	\
	, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS

SV_IMPL_PTRARR_SORT(Sw3SortFmts,SwFmtPtr)

////////////////////////////////////////////////////////////////////////////

// Vorbereitung des Exports eines Text-Nodes in das Sw31 File-Format
// (dazu muessen SwFmtInetFmt-Hints in Felder umgewandelt werden)
// Idee:
// Die Start- und End-Positionen aller Hints werden in zwei USHORT-Arrays
// gespeichert, die SfxPoolItems der Hints in einem dritten. Diese
// "Hint"-Arrays werden entsprechend aufbereitet und dann statt der
// Original-Hints ausgegeben.
//
// Wie wird aufbereitet?
// Die "Hints" werden zunaechst in die Arrays kopiert. dabei werden
// - Schachtelungen von SwFmtINetFmt-Hints aufgeloest.
// - leere SwFmtINetFmt-Hints "entfernt"
// - Hints innerhalb von SwFmtINetFmt-Hints "entfernt"
//
// Danach werden die Texte der SwFmtINetFmt-Hints extrahiert und der
// Text des Nodes sowie die Htnt-Psotionen an die Verwendung von Feldern
// angepasst.

SV_DECL_PTRARR(SfxPoolItems,SfxPoolItem * ,16,16)
struct Sw3ExportTxtAttrs
{
	SvXub_StrLens 	aItemStarts;	// Start-Pos der Hints
	SvXub_StrLens	aItemEnds;		// End-Pos der Hints
	SfxPoolItems 	aItems;			// Items der Hints
	SvByteStrings 	aINetFmtTexts;	// Texte der SwFmtINetFmt-Hints

	ByteString		aText;			// Node-Text

	USHORT			nDrawFrmFmts; 	// Anzahl zeichengeb. Zeichen-Objekte

	Sw3ExportTxtAttrs() : nDrawFrmFmts( 0 ) {}
};

class SwInsHardBlankSoftHyph
{
	SvXub_StrLens 	aItemStarts;	// Start-Pos der Hints
	SfxPoolItems 	aItems;			// Items der Hints
public:
	SwInsHardBlankSoftHyph() {}
	~SwInsHardBlankSoftHyph();
	void AddItem( xub_StrLen nPos, sal_Unicode c );
	void ChangePos( xub_StrLen nHtEnd, xub_StrLen nOffs );
	void OutAttr( Sw3IoImp& rIo, xub_StrLen nStt, xub_StrLen nEnd );
};


////////////////////////////////////////////////////////////////////////////

// Ausgabe von FlyFrames, die an einem Node kleben

void Sw3IoImp::OutNodeFlyFrames( ULONG nNodeId )
{
	// FlyFrames duerfen Tabellen enthalten, koennen also Tabelle in Tabelle
	// simulieren
	SwTable* pSave = pCurTbl; pCurTbl = NULL;
	SwFmt* pFly;
	while( ( pFly = FindFlyFrm( nNodeId ) ) != NULL )
	{
		if( !pFly->IsDefault() )
		{
			BYTE cType = SWG_FLYFMT;
            // OD 27.06.2003 #108784# - do *not* export drawing objects in header/footer
            bool bExport = true;
            if( RES_DRAWFRMFMT == pFly->Which() )
            {
				cType = SWG_SDRFMT;
                SwFrmFmt* pDrawFrmFmt = static_cast<SwFrmFmt*>(pFly);
                const SwFmtAnchor& rFmtAnchor = pDrawFrmFmt->GetAnchor();
                if ( rFmtAnchor.GetAnchorId() != FLY_PAGE &&
                     pDrawFrmFmt->GetDoc()->IsInHeaderFooter( rFmtAnchor.GetCntntAnchor()->nNode ) )
                {
                    bExport = false;
                }
            }
            if ( bExport )
            {
                OutFormat( cType, *pFly );
            }
		}
	}
	pCurTbl = pSave;
}

// zeichengebundene Zeichen-Objekte absatzgebunden exportieren
void Sw3IoImp::ExportNodeDrawFrmFmts( const SwTxtNode& rNd, xub_StrLen nStart,
									  xub_StrLen nEnd, USHORT nCount )
{
	ASSERT( pExportInfo, "Wo sind die Export-Informationen???" );
	if( !pExportInfo || !nCount )
		return;

	pExportInfo->bDrwFrmFmt31 = TRUE;

	USHORT nCntAttr = rNd.HasHints() ? rNd.GetSwpHints().Count() : 0;
	USHORT nExported = 0;
	for( USHORT n = 0; n < nCntAttr && nExported < nCount; n++ )
	{
		const SwTxtAttr* pHt = rNd.GetSwpHints()[ n ];
		BOOL   bHtEnd   = BOOL( pHt->GetEnd() != NULL );
		xub_StrLen nHtStart = *pHt->GetStart();

		if( !bHtEnd && nHtStart >= nStart && nHtStart < nEnd &&
			RES_TXTATR_FLYCNT==pHt->GetAttr().Which() )
		{
			const SwFmtFlyCnt& rFlyCnt = (const SwFmtFlyCnt&)pHt->GetAttr();
			const SwFmt *pFmt = rFlyCnt.GetFrmFmt();
			if( RES_DRAWFRMFMT == pFmt->Which() )
			{
				OutFormat( SWG_SDRFMT, *pFmt );
				nExported++;
			}
		}
	}

	pExportInfo->bDrwFrmFmt31 = FALSE;
}

sal_Char Sw3IoImp::ConvStarSymbolCharToStarBats( sal_Unicode c )
{
	if( !hBatsFontConv )
	{
		hBatsFontConv = CreateFontToSubsFontConverter( sStarSymbol,
				 FONTTOSUBSFONT_EXPORT|FONTTOSUBSFONT_ONLYOLDSOSYMBOLFONTS );
		ASSERT( hBatsFontConv, "Got no symbol font converter" );
	}
	if( hBatsFontConv )
	{
		c = ConvertFontToSubsFontChar( hBatsFontConv, c );
	}

	return (sal_Char)c;
}

sal_Unicode Sw3IoImp::ConvStarBatsCharToStarSymbol( sal_Char c )
{
	sal_Unicode cNew = (sal_Unicode)(sal_uChar)c;
	if( !hBatsFontConv )
	{
		hBatsFontConv = CreateFontToSubsFontConverter( sStarBats,
				 FONTTOSUBSFONT_IMPORT|FONTTOSUBSFONT_ONLYOLDSOSYMBOLFONTS );
		ASSERT( hBatsFontConv, "Got no symbol font converter" );
	}
	if( hBatsFontConv )
	{
		cNew = ConvertFontToSubsFontChar( hBatsFontConv, (sal_Unicode)(sal_uChar)c + 0xf000 );
	}

	return cNew;
}

sal_Unicode Sw3IoImp::ConvStarMathCharToStarSymbol( sal_Char c )
{
	sal_Unicode cNew = c;
	if( !hMathFontConv )
	{
		hMathFontConv = CreateFontToSubsFontConverter( sStarMath,
				 FONTTOSUBSFONT_IMPORT|FONTTOSUBSFONT_ONLYOLDSOSYMBOLFONTS );
		ASSERT( hMathFontConv, "Got no symbol font converter" );
	}
	if( hMathFontConv )
	{
		cNew = ConvertFontToSubsFontChar( hMathFontConv, (sal_Unicode)(sal_uChar)c + 0xf000 );
	}

	return cNew;
}

sal_Bool lcl_sw3io_isStarSymbolFontItem( const SvxFontItem& rFontItem )
{
	return ( rFontItem.GetFamilyName().EqualsAscii( "StarSymbol", 0, sizeof("StarSymbol")-1 ) ||
			 rFontItem.GetFamilyName().EqualsAscii( "OpenSymbol", 0, sizeof("OpenSymbol")-1 ) );
}

// Hilfsroutine fuer ConvertText: Suche nach dem naechsten Hint,
// der eine Konversion verbietet. Zur Zeit sind dies Hints, die entweder
// direkt oder indirekt auf einen Font mit CHARSET_SYMBOL hinweisen.
const SvxFontItem *lcl_sw3io_getNextFontHint( const SwpHints* pHints, USHORT& rHint,
								xub_StrLen& rStart, xub_StrLen& rEnd,
								sal_Bool& rIsMathOrBatsFontItem,
								Sw3Fmts *pConvToSymbolFmts,
							    const SvxFontItem& rStarBatsItem,
							    const SvxFontItem& rStarMathItem )
{
	rStart = rEnd = (xub_StrLen)-1;
	rIsMathOrBatsFontItem = sal_False;

	if( !pHints )
		return 0;

	const SvxFontItem *pFontItem = 0;
	while( rHint < pHints->Count() )
	{
		const SwTxtAttr* pHnt = (*pHints) [rHint++];
		if( pHnt->Which() == RES_CHRATR_FONT )
		{
			rStart = *pHnt->GetStart();
			rEnd   = *pHnt->GetEnd();
			pFontItem = &pHnt->GetFont();
			rIsMathOrBatsFontItem =
				RTL_TEXTENCODING_SYMBOL == pFontItem->GetCharSet() &&
				( pFontItem->GetFamilyName().EqualsIgnoreCaseAscii( "StarBats", 0, sizeof("StarBats")-1 ) ||
				  pFontItem->GetFamilyName().EqualsIgnoreCaseAscii( "StarMath", 0, sizeof("StarMath")-1 ) );
			break;
		}
		// Gibt es einen CharFormat-Hint mit einem Symbol-Font?
		else if( pHnt->Which() == RES_TXTATR_CHARFMT )
		{
			SwCharFmt* pFmt = pHnt->GetCharFmt().GetCharFmt();
			if( pFmt->GetAttrSet().GetItemState( RES_CHRATR_FONT, FALSE )
				== SFX_ITEM_SET )
			{
				rStart = *pHnt->GetStart();
				rEnd   = *pHnt->GetEnd();
				pFontItem = &pFmt->GetFont();
				if( pConvToSymbolFmts &&
					lcl_sw3io_isStarSymbolFontItem( *pFontItem ) )
				{
					BYTE nFlags = pConvToSymbolFmts->GetFlags( pFmt );
					if( (SW3IO_CONV_FROM_BATS & nFlags) != 0 )
						pFontItem = &rStarBatsItem;
					else if( (SW3IO_CONV_FROM_MATH & nFlags) != 0 )
						pFontItem = &rStarMathItem;
				}
				break;
			}
		}
	}

	return pFontItem;
}

// Text Node konvertieren
// Wird aufgerufen, wenn sich die Systeme unterscheiden. Der Text wird
// vom einen in den anderen Zeichensatz konvertiert. Nicht konvertierbare
// Zeichen werden farblich unterlegt; Hints mit CHARSET_SYMBOL-Zeichensaetzen
// werden uebersprungen

const SwTxtAttr* lcl_sw3io_hasTxtAttr( const SwpHints *pHints, xub_StrLen nIdx )
{
	const SwTxtAttr* pRet = 0;
	if( pHints )
	{
		USHORT nHints = pHints->Count();
		for( USHORT i = 0; i < nHints; i++ )
		{
			const SwTxtAttr *pPos = (*pHints)[i];
			const xub_StrLen nStart = *pPos->GetStart();
			if( nIdx == nStart && !pPos->GetEnd() )
			{
				pRet = pPos;
				break;
			}
			if( nStart > nIdx )
				break;
		}
	}

	return pRet;
}

sal_Bool Sw3IoImp::ConvertText( ByteString& rText8, String& rText,
							xub_StrLen nStart, xub_StrLen nEnd,
							xub_StrLen nOffset, const SwTxtNode& rNd,
							rtl_TextEncoding eEnc,
						   	const SvxFontItem& rFontItem,
							SwInsHardBlankSoftHyph* pHBSH, BOOL bTo8 )
{
	sal_Bool bRet = sal_False;
	const SwpHints *pHints = rNd.GetpSwpHints();
	if( bTo8 )
	{
		sal_Bool bToBats = lcl_sw3io_isStarSymbolFontItem( rFontItem );
		bRet = bToBats;
		if( bToBats || RTL_TEXTENCODING_SYMBOL == rFontItem.GetCharSet() )
		{
			for( xub_StrLen nPos = nStart; nPos < nEnd; nPos++ )
			{
				sal_Unicode c = rText.GetChar( nPos );
				switch ( c )
				{
				case CHAR_HARDBLANK:
				case CHAR_HARDHYPHEN:
				case CHAR_SOFTHYPHEN:
					if( pHBSH )
					{
						pHBSH->AddItem( nPos, c );
						c = '\xff';
					}
					break;

				case CH_TXTATR_BREAKWORD:
				case CH_TXTATR_INWORD:
					if( lcl_sw3io_hasTxtAttr( pHints, nPos+nOffset ) )
						c = '\xff';
					break;
				}
				if( bToBats )
					rText8 += ConvStarSymbolCharToStarBats( c );
				else
					rText8 += (sal_Char)c;
			}
		}
		else
		{
			xub_StrLen nCopy = nStart;
			for( xub_StrLen nPos = nStart; nPos < nEnd; nPos++ )
			{
				sal_Unicode c = rText.GetChar( nPos );
				BOOL bToFF = FALSE;
				switch ( c )
				{
				case CHAR_HARDBLANK:
				case CHAR_HARDHYPHEN:
				case CHAR_SOFTHYPHEN:
					if( pHBSH )
					{
						pHBSH->AddItem( nPos, c );
						bToFF = TRUE;
					}
					break;

				case CH_TXTATR_BREAKWORD:
				case CH_TXTATR_INWORD:
					bToFF = 0 != lcl_sw3io_hasTxtAttr( pHints, nPos+nOffset );
					break;
				}
				if( bToFF )
				{
					if( nCopy < nPos )
						rText8 += ByteString( rText.Copy(nCopy,nPos-nCopy),
										  	eEnc );
					rText8 += '\xff';
					nCopy = nPos + 1;
				}
			}
			if( nCopy < nEnd )
				rText8 += ByteString( rText.Copy(nCopy,nEnd-nCopy), eEnc );
		}
	}
	else
	{
		const SwTxtAttr* pTAttr;
		if( RTL_TEXTENCODING_SYMBOL == rFontItem.GetCharSet() )
		{
			sal_Bool bBatsToSymbol =
				rFontItem.GetFamilyName().EqualsIgnoreCaseAscii( sStarBats );
			sal_Bool bMathToSymbol =
				rFontItem.GetFamilyName().EqualsIgnoreCaseAscii( sStarMath );
			bRet = bBatsToSymbol || bMathToSymbol;
			for( xub_StrLen nPos = nStart; nPos < nEnd; nPos++ )
			{
				sal_Char c = rText8.GetChar( nPos );
				if( '\xff' == c && 0 != (pTAttr =
						lcl_sw3io_hasTxtAttr( pHints, nPos+nOffset )) )
					rText += GetCharOfTxtAttr( *pTAttr );
				else if( bBatsToSymbol )
					rText += ConvStarBatsCharToStarSymbol( c );
				else if( bMathToSymbol )
					rText += ConvStarMathCharToStarSymbol( c );
				else
					rText += ByteString::ConvertToUnicode( c,
										RTL_TEXTENCODING_SYMBOL );
			}
		}
		else
		{
			xub_StrLen nCopy = nStart;
			for( xub_StrLen nPos = nStart; nPos < nEnd; nPos++ )
			{
				sal_Char c = rText8.GetChar( nPos );
				sal_Unicode cNew;
				if( '\xff' == c )
				{
					if( 0 != ( pTAttr = lcl_sw3io_hasTxtAttr(
												pHints, nPos+nOffset )) ||
						CHAR_HARDBLANK ==
							( cNew = rNd.GetTxt().GetChar( nPos+nOffset )) ||
					  	CHAR_HARDHYPHEN == cNew || CHAR_SOFTHYPHEN == cNew )
					{
						if( nCopy < nPos )
							rText += String( rText8.Copy(nCopy,nPos-nCopy), eEnc );
						if( pTAttr )
							rText += GetCharOfTxtAttr( *pTAttr );
						else
							rText += cNew;
						nCopy = nPos + 1;
					}
				}
				else if( CHAR_SOFTHYPHEN ==rNd.GetTxt().GetChar( nPos+nOffset ) )
				{
					// The original charcter has been converted into a soft
					// hyphen, but there was no text attribute at this position.
					// We then have to replace the soft hyphen with a hard one.
					// The check is based on the source char set and not on
					// the actual one. The assumption is here that there is
					// no difference in the position of the soft hyphen.
					// However, to not accidentially do a wrong conversion
					// we check this again. The only mistake we might make
					// if the assumption is wrong is to not convert a soft
					// hyphen.
					if( eEnc == eSrcSet ||
						CHAR_SOFTHYPHEN == ByteString::ConvertToUnicode( c, eEnc ) )
					{
						if( nCopy < nPos )
							rText += String( rText8.Copy(nCopy,nPos-nCopy), eEnc );
						rText += '-';
						nCopy = nPos + 1;
					}
				}
			}
			if( nCopy < nEnd )
				rText += String( rText8.Copy( nCopy, nEnd-nCopy ), eEnc );
		}
	}
	return bRet;
}

typedef const SvxFontItem *SvxFontItemPtr;
SV_DECL_PTRARR( SvxFontItems, SvxFontItemPtr, 5, 5 );

typedef SwTxtAttr *SwTxtAttrPtr;
SV_DECL_PTRARR( SwTxtAttrs, SwTxtAttrPtr, 5, 5 );

void Sw3IoImp::ConvertText( ByteString& rText8, String& rText,
							xub_StrLen nOffset, SwTxtNode& rNd,
							rtl_TextEncoding eEnc, const SvxFontItem& rFontItem,
							SwInsHardBlankSoftHyph* pHBSH, BOOL bTo8 )

{
	SvxFontItems aFontItemStack;
	SvXub_StrLens aEndPosStack;
	SwTxtAttrs aDeleteFontTxtAttrs;
	SvXub_StrLens aInsertSymbolFontStartPoss;
	SvXub_StrLens aInsertSymbolFontEndPoss;

	SvxFontItem aStarBatsItem( FAMILY_DONTKNOW, sStarBats, aEmptyStr,
							   PITCH_DONTKNOW, RTL_TEXTENCODING_SYMBOL );
	SvxFontItem aStarMathItem( FAMILY_DONTKNOW, sStarMath, aEmptyStr,
							   PITCH_DONTKNOW, RTL_TEXTENCODING_SYMBOL );

	SwpHints *pHints = rNd.GetpSwpHints();
	// find next
	xub_StrLen nFntStart = (xub_StrLen)-1, nFntEnd = 0;
	USHORT nHint = 0;
	const SvxFontItem *pFontItem = &rFontItem;
	sal_Bool bIsBatsOrMathFontItem;
	const SvxFontItem *pNewFontItem =
			lcl_sw3io_getNextFontHint( pHints, nHint, nFntStart,
									   nFntEnd, bIsBatsOrMathFontItem,
									   pConvToSymbolFmts, aStarBatsItem,
									   aStarMathItem );
	if( !bTo8 && pNewFontItem && bIsBatsOrMathFontItem )
		aDeleteFontTxtAttrs.Insert( pHints->GetHt( nHint-1), aDeleteFontTxtAttrs.Count() );
	xub_StrLen nLen = nOffset + (bTo8 ? rText.Len() : rText8.Len() );
	xub_StrLen nCopy = nOffset;
	for( xub_StrLen nPos = 0; nPos < nLen; nPos++ )
	{
		if( aEndPosStack.Count() &&
			nPos == aEndPosStack[aEndPosStack.Count()-1] )
		{
			if( nPos > nCopy )
			{
				sal_Bool bSymConv = ConvertText( rText8, rText, nCopy, nPos,
												 nOffset, rNd, eEnc,
												 *pFontItem, pHBSH, bTo8 );
				if( bSymConv && !bTo8 )
				{
					aInsertSymbolFontStartPoss.Insert( nCopy,
							aInsertSymbolFontStartPoss.Count() );
					aInsertSymbolFontEndPoss.Insert( nPos,
							aInsertSymbolFontEndPoss.Count() );
				}
				nCopy = nPos;
			}
			pFontItem = aFontItemStack[ aFontItemStack.Count()-1 ];
			aFontItemStack.Remove( aFontItemStack.Count()-1 );
			aEndPosStack.Remove( aEndPosStack.Count()-1 );
		}
		while( (xub_StrLen)-1 != nFntStart && nPos == nFntStart )
		{
			if( nPos > nCopy )
			{
				sal_Bool bSymConv = ConvertText( rText8, rText, nCopy, nPos,
												 nOffset, rNd,eEnc, *pFontItem,
												 pHBSH, bTo8 );
				if( bSymConv && !bTo8 )
				{
					aInsertSymbolFontStartPoss.Insert( nCopy,
							aInsertSymbolFontStartPoss.Count() );
					aInsertSymbolFontEndPoss.Insert( nPos,
							aInsertSymbolFontEndPoss.Count() );
				}
				nCopy = nPos;
			}
			aEndPosStack.Insert( nFntEnd, aEndPosStack.Count() );
			aFontItemStack.Insert( pFontItem, aFontItemStack.Count() );
			pFontItem = pNewFontItem;
			pNewFontItem = lcl_sw3io_getNextFontHint( pHints, nHint, nFntStart,
									 nFntEnd, bIsBatsOrMathFontItem,
									 pConvToSymbolFmts, aStarBatsItem,
									 aStarMathItem);
			if( !bTo8 && pNewFontItem && bIsBatsOrMathFontItem )
				aDeleteFontTxtAttrs.Insert( pHints->GetHt( nHint-1 ), aDeleteFontTxtAttrs.Count() );
		}
	}
	if( nLen > nCopy )
	{
		sal_Bool bSymConv = ConvertText( rText8, rText, nCopy, nLen, nOffset,
							   rNd, eEnc, *pFontItem, pHBSH, bTo8 );
		if( bSymConv && !bTo8 )
		{
			aInsertSymbolFontStartPoss.Insert( nCopy,
					aInsertSymbolFontStartPoss.Count() );
			aInsertSymbolFontEndPoss.Insert( nPos,
					aInsertSymbolFontEndPoss.Count() );
		}
	}
	while( aDeleteFontTxtAttrs.Count() )
	{
		SwTxtAttr *pAttr = aDeleteFontTxtAttrs[0];
		aDeleteFontTxtAttrs.Remove( 0 );
		rNd.Delete( pAttr );
	}
	if( aInsertSymbolFontStartPoss.Count() )
	{
		const Font& rSymbolFont = SwNumRule::GetDefBulletFont();
		SvxFontItem aFontItem( rSymbolFont.GetFamily(), rSymbolFont.GetName(),
						  	   rSymbolFont.GetStyleName(),
							   rSymbolFont.GetPitch(),
							   rSymbolFont.GetCharSet() );
		for( USHORT i=0; i < aInsertSymbolFontStartPoss.Count(); i++ )
		{
			rNd.Insert( aFontItem, aInsertSymbolFontStartPoss[i],
						aInsertSymbolFontEndPoss[i] );
		}
	}
}

void Sw3IoImp::ConvertText( SwTxtNode& rNd, const ByteString& rText8,
							xub_StrLen nOffset,
							SvUShorts *pEncs, SvXub_StrLens *pPoss )
{
	if( !rText8.Len() )
		return;

	const SvxFontItem& rFont = rNd.GetSwAttrSet().GetFont();
	BOOL bNdSym = rFont.GetCharSet() == RTL_TEXTENCODING_SYMBOL;

	String& rNdText = (String &)rNd.GetTxt();
	String aText;
	ByteString aText8( rText8 );
	SvxFontItem aFontItem( rFont );
	if( pConvToSymbolFmts &&
		lcl_sw3io_isStarSymbolFontItem( aFontItem ) )
	{
		BYTE nFlags = pConvToSymbolFmts->GetFlags( rNd.GetFmtColl() );
		if( (SW3IO_CONV_FROM_BATS & nFlags) != 0 )
		{
			aFontItem.GetFamilyName() = sStarBats;
			aFontItem.GetCharSet() = RTL_TEXTENCODING_SYMBOL;
		}
		else if( (SW3IO_CONV_FROM_MATH & nFlags) != 0 )
		{
			aFontItem.GetFamilyName() = sStarMath;
			aFontItem.GetCharSet() = RTL_TEXTENCODING_SYMBOL;
		}
	}
	ConvertText( aText8, aText, nOffset, rNd,
						   eSrcSet, aFontItem, 0, FALSE );
	rNdText.Replace( nOffset, aText.Len(), aText );
	if( bNdSym &&
		SFX_ITEM_SET == rNd.GetSwAttrSet().GetItemState( RES_CHRATR_FONT,
														 sal_False ) &&
		( rFont.GetFamilyName().EqualsIgnoreCaseAscii( sStarBats ) ||
		  rFont.GetFamilyName().EqualsIgnoreCaseAscii( sStarMath ) ) )
	{
		const Font& rSymbolFont = SwNumRule::GetDefBulletFont();
		SvxFontItem aFontItem( rSymbolFont.GetFamily(),
							   rSymbolFont.GetName(),
							   rSymbolFont.GetStyleName(),
							   rSymbolFont.GetPitch(),
							   rSymbolFont.GetCharSet() );
		((SwCntntNode&)rNd).SetAttr( aFontItem );
	}

	if( pEncs )
	{
		for( USHORT i=0; i < pEncs->Count(); i++ )
		{
			xub_StrLen nStart = (*pPoss)[2*i];
			String aTmp( rText8.Copy( nStart - nOffset,
									  (*pPoss)[2*i+1] - nStart ),
						 (rtl_TextEncoding)(*pEncs)[i] );
			rNdText.Replace( nStart, aTmp.Len(), aTmp );
		}
	}
}

// Text Node einlesen
// Falls kein Node angegeben ist, wird ein neuer Node an der angegebenen
// Position erzeugt.
// nInsFirstPara - beim Document einfuegen, muss der erste Absatz
// 					sonderbehandelt werden (Absatz Attribute!)

void Sw3IoImp::InTxtNode( SwTxtNode* pNd, SwNodeIndex& rPos, xub_StrLen nOffset,
						  BYTE nInsFirstPara )
{
	SwTxtNode *pOldNd = pNd && pNd->GetDepends() ? pNd : 0;

	SvStringsDtor *pINetFldTexts = 0;	// Texte aus Internet-Feldern
	SvXub_StrLens *pINetFldPoss  = 0;		// Positionen der Internet-Felder

	SvXub_StrLens *pErasePoss  = 0;			// Positionen der Draw-Formate

	SvUShorts     *pCharSetColorEncs = 0;
	SvXub_StrLens *pCharSetColorPoss  = 0;	//

	OpenRec( SWG_TEXTNODE );
	BYTE   cNumLevel = NO_NUMBERING;
	USHORT nColl = IDX_DFLT_VALUE, nCondColl = IDX_DFLT_VALUE;
	SwWrongList *pWrong = 0;
	// 0x0L: Laenge der Daten
	// 0x10: Numerierung folgt
	// 0x20: Wrong-Liste ist nicht dirty
	BYTE cFlags = OpenFlagRec();
	*pStrm >> nColl;
	if( !IsVersion(SWG_LONGIDX) && (cFlags & 0x10) )
	{
		*pStrm >> cNumLevel;
		// Im SW31-format wurde fuer nicht numerierte
		// Absaetzte noch ein NO_NUMLEVEL mit rausgeschrieben.
		if( NO_NUM == cNumLevel  &&
			IsVersion( SWG_NONUMLEVEL, SWG_DESKTOP40 ) &&
			pStrm->Tell() != nFlagRecEnd )		// wenn noch Daten da sind
			*pStrm >> cNumLevel;				// NO_NUM -> NO_NUMLEVEL

		// Wenn ein NO_NUM gelesen wurde muss es noch in ein NO_NUMLEVEL
		// umgewandelt werden.
		bConvertNoNum |= (NO_NUM == cNumLevel);
	}

	if( IsVersion( SWG_CONDCOLLS, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		// bedingte Vorlagen gibt es nicht im 31-Export-Format
		*pStrm >> nCondColl;
		if( IDX_DFLT_VALUE != nCondColl )
		{
			// es ist eine gesetzt, dieses ist die bedingte Vorlage
			USHORT nTmp = nCondColl;
			nCondColl = nColl;
			nColl = nTmp;
		}
	}

	CloseFlagRec();
	SwTxtFmtColl* pColl = FindTxtColl( nColl );

	// JP 07.08.00: set never the default text format collection on a node
	if( pColl == pDoc->GetDfltTxtFmtColl() )
		pColl = pDoc->GetTxtCollFromPool( RES_POOLCOLL_STANDARD );

	// Der Text des Nodes darf nicht einfach so konvertiert werden!
	ByteString aText8;
	pStrm->ReadByteString( aText8 );
	if( pCrypter )
		pCrypter->Decrypt( aText8 );
	String aText( aText8, eSrcSet );
	if( !pNd )
	{
		pNd = pDoc->GetNodes().MakeTxtNode( rPos, pColl );
		rPos--;
		(String&) pNd->GetTxt() = aText;
	}
	else
	{
		if( !nInsFirstPara )
			pNd->ChgFmtColl( pColl );
		SwIndex aOff( pNd, nOffset );
		pNd->Insert( aText, aOff );
	}

	// Der Offset kann wegen Einf. von nicht sichtbaren Redlines auch
	// negativ werden. Das darf aber auch ausser weiteren Redlines nichts
	// mehr kommen.
	INT32 nOffsetL = nOffset;

	BOOL bConverted = FALSE;

	while( BytesLeft() )
	{
		BYTE cType = Peek();
		switch( cType )
		{
			case SWG_ATTRSET:
				if( nInsFirstPara )
				{
					SwAttrSet aTmpSet( pDoc->GetAttrPool(),
							RES_CHRATR_BEGIN, RES_CHRATR_END - 1 );
					InAttrSet( aTmpSet );
					if( aTmpSet.Count() )
					{
						ASSERT( nOffsetL>=0,
								"Offset darf hier nicht negativ sein" );
						if( 2 == nInsFirstPara )
							pNd->SetAttr( aTmpSet, 0, aText.Len() );
						else
							pNd->SetAttr( aTmpSet, (xub_StrLen)nOffsetL,
										  pNd->GetTxt().Len() );

						if( pNd->GetpSwAttrSet() )
							pNd->GetpSwAttrSet()->SetModifyAtAttr( pNd );
					}
				}
				else if( pOldNd )
				{
					SwAttrSet aTmpSet( pDoc->GetAttrPool(), aTxtNodeSetRange );
					InAttrSet( aTmpSet );
					if( aTmpSet.Count() )
					{
						pNd->SwCntntNode::SetAttr( aTmpSet );

						if( pNd->GetpSwAttrSet() )
							pNd->GetpSwAttrSet()->SetModifyAtAttr( pNd );
					}
				}
				else
				{
					if( !pNd->GetpSwAttrSet() )
						((SwCntntNode*) pNd)->NewAttrSet( pDoc->GetAttrPool() );
					InAttrSet( *pNd->GetpSwAttrSet() );
					pNd->GetpSwAttrSet()->SetModifyAtAttr( pNd );
				}
				break;
			case SWG_SDRFMT:
				// Keine Draw-Formate in Kopf oder Fusszeilen einfuegen oder
				// wenn kein Drawing-Layer da ist!
				if( (nGblFlags & SW3F_NODRAWING) || bInsIntoHdrFtr )
				{
					SkipRec(); break;
				} // sonst weiter:
			case SWG_FLYFMT:
			{
				// Absatzgebundener oder Rahmengebundener FlyFrame
				USHORT eSave_StartNodeType = eStartNodeType;
				eStartNodeType = SwFlyStartNode;
				SwFrmFmt* pFmt = (SwFrmFmt*) InFormat( cType, NULL );
				eStartNodeType = eSave_StartNodeType;

				if( !pFmt )
					break;

				// Anker darin versenken
				SwFmtAnchor aAnchor( pFmt->GetAnchor() );
				if( FLY_AT_CNTNT==aAnchor.GetAnchorId() ||
					FLY_IN_CNTNT==aAnchor.GetAnchorId() )
				{
					// Absatzgebunende Rahmen: Die Abfrage auf FLY_IN_CNTNT
					// ist drinne, weil der SW31-Export sowas dummerweise
					// mal exportiert hat...
					aAnchor.SetType( FLY_AT_CNTNT );
					SwPosition aPos( rPos );
					aAnchor.SetAnchor( &aPos );
				}
				else
				{
					// Dies sollte bisher nur ein rahmengebundener Rahmen
					// sein, koennte aber auch mal was anderes werden. Es
					// bleibt dann auf jeden Fall auch di Cntnt-Position
					// erhalten.
					SwPosition aPos( rPos, SwIndex(pNd,aAnchor.GetPageNum()) );
					aAnchor.SetAnchor( &aPos );
				}
				aAnchor.SetPageNum( 0 );
				pFmt->SetAttr( aAnchor );
				// Layout-Frames im Insert Mode fuer absatzgebundene
				// Flys erzeugen
				if( bInsert && !nRes ) pFmt->MakeFrms();
				break;
			}
			case SWG_ATTRIBUTE:
				ASSERT( nOffsetL>=0, "Offset darf hier nicht negativ sein" );
				InTxtAttr( *pNd, aText8, (xub_StrLen)nOffsetL, &pINetFldTexts,
						   &pINetFldPoss, &pErasePoss,
						   &pCharSetColorEncs, &pCharSetColorPoss );
				break;
			case SWG_NUMRULE:
				// NumRules gibt es an dieser Stelle nur im 3.1 und 4.0
				// Fileformat. Seit dem 5.0-Filformat werden sie in einem
				// eigenen Stream bzw. am Dok-Anfang gespeichert.
				OpenNumRange40( rPos );
				break;
			case SWG_NODENUM:
				// Den NodeNum-Record gibt es seit der 5.0
				{
					SwNodeNum aNodeNum;
					InNodeNum( aNodeNum );
					pNd->UpdateNum( aNodeNum );
				}
				break;
			case SWG_MARK:
				ASSERT( nOffsetL>=0, "Offset darf hier nicht negativ sein" );
				InNodeMark( rPos, (xub_StrLen)nOffsetL );
				break;

			case SWG_NODEREDLINE:
				// nOffsetL ist Referenz-Parameter.
				// nOffsetL kann jetzt negativ werden!
				// The text has to be converted before any redlines are
				// inserted. Otherwise, the content positions will not match
				// the indices within the 8-Bit-Text.
				if( !bConverted )
				{
					ConvertText( *pNd, aText8, (xub_StrLen)nOffsetL,
								 pCharSetColorEncs, pCharSetColorPoss );
					bConverted = TRUE;
				}
				InNodeRedline( rPos, nOffsetL );
				break;

			case SWG_WRONGLIST:
			{
				if( IsVersion( SWG_DESKTOP40 ) )
				{
					OpenRec( SWG_WRONGLIST );
					pWrong = new SwWrongList;
					UINT16 nBeginInv, nEndInv, nCount;
					OpenFlagRec();
					*pStrm >> nBeginInv >> nEndInv;
					CloseFlagRec();
					pWrong->SetInvalid( (xub_StrLen)nBeginInv,
										(xub_StrLen)nEndInv );
					*pStrm >> nCount;
					for( USHORT i=0; Good() && i<nCount; i++ )
					{
						UINT32 nWrong;
						*pStrm >> nWrong;
						xub_StrLen nPos = (xub_StrLen)nWrong;
						xub_StrLen nLen = (xub_StrLen)(0xFFFF & (nWrong >> 16));
						pWrong->Insert( nPos, nLen, pWrong->Count() );
					}
					if( bSpellAllAgain )
						pWrong->SetInvalid( 0, STRING_MAXLEN );
					if( bSpellWrongAgain )
						pWrong->InvalidateWrong();
					CloseRec( SWG_WRONGLIST );
				}
				else
					SkipRec();
			}
				break;
			default:
				SkipRec();
		}
	}
	CloseRec( SWG_TEXTNODE );

	// Eventuell den Text konvertieren
	if( !bConverted )
		ConvertText( *pNd, aText8, (xub_StrLen)nOffsetL,
					 pCharSetColorEncs, pCharSetColorPoss );

	// Numerierung uebernehmen
	if( !IsVersion(SWG_LONGIDX) )
	{
		if( cNumLevel != NO_NUMBERING )
		{
			// MAXLEVEL war im 3.1/4.0-SW 5 und kann sich nichr mehr aendern,
			// deshalb baruchen wir es nicht zu beachten.
#if 0
			if( cNumLevel != NO_NUM && GetRealLevel(cNumLevel) >= MAXLEVEL )
			{
				// die Numerierungs-Ebene ist zu hoch => die hoecht moegliche
				// setzen
				BYTE cTmp = MAXLEVEL-1;
				if( cNumLevel & NO_NUMLEVEL )
					cTmp |= NO_NUMLEVEL;
				cNumLevel = cTmp;
			}
#endif
			pNd->UpdateNum( SwNodeNum( cNumLevel ) );
		}
		else
			CloseNumRange40( rPos );
	}

	const SwNodeNum *pNdNum = pNd->GetNum();
	const SwAttrSet *pAttrSet = pNd->GetpSwAttrSet();
	if( pNdNum && IsVersion(SWG_LONGIDX) )
	{
		if( pAttrSet )
		{
			// Wenn der Absatz numeriert ist, muss die zugehoerige Numerierung
			// noch als benutzt markiert werden bzw. eine automatische
			// Numerierung beim Einfuegen umbenannt werden. Da automatische
			// Numerierungen nicht in Vorlagen vorkommen koennen, gehen
			// wir hier ueber das Attribut im Node-AttrSet und damit direkt
			// an unser Namens-Array.
			const SfxPoolItem *pItem;
			if( SFX_ITEM_SET == pAttrSet->GetItemState( RES_PARATR_NUMRULE,
														FALSE, &pItem )  )
			{
				const String& rName = ((const SwNumRuleItem*)pItem)->GetValue();
				if( rName.Len() )
				{
					Sw3NumRuleInfo aTmp( rName );
					USHORT nPos;
					if( aNumRuleInfos.Seek_Entry( &aTmp, &nPos ) )
					{
						Sw3NumRuleInfo *pInfo = aNumRuleInfos[nPos];
						if( !bNormal || bInsert )
						{
							// Beim Einfuegen oder Laden von Seitenvorlagen
							// muss das Item evtl. noch an den geaenderten Namen
							// der Seiten-Vorlage angepasst werden.
							pInfo->SetUsed();
							if( rName != pInfo->GetNewName() )
							{
								((SwCntntNode *)pNd)
									->SetAttr( SwNumRuleItem(pInfo->GetNewName()) );
							}
						}
						else
						{
							// Die entsprechende NumRule wird benutzt und braucht
							// nicht mehr geloescht zu werden. Also raus aus
							// dem Array damit.
							aNumRuleInfos.Remove( nPos, 1 );
							delete pInfo;
						}
					}
				}
				else
				{
					SwNodeNum aNodeNum( NO_NUMBERING );
					pNd->UpdateNum( aNodeNum );
					pNdNum = 0;
				}
			}
		}

		if( bPageDescs && !bNumRules )
		{
			// Wenn Seiten-Vorlagen aber keine Numerierungs-Vorlagen
			// geladen werden, dann muessen wir sicherstellen, dass
			// die Numerierungs-Vorlage auch existiert.
			const SfxPoolItem* pItem =
				pNd->GetNoCondAttr( RES_PARATR_NUMRULE, TRUE );
			if( pItem && ((SwNumRuleItem*)pItem)->GetValue().Len() &&
				!pDoc->FindNumRulePtr( ((SwNumRuleItem*)pItem)->GetValue() ) )
			{
				const String& rName = ((SwNumRuleItem*)pItem)->GetValue();
				USHORT nPoolId = SwStyleNameMapper::GetPoolIdFromUIName( rName, GET_POOLID_NUMRULE );
				if( nPoolId != USHRT_MAX )
					pDoc->GetNumRuleFromPool( nPoolId );
				else
					pDoc->MakeNumRule( rName );
			}
		}
	}

#ifdef NUM_RELSPACE
	// Wenn der Absatz ein LRSpace-Item enthaelt und in der Kapitel-Numerierung
	// ist muss das LRSpace-Item noch angepasst werden. Relative Werte
	// koennen dabei nicht vorkommen.
	const SwNumRule *pOutline = pDoc->GetOutlineNumRule();
	const SfxPoolItem *pItem;
	if( pAttrSet && (!pNdNum || NO_NUMBERING != pNdNum->GetLevel()) &&
		NO_NUMBERING != pColl->GetOutlineLevel() &&
		pOutline && nVersion != SWG_NUMRELSPACE )
	{
		const SwNumFmt& rNumFmt = pOutline->Get(
				GetRealLevel(((const SwTxtFmtColl*)pColl)->GetOutlineLevel()) );
		USHORT nNumLSpace = rNumFmt.GetAbsLSpace();

		if( SFX_ITEM_SET == pAttrSet->GetItemState( RES_LR_SPACE, FALSE,
													&pItem ) )
		{
			const SvxLRSpaceItem *pParaLRSpace =
				(const SvxLRSpaceItem *)pItem;

			USHORT nWishLSpace = (USHORT)pParaLRSpace->GetTxtLeft();
			USHORT nNewLSpace =
						nWishLSpace > nNumLSpace ? nWishLSpace-nNumLSpace : 0U;

			const SvxLRSpaceItem& rCollLRSpace = pColl->GetLRSpace();
			if( nNewLSpace == rCollLRSpace.GetTxtLeft() &&
				pParaLRSpace->GetRight() == rCollLRSpace.GetRight() &&
				pParaLRSpace->GetTxtFirstLineOfst() ==
											rCollLRSpace.GetTxtFirstLineOfst() )
			{
				pNd->ResetAttr( RES_LR_SPACE );
			}
			else if( nNewLSpace != pParaLRSpace->GetTxtLeft() )
			{
				SvxLRSpaceItem aLRSpace( *pParaLRSpace );
				short nFirst = aLRSpace.GetTxtFirstLineOfst();
				if( nFirst < 0 && (USHORT)-nFirst > nNewLSpace )
					aLRSpace.SetTxtFirstLineOfst( -(short)nNewLSpace );
				aLRSpace.SetTxtLeft( nNewLSpace );
				((SwCntntNode *)pNd)->SetAttr( aLRSpace );
			}

			if( !IsVersion(SWG_NUMRELSPACE) && nWishLSpace != nNewLSpace )
				lcl_sw3io__ConvertNumTabStop( *pNd, (long)nWishLSpace -
													(long)nNewLSpace, FALSE	);
		}
		else if( nNumLSpace > 0 && !IsVersion(SWG_NUMRELSPACE) )
		{
			lcl_sw3io__ConvertNumTabStop( *pNd, nNumLSpace, FALSE	);
		}
	}
#endif


	if( pINetFldTexts )
	{
		ASSERT( pINetFldPoss, "INet-Feld-Texte ohne Positionen???" );

		// Es mussen noch Texte von Internet-Feldern eingefuegt werden

		INT32 nOffset2 = 0;	// Verschiebung durch die Felder selbst

		for( USHORT i=0; i<pINetFldTexts->Count(); i++ )
		{
			const String &rStr = *(*pINetFldTexts)[i];

			// den Text hinter dem 0xff vom Feld einfuegen
			xub_StrLen nPos = xub_StrLen( nOffset2 + nOffset +
										  (*pINetFldPoss)[i] + 1 );
			SwIndex aOff( pNd, nPos );

			if( rStr.Len() )
			{
				pNd->Insert( rStr, aOff );
			}

			// und das 0xff loeschen
			aOff.Assign( pNd, nPos-1 );
			pNd->Erase( aOff, 1 );

			// und den Offset korrigieren
			nOffset2 += rStr.Len();
			nOffset2--;
		}

		// die Wrong-Liste ist jetzt ungueltig
		delete pWrong;
		pWrong = 0;
		cFlags &= 0xdf;

		// und die Array loeschen
		delete pINetFldTexts;
		delete pINetFldPoss;
	}

	if( pErasePoss )
	{
		// Es mussen noch 0xff-Zeichen aus dem Node geloescht werden
		USHORT i = pErasePoss->Count();
		while( i )
		{
			xub_StrLen nPos = (*pErasePoss)[--i];

			ASSERT( CH_TXTATR_BREAKWORD == pNd->GetTxt().GetChar( nPos ) ||
					CH_TXTATR_INWORD == pNd->GetTxt().GetChar( nPos ),
					"Es sollten nur 0xff geloescht werden" );

			SwIndex aOff( pNd, nPos );
			pNd->Erase( aOff, 1 );
		}


		// die Wrong-Liste ist jetzt ungueltig
		delete pWrong;
		pWrong = 0;
		cFlags &= 0xdf;

		delete pErasePoss;
	}

	// Wrong-Liste uebernehmen
	// ACHTUNG: dirty-bit wird invers gespeichert weil in alten Doks 0 steht
	BOOL bWrongDirty = ( ( cFlags & 0x20 ) == 0 ) ||
						nVersion < SWG_DESKTOP40 ||
						bSpellAllAgain || bSpellWrongAgain;
	pNd->SetWrongDirty( bWrongDirty );
	pNd->SetWrong( pWrong );

	// Condition-Collections setzen:
	if( IDX_DFLT_VALUE != nCondColl )
	{
		if( bInsert )
		{
			// dann muss die richtige Collection neu bestimmt werden!
			pNd->ChkCondColl();
		}
		else
		{
			SwTxtFmtColl* pCColl = FindTxtColl( nCondColl );
			pNd->SetCondFmtColl( pCColl );
		}
	}

#ifdef NUM_RELSPACE
	if( pNdNum && NO_NUMBERING != pNdNum->GetLevel() &&
		IsVersion(SWG_LONGIDX) )
	{
		// In Dokumenten, in denen der Einzug einer Numerierung noch
		// absolut war, muss der Absatz-Einzug noch angepasst werden.
		// Weil man dazu die bedingte Vorlage braucht, darf das erst
		// hier geschehen.
		const SwNumRule *pNumRule = pNd->GetNumRule();
		if( pNumRule )
			lcl_sw3io__ConvertNumLRSpace( *pNd, *pNumRule,
										  pNdNum->GetLevel(),
										  !IsVersion(SWG_NUMRELSPACE) );
	}
#endif

	rPos++;
}

// Einlesen des puren Textes eines TextNodes. Der Text wird an den vorhandenen
// Text im String angefuegt.

void Sw3IoImp::InTxtNodeText( String& rText )
{
	OpenRec( SWG_TEXTNODE );
	OpenFlagRec();
	CloseFlagRec();
	String aText;
	InString( *pStrm, aText );
	CloseRec( SWG_TEXTNODE );
	if( rText.Len() )
		rText += ' ';
	rText += aText;
}

// Zaehlen der Worte eines Nodes
//!! Wird auch vom SW2-Reader benutzt!!

void sw3io_countwords( const String& rDelimWrd, const String& rStr,
						ULONG &rWords, ULONG &rChars )
{
	FASTBOOL bInWord = FALSE;
	USHORT nSpChars = 0;

	for( xub_StrLen nPos = 0; nPos < rStr.Len(); nPos++ )
	{
		sal_Unicode c = rStr.GetChar( nPos );
		switch( c )
		{
			case CH_TXTATR_BREAKWORD:
			case CH_TXTATR_INWORD:
				++nSpChars;
				break;

			case 0x0A:
				++nSpChars;
				if ( bInWord )
				{
					rWords++;
					bInWord = FALSE;
				}
				break;

			default:
				if( rDelimWrd.Search( c ) == STRING_NOTFOUND  )
					bInWord = TRUE;
				else if ( bInWord )
				{
					rWords++;
					bInWord = FALSE;
				}
		}
	}

	if( bInWord )
		rWords++;
	rChars += rStr.Len() - nSpChars;
}

SwInsHardBlankSoftHyph::~SwInsHardBlankSoftHyph()
{
	for( USHORT n = 0, nCnt = aItems.Count(); n < nCnt; ++n )
		delete aItems[ n ];
}
void SwInsHardBlankSoftHyph::AddItem( xub_StrLen nPos, sal_Unicode c )
{
	SfxPoolItem* pItem = 0;
	switch ( c )
	{
	case CHAR_HARDBLANK:	pItem = new SwFmtHardBlank( ' ', FALSE ); break;
	case CHAR_HARDHYPHEN:	pItem = new SwFmtHardBlank( '-', FALSE ); break;
	case CHAR_SOFTHYPHEN:	pItem = new SwFmtSoftHyph; break;
	}
	if( pItem )
	{
		USHORT nInsPos = aItemStarts.Count();
		aItemStarts.Insert( nPos, nInsPos );
		aItems.C40_INSERT( SfxPoolItem, pItem, nInsPos );
	}
}
void SwInsHardBlankSoftHyph::ChangePos( xub_StrLen nHtEnd, xub_StrLen nOffs )
{
	for( USHORT n = 0, nCnt = aItemStarts.Count(); n < nCnt; ++n )
	{
		xub_StrLen& rStt = aItemStarts[ n ];
		if( rStt >= nHtEnd )
			rStt -= nOffs;
	}
}
void SwInsHardBlankSoftHyph::OutAttr( Sw3IoImp& rIo, xub_StrLen nStt,
										xub_StrLen nEnd )
{
	for( USHORT n = 0, nCnt = aItemStarts.Count(); n < nCnt; ++n )
	{
		xub_StrLen nHtStt = aItemStarts[ n ];
		if( nHtStt >= nStt && nHtStt < nEnd )
		{
			nHtStt -= nStt;
			const SfxPoolItem* pAttr = aItems[ n ];
			rIo.OutAttr( *pAttr, nHtStt, nHtStt );
		}
	}
}


Sw3ExportTxtAttrs *Sw3IoImp::ExportTxtNode( const SwTxtNode& rNd,
											xub_StrLen nStart, xub_StrLen nEnd,
											rtl_TextEncoding eEnc,
											SwInsHardBlankSoftHyph& rHBSH )
{
	USHORT nCntAttr = rNd.HasHints() ? rNd.GetSwpHints().Count() : 0;
	if( !nCntAttr )
		return 0;

	// Erstmal nachschauen, ob es ueberhaupt Hints gibt, die einen Export
	// erfordern. Der zusaetzliche Schleifendurchlauf sollte sich in den
	// meisten Faellen lohnen, weil keine Arrays gewartet werden muessen.
	USHORT n;
	BOOL bExport = FALSE;
	for( n = 0; !bExport && n < nCntAttr; n++ )
	{
		const SwTxtAttr* pHt = rNd.GetSwpHints()[n];
		BOOL   bHtEnd   = BOOL( pHt->GetEnd() != NULL );
		xub_StrLen nHtStart = *pHt->GetStart();
		xub_StrLen nHtEnd   = *pHt->GetAnyEnd();

		if( (bHtEnd && nHtEnd > nStart && nHtStart < nEnd) ||
			(!bHtEnd && nHtStart >= nStart && nHtStart < nEnd ) )
		{
			switch( pHt->GetAttr().Which() )
			{
			case RES_TXTATR_INETFMT:
				// SwFmtINetFmt-Attribute werden als Felder exportiert
				bExport = TRUE;
				break;

			case RES_TXTATR_FIELD:
				{
					// alle neuen Felder (ab Script-Feld) werden ignoriert
					const SwFmtFld& rFmtFld =
						(const SwFmtFld&)pHt->GetAttr();
					bExport = rFmtFld.GetFld()->Which() >= RES_SCRIPTFLD;
				}
				break;

			case RES_TXTATR_FLYCNT:
				{
					// zeichengebunde Draw-Formate werden absatz-gebunden
					const SwFmtFlyCnt& rFlyCnt =
						(const SwFmtFlyCnt&)pHt->GetAttr();
					bExport = RES_DRAWFRMFMT == rFlyCnt.GetFrmFmt()->Which();
				}
				break;
			}

		}
	}

	if( !bExport )
		return 0;

	Sw3ExportTxtAttrs *pInfo = new Sw3ExportTxtAttrs;
	xub_StrLen nINetFmtStart = 0, nINetFmtEnd = 0;
	for( n = 0; n < nCntAttr; n++ )
	{
		const SwTxtAttr* pHt = rNd.GetSwpHints()[n];
		BOOL   bHtEnd   = BOOL( pHt->GetEnd() != NULL );
		xub_StrLen nHtStart = *pHt->GetStart();
		xub_StrLen nHtEnd   = *pHt->GetAnyEnd();

		if( (bHtEnd && nHtEnd > nStart && nHtStart < nEnd) ||
			(!bHtEnd && nHtStart >= nStart && nHtStart < nEnd) )
		{
			// Der Hint liegt zumindest teilweise im Text
			const SfxPoolItem& rAttr = pHt->GetAttr();
			BOOL bInsert = FALSE, bSplit = FALSE;

			USHORT nWhich = rAttr.Which();
			switch( nWhich )
			{
			case RES_TXTATR_INETFMT:
				// leere SwFmtINetFmt-Hint koennen und muessen ignoriert
				// werden
				if( nHtStart != nHtEnd )
				{
					if( nHtStart >= nINetFmtEnd )
					{
						// das SwFmtINetFmt ist auf dem Top-Level
						nINetFmtStart = nHtStart;
						nINetFmtEnd	= nHtEnd;
						bInsert = TRUE;
					}
					else
					{
						// die SwFmtINetFmt-Attribute sind geschachtelt,
						// das auessere muss gesplittet werden
						ASSERT( nHtEnd <= nINetFmtEnd,
								"Seit wann koennen sich gleiche Attribute ueberlappen?" );
						bSplit = TRUE;
					}
				}
				break;

			default:
				// laut AMA werden alle anderen Attribute an den Grenzen
				// von SwFmtINetFmt-Attributen aufgespannt. Wenn das mal
				// doch nicht der Fall ist, gibt's einen
				ASSERT( nHtStart >= nINetFmtEnd || nHtEnd <= nINetFmtEnd,
						"Ein Attribut ueberlappt sich mit einen SwFmtINetFmt" );

				// Attribute im inneren eines SwFmtINetFmt werden ignoriert,
				// es sein denn, die spannen genau den Bereich des
				// SwFmtINetFmts auf
				if( nHtStart >= nINetFmtEnd ||
					(nHtStart == nINetFmtStart && nHtEnd == nINetFmtEnd) )
				{
					// das Attribut beginnt erst hinter einen SwFmtINetFmt
					// oder spannt exakt den gleichen Bereich auf
					bInsert = TRUE;
				}
				else if( RES_TXTATR_NOEND_BEGIN <= nWhich &&
						 RES_TXTATR_NOEND_END > nWhich )
				{
					// ein Hint ohne Ende muss auch immer eingefuegt werden
					bSplit = TRUE;
				}
				break;
			}

			if( bInsert )
			{
				// das Item als letztes an seiner Start-Position beginnen,
				// aber in jedem Fall vor einem SwFmtINetFmt
				USHORT nAPos = pInfo->aItemStarts.Count();
				while( nAPos > 0 &&
					   ( (pInfo->aItemStarts[nAPos-1] > nHtStart) ||
						 (pInfo->aItemStarts[nAPos-1] == nHtStart &&
						  RES_TXTATR_INETFMT==pInfo->aItems[nAPos-1]->Which()) ) )
					nAPos--;

				pInfo->aItemStarts.Insert( nHtStart, nAPos );
				pInfo->aItemEnds.Insert( nHtEnd, nAPos );
				const SfxPoolItem *pItem = &rAttr;
				pInfo->aItems.C40_INSERT( SfxPoolItem, pItem, nAPos );
			}
			else if( bSplit )
			{
				// Ein anderes SwFmtINetFmt splitten. Dazu muss zunaechst
				// das umgebende gesucht werden.
				USHORT nAPos = pInfo->aItemStarts.Count();
				while( nAPos > 0 && pInfo->aItemStarts[nAPos-1] > nHtStart )
					nAPos--;

				// es muss ein Attribut geben, das zuvor geoffent wurde
				ASSERT( nAPos, "kein Attribut gefunden" );
				if( !nAPos )
					continue;
				nAPos--;

				// Das unmittlabr vor der aktuellen Position geoffente
				// Attribut kann auch ein Text-Attribut ohen Ende sein
				const SfxPoolItem *pLastItem = pInfo->aItems[nAPos];
				if( RES_TXTATR_NOEND_BEGIN <= pLastItem->Which() &&
					RES_TXTATR_NOEND_END > pLastItem->Which())
				{
					ASSERT( bHtEnd, "zwei Hints ohne Ende an gleicher Pos.?" );
					// es muss dann aber an der aktuellen Position beginnen
					ASSERT( pInfo->aItemStarts[nAPos]==nHtStart,
							"Text-Attribut ohne Ende an falscher Position" );
					if( pInfo->aItemStarts[nAPos]==nHtStart )
						continue;

					// das Feld ein Zeichen spater beginnen
					nHtStart++;
					if( nHtStart-nHtEnd == 0 )
						continue;

					nAPos++;
					ASSERT( nAPos<pInfo->aItems.Count(),
							"Wo ist das SwFmtINetFmt geblieben?" );
					pLastItem = pInfo->aItems[nAPos];
				}

				// muss ein SwFmtINetFmt-Attribut sein!
				xub_StrLen nLastEnd = pInfo->aItemEnds[nAPos];
				ASSERT( RES_TXTATR_INETFMT==pLastItem->Which(),
						"das umgebende Item muesste ein SwFmtINetFmt sein!!" );
				if( !RES_TXTATR_INETFMT==pLastItem->Which() )
					continue;

				// das bisherige Attribut vorzeitig beenden, wenn es dann
				// nicht leer ist und sonst loeschen.
				if( pInfo->aItemStarts[nAPos] < nHtStart )
				{
					pInfo->aItemEnds[nAPos] = nHtStart;
					nAPos++;
				}
				else
				{
					pInfo->aItemStarts.Remove( nAPos, 1 );
					pInfo->aItemEnds.Remove( nAPos, 1 );
					pInfo->aItems.Remove( nAPos, 1 );
				}

				// jetzt fuegen wir das neue Attribut ein
				pInfo->aItemStarts.Insert( nHtStart, nAPos );
				pInfo->aItemEnds.Insert( nHtEnd, nAPos );
				const SfxPoolItem *pItem = &rAttr;
				pInfo->aItems.C40_INSERT( SfxPoolItem, pItem, nAPos );
				nAPos++;

				// und noch den Rest von dem alten Attribut, wenn er nicht
				// leer ist
				if( !bHtEnd )
					nHtEnd++;
				if( nHtEnd < nLastEnd )
				{
					pInfo->aItemStarts.Insert( nHtEnd, nAPos );
					pInfo->aItemEnds.Insert( nLastEnd, nAPos );
					pInfo->aItems.C40_INSERT( SfxPoolItem, pLastItem, nAPos );
				}
			}
		}
	}

	// jetzt muessen noch der Text und die Positionen der Hints angepasst
	// werden
	String aText( rNd.GetTxt() );
	const SvxFontItem& rFont = rNd.GetSwAttrSet().GetFont();
	ConvertText( pInfo->aText, aText, 0, (SwTxtNode& )rNd, eEnc,
						   rFont,
						   &rHBSH, TRUE );
	for( USHORT nAPos=0; nAPos<pInfo->aItems.Count(); nAPos++ )
	{
		const SfxPoolItem *pAttr = pInfo->aItems[nAPos];
		xub_StrLen nHtStart = pInfo->aItemStarts[nAPos];
		xub_StrLen nHtEnd = pInfo->aItemEnds[nAPos];
		xub_StrLen nOffs = 0;
		BOOL bRemoveTxtAttr = FALSE;
		switch( pAttr->Which() )
		{
		case RES_TXTATR_INETFMT:
			// wieviel muss gelosecht werden ?
			nOffs = (nHtEnd - nHtStart) - 1;

			// den Text ses SwFmtINetFmt merken
			pInfo->aINetFmtTexts.Insert(
				new ByteString( pInfo->aText.Copy( nHtStart, nOffs+1 ) ),
				pInfo->aINetFmtTexts.Count() );

			// und noch den auszugebenden Text anpassen
			pInfo->aText.SetChar( nHtStart, '\xff' );
			nHtStart++;
			break;

		case RES_TXTATR_FIELD:
			{
				const SwFmtFld *pFmtFld =
					(const SwFmtFld *)pAttr;
				if( pFmtFld->GetFld()->Which() >= RES_SCRIPTFLD )
					bRemoveTxtAttr = TRUE;
			}
			break;

		case RES_TXTATR_FLYCNT:
			{
				const SwFmtFlyCnt *pFlyCnt = (const SwFmtFlyCnt *)pAttr;
				if( RES_DRAWFRMFMT == pFlyCnt->GetFrmFmt()->Which() )
				{
					bRemoveTxtAttr = TRUE;
					pInfo->nDrawFrmFmts++;
				}
			}
			break;
		}

		if( bRemoveTxtAttr )
		{
			nOffs = 1;
			nHtEnd += 1;
			pInfo->aItemStarts.Remove( nAPos, 1 );
			pInfo->aItemEnds.Remove( nAPos, 1 );
			pInfo->aItems.Remove( nAPos, 1 );
			nAPos--;	// nicht schoen, aber wirksam
		}

		// die Start- und Ende-Positionen korregieren
		if( nOffs )
		{
			for( USHORT i=0; i<pInfo->aItems.Count(); i++ )
			{
				if( pInfo->aItemStarts[i] >= nHtEnd )
					pInfo->aItemStarts[i] -= nOffs;
				if( pInfo->aItemEnds[i] >= nHtEnd )
					pInfo->aItemEnds[i] -= nOffs;
			}

			rHBSH.ChangePos( nHtEnd, nOffs );
			pInfo->aText.Erase( nHtStart, nOffs );

			if( nEnd != STRING_LEN )
				nEnd -= nOffs;
		}
	}

	if( nEnd == STRING_LEN || nEnd < nStart )
		nEnd = pInfo->aText.Len();
	else if ( nEnd != pInfo->aText.Len() )
		pInfo->aText.Erase( nEnd );
	if( nStart )
		pInfo->aText.Erase( 0, nStart );

	return pInfo;
}


void lcl_sw3io__ConvertNumTabStop( const SwCntntNode& rCNd, long nOffset,
								   SfxItemSet& rItemSet )
{
	const SfxPoolItem* pItem;
	if( SFX_ITEM_SET == rCNd.GetSwAttrSet().GetItemState(
										RES_PARATR_TABSTOP, TRUE, &pItem ))
	{
		SvxTabStopItem aTStop( *(SvxTabStopItem*)pItem );
		lcl_sw3io__ConvertNumTabStop( aTStop, nOffset );
		rItemSet.Put( aTStop );
	}
}

// Text Node:
// BYTE			Flags
//				0x10 - mit Numerierung
// 				0x20 - Wrong-Liste ist nicht dirty
// UINT16		String-Index der Absatzvorlage
// BYTE			Numerierungs-Level (opt.)
// String		Text
// SWG_ATTRSET	eigene Attribute (opt.)
// SWG_FLYFMT	FlyFrame (opt).
// SWG_SDRFMT	Drawing-Objekt (opt).
// SWG_TEXTATTR harte Attribute (opt, mehrfach).
// SWG_WRONGLIST Liste falscher Worte (opt)

void Sw3IoImp::OutTxtNode
( SwCntntNode & rNode, xub_StrLen nStart, xub_StrLen nEnd, ULONG nPosIdx )
{
	SwTxtNode *pNd  = &((SwTxtNode&) rNode );
	const SwFmtColl* pColl = &pNd->GetAnyFmtColl();
	ASSERT( pColl != pDoc->GetDfltTxtFmtColl(),
			"the default text format collection isn't allowed on a node" );
	BOOL bNewNumRule = FALSE;
	// 0x0L: Laenge der Daten
	// 0x10: Numerierung folgt (nur 3.1/4.0)
	// 0x20: Wrong-Liste ist nicht dirty
	BYTE   cFlags 	 = IsSw31Export() ? 0x02 : 0x04; // CollIdx & CondCollIdx
	USHORT nColl	 = aStringPool.Add( pColl->GetName(),
										pColl->GetPoolFmtId() );
	BYTE   cNumLevel = NO_NUMBERING;

	// Numerierungsregel fuer 3.1/4.0-Export ermitteln
	const SwNodeNum *pNdNum = pNd->GetNum();
#ifndef PRODUCT
	{
		const SwNumRule* pNumRule = pNd->GetNumRule();
		ASSERT( pNumRule ? pNdNum!=0 : TRUE,
				"Node hat NumRule aber kein NodeNum" );
		ASSERT( pNdNum ? pNumRule!=0 : TRUE,
				"Node hat NodeNum aber keine NumRule" );
	}
#endif

	SfxItemSet *pExportAttrSet = 0;
	const SfxItemSet *pAttrSet = rNode.GetpSwAttrSet();

	if( pNdNum && pNdNum->GetLevel() != NO_NUMBERING )
	{
		const SwNumRule* pNumRule = pNd->GetNumRule();
		if( pNumRule )
		{
			cNumLevel = pNdNum->GetLevel();
			BYTE cRealLevel = GetRealLevel( cNumLevel );
			if( IsSw31Or40Export() )
			{
				if( cRealLevel >= OLD_MAXLEVEL )
				{
					// Die Numerierungs-Ebene ist zu hoch => die
					// hoechst moegliche setzen
					BYTE cTmp = OLD_MAXLEVEL-1;
					if( cNumLevel & NO_NUMLEVEL )
						cTmp |= NO_NUMLEVEL;
					cNumLevel = cTmp;
				}
				if( IsSw31Export() )
					cFlags += NO_NUMLEVEL & cNumLevel ? 0x12 : 0x11;
				else
					cFlags += 0x11;
				if( pNumRule != pCurNumRule )
				{
					// Dann vor dem betroffenen Node ausgeben
					pCurNumRule = (SwNumRule *)pNumRule;

					//JP 06.10.95: falls SH mal wieder mit der Numerierung
					//durcheinander kommt
					//	bNewNumRule = TRUE;
					bNewNumRule = 0 != pCurNumRule;
				}
			}

#ifdef NUM_RELSPACE
			// Den Erstzeilen-Einzug immer aus der NumRule uebernehmen
			// und als linken Einzug die Summe aus Absatz- und
			// NumRule-Einzug schreiben.
			const SwNumFmt& rNumFmt = pNumRule->Get( cRealLevel );
			const SvxLRSpaceItem& rLRSpace =
					(const SvxLRSpaceItem&)rNode.GetAttr(RES_LR_SPACE);

			USHORT nLeft = rNumFmt.GetAbsLSpace();
			USHORT nOldLeft = (USHORT)rLRSpace.GetTxtLeft();
			if( !pNumRule->IsAbsSpaces() )
				nLeft += (USHORT)rLRSpace.GetTxtLeft();
			short nFirstLineOffset =
				(cNumLevel & NO_NUMLEVEL)==0 ? rNumFmt.GetFirstLineOffset() : 0;
			if( nLeft != rLRSpace.GetTxtLeft() ||
				nFirstLineOffset != rLRSpace.GetTxtFirstLineOfst() )
			{
				if( pAttrSet )
					pExportAttrSet = new SfxItemSet( *pAttrSet );
				else
					pExportAttrSet = new SfxItemSet( pDoc->GetAttrPool(),
											 pColl->GetAttrSet().GetRanges() );
				pAttrSet = pExportAttrSet;
				SvxLRSpaceItem aLRSpace( rLRSpace );
				aLRSpace.SetTxtFirstLineOfst( nFirstLineOffset );
				aLRSpace.SetTxtLeft( nLeft );

				pExportAttrSet->Put( aLRSpace );

				if( IsSw31Or40Export() && nOldLeft != nLeft )
					lcl_sw3io__ConvertNumTabStop( rNode,
												  (long)nOldLeft - (long)nLeft,
												  *pExportAttrSet );
			}
#endif
		}
		else if( IsSw31Or40Export() )
			pCurNumRule = NULL;

	}
	else if( IsSw31Or40Export() )
	{
		pCurNumRule = NULL;
	}

	// Wrong-List-Dirty-Flag (wird wegen alter doks invers gespeichert)
	if( !IsSw31Export() && !rNode.IsWrongDirty() )
		cFlags += 0x20;

	OpenRec( SWG_TEXTNODE );
	*pStrm << cFlags << nColl;
	if( IsSw31Or40Export() && (cFlags & 0x10) )
	{
		// Frueher wurde hier fuer NO_NUMLEVEL noch ein NO_NUM
		// rausgeschrieben. Ist jetzt nicht mehr noetig.
		//if( NO_NUMLEVEL & cNumLevel )
		//	*pStrm << (BYTE)NO_NUM << cNumLevel;
		//else
		if( IsSw31Export() && (NO_NUMLEVEL & cNumLevel) )
			*pStrm << (BYTE)NO_NUM << cNumLevel;
		else
			*pStrm << cNumLevel;
	}

	// bedingte Vorlagen nicht beim SW31-Export rausschreiben
	if( !IsSw31Export() )
	{
		USHORT nCondColl = IDX_DFLT_VALUE;
		if( pNd->GetCondFmtColl() )
		{
			// dann die bedingte Vorlage schreiben!!
			pColl = pNd->GetFmtColl();
			nCondColl =
				aStringPool.Add( pColl->GetName(), pColl->GetPoolFmtId() );
		}
		*pStrm << nCondColl;
	}

#ifdef NUM_RELSPACE
	// Wenn der Absatz ein LRSpace-Item enthaelt und in der Kapitel-Numerierung
	// ist muss das LRSpace-Item noch angepasst werden. Relative Werte
	// koennen dabei nicht vorkommen. Der Ertzeilen-Einzug geht verloren.
	const SwNumRule *pOutline = pDoc->GetOutlineNumRule();
	const SfxPoolItem *pItem;
	if( pAttrSet && (!pNdNum || NO_NUMBERING == pNdNum->GetLevel()) &&
		NO_NUMBERING != ((const SwTxtFmtColl *)pColl)->GetOutlineLevel() &&
		SFX_ITEM_SET == pAttrSet->GetItemState( RES_LR_SPACE, FALSE, &pItem ) &&
		pOutline )
	{
		const SvxLRSpaceItem *pParaLRSpace = (const SvxLRSpaceItem *)pItem;

		const SwNumFmt& rNumFmt = pOutline->Get(
			GetRealLevel(((const SwTxtFmtColl *)pColl)->GetOutlineLevel()) );
		USHORT nLSpace = (USHORT)pParaLRSpace->GetTxtLeft();
		USHORT nOldLSpace = nLSpace;
		if( pOutline->IsAbsSpaces() )
			nLSpace = rNumFmt.GetAbsLSpace();
		else
			nLSpace += rNumFmt.GetAbsLSpace();

		if( nLSpace  != pParaLRSpace->GetTxtLeft() ||
			rNumFmt.GetFirstLineOffset()!=pParaLRSpace->GetTxtFirstLineOfst() )
		{
			if( !pExportAttrSet )
			{
				pExportAttrSet = new SfxItemSet( *pAttrSet );
				pAttrSet = pExportAttrSet;
			}

			SvxLRSpaceItem aLRSpace( *pParaLRSpace );
			aLRSpace.SetTxtFirstLineOfst( rNumFmt.GetFirstLineOffset());
			aLRSpace.SetTxtLeft( nLSpace );
			pExportAttrSet->Put( aLRSpace );

			if( IsSw31Or40Export() && nOldLSpace != nLSpace )
				lcl_sw3io__ConvertNumTabStop( rNode,
											  (long)nOldLSpace - (long)nLSpace,
											  *pExportAttrSet );
		}
	}
#endif

	if( (nEnd == STRING_LEN ? pNd->GetTxt().Len() : nEnd) > STRING_MAXLEN52 )
		nEnd = STRING_MAXLEN52;

	SwInsHardBlankSoftHyph aHBSH;

	String aText;
	Sw3ExportTxtAttrs *pExpInfo = IsSw31Export()
			? ExportTxtNode( *pNd, nStart, nEnd, eSrcSet, aHBSH )
			: 0;

	ByteString aText8;
	if( !pExpInfo )
	{
		aText = pNd->GetTxt();
		if( nEnd == STRING_LEN || nEnd < nStart )
			nEnd = aText.Len();
		else if ( nEnd != aText.Len() )
			aText.Erase( nEnd );
		if( nStart )
			aText.Erase( 0, nStart );
		const SvxFontItem& rFont = pNd->GetSwAttrSet().GetFont();
		ConvertText( aText8, aText, nStart, *pNd, eSrcSet,
							   rFont, &aHBSH, TRUE );
	}
	else
		aText8 = pExpInfo->aText;

	if( aText.Len() )
		sw3io_countwords( aDefWordDelim, aText, aStat.nWord, aStat.nChar );

	if( aText8.Len() && pCrypter )
		pCrypter->Encrypt( aText8 );
	pStrm->WriteByteString( aText8 );
	aStat.nPara++;

	if( pAttrSet )
		OutAttrSet( *pAttrSet );
	delete pExportAttrSet;
	pAttrSet = pExportAttrSet = 0;
	OutNodeMarks( nPosIdx );

	// die absatzgebunden Rahmen schreiben und beim SW31-Export ggf. auch
	// noch die zeichengebunden Zeichen-Objekte als abstzgebundene Objekte
	OutNodeFlyFrames( nPosIdx );
	if( pExpInfo && pExpInfo->nDrawFrmFmts )
		ExportNodeDrawFrmFmts( *pNd, nStart, nEnd, pExpInfo->nDrawFrmFmts );

	// Beim SW31-Export evtl. die "umgebauten" Hints ausgeben, sonst die
	// Original-Hints
	if( pExpInfo )
		ExportTxtAttrs( pExpInfo, nStart, nEnd );
	else if( ((SwTxtNode&)rNode).HasHints() )
		OutTxtAttrs( *pNd, nStart, nEnd );
	aHBSH.OutAttr( *this, nStart, nEnd );

	// Evtl. noch die neue Numerierungsregel (3.1/4.0) oder die
	// SwNodeNum-Struktor (5.0 ff) ausgeben
	if( IsSw31Or40Export() )
	{
		if( bNewNumRule )
			OutNumRule( SWG_NUMRULE, *pCurNumRule );
	}
	else if( pNdNum )
	{
		OutNodeNum( *pNdNum );
	}

	// Eventuell noch die Wrong-Liste
	const SwWrongList* pWrong = pNd->GetWrong();
	if( !IsSw31Export() && pWrong )
	{
		OpenRec( SWG_WRONGLIST );

		// der Header
		cFlags = 0x04;	// 4 Bytes Daten
		xub_StrLen nBegin = pWrong->GetBeginInv();
		if( nBegin > STRING_MAXLEN52 )
			nBegin = STRING_MAXLEN52;

		xub_StrLen nEnd = pWrong->GetEndInv();
		if( nEnd > STRING_MAXLEN52 )
			nEnd = STRING_MAXLEN52;

		*pStrm << cFlags
			   << (UINT16)nBegin
			   << (UINT16)nEnd;

		// nun die eigentliche Liste
		OpenValuePos16( 0 );
		USHORT nCount = pWrong->Count();
		for( USHORT i=0; i<nCount; i++ )
		{
			xub_StrLen nIdx = pWrong->Pos( i );
			if( nIdx < STRING_MAXLEN52 )
			{
				xub_StrLen nLen = pWrong->Len( i );
				if( nIdx + nLen > STRING_MAXLEN52 )
					nLen = STRING_MAXLEN52 - nIdx;
				 UINT32 n = nIdx + (nLen << 16);
				*pStrm << n;
			}
		}
		CloseValuePos16( nCount );
		CloseRec( SWG_WRONGLIST );
	}

	if( !IsSw31Or40Export() )
	{
		// Redline-Markierungen rausschreiben. Muss wegen geloeschter
		// Redlines immer als letztes passieren, weil beim Einfuegen
		// eines solechen Doks Attribute schon gesetzt sein muessen!
		OutNodeRedlines( nPosIdx );
	}

	CloseRec( SWG_TEXTNODE );
}

void Sw3IoImp::OutEmptyTxtNode( ULONG nNodeIdx, BOOL bNodeMarks )
{
	// 0x0L: length of data
	// 0x20: wrong list is valid
	BYTE   cFlags = 0x24; // CollIdx & CondCollIdx
	USHORT nColl = aStringPool.Add( *SwStyleNameMapper::GetTextUINameArray()
						[ RES_POOLCOLL_STANDARD - RES_POOLCOLL_TEXT_BEGIN ],
						RES_POOLCOLL_STANDARD );

	OpenRec( SWG_TEXTNODE );
	*pStrm << cFlags << nColl << IDX_DFLT_VALUE;
	OutString( *pStrm, aEmptyStr );

	if( bNodeMarks )
		OutNodeMarks( nNodeIdx );

	aStat.nPara++;
	CloseRec( SWG_TEXTNODE );
}

// nOffset ist ungleich Null, wenn innerhalb eines Nodes eingefuegt werden
// soll. Dann ist nOffset die Start-Position des Textes.

void Sw3IoImp::InTxtAttr( SwTxtNode& rNd, const ByteString& rText8,
						  xub_StrLen nOffset,
						  SvStringsDtor **pINetFldTexts,
						  SvXub_StrLens **pINetFldPoss,
						  SvXub_StrLens **pErasePoss,
						  SvUShorts		**pCharSetColorEncs,
						  SvXub_StrLens **pCharSetColorPoss )
{
	// Dieser Record kann auch leer sein
	// (bei teilweisem Speichern eines Nodes, z.B.)
	xub_StrLen nLen = rNd.GetTxt().Len();
	if( nLen ) nLen --;
	xub_StrLen nStart, nEnd;
	SfxPoolItem* pItem = InAttr( nStart, nEnd, &rNd );
	if( !pItem )
	{
		if( bDrawFmtSkipped )
		{
			ASSERT( bInsIntoHdrFtr,
					"Draw-Formate durften nur in Kopf-/Fusszeilen geloecht werden" );
			ASSERT( CH_TXTATR_BREAKWORD == rNd.GetTxt().GetChar(nStart) ||
					CH_TXTATR_INWORD == rNd.GetTxt().GetChar(nStart),
					"Wo ist das 0xff des Draw-Formats?" );

			if( !(*pErasePoss) )
				*pErasePoss = new SvXub_StrLens;
			(*pErasePoss)->Insert( nStart, (*pErasePoss)->Count() );

			bDrawFmtSkipped = FALSE;
			return;
		}

		if( !pFmtINetFmt )
			return;

		// Es wurde ein INetFlield gelesen und in einen INet-Attribut
		// umgewandelt

		// Text und Position merken
		if( !(*pINetFldTexts) )
			*pINetFldTexts = new SvStringsDtor;
		(*pINetFldTexts)->Insert( new String( aINetFldText ),
										(*pINetFldTexts)->Count() );
		if( !(*pINetFldPoss) )
			*pINetFldPoss = new SvXub_StrLens;
		(*pINetFldPoss)->Insert( nStart, (*pINetFldPoss)->Count() );

		if( aINetFldText.Len() )
		{
			// ggf. das Attribut ueber dem =xff aufspannen
			// das Item wird ann unten geloescht
			pItem = pFmtINetFmt;
			nEnd++;
			aINetFldText.Erase();
		}
		else
		{
			// leere Felder nicht einfuegen
			delete pFmtINetFmt;
		}

		pFmtINetFmt = 0;

		if( !pItem )
			return;
	}

	if( nEnd < nStart ) nEnd = nLen;
	nStart += nOffset;
	nEnd   += nOffset;
	USHORT nWhich = pItem->Which();
	if( nWhich == RES_TXTATR_FTN )
	{
		//JP 02.12.96:
		// Das Fussnoten-Attribut liest seine Section "auf der Wiese" ein
		// und erzeugt auch ihr TextAttribut (weil an dem noch weitere
		// Informationen gesetzt werden muessen - Referenznummer)
		SwTxtFtn& rFtn = *((SwFmtFtn*)pItem)->GetTxtFtn();
		*rFtn.GetStart() = nStart;
		rNd.Insert( &rFtn, SETATTR_NOTXTATRCHR );
		return ;
	}
	else if( RES_CHRATR_CHARSETCOLOR == nWhich )
	{
		if( !(*pCharSetColorEncs) )
			*pCharSetColorEncs = new SvUShorts;
		(*pCharSetColorEncs)->Insert(
			((const SvxCharSetColorItem *)pItem)->GetCharSet(),
			(*pCharSetColorEncs)->Count() );

		if( !(*pCharSetColorPoss) )
			*pCharSetColorPoss = new SvXub_StrLens;
		(*pCharSetColorPoss)->Insert( nStart, (*pCharSetColorPoss)->Count() );
		(*pCharSetColorPoss)->Insert( nEnd, (*pCharSetColorPoss)->Count() );
	}
	else
	{
		// Bug 31560: mehrere TOX-Marks ohne Ende an der gleichen Position!
		if( nStart == nEnd && (( RES_TXTATR_TOXMARK == nWhich &&
			  ((SwTOXMark*)pItem)->IsAlternativeText() ) ||
			( RES_TXTATR_NOEND_BEGIN <= nWhich && nWhich < RES_TXTATR_NOEND_END )))
		{
			// teste doch mal ob das Zeichen am der Position steht und on
			// an der Position nicht schon ein Attribut ohne Ende gesetzt ist!
			if( '\xff' != rText8.GetChar(nStart-nOffset) )
			{
				nWhich = 0;
				ASSERT( !this, "TextAttribut ohne Ende ohne 0xFF" );
			}
			else
			{
				sal_Unicode cReplace = 0;
				switch( nWhich )
				{
				case RES_TXTATR_TOXMARK:
					{
						// pruefe mal auf doppelte:
						SwTxtAttr* pAttr = rNd.GetTxtAttr( nStart, nWhich );
						if( pAttr )
						{
							nWhich = 0;
							ASSERT( !this, "TOXMark ohne Ende doppelt" );
						}
					}
					break;
				case RES_TXTATR_SOFTHYPH:
					// set the unicode character into the node text
					cReplace = CHAR_SOFTHYPHEN;
					break;

				case RES_TXTATR_HARDBLANK:
					cReplace = ((SwFmtHardBlank*)pItem)->GetChar();
					if( ' ' == cReplace )
						cReplace = CHAR_HARDBLANK;
					else if( '-' == cReplace )
						cReplace = CHAR_HARDHYPHEN;
					else
						cReplace = 0;
					break;
				}
				if( cReplace )
				{
					rNd.Replace( SwIndex( &rNd, nStart ), cReplace );
			 		nWhich = 0;
				}
			}
		}

		if( nWhich )
		{
			SwTxtAttr* pAttr = rNd.Insert( *pItem, nStart, nEnd, SETATTR_NOTXTATRCHR );
			// Sonderbehandlung fuer einige Text-Attribute:
			if( pAttr && RES_TXTATR_FLYCNT == nWhich )
				// ein zeichengebundener FlyFrm muss noch verankert werden
				((SwTxtFlyCnt*) pAttr)->SetAnchor( &rNd );
		}
	}
	delete pItem;
}

// Schreiben aller harten Attributierungen

void Sw3IoImp::OutTxtAttrs( const SwTxtNode& rNd, xub_StrLen nStart,
						    xub_StrLen nEnd )
{
	USHORT nCntAttr = rNd.HasHints() ? rNd.GetSwpHints().Count() : 0;
	if( nCntAttr )
	{
		for( USHORT n = 0; n < nCntAttr; n++ )
		{
			const SwTxtAttr* pHt = rNd.GetSwpHints()[ n ];
			BOOL   bHtEnd   = BOOL( pHt->GetEnd() != NULL );
			xub_StrLen nHtStart = *pHt->GetStart();
			xub_StrLen nHtEnd   = *pHt->GetAnyEnd();

			// MIB 11.11.96: Der Bereich des Hints muss sich nur irgendwie
			// mit dem auszugenden Bereich ueberschneiden
			if( (bHtEnd && nHtEnd > nStart && nHtStart < nEnd) ||
				(!bHtEnd && nHtStart >= nStart && nHtStart < nEnd ) )
			{
				// Der Hint liegt zumindest teilweise im Text, also
				// Start und Ende korrigieren und Hint ausgeben
				nHtStart = ( nHtStart < nStart ) ? 0 : ( nHtStart - nStart );
				nHtEnd   = ( nHtEnd > nEnd ? nEnd : nHtEnd ) - nStart;
				const SfxPoolItem& rAttr = pHt->GetAttr();
				OutAttr( rAttr, nHtStart, nHtEnd );
			}
		}
	}
}

void Sw3IoImp::ExportTxtAttrs( const Sw3ExportTxtAttrs* pInfo,
							   xub_StrLen nStart, xub_StrLen nEnd )
{
	USHORT nINetFmtCnt = 0;
	for( USHORT n = 0; n < pInfo->aItems.Count(); n++ )
	{
		xub_StrLen nHtStart = pInfo->aItemStarts[n];
		xub_StrLen nHtEnd   = pInfo->aItemEnds[n];;

		// Der Hint liegt zumindest teilweise im Text, also
		// Start und Ende korrigieren und Hint ausgeben
		nHtStart = ( nHtStart < nStart ) ? 0 : ( nHtStart - nStart );
		nHtEnd   = ( nHtEnd > nEnd ? nEnd : nHtEnd ) - nStart;
		const SfxPoolItem* pAttr = pInfo->aItems[n];
		if( RES_TXTATR_INETFMT==pAttr->Which() )
		{
			// ein SwFmtINetFmtNet muss bei SW31-Export zum Feld werden

			// Start OutAttr()
			OpenRec( SWG_ATTRIBUTE );
			BYTE cFlags = 0x04;			// Which + Version
			cFlags += 0x12;				// Begin
			USHORT nWhich = RES_TXTATR_FIELD -	RES_TXTATR_NOEND_BEGIN + 0x3000;
			*pStrm  << (BYTE) cFlags
					<< (UINT16) nWhich
					<< (UINT16) 0		   		// rAttr.GetVersion();
					<< (UINT16)nHtStart;

			// Start SwFmtFld::Store()

			// Start OutField()
			*pStrm << (INT16) ( RES_INTERNETFLD - RES_FIELDS_BEGIN )
				   << (INT16) 0;

			// Start lcl_sw3io_OutINetField()
			OutString( *pStrm, INetURLObject::AbsToRel(
						((const SwFmtINetFmt *)pAttr)->GetValue() URL_DECODE ) );
			pStrm->WriteByteString( *pInfo->aINetFmtTexts[nINetFmtCnt] );
			// Ende lcl_sw3io_OutINetField()

			// Ende OutField()

			// Ende SwFmtFld::Store()

			CloseRec( SWG_ATTRIBUTE );
			// Ende OutAttr()

			nINetFmtCnt++;
		}
		else
		{
			OutAttr( *pAttr, nHtStart, nHtEnd );
		}
	}
}


// Die Formate von Grafik- und OLE-Nodes muessen nicht registriert
// werden; die Layout-Frames erhalten ja eine Node-Referenz.

//#define SWG_GRAPHIC_EXT 'X' jetzt SWG_IMAGEMAP

void Sw3IoImp::InGrfNode( SwNodeIndex& rPos )
{
	Graphic aGrf;
	Graphic* pGrf = &aGrf;
	String aGrfName, aFltName, aStrmName, aURL, aTarget, aAltText;
	ImageMap *pImgMap = 0;
	PolyPolygon *pContour = 0;
	OpenRec( SWG_GRFNODE );
	BYTE cFlags = OpenFlagRec();
	CloseFlagRec();
	BOOL bLink = BOOL( ( cFlags & 0x10 ) == 0 );
	BOOL bEmptyGrf = BOOL( cFlags & 0x20 );
	BOOL bIsServerMap = BOOL( (cFlags & 0x40) != 0 );

	InString( *pStrm, aGrfName );
	InString( *pStrm, aFltName );

	if( IsVersion( SWG_DESKTOP40 ) )
		InString( *pStrm, aAltText );

	aStrmName = aGrfName;
	SwAttrSet aSet( pDoc->GetAttrPool(), aNoTxtNodeSetRange );
	while( BytesLeft() )
	{
		BYTE cType = Peek();
		switch( cType )
		{
			case SWG_ATTRSET:
				InAttrSet( aSet );
				break;
			case SWG_IMAGEMAP:
				{
					BOOL bDummy; // IsURL-Map-Flag wird im Node selbst gesp.
					pImgMap = InImageMap( aURL, aTarget, bDummy );
				}
				break;

			case SWG_CONTOUR:
				pContour = InContour();
				break;

			default:
				SkipRec();
		}
	}
	CloseRec( SWG_GRFNODE );
	if( CheckPersist() )
	{
		// Muss die Grafik noch geladen werden?
		if( !bEmptyGrf )
		{
			if( bLink )
			{
				pGrf = 0;
				if( aGrfName.Len() )
					aGrfName = URIHelper::SmartRelToAbs( aGrfName );
			}
			else
			{
				SvStorageRef pPicStg = pRoot->OpenStorage( N_PICTURES,
							STREAM_READ | STREAM_SHARE_DENYWRITE, 0 );
				SvStorageStreamRef pPicStrm;
				if( pPicStg.Is() )
					pPicStrm = pPicStg->OpenStream
						( aGrfName, STREAM_READ | STREAM_SHARE_DENYWRITE );
				aGrfName.Erase();	// Ist ja gar kein Grafikname!
				ASSERT( pPicStrm.Is() && pPicStrm->GetError() == SVSTREAM_OK, "Grafik nicht gefunden" );
				if( pPicStrm.Is() && pPicStrm->GetError() == SVSTREAM_OK )
				{
					// Wenn kein DocFileName gesetzt ist, wird eine TmpFile
					// erzeugt, was wir im Moment nicht wollen!
					pPicStrm->SetVersion( pRoot->GetVersion() );
					String aDummy( String::CreateFromAscii("file:///Dummy") );
					aGrf.SetDocFileName( aDummy, 0L );
					BOOL bSwapOut = BOOL( !bInsert );
					// Beim SW3.1-Import verliern wir unserden Dok-Storage,
					// also darf die Grafik nicht rausgeswappt werden.
					// MIB 3.9.98: Ausserdem muessen Grafiken immer beim
					// LoadStyles reingeswappt werden, weil dann der Storage
					// aus dem geladen wird nicht unbedingt der Doc-Storage
					// sein muss. Das ist zum Beispiel beim Aktualisieren von
					// Vorlagen aus einer Dokument-Vorlage der Fall (#55896#)
					// Aufgrund eines Hackks im Organizer stimmt dort der
					// Dok-Storage uebrigens ...
					if( bBlock || bOrganizer || nVersion < SWG_MAJORVERSION )
						bSwapOut = FALSE;
					aGrf.ReadEmbedded( *pPicStrm, bSwapOut );
					aDummy.Erase();
					aGrf.SetDocFileName( aDummy, 0L );
					if( pPicStrm->GetError() != SVSTREAM_OK )
						Error( ERR_SWG_READ_ERROR );
				}
				else
					Warning( WARN_SWG_POOR_LOAD );
			}
		}

		if( !nRes )
		{
			if( !IsVersion( SWG_URLANDMAP, SWG_EXPORT31, SWG_DESKTOP40 ) )
			{
				// bei importierten Dateien muss ggf noch die URL in das
				// Format gestopft werden
				SwFmtURL aFmtURL;
				aFmtURL.SetURL( aURL, bIsServerMap );
				aFmtURL.SetTargetFrameName( aTarget );
				if( pImgMap )
					aFmtURL.SetMap( pImgMap );
				aSet.Put( aFmtURL );
			}
			SwGrfNode* pNd = pDoc->GetNodes().MakeGrfNode( rPos,
									  aGrfName, aFltName, pGrf,
									  (SwGrfFmtColl*) pDoc->GetDfltGrfFmtColl(),
									  &aSet, bLink );
			if( !bLink && !bBlock && !bInsert && !bOrganizer )
				pNd->SetStreamName( aStrmName );
			pNd->SetAlternateText( aAltText );
			pNd->SetContour( pContour );
		}
	}
	delete pImgMap;
	delete pContour;
}

// Ausgabe eines Grafik-Nodes

void Sw3IoImp::OutGrfNode( const SwNoTxtNode& rNode )
{
	if( CheckPersist() )
	{
		SwGrfNode& rGrf = (SwGrfNode&) rNode;

		String aName, sFilterNm;
		BYTE cFlags = 0x00;
		if( !rGrf.IsGrfLink() )		// gelinkte Graphic
		{
			cFlags = 0x10;
			if( GRAPHIC_NONE == rGrf.GetGrf().GetType() )
				cFlags |= 0x20;
			else
			{
				// Falls die Grafik bereits im Storage ist, ist der Stream-Name
				// gesetzt. Dann brauchen wir sie nicht mehr zu speichern.
				// oder es ist ein SaveAs, dann auf jedenfall kopieren
				if( !rGrf.StoreGraphics( pRoot ) )
				{
					Warning( WARN_SWG_POOR_LOAD );
					cFlags |= 0x20;		// dann als leere Grf kennzeichnen!
//					Error( ERR_SWG_WRITE_ERROR );
				}
				// Den Namen merken
				else
					aName = rGrf.GetStreamName();
			}
		}
		else
		{
			nFileFlags |= SWGF_HAS_GRFLNK;
			rGrf.GetFileFilterNms( &aName, &sFilterNm );
			aName = INetURLObject::AbsToRel( aName );
		}

		// Beim 31-Export muss die URL noch am Node gespeichert werden
		const SfxPoolItem *pURLItem = 0;
		if( IsSw31Export() &&
			SFX_ITEM_SET == rNode.GetFlyFmt()->GetAttrSet().
									GetItemState( RES_URL, FALSE, &pURLItem ) )
		{
			if ( ((SwFmtURL*)pURLItem)->IsServerMap() )
				cFlags |= 0x40;
		}

		OpenRec( SWG_GRFNODE );
		*pStrm << cFlags;
		OutString( *pStrm, aName );
		OutString( *pStrm, sFilterNm );
		if( !IsSw31Export() )
			OutString( *pStrm, rGrf.GetAlternateText() );
		if( rNode.GetpSwAttrSet() )
			OutAttrSet( *rNode.GetpSwAttrSet() );

		if( pURLItem )
		{
			const String& rURL = ((SwFmtURL*)pURLItem)->GetURL();
			const String& rTarget = ((SwFmtURL*)pURLItem)->GetTargetFrameName();
			const ImageMap *pIMap = ((SwFmtURL*)pURLItem)->GetMap();
			if( rURL.Len() || rTarget.Len() || pIMap || (cFlags & 0x40) )
				OutImageMap( rURL, rTarget, pIMap, (cFlags & 0x40) );
		}

		// wegen der while( BytesLeft() )-Schleife beim Einlesen brauchen
		// wir hier einen eigenen Record, der aber auch fuer andere Sachen
		// verwendet werden kann und sollte
		if( !IsSw31Export() && rNode.HasContour() )
			OutContour( *rNode.HasContour() );

		CloseRec( SWG_GRFNODE );
		aStat.nGrf++;
	}
}

// Einlesen eines OLE-Nodes

void Sw3IoImp::InOLENode( SwNodeIndex& rPos )
{
	SwOLENode* pOLENd = 0;
	SwNoTxtNode* pNoTxtNd = 0;
	String aObjName, aAltText;

	OpenRec( SWG_OLENODE );
	InString( *pStrm, aObjName );

	if( IsVersion( SWG_DESKTOP40 ) )
		InString( *pStrm, aAltText );

	// change the StarImageObj to a graphic
	SvPersistRef xSrcDoc( new SvPersist() );
	SvInfoObjectRef xObjInfo;
	if( xSrcDoc->DoOwnerLoad( pRoot ) && xSrcDoc->GetObjectList() )
	{
		// Suche die richtige Info
		xObjInfo = xSrcDoc->Find( aObjName );
		ASSERT( xObjInfo.Is(), "Keine Objektinfo zum Einfuegen gefunden" );
	}

	if( xObjInfo.Is() )
	{
		SvStorageRef xSimStg( pRoot->OpenStorage(
											xObjInfo->GetStorageName() ) );
		String aStmName;
		if( xSimStg.Is() && (
			xSimStg->IsStream( aStmName = String(
					RTL_CONSTASCII_USTRINGPARAM( "StarImageDocument" )) ) ||
			xSimStg->IsStream( aStmName = String(
					RTL_CONSTASCII_USTRINGPARAM( "StarImageDocument 4.0" ))) ))
		{
			SvStorageStreamRef xSimStm( xSimStg->OpenStream( aStmName ) );

			if( xSimStm.Is() && !xSimStm->GetError() )
			{
				Graphic aGraphic;
				xSimStm->SetBufferSize( 32768 );
				xSimStm->SetKey( xSimStg->GetKey() );
				*xSimStm >> aGraphic;
				xSimStm->SetBufferSize( 0 );

				pNoTxtNd = pDoc->GetNodes().MakeGrfNode( rPos, aEmptyStr,
						aEmptyStr, &aGraphic,
						(SwGrfFmtColl*) pDoc->GetDfltGrfFmtColl() );
			}
		}
	}

	if( !pNoTxtNd && CheckPersist() )
	{
		// Im Insert Mode muss das OLE-Objekt in den Ziel-Storage kopiert werden
		if( bInsert && xObjInfo.Is() )
		{
			SvPersistRef rpDstDoc( pDoc->GetPersist() );

			String aStgName( xObjInfo->GetStorageName() );
			SvStorageRef rpDst( pDoc->GetPersist()->GetStorage() );
			// Sind Objektname und Storagename eindeutig?
			if( rpDstDoc->GetObjectList() )
				for( ULONG i = 0; i < rpDstDoc->GetObjectList()->Count(); i++ )
				{
					SvInfoObject* pTst = rpDstDoc->GetObjectList()->GetObject(i);
					// TODO: unicode: is this correct?
					if( aObjName.EqualsIgnoreCaseAscii( pTst->GetObjName() ))
						aObjName = Sw3Io::UniqueName( rpDst, "Obj" );
					// TODO: unicode: is this correct?
					if( aStgName.EqualsIgnoreCaseAscii( pTst->GetStorageName() ) )
						aStgName = Sw3Io::UniqueName( rpDst, "Obj" );
				}
			if( !rpDstDoc->Copy( aObjName, aStgName, &xObjInfo, xSrcDoc ) )
			{
				Error( ERR_SWG_READ_ERROR );
				return;
			}
		}
		pNoTxtNd = pOLENd = pDoc->GetNodes().MakeOLENode( rPos, aObjName,
						(SwGrfFmtColl*) pDoc->GetDfltGrfFmtColl() );
	}

	if( pNoTxtNd )
	{
		pNoTxtNd->SetAlternateText( aAltText );

		while( BytesLeft() )
		{
			BYTE cType = Peek();
			switch( cType )
			{
			case SWG_ATTRSET:
				if( !pNoTxtNd->GetpSwAttrSet() )
					((SwCntntNode*) pNoTxtNd)->NewAttrSet( pDoc->GetAttrPool() );
				InAttrSet( *pNoTxtNd->GetpSwAttrSet() );
				pNoTxtNd->GetpSwAttrSet()->SetModifyAtAttr( pNoTxtNd );
				break;

			case SW_OLE_CHARTNAME:
				if( pOLENd )
				{
					String sStr;
					OpenRec( SW_OLE_CHARTNAME );
					InString( *pStrm, sStr );
					CloseRec( SW_OLE_CHARTNAME );
					pOLENd->SetChartTblName( sStr );
				}
				else
					SkipRec();
				break;

			case SWG_IMAGEMAP:
				{
					String aURL, aTarget;
					BOOL bIsServerMap = FALSE;
					ImageMap *pImgMap = InImageMap( aURL, aTarget, bIsServerMap);
					SwFmtURL aFmtURL;
					aFmtURL.SetURL( aURL, bIsServerMap );
					aFmtURL.SetTargetFrameName( aTarget );
					if ( pImgMap )
					{
						aFmtURL.SetMap( pImgMap );
						delete pImgMap;
					}
					pNoTxtNd->SetAttr( aFmtURL );
				}
				break;

			case SWG_CONTOUR:
				if( pOLENd )
				{
					PolyPolygon *pContour = InContour();
					pOLENd->SetContour( pContour );
					delete pContour;
				}
				else
					SkipRec();
				break;

			default:
				SkipRec();
			}
		}
		// falls ein 3.0-Dokument gelesen wird: Node merken
		if( pOLENd )
		{
			if( bNormal && !bInsert && !bBlock && nVersion<=SWG_SHORTFIELDS )
			{
				if( !p30OLENodes )
					p30OLENodes = new SwOLENodes;

				p30OLENodes->Insert( pOLENd, p30OLENodes->Count() );
			}

			if( bInsert )
				pOLENd->SetOLESizeInvalid( TRUE );	//wg. Druckerwechsel
		}
	}
	if( !xObjInfo.Is() )
		Warning( WARN_SWG_POOR_LOAD );
		
	CloseRec( SWG_OLENODE );
}

// Ausgabe eines OLE-Nodes

void Sw3IoImp::OutOLENode( const SwNoTxtNode& rNd )
{
	if( CheckPersist() )
	{
		OpenRec( SWG_OLENODE );
		SwOLENode& rNode = (SwOLENode&) rNd;
		SwOLEObj& rObj = rNode.GetOLEObj();

		String aName( rObj.GetName() );
		OutString( *pStrm, aName );
		if( !IsSw31Export() )
			OutString( *pStrm, rNode.GetAlternateText() );
		if( rNode.GetpSwAttrSet() )
			OutAttrSet( *rNode.GetpSwAttrSet() );

		if( rNode.GetChartTblName().Len() )
		{
			OpenRec( SW_OLE_CHARTNAME );
			OutString( *pStrm, rNode.GetChartTblName() );
			CloseRec( SW_OLE_CHARTNAME );
		}

		if( !IsSw31Export() && rNode.HasContour() )
			OutContour( *rNode.HasContour() );

		CloseRec( SWG_OLENODE );
		aStat.nOLE++;
	}
}


// Einlesen eines Text-Wiederholungs-Nodes

void Sw3IoImp::InRepTxtNode( SwNodeIndex& rPos )
{
	UINT32 nRepetitions;

	OpenRec( SWG_REPTEXTNODE );
	*pStrm >> nRepetitions;

	rPos--;
	SwTxtNode *pNode = pDoc->GetNodes()[rPos]->GetTxtNode();
	rPos++;

	for( ULONG i=0; i<nRepetitions; i++ )
		pNode->MakeCopy( pDoc, rPos );

	CloseRec( SWG_REPTEXTNODE );
}


// Ausgabe eines Text-Wiederholungs-Nodes

void Sw3IoImp::OutRepTxtNode( ULONG nRepetitions )
{
	OpenRec( SWG_REPTEXTNODE );
	*pStrm << (UINT32)nRepetitions;
	CloseRec( SWG_REPTEXTNODE );
}

// Der Image-Map-Record war frueher ein SWG_GRAPHIC_EXT-Record.
// Deshalb enthaelt er immer der URL fuer eine Server-seitige
// Image-Map und kein ismap-Flag! Aus dem gleichen Grund wird die
// URL fuer eine Client-seitige Image-Map ueber ein Falg gesteuert.
// damit alte Writer-Version keine Warnung ausgeben, wenn der String
// leer ist.

ImageMap *Sw3IoImp::InImageMap( String& rURL, String& rTarget, BOOL& rIsMap )
{
	OpenRec( SWG_IMAGEMAP );
	BYTE cFlags = OpenFlagRec();
	CloseFlagRec();

	rIsMap = BOOL( (cFlags & 0x10) != 0 );

	InString( *pStrm, rURL );
	if( rURL.Len() )
		rURL = URIHelper::SmartRelToAbs( rURL );

	// bis hier hatten wir frueher einen SWG_GRAPHIC_EXT-Record!
	if( IsVersion( SWG_TARGETFRAME, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		String sDummy;
		InString( *pStrm, rTarget );
		InString( *pStrm, sDummy );
	}

	ImageMap *pIMap = 0;
	if( cFlags & 0x20 )
	{
		pIMap = new ImageMap;
		*pStrm >> *pIMap;
	}

	CloseRec( SWG_IMAGEMAP );

	return pIMap;	// muss ggf. vom Aufrufer geloescht werden!
}

void lcl_sw3io__ConvertMarkToOutline( String& rURL )
{
	if( rURL.Len() && '#' == rURL.GetChar( 0 ) )
	{
		String sCmp, sMark( INetURLObject::decode( rURL, INET_HEX_ESCAPE,
										INetURLObject::DECODE_WITH_CHARSET,
										RTL_TEXTENCODING_UTF8 ));
		xub_StrLen nPos = sMark.SearchBackward( cMarkSeperator );
		if( STRING_NOTFOUND != nPos &&
			( sCmp = sMark.Copy( nPos + 1 ) ).EraseAllChars().Len() &&
			COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToOutline ) )
		{
			rURL = '#';
			rURL += INetURLObject::createFragment( sMark.Copy( 1, nPos-1 ) );
			rURL += cMarkSeperator;
			rURL.AppendAscii( pMarkToOutline );
		}
	}
}

void Sw3IoImp::OutImageMap( const String& rURL, const String& rTarget,
							const ImageMap *pIMap, BOOL bIsServerMap )
{
	// Dieser Record ist fuer den 31-Export ein SWG_GRAPHIC_EXT und
	// enthaelt dann nur eine URL
	OpenRec( SWG_IMAGEMAP );
	BYTE cFlags = 0x00;
	if( !IsSw31Export() && bIsServerMap )
		cFlags += 0x10;	// es ist eine Image-Map
	if( !IsSw31Export() && pIMap )
		cFlags += 0x20;	// es folgt eine Image-Map

	*pStrm << cFlags;

	// Unabhaengigkeit von der AbsToRel-Schnittstelle sicherstellen!
	String aURL( rURL );
	if( aURL.Len() )
	{
		lcl_sw3io__ConvertMarkToOutline( aURL );
		aURL = INetURLObject::AbsToRel( aURL URL_DECODE);
	}
	OutString( *pStrm, aURL );

	// bis hier hatten wir frueher einen SWG_GRAPHIC_EXT-Record!

	if( !IsSw31Export() )
	{
		OutString( *pStrm, rTarget );
		OutString( *pStrm, aEmptyStr );

		if( pIMap )
		  *pStrm << *pIMap;
	}

	CloseRec( SWG_IMAGEMAP );
}

PolyPolygon *Sw3IoImp::InContour()
{
	PolyPolygon *pContour = 0;

	OpenRec( SWG_CONTOUR );
	BYTE cFlags = OpenFlagRec();
	CloseFlagRec();

	if( (cFlags & 0x10) != 0 )
	{
		pContour = new PolyPolygon;
		*pStrm >> *pContour;
	}

	CloseRec( SWG_CONTOUR );

	return pContour;
}

void Sw3IoImp::OutContour( const PolyPolygon& rPoly )
{
	OpenRec( SWG_CONTOUR );

	BYTE cFlags = 0x10;	// es folgt ein Contour Poly-Polygon
	*pStrm << cFlags;

	// das Contour-PolyPolygon rausschreiben
	*pStrm << rPoly;

	CloseRec( SWG_CONTOUR );
}


