/*************************************************************************
 *
 *  $RCSfile: ownview.cxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/02/19 16:24:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *		 - GNU Lesser General Public License Version 2.1
 *		 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_XTOPWINDOW_HPP_
#include <com/sun/star/awt/XTopWindow.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XSIMPLEFILEACCESS_HPP_
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTBRODCASTER_HPP_
#include <com/sun/star/document/XEventBroadcaster.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
#include <com/sun/star/document/XEventListener.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#include <unotools/ucbhelper.hxx>
#include <unotools/tempfile.hxx>
#include <comphelper/processfactory.hxx>
#include "ownview.hxx"


using namespace ::com::sun::star;

//========================================================
// Dummy interaction handler
//========================================================
//--------------------------------------------------------
class DummyHandler_Impl : public ::cppu::WeakImplHelper1< task::XInteractionHandler >
{
public:
	DummyHandler_Impl() {}
	~DummyHandler_Impl();

	virtual void SAL_CALL handle( const uno::Reference< task::XInteractionRequest >& xRequest )
			throw( uno::RuntimeException );
};

//--------------------------------------------------------
DummyHandler_Impl::~DummyHandler_Impl()
{
}

//--------------------------------------------------------
void SAL_CALL DummyHandler_Impl::handle( const uno::Reference< task::XInteractionRequest >& xRequest )
		throw( uno::RuntimeException )
{
	return;
}

//========================================================
// Object viewer
//========================================================
//--------------------------------------------------------
OwnView_Impl::OwnView_Impl( SvStorage& aObjStorage )
: m_bBusy( sal_False )
, m_bUseNative( sal_False )
{
	// only OLE storages are accepted
	if ( aObjStorage.GetError() || aObjStorage.GetVersion() >=  SOFFICE_FILEFORMAT_60 )
		throw uno::RuntimeException();

	// it must be an OLE storage
	::rtl::OUString aSubStreamName = ::rtl::OUString::createFromAscii( "Ole-Object" );
	if( !aObjStorage.IsContained( aSubStreamName ) || !aObjStorage.IsStream( aSubStreamName ) )
		throw uno::RuntimeException();

	// open substream
	SotStorageStreamRef aStorStream = aObjStorage.OpenSotStream( aSubStreamName, STREAM_STD_READ );
	if ( aStorStream->GetError() )
	{
		if ( aObjStorage.GetError() )
			aObjStorage.ResetError();

		throw uno::RuntimeException();
	}

	// create tempfile
	m_aTempFileURL = ::utl::TempFile().GetURL();
	SvStream* pOutStream = new SvFileStream( m_aTempFileURL, STREAM_STD_READWRITE );

	// write to the tempfile
	*aStorStream >> *pOutStream;
	pOutStream->Flush();
	sal_Bool bOk = !aStorStream->GetError() && !pOutStream->GetError();
	DELETEZ( pOutStream );

	if ( !bOk )
	{
		::utl::UCBContentHelper::Kill( m_aTempFileURL );
		throw uno::RuntimeException();
	}
}

//--------------------------------------------------------
OwnView_Impl::~OwnView_Impl()
{
	::utl::UCBContentHelper::Kill( m_aTempFileURL );
	if ( m_aNativeTempURL.getLength() )
		::utl::UCBContentHelper::Kill( m_aNativeTempURL );
}

//--------------------------------------------------------
sal_Bool OwnView_Impl::CreateModelFromURL( const ::rtl::OUString& aFileURL )
{
	sal_Bool bResult = sal_False;
	uno::Reference< lang::XMultiServiceFactory > xFactory = ::comphelper::getProcessServiceFactory();

	if ( xFactory.is() && aFileURL.getLength() )
	{
		try {
			uno::Reference < frame::XComponentLoader > xDocumentLoader( 
							xFactory->createInstance ( 
										::rtl::OUString::createFromAscii( "com.sun.star.frame.Desktop" ) ),
							uno::UNO_QUERY );

			if ( xDocumentLoader.is() )
			{
				uno::Sequence< beans::PropertyValue > aArgs( 4 );
	
				aArgs[0].Name = ::rtl::OUString::createFromAscii( "URL" );
				aArgs[0].Value <<= aFileURL;
	
				aArgs[1].Name = ::rtl::OUString::createFromAscii( "ReadOnly" );
				aArgs[1].Value <<= sal_True;
	
				aArgs[2].Name = ::rtl::OUString::createFromAscii( "InteractionHandler" );
				aArgs[2].Value <<= uno::Reference< task::XInteractionHandler >(
									static_cast< ::cppu::OWeakObject* >( new DummyHandler_Impl() ), uno::UNO_QUERY );

				aArgs[3].Name = ::rtl::OUString::createFromAscii( "DontEdit" );
				aArgs[3].Value <<= sal_True;
	
				
				uno::Reference< frame::XModel > xModel( xDocumentLoader->loadComponentFromURL(
																aFileURL,
																::rtl::OUString::createFromAscii( "_blank" ),
																0,
																aArgs ),
															uno::UNO_QUERY );
	
				if ( xModel.is() )
				{
					uno::Reference< document::XEventBroadcaster > xBroadCaster( xModel, uno::UNO_QUERY );
					if ( xBroadCaster.is() )
						xBroadCaster->addEventListener( uno::Reference< document::XEventListener >(
																static_cast< ::cppu::OWeakObject* >( this ),
									 							uno::UNO_QUERY ) );
	
					uno::Reference< util::XCloseable > xCloseable( xModel, uno::UNO_QUERY );
					if ( xCloseable.is() )
					{
						xCloseable->addCloseListener( uno::Reference< util::XCloseListener >(
																		static_cast< ::cppu::OWeakObject* >( this ),
										  								uno::UNO_QUERY ) );
	
						::osl::MutexGuard aGuard( m_aMutex );
						m_xModel = xModel;	
						bResult = sal_True;
					}
				}
			}
		}
		catch( uno::Exception& )
		{
		}
	}

	return bResult;
}

//--------------------------------------------------------
sal_Bool OwnView_Impl::CreateModel( sal_Bool bUseNative )
{
	uno::Reference< io::XInputStream > xTempInStream;
	sal_Bool bResult = sal_False;

	try {
		bResult = CreateModelFromURL( bUseNative ? m_aNativeTempURL : m_aTempFileURL );
	}
	catch( uno::Exception& )
	{
	}

	return bResult;
}

//--------------------------------------------------------
sal_Bool OwnView_Impl::ReadContentsAndGenerateTempFile( const SotStorageStreamRef& aStorStream )
{
	uno::Sequence< sal_uInt8 > aReadSeq( 4 );

	// read the complete size of the Object Package
	if ( aStorStream->Read( aReadSeq.getArray(), 4 ) != 4 )
		return sal_False;

	sal_uInt32 nLength = aReadSeq[0]
						+ aReadSeq[1] * 0x100
						+ aReadSeq[2] * 0x10000
						+ aReadSeq[3] * 0x1000000;

	// read the first header ( have no idea what does this header mean )
	if ( aStorStream->Read( aReadSeq.getArray(), 2 ) != 2 || aReadSeq[0] != 2 || aReadSeq[1] != 0 )
		return sal_False;

	String aFileSuffix;
	sal_uInt8 aByte = 0;

	// read file name
	// only extension is interesting so only subset of symbols is accepted
	do
	{
		if ( aStorStream->Read( &aByte, 1 ) != 1 )
			return sal_False;

		if ( aByte >= '0' && aByte <= '9'
		  || aByte >= 'a' && aByte <= 'z'
		  || aByte >= 'A' && aByte <= 'Z'
		  || aByte == '.' )
			aFileSuffix += (sal_Unicode) aByte;

	} while( aByte );

	// skip url
	do
	{
		if ( aStorStream->Read( &aByte, 1 ) != 1 )
			return sal_False;

	} while( aByte );

	// check the next header
	if ( aStorStream->Read( aReadSeq.getArray(), 4 ) != 4
	  || aReadSeq[0] || aReadSeq[1] || aReadSeq[2] != 3 || aReadSeq[3] )
		return sal_False;

	// get the size of the next entry
	if ( aStorStream->Read( aReadSeq.getArray(), 4 ) != 4 )
		return sal_False;

	sal_uInt32 nUrlSize = aReadSeq[0]
						+ aReadSeq[1] * 0x100
						+ aReadSeq[2] * 0x10000
						+ aReadSeq[3] * 0x1000000;
	sal_uInt32 nTargetPos = aStorStream->Tell() + nUrlSize;

	if ( aStorStream->Seek( nTargetPos ) != nTargetPos )
		return sal_False;

	// get the size of stored data
	if ( aStorStream->Read( aReadSeq.getArray(), 4 ) != 4 )
		return sal_False;

	sal_uInt32 nDataSize = aReadSeq[0]
						+ aReadSeq[1] * 0x100
						+ aReadSeq[2] * 0x10000
						+ aReadSeq[3] * 0x1000000;

	m_aNativeTempURL = ::utl::TempFile( String(), &aFileSuffix ).GetURL();
	SvStream* pOutStream = new SvFileStream( m_aNativeTempURL, STREAM_STD_READWRITE );

	sal_Bool bFailed = sal_False;

	aReadSeq.realloc( 32000 );
	sal_uInt32 nRead = 0;
	while ( nRead < nDataSize )
	{
		sal_uInt32 nToRead = ( nDataSize - nRead > 32000 ) ? 32000 : nDataSize - nRead;
		sal_uInt32 nLocalRead = aStorStream->Read( aReadSeq.getArray(), nToRead );
		
		if ( !nLocalRead || pOutStream->Write( aReadSeq.getArray(), nLocalRead ) != nLocalRead )
		{
			bFailed = sal_True;
			break;
		}

		nRead += nLocalRead;
	}

	DELETEZ( pOutStream );
	
	return !bFailed;
}

//--------------------------------------------------------
void OwnView_Impl::CreateNative()
{
	if ( m_aNativeTempURL.getLength() )
		return;

	SvStream* pInStream = new SvFileStream( m_aTempFileURL, STREAM_STD_READWRITE );
	if ( !pInStream->GetError() )
	{
		SotStorageRef rStorage = new SotStorage( sal_False, *pInStream );
		::rtl::OUString aSubStreamName = ::rtl::OUString::createFromAscii( "\1Ole10Native" );
		if ( !rStorage->GetError()
		  && rStorage->IsContained( aSubStreamName ) && rStorage->IsStream( aSubStreamName ) )
		{
			SotStorageStreamRef aStorStream = rStorage->OpenSotStream( aSubStreamName, STREAM_STD_READ );

			if ( aStorStream && !aStorStream->GetError() )
			{
				sal_Bool bOk = sal_False;

				// check whether storage represets Object Package
				SvGlobalName aGlobalName = rStorage->GetClassName();
				if ( aGlobalName == SvGlobalName( 0x0003000C, 0x0000, 0x0000, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 ) )
				{
					// the storage represents Object Package
					bOk = ReadContentsAndGenerateTempFile( aStorStream );

					if ( !bOk && m_aNativeTempURL.getLength() )
					{
						::utl::UCBContentHelper::Kill( m_aNativeTempURL );
						m_aNativeTempURL = ::rtl::OUString();
					}
				}

				if ( !bOk )
				{
					aStorStream->Seek( 0 );
					m_aNativeTempURL = ::utl::TempFile().GetURL();
					SvStream* pOutStream = new SvFileStream( m_aNativeTempURL, STREAM_STD_READWRITE );
	
					// just try to use \001Ole10Native stream
					// to write to the tempfile

					*aStorStream >> *pOutStream;
					pOutStream->Flush();
					bOk = !aStorStream->GetError() && !pOutStream->GetError();
					DELETEZ( pOutStream );

					if ( !bOk )
					{
						::utl::UCBContentHelper::Kill( m_aNativeTempURL );
						m_aNativeTempURL = ::rtl::OUString();
					}
				}
			}
		}
	}
}

//--------------------------------------------------------
sal_Bool OwnView_Impl::Open()
{
	sal_Bool bResult = sal_False;

	uno::Reference< frame::XModel > xExistingModel;

	{
		::osl::MutexGuard aGuard( m_aMutex );
		xExistingModel = m_xModel;
		if ( m_bBusy )
			return sal_False;

		m_bBusy = sal_True;
	}

	if ( xExistingModel.is() )
	{
		try {
			uno::Reference< frame::XController > xController = xExistingModel->getCurrentController();
			if ( xController.is() )
			{
				uno::Reference< frame::XFrame > xFrame = xController->getFrame();
				if ( xFrame.is() )
				{
					xFrame->activate();
					uno::Reference<awt::XTopWindow> xTopWindow( xFrame->getContainerWindow(), uno::UNO_QUERY );
					if(xTopWindow.is())
						xTopWindow->toFront();

					bResult = sal_True;
				}
			}
		}
		catch( uno::Exception& )
		{
		}
	}
	else
	{
		bResult = CreateModel( m_bUseNative );

		if ( !bResult && !m_bUseNative )
		{
			// the original storage can not be recognized
			if ( !m_aNativeTempURL.getLength() )
			{
				// create a temporary file for the native representation if there is no
				CreateNative();
			}

			if ( m_aNativeTempURL.getLength() )
			{
				bResult = CreateModel( sal_True );
				if ( bResult )
					m_bUseNative = sal_True;
			}
		}
	}

	m_bBusy = sal_False;

	return bResult;
}

//--------------------------------------------------------
void OwnView_Impl::Close()
{
	uno::Reference< frame::XModel > xModel;

	{
		::osl::MutexGuard aGuard( m_aMutex );
		if ( !m_xModel.is() )
			return;
		xModel = m_xModel;
		m_xModel = uno::Reference< frame::XModel >();

		if ( m_bBusy )
			return;

		m_bBusy = sal_True;
	}

	try {
		uno::Reference< document::XEventBroadcaster > xBroadCaster( xModel, uno::UNO_QUERY );
		if ( xBroadCaster.is() )
			xBroadCaster->removeEventListener( uno::Reference< document::XEventListener >(
																	static_cast< ::cppu::OWeakObject* >( this ),
											 						uno::UNO_QUERY ) );

		uno::Reference< util::XCloseable > xCloseable( xModel, uno::UNO_QUERY );
		if ( xCloseable.is() )
		{
			xCloseable->removeCloseListener( uno::Reference< util::XCloseListener >(
																	static_cast< ::cppu::OWeakObject* >( this ),
											 						uno::UNO_QUERY ) );
			xCloseable->close( sal_True );
		}
	}
	catch( uno::Exception& )
	{}

	m_bBusy = sal_False;
}

//--------------------------------------------------------
void SAL_CALL OwnView_Impl::notifyEvent( const document::EventObject& aEvent )
		throw ( uno::RuntimeException )
{

	uno::Reference< frame::XModel > xModel;

	{
		::osl::MutexGuard aGuard( m_aMutex );
		if ( aEvent.Source == m_xModel && aEvent.EventName.equalsAscii( "OnSaveAsDone" ) )
		{
			// SaveAs operation took place, so just forget the model and deregister listeners
			xModel = m_xModel;
			m_xModel = uno::Reference< frame::XModel >();
		}
	}

	if ( xModel.is() )
	{
		try {
			uno::Reference< document::XEventBroadcaster > xBroadCaster( xModel, uno::UNO_QUERY );
			if ( xBroadCaster.is() )
				xBroadCaster->removeEventListener( uno::Reference< document::XEventListener >(
																		static_cast< ::cppu::OWeakObject* >( this ),
											 							uno::UNO_QUERY ) );
	
			uno::Reference< util::XCloseable > xCloseable( xModel, uno::UNO_QUERY );
			if ( xCloseable.is() )
				xCloseable->removeCloseListener( uno::Reference< util::XCloseListener >(
																		static_cast< ::cppu::OWeakObject* >( this ),
											 							uno::UNO_QUERY ) );
		}
		catch( uno::Exception& )
		{}
	}
}

//--------------------------------------------------------
void SAL_CALL OwnView_Impl::queryClosing( const lang::EventObject& Source, sal_Bool GetsOwnership )
		throw ( util::CloseVetoException,
				uno::RuntimeException )
{
}

//--------------------------------------------------------
void SAL_CALL OwnView_Impl::notifyClosing( const lang::EventObject& Source )
		throw ( uno::RuntimeException )
{
	::osl::MutexGuard aGuard( m_aMutex );
	if ( Source.Source == m_xModel )
		m_xModel = uno::Reference< frame::XModel >();
}

//--------------------------------------------------------
void SAL_CALL OwnView_Impl::disposing( const lang::EventObject& Source )
		throw (uno::RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	if ( Source.Source == m_xModel )
		m_xModel = uno::Reference< frame::XModel >();
};

