/*************************************************************************
 *
 *  $RCSfile: dlgcont.cxx,v $
 *
 *  $Revision: 1.12.116.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/16 15:19:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XSIMPLEFILEACCESS_HPP_
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

#include "dlgcont.hxx"

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <svtools/pathoptions.hxx>
#include <xmlscript/xmldlg_imexp.hxx>
#include <app.hxx>


using namespace com::sun::star::container;
using namespace com::sun::star::io;
using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;
using namespace com::sun::star::lang;
using namespace com::sun::star::script;
using namespace com::sun::star::xml::sax;
using namespace com::sun::star;
using namespace cppu;
using namespace rtl;
using namespace osl;


//============================================================================
// Implementation class SfxDialogLibraryContainer

sal_Bool SfxDialogLibraryContainer::init
    ( const ::rtl::OUString& aInitialisationParam, SotStorage* pStor )
{
    return SfxLibraryContainer_Impl::init( 
          aInitialisationParam,
          OUString ( RTL_CONSTASCII_USTRINGPARAM("dialog") ),
		  OUString ( RTL_CONSTASCII_USTRINGPARAM("dialogs") ),
		  OUString ( RTL_CONSTASCII_USTRINGPARAM("xdl") ),
		  OUString ( RTL_CONSTASCII_USTRINGPARAM("Dialogs") ),
          pStor );
}

// Ctor for service
SfxDialogLibraryContainer::SfxDialogLibraryContainer( void )
{
    // all initialisation has to be done
    // by calling XInitialization::initialize
}

SfxDialogLibraryContainer::SfxDialogLibraryContainer( SotStorage* pStor )
{
    OUString aInitialisationParam;
    init( aInitialisationParam, pStor );
}

// Methods to get library instances of the correct type
SfxLibrary_Impl* SfxDialogLibraryContainer::implCreateLibrary( void )
{
	SfxLibrary_Impl* pRet = (SfxLibrary_Impl*) new SfxDialogLibrary( mxMSF, mxSFI );
	return pRet;
}

SfxLibrary_Impl* SfxDialogLibraryContainer::implCreateLibraryLink
	( const OUString& aLibInfoFileURL, const OUString& StorageURL, sal_Bool ReadOnly )
{
	SfxLibrary_Impl* pRet = 
		(SfxLibrary_Impl*) new SfxDialogLibrary
            ( mxMSF, mxSFI, aLibInfoFileURL, StorageURL, ReadOnly );
	return pRet;
}

Any SAL_CALL SfxDialogLibraryContainer::createEmptyLibraryElement( void )
{
	Reference< XInputStreamProvider > xISP;
	Any aRetAny;
	aRetAny <<= xISP;
	return aRetAny;
}

sal_Bool SAL_CALL SfxDialogLibraryContainer::isLibraryElementValid( Any aElement )
{
	Reference< XInputStreamProvider > xISP;
	aElement >>= xISP;
	sal_Bool bRet = xISP.is();
	return bRet;
}

void SAL_CALL SfxDialogLibraryContainer::writeLibraryElement
( 
	Any aElement,
	const OUString& aElementName, 
	Reference< XOutputStream > xOutput 
)
	throw(Exception)
{
	Reference< XInputStreamProvider > xISP;
	aElement >>= xISP;
	if( !xISP.is() )
		return;

	Reference< XInputStream > xInput( xISP->createInputStream() );
	Sequence< sal_Int8 > bytes;
	sal_Int32 nRead = xInput->readBytes( bytes, xInput->available() );
	for (;;)
	{
		if( nRead )
			xOutput->writeBytes( bytes );

		nRead = xInput->readBytes( bytes, 1024 );
		if (! nRead)
			break;
	}
	xInput->closeInput();
}

void SfxDialogLibraryContainer::storeLibrariesToStorage( SotStorageRef xStorage )
{
	mbOasis2OOoFormat = sal_False;

	if ( mxStorage.Is() && SotStorage::IsOasisFormat( mxStorage ) &&
		!SotStorage::IsOasisFormat( xStorage ) )
	{
		mbOasis2OOoFormat = sal_True;
	}

	SfxLibraryContainer_Impl::storeLibrariesToStorage( xStorage );

	mbOasis2OOoFormat = sal_False;
}


Any SAL_CALL SfxDialogLibraryContainer::importLibraryElement
	( const OUString& aFile, SotStorageStreamRef xElementStream )
{
	Any aRetAny;

	// TODO: Member because later it will be a component
	Reference< XMultiServiceFactory > xMSF( comphelper::getProcessServiceFactory() );
	if( !xMSF.is() )
	{
		OSL_ENSURE( 0, "### couln't get ProcessServiceFactory\n" );
		return aRetAny;
	}

	Reference< XParser > xParser( xMSF->createInstance(
		OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Parser") ) ), UNO_QUERY );
	if( !xParser.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax parser component\n" );
		return aRetAny;
	}

	Reference< XNameContainer > xDialogModel( xMSF->createInstance
		( OUString(RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.awt.UnoControlDialogModel" ) ) ), UNO_QUERY );
	if( !xDialogModel.is() )
	{
		OSL_ENSURE( 0, "### couln't create com.sun.star.awt.UnoControlDialogModel component\n" );
		return aRetAny;
	}

	// Read from storage?
	sal_Bool bStorage = xElementStream.Is();
	Reference< XInputStream > xInput;

	if( bStorage )
	{
		xInput = new utl::OInputStreamWrapper( *xElementStream );
	}
	else
	{
		try
		{
			xInput = mxSFI->openFileRead( aFile );
		}
		catch( Exception& )
		//catch( Exception& e )
		{
			// TODO:
			//throw WrappedTargetException( e );
		}
	}
	if( !xInput.is() )
		return aRetAny;

    Reference< XComponentContext > xContext;
    Reference< beans::XPropertySet > xProps( xMSF, UNO_QUERY );
    OSL_ASSERT( xProps.is() );
    OSL_VERIFY( xProps->getPropertyValue( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("DefaultContext")) ) >>= xContext );

	InputSource source;
	source.aInputStream = xInput;
	source.sSystemId 	= aFile;
	
	Reference< xml::sax::XDocumentHandler > xHandler;
	if ( mxStorage.Is() && SotStorage::IsOasisFormat( mxStorage ) )
	{
		Sequence<Any> aArgs( 1 );
		aArgs[0] <<= ::xmlscript::importDialogModel( xDialogModel, xContext );

		Reference< xml::sax::XDocumentHandler > xOasisHandler(
			xMSF->createInstanceWithArguments(
				OUString( RTL_CONSTASCII_USTRINGPARAM(
					"com.sun.star.comp.Oasis2OOoTransformer" ) ),
				aArgs),
			UNO_QUERY );

		if ( xOasisHandler.is() )
		{
			xHandler = xOasisHandler;
		}
	}

	if ( !xHandler.is() )
	{
		xHandler = ::xmlscript::importDialogModel( xDialogModel, xContext );
	}

	// start parsing 
	xParser->setDocumentHandler( xHandler );
	xParser->parseStream( source );

	// Create InputStream, TODO: Implement own InputStreamProvider
	// to avoid creating the DialogModel here!
	Reference< XInputStreamProvider > xISP = ::xmlscript::exportDialogModel( xDialogModel, xContext );
	aRetAny <<= xISP;
	return aRetAny;
}

void SAL_CALL SfxDialogLibraryContainer::importFromOldStorage( const ::rtl::OUString& aFile )
{
    // Nothing to do here, old dialogs cannot be imported
}

SfxLibraryContainer_Impl* SfxDialogLibraryContainer::createInstanceImpl( void )
{
    return new SfxDialogLibraryContainer();
}


//============================================================================
// Methods XInitialization
void SAL_CALL SfxDialogLibraryContainer::initialize( const Sequence< Any >& aArguments ) 
    throw (::com::sun::star::uno::Exception, 
           ::com::sun::star::uno::RuntimeException)
{
	sal_Int32 nArgCount = aArguments.getLength();
	OSL_ENSURE( nArgCount, "SfxDialogLibraryContainer::initialize() called with no arguments\n" );

    OUString aInitialisationParam;
    if( nArgCount )
    {
        const Any* pArgs = aArguments.getConstArray();
        pArgs[0] >>= aInitialisationParam;
    	OSL_ENSURE( aInitialisationParam.getLength(), 
            "SfxDialogLibraryContainer::initialize() called with empty url\n" );
    }

    init( aInitialisationParam );
}


//============================================================================
// Service
SFX_IMPL_SINGLEFACTORY( SfxDialogLibraryContainer )

Sequence< OUString > SfxDialogLibraryContainer::impl_getStaticSupportedServiceNames()
{
    static Sequence< OUString > seqServiceNames( 1 );
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        OUString* pSeq = seqServiceNames.getArray();
        pSeq[0] = OUString::createFromAscii( "com.sun.star.script.DialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return seqServiceNames;
}

OUString SfxDialogLibraryContainer::impl_getStaticImplementationName()
{
    static OUString aImplName;
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        aImplName = OUString::createFromAscii( "com.sun.star.comp.sfx2.DialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return aImplName;
}

Reference< XInterface > SAL_CALL SfxDialogLibraryContainer::impl_createInstance
    ( const Reference< XMultiServiceFactory >& xServiceManager ) 
        throw( Exception )
{
    Reference< XInterface > xRet = 
        static_cast< XInterface* >( static_cast< OWeakObject* >(new SfxDialogLibraryContainer()) );
    return xRet;
}


//============================================================================
// Service for application library container
SFX_IMPL_ONEINSTANCEFACTORY( SfxApplicationDialogLibraryContainer )

Sequence< OUString > SfxApplicationDialogLibraryContainer::impl_getStaticSupportedServiceNames()
{
    static Sequence< OUString > seqServiceNames( 1 );
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        OUString* pSeq = seqServiceNames.getArray();
        pSeq[0] = OUString::createFromAscii( "com.sun.star.script.ApplicationDialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return seqServiceNames;
}

OUString SfxApplicationDialogLibraryContainer::impl_getStaticImplementationName()
{
    static OUString aImplName;
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        aImplName = OUString::createFromAscii( "com.sun.star.comp.sfx2.ApplicationDialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return aImplName;
}

Reference< XInterface > SAL_CALL SfxApplicationDialogLibraryContainer::impl_createInstance
    ( const Reference< XMultiServiceFactory >& xServiceManager ) 
        throw( Exception )
{
	SFX_APP()->GetBasicManager();
    Reference< XInterface > xRet = 
        Reference< XInterface >( SFX_APP()->GetDialogContainer(), UNO_QUERY );
    return xRet;
}


//============================================================================
// Implementation class SfxDialogLibrary

// Ctor
SfxDialogLibrary::SfxDialogLibrary( Reference< XMultiServiceFactory > xMSF, 
                                    Reference< XSimpleFileAccess > xSFI )
	: SfxLibrary_Impl( getCppuType( (const Reference< XInputStreamProvider > *)0 ), xMSF, xSFI )
{
}

SfxDialogLibrary::SfxDialogLibrary( Reference< XMultiServiceFactory > xMSF, 
                                    Reference< XSimpleFileAccess > xSFI,
                                    const OUString& aLibInfoFileURL, 
                                    const OUString& aStorageURL, 
                                    sal_Bool ReadOnly )
	: SfxLibrary_Impl( getCppuType( (const Reference< XInputStreamProvider > *)0 ),
                       xMSF, xSFI, aLibInfoFileURL, aStorageURL, ReadOnly)
{
}

//============================================================================

