/*************************************************************************
 *
 *  $RCSfile: ipfrm.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:27:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_IPFRM_HXX
#define _SFX_IPFRM_HXX

#include "viewfrm.hxx"
#include "objface.hxx"
#include "objsh.hxx"

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif

class SfxItemSet;
class SfxItemPool;
class SfxViewShell;
class SfxInPlaceFrame;
class SfxInPlaceEnv_Impl;
class SvInPlaceClipWindow;
class SvInPlaceWindow;
class SfxConfigManager;
class SfxBorderWindow;
struct SfxInPlaceFrame_Impl;

// -----------------------------------------------------------------------

class SfxInPlaceFrame: public SfxViewFrame
{
friend class SfxBorderWindow; // Resize aufrufen

	SfxInPlaceFrame_Impl*	pImp; // unused
	SfxInPlaceEnv_Impl*     pEnv;
	SfxViewShell*			pViewShell;

protected:
							// Forwarding zwischen SfxInternalObject und SfxViewShell
	virtual void            Activate( BOOL bUI );
	virtual void            Deactivate( BOOL bUI );
	virtual BOOL            Close();

	virtual void            SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
									const SfxHint& rHint, const TypeId& rHintType );
	virtual void            ShowStatusText( const String& rText );
	virtual void            HideStatusText();
	virtual                 ~SfxInPlaceFrame();

public:
							TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXIPFRM);

							SfxInPlaceFrame( SfxObjectShell &rObjSh, SfxFrame*p=0 );

	virtual void            SetZoomFactor( const Fraction &rZoomX,
										   const Fraction &rZoomY );

	void                    Exec(SfxRequest &);
	void                    GetState(SfxItemSet &);

	virtual void            Optimize();

	void                    SetChildWindow(const ResId& rResId);

	virtual BOOL			SetBorderPixelImpl( const SfxViewShell *pSh,
												const SvBorder &rBorder );
	virtual const SvBorder& GetBorderPixelImpl( const SfxViewShell *pSh ) const;
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );

#ifndef _SFXDOC_HXX
	SfxInPlaceObject*		GetIPObject_Impl()
								{ return GetObjectShell()->GetInPlaceObject(); }
	SfxInPlaceEnv_Impl* 	GetEnv_Impl() const
								 { 	return pEnv; }
#endif
};


#endif

