/*************************************************************************
 *
 *  $RCSfile: mover.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: cl $ $Date: 2002/04/30 10:00:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <math.h>
#include <tools/debug.hxx>
#include <vcl/poly.hxx>
#include <vcl/wrkwin.hxx>
#include <vcl/svapp.hxx>
#include <svx/xpoly.hxx>
#include <svx/svdpagv.hxx>
#include "mover.hxx"
#include "fuslshow.hxx"
#include "sprite.hxx"
#include "showview.hxx"
#include "docshell.hxx"
#include "viewshel.hxx"
#include "sdview.hxx"

// -----------
// - Defines -
// -----------

#define SDBITMAPMOVER_PATHTYPE_UNDEFINED	0
#define SDBITMAPMOVER_PATHTYPE_LINE 		1
#define MOVER_MAGIC							0x23456789

// -----------------
// - SdBitmapMover -
// -----------------

SdBitmapMover::SdBitmapMover( Window* pWindow, FuSlideShow* pFu ) :
	pWin			( pWindow ),
	pFuSlideShow	( pFu ),
	pListOfImages	( NULL ),
	pPolygon		( NULL ),
	pInitDev		( NULL ),
	pTopLayer		( NULL ),
	ppTopMtf		( NULL ),
	nMulti			( 1UL ),
	nMagic			( MOVER_MAGIC )
{
}

// ------------------------------------------------------------------------

SdBitmapMover::~SdBitmapMover()
{
	nMagic = 0L;
	delete pPolygon;
}

// ------------------------------------------------------------------------

void SdBitmapMover::SetPath( const Point& rStart, const Point& rEnd,
							 const double* pStartScaleX, const double* pEndScaleX, 
							 const double* pStartScaleY, const double* pEndScaleY )
{
	delete pPolygon;
	pPolygon = new Polygon( 2 );
	(*pPolygon)[ 0 ] = rStart;
	(*pPolygon)[ 1 ] = rEnd;

	mfStartScaleX = ( pStartScaleX ? *pStartScaleX : 1.0 );
	mfEndScaleX = ( pEndScaleX ? *pEndScaleX : 1.0 );
	
	mfStartScaleY = ( pStartScaleY ? *pStartScaleY : 1.0 );
	mfEndScaleY = ( pEndScaleY ? *pEndScaleY : 1.0 );
}

// ------------------------------------------------------------------------

void SdBitmapMover::SetPath( const XPolyPolygon& rXPolyPolygon, 
							 const double* pStartScaleX, const double* pEndScaleX,
							 const double* pStartScaleY, const double* pEndScaleY )
{
	ULONG			nTotal = 0L;
	ULONG			nMax = USHRT_MAX;
	const USHORT	nXPoly = rXPolyPolygon.Count();
	USHORT			n;

	for ( n = 0; n < nXPoly; n++ )
		nTotal += rXPolyPolygon.GetObject( n ).GetPointCount();

	delete pPolygon;
	pPolygon = new Polygon( (USHORT) Min( nMax, nTotal ) );

	for( nTotal = n = 0; ( n < nXPoly ) && ( nTotal <= nMax ); n++ )
	{
		const XPolygon& rXPoly = rXPolyPolygon.GetObject( n );
		USHORT			nPoints = rXPoly.GetPointCount();

		for( USHORT i = 0; ( i < nPoints ) && ( nTotal <= nMax ); i++ )
			(*pPolygon)[ (USHORT) ( nTotal++ ) ] = rXPoly[ i ];
	}

	mfStartScaleX = ( pStartScaleX ? *pStartScaleX : 1.0 );
	mfEndScaleX = ( pEndScaleX ? *pEndScaleX : 1.0 );

	mfStartScaleY = ( pStartScaleY ? *pStartScaleY : 1.0 );
	mfEndScaleY = ( pEndScaleY ? *pEndScaleY : 1.0 );
}

// ------------------------------------------------------------------------

BOOL SdBitmapMover::Move()
{
	DBG_ASSERT( pWin, "kein Fenster gesetzt" );
	DBG_ASSERT( pListOfImages, "kein Liste gesetzt" );
	DBG_ASSERT( pPolygon, "kein Polygon" );

	Sprite			aSprite( pListOfImages );
	const Region	aOldRegion( pWin->GetClipRegion() );
	const Polygon&	rPoly = *pPolygon;
	const USHORT	nPolySize = rPoly.GetSize();
	const ULONG		nImageCount = (USHORT) pListOfImages->Count();
	const BOOL		bIsClipRegion = pWin->IsClipRegion();
	BOOL			bRet;

	// Clip-Region setzen
	if( !aClip.IsEmpty() )
		pWin->SetClipRegion( aClip );

	bRet = aSprite.StartMoving( pWin,pInitDev, pTopLayer, ppTopMtf, &aObjStartMarker, &aObjEndMarker );

	if( bRet )
	{
		Application*	pApp = GetpApp();
		SdView*			pView;
		SdrPageView*	pPageView;
		BOOL			bGrid = FALSE;

		if( pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_VIEW )
		{
			pView = pFuSlideShow->GetDocSh()->GetViewShell()->GetView();

			if( pView->IsGridVisible() && pView->IsGridFront() )
			{
				pPageView = pView->GetPageView( (SdrPage*) pFuSlideShow->GetActualPage() );
				bGrid = TRUE;
			}
		}

		if( ( rPoly.GetSize() == 2 ) && ( rPoly[ 0 ] == rPoly[ 1 ] ) && ( nImageCount > 1 ) )
		{
			// Apspielen einer Sequenz an gleicher Stelle
			const Point&	rPt = rPoly[ 0 ];
			const ULONG		nLastTime = Time::GetSystemTicks();
			ULONG			nTime = 250UL;

			for( ULONG i = 0UL; ( i < nImageCount ) && ( nMagic == MOVER_MAGIC ); i++ )
			{
				const ULONG nLastTime = Time::GetSystemTicks();

				aSprite.MoveTo( pWin, rPt );

				if( bGrid )
				{
					const BOOL bOldMap = pWin->IsMapModeEnabled();
					pWin->EnableMapMode( TRUE );
					pPageView->DrawGrid( *pWin, pView->GetGridColor() );
					pWin->EnableMapMode( bOldMap );
				}

				while( ( Time::GetSystemTicks() - nLastTime ) < nTime )
				{
					if( nMagic != MOVER_MAGIC )
						break;

					pApp->Reschedule();
				}
			}
		}
		else
		{
			// tatsaechliche Bewegung
			Point			aPt;
			double			fScaleX, fScaleY;
			ULONG			nUnitsPerSec;
			BOOL			bCont;

			switch( eSpeed )
			{
				case( MOVE_SPEED_SLOW ):	nUnitsPerSec = 10000; break;
				case( MOVE_SPEED_FAST ):	nUnitsPerSec = 56000; break;
				default:					nUnitsPerSec = 32000; break;
			}

			aCtrl.Reset( rPoly, pWin, ( nMulti > 1UL ) ? nUnitsPerSec * nMulti : nUnitsPerSec,
						 mfStartScaleX, mfEndScaleX, mfStartScaleY, mfEndScaleY );

			do
			{
				if( nMagic != MOVER_MAGIC )
					break;

				bCont = aCtrl.GetNextPathPoint( aPt, fScaleX, fScaleY );

				if( nMagic != MOVER_MAGIC )
					break;

				aSprite.MoveTo( pWin, aPt, fScaleX, fScaleY );

				if( bGrid )
				{
					const BOOL bOldMap = pWin->IsMapModeEnabled();
					pWin->EnableMapMode( TRUE );
					pPageView->DrawGrid( *pWin, pView->GetGridColor() );
					pWin->EnableMapMode( bOldMap );
				}
			}
			while( bCont );
		}

		// Falls wir zerstoert wurden, nicht mehr auf das Window zugreifen
		if( MOVER_MAGIC == nMagic )
		{
			aSprite.EndMoving( pWin );
            pWin->Sync();

			// ClipRegion zuruecksetzen
			if( bIsClipRegion )
				pWin->SetClipRegion( aOldRegion );
			else
				pWin->SetClipRegion();
		}
	}

	return bRet;
}
