
	.file	"armhelper.s"

@ ARM support code for OpenOffice C++/UNO bridging
@
@ Written by Peter Naulls <peter@chocky.org>
@
@ This code avoids the dynamically generated code used on other
@ platforms to intercept and make virtual method calls.  This
@ avoids the need to flush the-icache, although it does mean some
@ guessing to determine the index.


@ Call a virtual function with an arbitrary number of words
@
@ With 4 or less parameters, the function is directly jumped to.
@ With more, parameters are pushed on the stack, and a stack
@ frame is saved so the state can be restored.
@
@ r0: pThis
@ r1: nStackLongs
@ r2: pStackLongs
@ r3: nVtableIndex

        .global arm_callVirtualMethod
        .type   arm_callVirtualMethod, %function
arm_callVirtualMethod:
        ldr     r0, [r0, #0]           @ get class reference
        ldr     ip, [r0, r3, lsl #2]   @ get method

        cmp     r1, #5
        ldmltia r2, {r0-r3}            @ load register params
        movlt   pc, ip                 @ don't return to this function

        mov     r0, ip

        mov     ip, sp
        stmfd   sp!, {fp, ip, lr, pc}
        sub     fp, ip, #4


        @ push paramters after #4 onto the stack
        sub     r1, r1, #4
        add     r2, r2, #16
.Lstack:
        cmp     r1, #0
        subgt   r1, r1, #1
        ldrgt   r3, [r2, r1, lsl #2]
        strgt   r3, [sp, #-4]!
        bgt     .Lstack

        mov     ip, r0

        ldmdb   r2, {r0-r3}        @ load register params
        mov     lr, pc             @ save return address
        mov     pc, ip             @ jump to function

        ldmea   fp, {fp, sp, pc}   @ return




@ Intercept a virtual call with a simple return type

        .type   arm_codeSnippetSimple, %function
        .global arm_codeSnippetSimple
arm_codeSnippetSimple:
        stmfd sp!, {r0-r3}         @  follow other parameters on stack
        stmfd sp!, {lr}

        ldr   r0, [lr, #-4]        @ Fetch the vtable LDR instruction
        and   r1, r0, #0x05900000  @ Check that it's really an LDR
        cmp   r1, #0x05900000      @ If not, fetch from further back
        ldrne r0, [lr, #-20]
        andne r1, r0, #0x05900000  @ Check again
        cmpne r1, #0x05900000      @
        ldrne r0, [lr, #-24]       @ If not, fetch from one more back

        mov   r0, r0, lsr #2       @ Divide by 4 to get the table offset
        and   r0, r0, #0xff        @ Get the index from the instruction

        add   r1, sp, #4           @ r1 points to this and params
        bl    cpp_vtable_call(PLT)

        add  sp, sp, #20           @ restore stack
        ldr  pc, [sp, #-20]        @ return


@ Intercept a virtual call with a complex return type

        .type   arm_codeSnippetComplex, %function
        .global arm_codeSnippetComplex
arm_codeSnippetComplex:
        stmfd sp!, {r0-r3}         @ follow other parameters on stack
        stmfd sp!, {lr}

        ldr   r0, [lr, #-4]        @ Fetch the vtable LDR instruction
        and   r1, r0, #0x05900000  @ Check that it's really an LDR
        cmp   r1, #0x05900000      @ If not, fetch from further back
        ldrne r0, [lr, #-20]
        andne r1, r0, #0x05900000  @ Check again
        cmpne r1, #0x05900000      @
        ldrne r0, [lr, #-24]       @ If not, fetch from one more back

        mov  r0, r0, lsr #2        @ Divide by 4 to get the table offset
        and  r0, r0, #0xff         @ Get the index from the instruction
        orr  r0, r0, #1<<31        @ Set top bit to indicate complex return
        
        add  r1, sp, #4            @ r1 points to this and params
        bl   cpp_vtable_call(PLT)

        add  sp, sp, #20           @ restore stack
        ldr  pc, [sp, #-20]        @ return



