/*************************************************************************
 *
 *  $RCSfile: sbxitem.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: tbe $ $Date: 2001/07/04 13:40:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBXITEM_HXX
#define _SBXITEM_HXX


#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

const USHORT BASICIDE_TYPE_UNKNOWN	=	0;
const USHORT BASICIDE_TYPE_SHELL	=	1;
const USHORT BASICIDE_TYPE_LIBRARY	=	2;
const USHORT BASICIDE_TYPE_MODULE	=	3;
const USHORT BASICIDE_TYPE_DIALOG	=	4;
const USHORT BASICIDE_TYPE_METHOD	=	5;


class SbxItem : public SfxPoolItem
{
	SfxObjectShell*			m_pShell;
	String					m_aLibName;
	String					m_aName;
	String					m_aMethodName;
	USHORT					m_nType; 

public:
	TYPEINFO();
	SbxItem( USHORT nWhich, SfxObjectShell* pShell, const String& aLibName, const String& aName, USHORT nType );
	SbxItem( USHORT nWhich, SfxObjectShell* pShell, const String& aLibName, const String& aName, const String& aMethodName, USHORT nType );
	SbxItem( const SbxItem& );

	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
	virtual int				operator==( const SfxPoolItem& ) const;

	SfxObjectShell*			GetShell() const { return m_pShell; }
	void					SetShell( SfxObjectShell* pShell ) { m_pShell = pShell; }

	const String&			GetLibName() const { return m_aLibName; }
	void					SetLibName( const String& aLibName ) { m_aLibName = aLibName; }

	const String&			GetName() const { return m_aName; }
	void					SetName( const String& aName ) { m_aName = aName; }

	const String&			GetMethodName() const { return m_aMethodName; }
	void					SetMethodName( const String& aMethodName ) { m_aMethodName = aMethodName; }

	USHORT					GetType() const { return m_nType; }
	void					SetType( USHORT nType ) { m_nType = nType; }
};


#endif
