/**********************************************************************
  FT_PAO.c:

     FT_PAO.c is a subroutine to Fourier transform pseudo atomic 
     orbitals.

  Log of FT_PAO.c:

     15/Sep/2002  Released by T.Ozaki

***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "openmx_common.h"

#ifdef nompi
#include "mimic_mpi.h"
#else
#include "mpi.h"
#endif


void FT_PAO()
{
  int numprocs,myid,ID,tag=999;
  int count,NumSpe;
  int i,kj,num_k;
  int Lspe,spe,GL,Mul;
  double dk,norm_k,h;
  double rmin,rmax,r,sum;
  double sj,sy,sjp,syp;
  double Sr,Dr,dum0;
  double **SphB,**SphBp;
  double *tmp_SphB,*tmp_SphBp;
  double TStime, TEtime;
  MPI_Status stat;
  MPI_Request request;

  dtime(&TStime);

  /* MPI */
  MPI_Comm_size(mpi_comm_level1,&numprocs);
  MPI_Comm_rank(mpi_comm_level1,&myid);

  if (myid==Host_ID) printf("<FT_PAO>          Fourier transform of pseudo atomic orbitals\n");

  for (Lspe=0; Lspe<MSpeciesNum; Lspe++){

    spe = Species_Top[myid] + Lspe;

    num_k = Ngrid_NormK;
    dk = PAO_Nkmax/(double)num_k;

    /* allocate SphB and SphBp */

    SphB = (double**)malloc(sizeof(double*)*(Spe_MaxL_Basis[spe]+3));
    for(GL=0; GL<(Spe_MaxL_Basis[spe]+3); GL++){ 
      SphB[GL] = (double*)malloc(sizeof(double)*(OneD_Grid+1));
    }

    SphBp = (double**)malloc(sizeof(double*)*(Spe_MaxL_Basis[spe]+3));
    for(GL=0; GL<(Spe_MaxL_Basis[spe]+3); GL++){ 
      SphBp[GL] = (double*)malloc(sizeof(double)*(OneD_Grid+1));
    }

    tmp_SphB  = (double*)malloc(sizeof(double)*(Spe_MaxL_Basis[spe]+3));
    tmp_SphBp = (double*)malloc(sizeof(double)*(Spe_MaxL_Basis[spe]+3));

    /* kj loop */

    for (kj=0; kj<num_k; kj++){

      norm_k = (double)kj*dk;

      /* calculate SphB */

      rmin = Spe_PAO_RV[spe][0];
      rmax = Spe_Atom_Cut1[spe] + 0.5;
      h = (rmax - rmin)/(double)OneD_Grid;

      for (i=0; i<=OneD_Grid; i++){
        r = rmin + (double)i*h;

	Spherical_Bessel(norm_k*r,Spe_MaxL_Basis[spe],tmp_SphB,tmp_SphBp);

	for(GL=0; GL<=Spe_MaxL_Basis[spe]; GL++){ 
	  SphB[GL][i]  =  tmp_SphB[GL]; 
	  SphBp[GL][i] = tmp_SphBp[GL]; 
	}
      }

      /* loof for GL and Mul */

      for (GL=0; GL<=Spe_MaxL_Basis[spe]; GL++){
	for (Mul=0; Mul<Spe_Num_Basis[spe][GL]; Mul++){

	  /****************************************************
                        \int jL(k*r)RL r^2 dr 
	  ****************************************************/

	  /* trapezoidal rule */

	  rmin = Spe_PAO_RV[spe][0];
	  rmax = Spe_Atom_Cut1[spe] + 0.5;

          sum = 0.0;
          h = (rmax - rmin)/(double)OneD_Grid;
          for (i=0; i<=OneD_Grid; i++){

            r = rmin + (double)i*h;
            sj = SphB[GL][i];

            if (i==0 || i==OneD_Grid) 
              sum += 0.5*r*r*RadialF(spe,GL,Mul,r)*sj;
            else
              sum += r*r*RadialF(spe,GL,Mul,r)*sj;
          } 
          sum = sum*h;
          Spe_RF_Bessel[spe][GL][Mul][kj] = sum;
          NormK[kj] = norm_k;

	} /* Mul */
      } /* GL */
    } /* kj */

    /* free SphB and SphBp */

    for(GL=0; GL<(Spe_MaxL_Basis[spe]+3); GL++){ 
      free(SphB[GL]);
    }
    free(SphB);

    for(GL=0; GL<(Spe_MaxL_Basis[spe]+3); GL++){ 
      free(SphBp[GL]);
    }
    free(SphBp);

    free(tmp_SphB);
    free(tmp_SphBp);

  } /* Lspe */

  /****************************************************
          generate radial grids in the k-space
  ****************************************************/

  dk = PAO_Nkmax/(double)Ngrid_NormK;
  for (i=0; i<Ngrid_NormK; i++){
    NormK[i] = (double)i*dk;
  }

  /***********************************************************
        sending and receiving of Spe_RF_Bessel by MPI
  ***********************************************************/

  for (ID=0; ID<Num_Procs2; ID++){
    NumSpe = Species_End[ID] - Species_Top[ID] + 1;
    for (Lspe=0; Lspe<NumSpe; Lspe++){
      spe = Species_Top[ID] + Lspe;
      for (GL=0; GL<=Spe_MaxL_Basis[spe]; GL++){
	for (Mul=0; Mul<Spe_Num_Basis[spe][GL]; Mul++){
	  MPI_Bcast(&Spe_RF_Bessel[spe][GL][Mul][0],
		    List_YOUSO[15],MPI_DOUBLE,ID, mpi_comm_level1);
	}
      }
    }
  }

  /***********************************************************
                         elapsed time
  ***********************************************************/

  dtime(&TEtime);

}
