#include "catch.hpp"
#include "ScopedAssign.hh"

TEST_CASE("ScopedAssign, local")
{
	int l = 1;
	CHECK(l == 1);
	{
		ScopedAssign<int> sa1(l, 2);
		CHECK(l == 2);
		{
			ScopedAssign<int> sa2(l, 3);
			CHECK(l == 3);
		}
		CHECK(l == 2);
	}
	CHECK(l == 1);
}

int g;
static void testAssign()
{
	CHECK(g == 2);
	ScopedAssign<int> sa(g, 3);
	CHECK(g == 3);
}
TEST_CASE("ScopedAssign, global")
{
	g = 1;
	CHECK(g == 1);
	{
		ScopedAssign<int> sa(g, 2);
		CHECK(g == 2);
		testAssign();
		CHECK(g == 2);
	}
	CHECK(g == 1);
}
