// $Id: ResampleBlip.hh 11509 2010-06-12 21:24:26Z m9710797 $

#ifndef RESAMPLEBLIP_HH
#define RESAMPLEBLIP_HH

#include "ResampleAlgo.hh"
#include "BlipBuffer.hh"

namespace openmsx {

class Resample;

template <unsigned CHANNELS>
class ResampleBlip : public ResampleAlgo
{
public:
	ResampleBlip(Resample& input, double ratio);

	virtual bool generateOutput(int* dataOut, unsigned num);

private:
	BlipBuffer blip[CHANNELS];
	Resample& input;
	const double ratio;
	const double invRatio;
	double lastPos;
	typedef FixedPoint<16> FP;
	const FP invRatioFP;
	int lastInput[CHANNELS];
};

} // namespace openmsx

#endif
