# $Id: info2code.mk 8441 2009-01-06 09:54:24Z m9710797 $
#
# Write build info to C++ constants, so source can access it.
# Advantages of this approach:
# - file dates used for dependency checks (as opposed to "-D" compile flag)
# - inactive code is still checked by compiler (as opposed to "#if")

# Sanity checks on required Make variables.
$(call DEFCHECK,OPENMSX_TARGET_CPU)
ifneq ($(OPENMSX_TARGET_CPU),univ)
$(call BOOLCHECK,BIG_ENDIAN)
endif
$(call BOOLCHECK,UNALIGNED_MEMORY_ACCESS)
$(call BOOLCHECK,SET_WINDOW_ICON)

$(CONFIG_HEADER): $(MAKE_PATH)/info2code.mk $(MAKE_PATH)/custom.mk
	@echo "Creating $@..."
	@mkdir -p $(@D)
	@echo "// Automatically generated by build process." > $@
	@echo "" >> $@
	@echo "#ifndef BUILD_INFO_HH" >> $@
	@echo "#define BUILD_INFO_HH" >> $@
	@echo "" >> $@
	@echo "#include <string>" >> $@
	@echo "" >> $@
	@echo "namespace openmsx {" >> $@
	@echo "" >> $@
# Use a macro iso a boolean to prevent compilation errors on non x86 machines
	@if [ "$(OPENMSX_TARGET_CPU)" = "x86" ] ; then \
		echo "#define ASM_X86_32" >> $@ ; \
		echo "#define ASM_X86" >> $@ ; \
	fi
	@if [ "$(OPENMSX_TARGET_CPU)" = "x86_64" ] ; then \
		echo "#define ASM_X86_64" >> $@ ; \
		echo "#define ASM_X86" >> $@ ; \
	fi
# Macro iso integer because we really need to exclude code sections based on this
	@echo "#define PLATFORM_GP2X $(PLATFORM_GP2X)" >> $@
	@echo "#define HAVE_16BPP $(HAVE_16BPP)" >> $@
	@echo "#define HAVE_32BPP $(HAVE_32BPP)" >> $@
	@echo "#define MIN_SCALE_FACTOR $(MIN_SCALE_FACTOR)" >> $@
	@echo "#define MAX_SCALE_FACTOR $(MAX_SCALE_FACTOR)" >> $@
# Don't call it "BIG_ENDIAN", because some system header may #define that.
	@echo "static const bool OPENMSX_BIGENDIAN = $(BIG_ENDIAN);" >> $@
	@echo "static const bool OPENMSX_UNALIGNED_MEMORY_ACCESS = $(UNALIGNED_MEMORY_ACCESS);" >> $@
	@echo "static const bool OPENMSX_SET_WINDOW_ICON = $(SET_WINDOW_ICON);" >> $@
	@echo "static const std::string DATADIR = \"$(INSTALL_SHARE_DIR)\";" >> $@
	@echo "static const std::string BUILD_FLAVOUR = \"$(OPENMSX_FLAVOUR)\";" >> $@
	@echo "static const std::string BUILD_COMPONENTS = \"$(sort $(COMPONENTS_TRUE))\";" >> $@
	@echo "" >> $@
	@echo "} // namespace openmsx" >> $@
	@echo "" >> $@
	@echo "#endif // BUILD_INFO_HH" >> $@

$(VERSION_HEADER): ChangeLog $(MAKE_PATH)/info2code.mk $(MAKE_PATH)/version.mk
	@echo "Creating $@..."
	@mkdir -p $(@D)
	@echo "// Automatically generated by build process." > $@
	@echo "" >> $@
	@echo "const bool Version::RELEASE = $(RELEASE_FLAG);" >> $@
	@echo "const std::string Version::VERSION = \"$(PACKAGE_VERSION)\";" >> $@
	@echo "const std::string Version::CHANGELOG_REVISION = \"$(CHANGELOG_REVISION)\";" >> $@
