// $Id: WD2793BasedFDC.cc 4652 2005-09-03 21:28:16Z m9710797 $

#include "WD2793BasedFDC.hh"
#include "DriveMultiplexer.hh"
#include "WD2793.hh"
#include "MSXMotherBoard.hh"

namespace openmsx {

WD2793BasedFDC::WD2793BasedFDC(MSXMotherBoard& motherBoard,
                               const XMLElement& config, const EmuTime& time)
	: MSXFDC(motherBoard, config, time)
	, multiplexer(new DriveMultiplexer(reinterpret_cast<DiskDrive**>(drives)))
	, controller(new WD2793(motherBoard.getScheduler(), *multiplexer, time))
{
}

WD2793BasedFDC::~WD2793BasedFDC()
{
}

void WD2793BasedFDC::reset(const EmuTime& time)
{
	controller->reset(time);
}

} // namespace openmsx
