// $Id: EmuTimer.cc 4861 2005-11-13 08:49:47Z m9710797 $

#include "EmuTimer.hh"
#include "Clock.hh"

namespace openmsx {

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::EmuTimer(
		Scheduler& scheduler, EmuTimerCallback& cb_)
	: Schedulable(scheduler), count(256), counting(false), cb(cb_)
{
}

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
void EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::setValue(byte value)
{
	count = 256 - value;
}

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
void EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::setStart(
	bool start, const EmuTime& time)
{
	if (start != counting) {
		counting = start;
		if (start) {
			schedule(time);
		} else {
			unschedule();
		}
	}
}

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
void EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::schedule(const EmuTime& time)
{
	Clock<FREQ_NOM, FREQ_DENOM> now(time);
	now += count;
	setSyncPoint(now.getTime());
}

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
void EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::unschedule()
{
	removeSyncPoint();
}

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
void EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::executeUntil(
	const EmuTime& time, int /*userData*/)
{
	cb.callback(FLAG);
	schedule(time);
}

template<byte FLAG, unsigned FREQ_NOM, unsigned FREQ_DENOM>
const std::string& EmuTimer<FLAG, FREQ_NOM, FREQ_DENOM>::schedName() const
{
	static const std::string name("EmuTimer");
	return name;
}


// Force template instantiation
template class EmuTimer<0x40,  3579545, 72 *  4    >; // EmuTimerOPL3_1
template class EmuTimer<0x20,  3579545, 72 *  4 * 4>; // EmuTimerOPL3_2
template class EmuTimer<0x40, 33868800, 72 * 38    >; // EmuTimerOPL4_1
template class EmuTimer<0x20, 33868800, 72 * 38 * 4>; // EmuTimerOPL4_2

} // namespace openmsx
