// -*- mode: C++; tab-width: 2; -*-
// vi: set ts=2:
//
// --------------------------------------------------------------------------
//                   OpenMS Mass Spectrometry Framework
// --------------------------------------------------------------------------
//  Copyright (C) 2003-2011 -- Oliver Kohlbacher, Knut Reinert
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// --------------------------------------------------------------------------
// $Maintainer: Andreas Bertsch $
// $Authors: Marc Sturm $
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>

///////////////////////////
#include <OpenMS/METADATA/ScanWindow.h>
///////////////////////////

using namespace OpenMS;
using namespace std;

START_TEST(ScanWindow, "$Id: ScanWindow_test.C 8210 2011-03-28 13:19:52Z aiche $")

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

ScanWindow* ptr = 0;
ScanWindow* nullPointer = 0;
START_SECTION((ScanWindow()))
	ptr = new ScanWindow();
	TEST_NOT_EQUAL(ptr, nullPointer)
END_SECTION

START_SECTION((~ScanWindow()))
	delete ptr;
END_SECTION

START_SECTION((ScanWindow(const ScanWindow& source)))
  ScanWindow tmp;
  tmp.begin = 1.0;
  tmp.end = 2.0;
  tmp.setMetaValue("label",String("label"));
  
  ScanWindow tmp2(tmp);
  TEST_REAL_SIMILAR(tmp2.begin, 1.0)
  TEST_REAL_SIMILAR(tmp2.end, 2.0)
	TEST_EQUAL((String)(tmp2.getMetaValue("label")), "label");  
END_SECTION

START_SECTION((ScanWindow& operator= (const ScanWindow& source)))
  ScanWindow tmp;
  tmp.begin = 1.0;
  tmp.end = 2.0;
  tmp.setMetaValue("label",String("label"));
  
  ScanWindow tmp2;
  tmp2 = tmp;
  TEST_REAL_SIMILAR(tmp2.begin, 1.0)
  TEST_REAL_SIMILAR(tmp2.end, 2.0)
	TEST_EQUAL((String)(tmp2.getMetaValue("label")), "label");  
END_SECTION

START_SECTION((bool operator==(const ScanWindow &source) const ))
  ScanWindow edit, empty;
  
  TEST_EQUAL(edit==empty,true);
  
  edit.begin = 1.0;
  TEST_EQUAL(edit==empty,false);
  
  edit = empty; 
  edit.end = 1.0;
  TEST_EQUAL(edit==empty,false);
  
	edit = empty;
	edit.setMetaValue("label",String("label"));
	TEST_EQUAL(edit==empty,false);
END_SECTION

START_SECTION((bool operator!=(const ScanWindow &source) const ))
  ScanWindow edit, empty;
  
  TEST_EQUAL(edit!=empty,false);
  
  edit.begin = 1.0;
  TEST_EQUAL(edit!=empty,true);
  
  edit = empty; 
  edit.end = 1.0;
  TEST_EQUAL(edit!=empty,true);
  
	edit = empty;
	edit.setMetaValue("label",String("label"));
	TEST_EQUAL(edit!=empty,true);
END_SECTION



/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST



