// -*- Mode: C++; tab-width: 2; -*-
// vi: set ts=2:
//
// --------------------------------------------------------------------------
//                   OpenMS Mass Spectrometry Framework 
// --------------------------------------------------------------------------
//  Copyright (C) 2003-2011 -- Oliver Kohlbacher, Knut Reinert
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// --------------------------------------------------------------------------
// $Maintainer: Johannes Junker $
// $Authors: Johannes Junker $
// --------------------------------------------------------------------------

#ifndef OPENMS_VISUAL_ANNOTATION_ANNOTATION1DPEAKITEM_H
#define OPENMS_VISUAL_ANNOTATION_ANNOTATION1DPEAKITEM_H

#include <OpenMS/VISUAL/ANNOTATION/Annotation1DItem.h>

#include <QtGui/QColor>

namespace OpenMS
{
  /** @brief A peak annotation item
			@see Annotation1DItem
	*/
	class Annotation1DPeakItem
		: public Annotation1DItem
	{	
		public:			
			/// Constructor
      Annotation1DPeakItem(const PointType& peak_position, const QString& text, const QColor& color);

			/// Copy constructor
			Annotation1DPeakItem(const Annotation1DPeakItem& rhs);

			/// Destructor
			virtual ~Annotation1DPeakItem();

      /// Docu in base class
      virtual void ensureWithinDataRange(Spectrum1DCanvas* const canvas);

      /// Docu in base class
			virtual void draw(Spectrum1DCanvas* const canvas, QPainter& painter, bool flipped = false);

      /// Docu in base class
			virtual void move(const PointType& /*delta*/);

      /// Sets the position of the label (in MZ / intensity coordinates)
			void setPosition(const PointType& position);

      /// Sets the anker position of the label (peak) (in MZ / intensity coordinates)
      const PointType& getPeakPosition() const;

			/// Returns the position of the peak (in MZ / intensity coordinates)
      const PointType& getPosition() const;

      /// Set the color of the label
      void setColor(const QColor& color);

      /// Returns the color of the label
      const QColor& getColor() const;
		protected:
      /// The position of the anker (peak) (in MZ / intensity coordinates)
      PointType peak_position_;      

      /// The position of the label (in MZ / intensity coordinates)
			PointType position_;			

      /// The color of the label
      QColor color_;
	};
} // namespace OpenMS

#endif
