// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "nle.h"

void NleUI::cb_mainWindow_i(Fl_Double_Window*, void*) {
  if (Fl::event()==FL_SHORTCUT && Fl::event_key()==FL_Escape) 
    return; // ignore Escape
mainWindow->hide();
if ( Fl::event()==FL_CLOSE ) {
	m_videoView->stop();
	nle::g_loadSaveManager->shutdown();
};
}
void NleUI::cb_mainWindow(Fl_Double_Window* o, void* v) {
  ((NleUI*)(o->user_data()))->cb_mainWindow_i(o,v);
}

void NleUI::cb_New_i(Fl_Menu_*, void*) {
  nle::g_loadSaveManager->newProject();
}
void NleUI::cb_New(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_New_i(o,v);
}

void NleUI::cb_Save_i(Fl_Menu_*, void*) {
  nle::g_loadSaveManager->saveAs();
}
void NleUI::cb_Save(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Save_i(o,v);
}

void NleUI::cb_Render_i(Fl_Menu_*, void*) {
  Fl_Group::current( mainWindow );
nle::CodecParameters cp( nle::g_audio_codec_info, nle::g_video_codec_info );
EncodeDialog dlg( 0, 0, &cp );
dlg.show();
while (dlg.shown())
  Fl::wait();

if ( dlg.go && strcmp( "", dlg.export_filename->value() ) != 0 ) {
	ProgressDialog pDlg( "Rendering Project" );
	render_frame_size* fs = (render_frame_size*)dlg.frameSize();
	nle::Renderer ren( dlg.export_filename->value(), fs, 25, 48000, &cp );

	/* stop playback before starting to render... */
	g_playButton->label( "@>" );
	m_videoView->stop();
	lastButton->activate();
	firstButton->activate();
	forwardButton->activate();
	backButton->activate();

	if ( ren.ok() ) {
		nle::g_preferences->lastVideoCodec( dlg.video_codec_menu->value() );
		nle::g_preferences->lastAudioCodec( dlg.audio_codec_menu->value() );
		nle::g_preferences->lastFramesize( dlg.frame_size_choice->value() );
		nle::g_preferences->lastRenderFilename( dlg.export_filename->value() );
	
		ren.go( &pDlg );
	}
	

//	pDlg.progressDialog->show();
//	while ( pDlg.progressDialog->shown() )
//		Fl::wait();
//	pDlg.progressDialog->hide();
};
}
void NleUI::cb_Render(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Render_i(o,v);
}

void NleUI::cb_Quit_i(Fl_Menu_* o, void*) {
  m_videoView->stop();
o->window()->hide();
nle::g_loadSaveManager->shutdown();
}
void NleUI::cb_Quit(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Quit_i(o,v);
}

void NleUI::cb_undo_item_i(Fl_Menu_*, void*) {
  m_timelineView->clear_selection();
nle::g_docManager->undo();
m_timelineView->redraw();
}
void NleUI::cb_undo_item(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_undo_item_i(o,v);
}

void NleUI::cb_redo_item_i(Fl_Menu_*, void*) {
  m_timelineView->clear_selection();
nle::g_docManager->redo();
m_timelineView->redraw();
}
void NleUI::cb_redo_item(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_redo_item_i(o,v);
}

void NleUI::cb_cut_item_i(Fl_Menu_*, void*) {
  m_timelineView->cut();
}
void NleUI::cb_cut_item(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_cut_item_i(o,v);
}

void NleUI::cb_copy_item_i(Fl_Menu_*, void*) {
  m_timelineView->copy();
}
void NleUI::cb_copy_item(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_copy_item_i(o,v);
}

void NleUI::cb_paste_item_i(Fl_Menu_*, void*) {
  m_timelineView->paste();
}
void NleUI::cb_paste_item(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_paste_item_i(o,v);
}

void NleUI::cb_delete_item_i(Fl_Menu_*, void*) {
  m_timelineView->remove();
}
void NleUI::cb_delete_item(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_delete_item_i(o,v);
}

void NleUI::cb_Add_i(Fl_Menu_*, void*) {
  m_timelineView->add_track( nle::TRACK_TYPE_VIDEO );
}
void NleUI::cb_Add(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Add_i(o,v);
}

void NleUI::cb_Add1_i(Fl_Menu_*, void*) {
  m_timelineView->add_track( nle::TRACK_TYPE_AUDIO );
}
void NleUI::cb_Add1(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Add1_i(o,v);
}

void NleUI::cb_4_i(Fl_Menu_* o, void*) {
  g_16_9 = !(o->mvalue())->value();
m_videoView->redraw();
}
void NleUI::cb_4(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_4_i(o,v);
}

void NleUI::cb_16_i(Fl_Menu_* o, void*) {
  g_16_9 = (o->mvalue())->value();
m_videoView->redraw();
}
void NleUI::cb_16(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_16_i(o,v);
}

void NleUI::cb_Black_i(Fl_Menu_* o, void*) {
  g_black_borders = (o->mvalue())->value();
m_videoView->redraw();
}
void NleUI::cb_Black(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Black_i(o,v);
}

void NleUI::cb_Transport_i(Fl_Menu_* o, void*) {
  // FIXME: allow change only if not currently playing ?!
// -> assign this value in SimplePlaybackCore "on play"
g_use_jack_transport = (o->mvalue())->value();
}
void NleUI::cb_Transport(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Transport_i(o,v);
}

void NleUI::cb_Scrub_i(Fl_Menu_* o, void*) {
  g_scrub_audio = (o->mvalue())->value();
}
void NleUI::cb_Scrub(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Scrub_i(o,v);
}

void NleUI::cb_Fullscreen_i(Fl_Menu_*, void*) {
  static bool fullscreen_on = false;
static int x;
static int y;
static int w;
static int h;
if ( fullscreen_on ) {
	mainWindow->fullscreen_off( x, y, w, h );
	fullscreen_on = false;
} else {
	x = mainWindow->x();
	y = mainWindow->y();
	w = mainWindow->w();
	h = mainWindow->h();
	mainWindow->fullscreen();
	fullscreen_on = true;
};
}
void NleUI::cb_Fullscreen(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Fullscreen_i(o,v);
}

void NleUI::cb_Normal_i(Fl_Menu_*, void*) {
  Fl_Tooltip::color( fl_rgb_color( 0, 0, 1 ) );
Fl::background2( 34, 52, 103 );
Fl::background( 93, 93, 114 );
Fl::foreground( 255, 255, 255 );
Fl::set_color( FL_BLACK, 200, 200, 200 );
Fl::scheme("none");
}
void NleUI::cb_Normal(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Normal_i(o,v);
}

void NleUI::cb_Plastic_i(Fl_Menu_*, void*) {
  Fl_Tooltip::color( fl_rgb_color( 255, 255, 191 ) );
Fl::background2( 255, 255, 255 );
Fl::background( 234, 234, 234 );
Fl::foreground( 0, 0, 0 );
Fl::set_color( FL_BLACK, 0, 0, 0 );
Fl::scheme("plastic");
}
void NleUI::cb_Plastic(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Plastic_i(o,v);
}

void NleUI::cb_Tutorial_i(Fl_Menu_*, void*) {
  m_timelineView->help();
}
void NleUI::cb_Tutorial(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_Tutorial_i(o,v);
}

void NleUI::cb_About_i(Fl_Menu_*, void*) {
  AboutDialog dlg;
dlg.show();
while (dlg.shown())
  Fl::wait();
}
void NleUI::cb_About(Fl_Menu_* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_About_i(o,v);
}

Fl_Menu_Item NleUI::menu_Black[] = {
 {"&Project", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"New Project", 0,  (Fl_Callback*)NleUI::cb_New, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save as...", 0x50073,  (Fl_Callback*)NleUI::cb_Save, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Render...", 0,  (Fl_Callback*)NleUI::cb_Render, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Quit", 0x40071,  (Fl_Callback*)NleUI::cb_Quit, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Edit", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Undo", 0x4007a,  (Fl_Callback*)NleUI::cb_undo_item, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"Redo", 0x40079,  (Fl_Callback*)NleUI::cb_redo_item, 0, 129, FL_NORMAL_LABEL, 0, 14, 0},
 {"Cut", 0x40078,  (Fl_Callback*)NleUI::cb_cut_item, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"Copy", 0x40063,  (Fl_Callback*)NleUI::cb_copy_item, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"Paste", 0x40076,  (Fl_Callback*)NleUI::cb_paste_item, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"Delete", 0xffff,  (Fl_Callback*)NleUI::cb_delete_item, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Tracks", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Add Video Track", 0,  (Fl_Callback*)NleUI::cb_Add, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Add Audio Track", 0,  (Fl_Callback*)NleUI::cb_Add1, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"P&references", 0,  0, 0, 80, FL_NORMAL_LABEL, 0, 14, 0},
 {"No SW Scaling", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"2x2 Scaling good", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"2x2 Scaling bad", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"Format", 0,  0, 0, 80, FL_NORMAL_LABEL, 0, 14, 0},
 {"4:3", 0,  (Fl_Callback*)NleUI::cb_4, 0, 12, FL_NORMAL_LABEL, 0, 14, 0},
 {"16:9", 0,  (Fl_Callback*)NleUI::cb_16, 0, 136, FL_NORMAL_LABEL, 0, 14, 0},
 {"Black Borders", 0,  (Fl_Callback*)NleUI::cb_Black, 0, 2, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&JACK", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Transport connect", 0,  (Fl_Callback*)NleUI::cb_Transport, 0, 6, FL_NORMAL_LABEL, 0, 14, 0},
 {"Scrub audio", 0,  (Fl_Callback*)NleUI::cb_Scrub, 0, 6, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&View", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Fullscreen", 0xffc8,  (Fl_Callback*)NleUI::cb_Fullscreen, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Track Overview", 0,  0, 0, 18, FL_NORMAL_LABEL, 0, 14, 0},
 {"Normal Style", 0,  (Fl_Callback*)NleUI::cb_Normal, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Plastic Style", 0,  (Fl_Callback*)NleUI::cb_Plastic, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Help", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Tutorial...", 0,  (Fl_Callback*)NleUI::cb_Tutorial, 0, 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"About...", 0,  (Fl_Callback*)NleUI::cb_About, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* NleUI::undo_item = NleUI::menu_Black + 7;
Fl_Menu_Item* NleUI::redo_item = NleUI::menu_Black + 8;
Fl_Menu_Item* NleUI::cut_item = NleUI::menu_Black + 9;
Fl_Menu_Item* NleUI::copy_item = NleUI::menu_Black + 10;
Fl_Menu_Item* NleUI::paste_item = NleUI::menu_Black + 11;
Fl_Menu_Item* NleUI::delete_item = NleUI::menu_Black + 12;
Fl_Menu_Item* NleUI::jackMenu = NleUI::menu_Black + 28;

void NleUI::cb__i(nle::FileBrowser* o, void*) {
  nle::FileBrowser* fb = (nle::FileBrowser*)o;
fb->load_rel();
}
void NleUI::cb_(nle::FileBrowser* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb__i(o,v);
}

void NleUI::cb_effect_browser_i(Fl_Hold_Browser*, void*) {
  setEffectButtons();
}
void NleUI::cb_effect_browser(Fl_Hold_Browser* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_effect_browser_i(o,v);
}

void NleUI::cb_m_effect_up_i(Fl_Button*, void*) {
  m_timelineView->moveEffectUp();
}
void NleUI::cb_m_effect_up(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_m_effect_up_i(o,v);
}

void NleUI::cb_m_effect_down_i(Fl_Button*, void*) {
  m_timelineView->moveEffectDown();
}
void NleUI::cb_m_effect_down(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_m_effect_down_i(o,v);
}

void NleUI::cb_m_remove_effect_i(Fl_Button*, void*) {
  m_timelineView->removeEffect();
}
void NleUI::cb_m_remove_effect(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_m_remove_effect_i(o,v);
}

void NleUI::cb_m_edit_effect_i(Fl_Button*, void*) {
  m_timelineView->editEffect();
}
void NleUI::cb_m_edit_effect(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_m_edit_effect_i(o,v);
}

void NleUI::cb_titles_text_i(Fl_Input* o, void*) {
  m_timelineView->titles_text( o->value() );
}
void NleUI::cb_titles_text(Fl_Input* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_titles_text_i(o,v);
}

void NleUI::cb_titles_fonts_i(Fl_Choice* o, void*) {
  m_timelineView->titles_font( o->value() );
m_timelineView->titles_text( titles_text->value() );
}
void NleUI::cb_titles_fonts(Fl_Choice* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_titles_fonts_i(o,v);
}

Fl_Menu_Item NleUI::menu_titles_fonts[] = {
 {"Helvetica", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Helvetica bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Helvetica italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Helvetica bold italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Courier", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Courier bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Courier italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Courier bold italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Times", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Times bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Times italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Times bold ital", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void NleUI::cb_titles_size_i(Fl_Value_Input* o, void*) {
  m_timelineView->titles_size( llrint(o->value()) );
m_timelineView->titles_text( titles_text->value() );
}
void NleUI::cb_titles_size(Fl_Value_Input* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_titles_size_i(o,v);
}

void NleUI::cb_titles_color_i(Fl_Button* o, void*) {
  o->color(fl_show_colormap(o->color()));
m_timelineView->titles_color( o->color() );
m_timelineView->titles_text( titles_text->value() );
o->redraw();
}
void NleUI::cb_titles_color(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_titles_color_i(o,v);
}

void NleUI::cb_titles_x_i(Fl_Slider* o, void*) {
  m_timelineView->titles_x( o->value() );
m_timelineView->titles_text( titles_text->value() );
}
void NleUI::cb_titles_x(Fl_Slider* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_titles_x_i(o,v);
}

void NleUI::cb_titles_y_i(Fl_Slider* o, void*) {
  m_timelineView->titles_y( o->value() );
m_timelineView->titles_text( titles_text->value() );
}
void NleUI::cb_titles_y(Fl_Slider* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_titles_y_i(o,v);
}

void NleUI::cb_playButton_i(Fl_Button* o, void*) {
  if ( strcmp( o->label(), "@>" ) == 0 ) {
	o->label( "@square" );
	lastButton->deactivate();
	firstButton->deactivate();
	forwardButton->deactivate();
	backButton->deactivate();
	m_videoView->play();
} else {
	o->label( "@>" );
	m_videoView->stop();
	lastButton->activate();
	firstButton->activate();
	forwardButton->activate();
	backButton->activate();
};
}
void NleUI::cb_playButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_playButton_i(o,v);
}

void NleUI::cb_lastButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipLast();
}
void NleUI::cb_lastButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_lastButton_i(o,v);
}

void NleUI::cb_firstButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipFirst();
}
void NleUI::cb_firstButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_firstButton_i(o,v);
}

void NleUI::cb_backButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipBackward();
}
void NleUI::cb_backButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_backButton_i(o,v);
}

void NleUI::cb_forwardButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipForward();
}
void NleUI::cb_forwardButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_forwardButton_i(o,v);
}

void NleUI::cb_projectNameInput_i(Fl_Button*, void*) {
  const char* name = fl_input( "Please enter the project name.", projectNameInput->label() );
if ( name ) {
	projectNameInput->label( name );
	nle::g_loadSaveManager->name( name );
};
}
void NleUI::cb_projectNameInput(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_projectNameInput_i(o,v);
}

void NleUI::cb_pauseButton_i(Fl_Button*, void*) {
  m_videoView->pause();
}
void NleUI::cb_pauseButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pauseButton_i(o,v);
}

void NleUI::cb_pa_playButton_i(Fl_Button* o, void*) {
  if ( strcmp( o->label(), "@>" ) == 0 ) {
	o->label( "@square" );
	pa_lastButton->deactivate();
	pa_firstButton->deactivate();
	pa_forwardButton->deactivate();
	pa_backButton->deactivate();
	m_videoView->play();
} else {
	o->label( "@>" );
	m_videoView->stop();
	pa_lastButton->activate();
	pa_firstButton->activate();
	pa_forwardButton->activate();
	pa_backButton->activate();
};
}
void NleUI::cb_pa_playButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pa_playButton_i(o,v);
}

void NleUI::cb_pa_lastButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipLast();
}
void NleUI::cb_pa_lastButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pa_lastButton_i(o,v);
}

void NleUI::cb_pa_firstButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipFirst();
}
void NleUI::cb_pa_firstButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pa_firstButton_i(o,v);
}

void NleUI::cb_pa_backButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipBackward();
}
void NleUI::cb_pa_backButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pa_backButton_i(o,v);
}

void NleUI::cb_pa_forwardButton_i(Fl_Button*, void*) {
  nle::g_ruler->skipForward();
}
void NleUI::cb_pa_forwardButton(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pa_forwardButton_i(o,v);
}

void NleUI::cb_scaleBar_i(Flmm_Scalebar* o, void*) {
  Flmm_Scalebar *sb = (Flmm_Scalebar *)o;
float width = sb->w();
float slider_size = sb->slider_size_i();
float zoom = width / slider_size;
m_timelineView->scroll( (int64_t)sb->value() );
m_timelineView->zoom( zoom );
}
void NleUI::cb_scaleBar(Flmm_Scalebar* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_scaleBar_i(o,v);
}

void NleUI::cb_1_i(Fl_Button* o, void*) {
  g_snap = o->value();
}
void NleUI::cb_1(Fl_Button* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_1_i(o,v);
}

#include <FL/Fl_Pixmap.H>
static const char *idata_snap[] = {
"16 16 4 1",
" \tc None",
".\tc #000000",
"+\tc #E2E2E2",
"@\tc #888888",
"                ",
"                ",
"                ",
"    ........    ",
"   .+++++@@. ...",
"  .++++++@@.    ",
" .+++....... ...",
" .++.           ",
" .++.           ",
" .++.           ",
" .+++....... ...",
"  .++++++@@.    ",
"   .+++++@@. ...",
"    ........    ",
"                ",
"                "
};
static Fl_Pixmap image_snap(idata_snap);

void NleUI::cb_vScrollBar_i(Fl_Scrollbar* o, void*) {
  scroll_area->position( 0, o->value() );
}
void NleUI::cb_vScrollBar(Fl_Scrollbar* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_vScrollBar_i(o,v);
}

void NleUI::cb_scroll_area_i(nle::TimelineScroll*, void*) {
  cout << "scrollarea" << endl;
}
void NleUI::cb_scroll_area(nle::TimelineScroll* o, void* v) {
  ((NleUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_scroll_area_i(o,v);
}

static const char *idata_tool_positioning[] = {
"32 32 2 1",
" \tc None",
".\tc #000000",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"       .                .       ",
"      ..                ..      ",
"     ...                ...     ",
"    ....                ....    ",
"   ..........................   ",
"    ....                ....    ",
"     ...                ...     ",
"      ..                ..      ",
"       .                .       ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                                "
};
static Fl_Pixmap image_tool_positioning(idata_tool_positioning);

static const char *idata_tool_automations[] = {
"32 32 2 1",
" \tc None",
".\tc #000000",
"                                ",
"                                ",
"                                ",
"                                ",
"                .               ",
"               ...              ",
"              .....             ",
"             .......            ",
"            .........           ",
"                .               ",
"                .               ",
"                .               ",
"                .               ",
"                                ",
"                  .             ",
"              .....             ",
"              .....             ",
"              .....             ",
"              .....             ",
"             ......             ",
"                                ",
"                .               ",
"                .               ",
"                .               ",
"                .               ",
"            .........           ",
"             .......            ",
"              .....             ",
"               ...              ",
"                .               ",
"                                ",
"                                "
};
static Fl_Pixmap image_tool_automations(idata_tool_automations);

static const char *idata_trash_big[] = {
"27 33 4 1",
" \tc None",
".\tc #000000",
"+\tc #B3B3B3",
"@\tc #404040",
"        ...........        ",
"    .....+++++++++.....    ",
"  ...+++++++++++++++++...  ",
" ..+++++++.......+++++++.. ",
"..+++++++.+++++++.+++++++..",
".+++++++..+++++++..+++++++.",
".+++++++++++++++++++++++++.",
"..+++++++++++++++++++++++..",
"...+++++++++++++++++++++...",
".+...+++++++++++++++++...+.",
"..++.....+++++++++.....++..",
"...+++++...........+++++...",
".+...+++++++++++++++++...+.",
".+++.....+++++++++.....+++.",
".++++@@+...........++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
".++++@@++++++@@++++++@@+++.",
"..+++@@++++++@@++++++@@++..",
" ..++@@++++++@@++++++@@+.. ",
"  ...@@++++++@@++++++@...  ",
"    .....++++@@+++.....    ",
"        ...........        "
};
static Fl_Pixmap image_trash_big(idata_trash_big);

static const char *idata_razor[] = {
"32 32 4 1",
" \tc None",
".\tc #000000",
"+\tc #CCCCCC",
"@\tc #666666",
"                                ",
"                                ",
"                                ",
"            ..                  ",
"        .. .+@.                 ",
"       .++.+++@.                ",
"      .++++++++@.               ",
"     .++++++++++@.              ",
"    .+++++..+++++@.             ",
"    .++++. .++++++@.            ",
"     .++.  .+++++++@.           ",
"    .+++... ..++++++@.          ",
"   .+++++++. .+++++++@.         ",
"   .@++++++.. ...+++++@.        ",
"    .@+++++++.   .+++++@.       ",
"     .@++++++.   .++++++@.      ",
"      .@+++++.   .+++++++@.     ",
"       .@+++++... ..++++++@.    ",
"        .@+++++++. .+++++++.    ",
"         .@++++++.. ...+++.     ",
"          .@+++++++.  .++.      ",
"           .@++++++. .++++.     ",
"            .@+++++..+++++.     ",
"             .@++++++++++.      ",
"              .@++++++++.       ",
"               .@+++.++.        ",
"                .@+. ..         ",
"                 ..             ",
"                                ",
"                                ",
"                                ",
"                                "
};
static Fl_Pixmap image_razor(idata_razor);

void NleUI::cb_projectChoice_i(Fl_Choice* o, void*) {
  char* name = (char*)o->mvalue()->user_data();
nle::g_loadSaveManager->load( name );
}
void NleUI::cb_projectChoice(Fl_Choice* o, void* v) {
  ((NleUI*)(o->parent()->user_data()))->cb_projectChoice_i(o,v);
}

NleUI::NleUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = mainWindow = new Fl_Double_Window(700, 600, "Open Movie Editor");
    w = o;
    o->callback((Fl_Callback*)cb_mainWindow, (void*)(this));
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(0, 0, 530, 25, "Black Borders");
      o->menu(menu_Black);
    }
    { Fl_Tile* o = new Fl_Tile(0, 25, 700, 575);
      { Fl_Tile* o = new Fl_Tile(0, 25, 700, 320);
        { Fl_Group* o = new Fl_Group(365, 25, 335, 320);
          { nle::VideoViewGL* o = m_videoView = new nle::VideoViewGL(365, 25, 335, 320, "VideoView");
            o->box(FL_DOWN_BOX);
            o->color(FL_BACKGROUND_COLOR);
            o->selection_color(FL_BACKGROUND_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(14);
            o->labelcolor(FL_GRAY0);
            o->align(FL_ALIGN_CENTER);
            o->when(FL_WHEN_RELEASE);
            Fl_Group::current()->resizable(o);
          }
          o->end();
        }
        { Fl_Group* o = new Fl_Group(0, 25, 365, 320);
          { Fl_Tabs* o = new Fl_Tabs(0, 50, 365, 255);
            o->box(FL_UP_BOX);
            o->labelcolor(FL_GRAY0);
            { Fl_Group* o = new Fl_Group(0, 75, 365, 230, "Files");
              o->hide();
              { nle::FileBrowser* o = new nle::FileBrowser(5, 80, 355, 220);
                o->box(FL_NO_BOX);
                o->color(FL_BACKGROUND2_COLOR);
                o->selection_color(FL_SELECTION_COLOR);
                o->labeltype(FL_NORMAL_LABEL);
                o->labelfont(0);
                o->labelsize(14);
                o->labelcolor(FL_FOREGROUND_COLOR);
                o->callback((Fl_Callback*)cb_);
                o->align(FL_ALIGN_BOTTOM);
                o->when(FL_WHEN_RELEASE_ALWAYS);
                Fl_Group::current()->resizable(o);
              }
              o->end();
              Fl_Group::current()->resizable(o);
            }
            { Fl_Group* o = new Fl_Group(0, 75, 365, 230, "Media Browser");
              { nle::MediaPanel* o = new nle::MediaPanel(5, 80, 355, 220);
                o->box(FL_NO_BOX);
                o->color(FL_BACKGROUND_COLOR);
                o->selection_color(FL_BACKGROUND_COLOR);
                o->labeltype(FL_NORMAL_LABEL);
                o->labelfont(0);
                o->labelsize(14);
                o->labelcolor(FL_FOREGROUND_COLOR);
                o->align(FL_ALIGN_TOP);
                o->when(FL_WHEN_RELEASE);
                o->end();
                Fl_Group::current()->resizable(o);
              }
              o->end();
            }
            { Fl_Group* o = new Fl_Group(0, 75, 365, 230, "Effects");
              o->hide();
              { nle::FltkEffectMenu* o = m_effectMenu = new nle::FltkEffectMenu(5, 80, 355, 25, "Add Effect");
                o->box(FL_UP_BOX);
                o->color(FL_BACKGROUND_COLOR);
                o->selection_color(FL_SELECTION_COLOR);
                o->labeltype(FL_NORMAL_LABEL);
                o->labelfont(0);
                o->labelsize(14);
                o->labelcolor(FL_FOREGROUND_COLOR);
                o->align(FL_ALIGN_CENTER);
                o->when(FL_WHEN_RELEASE_ALWAYS);
                o->deactivate();
              }
              { Fl_Hold_Browser* o = effect_browser = new Fl_Hold_Browser(5, 105, 355, 170);
                o->box(FL_NO_BOX);
                o->color(FL_BACKGROUND2_COLOR);
                o->selection_color(FL_SELECTION_COLOR);
                o->labeltype(FL_NORMAL_LABEL);
                o->labelfont(0);
                o->labelsize(14);
                o->labelcolor(FL_FOREGROUND_COLOR);
                o->callback((Fl_Callback*)cb_effect_browser);
                o->align(FL_ALIGN_BOTTOM);
                o->when(FL_WHEN_RELEASE_ALWAYS);
                Fl_Group::current()->resizable(o);
              }
              { Fl_Group* o = new Fl_Group(5, 275, 355, 25);
                { Fl_Group* o = new Fl_Group(5, 275, 50, 25);
                { Fl_Button* o = m_effect_up = new Fl_Button(5, 275, 25, 25, "@8->");
                o->tooltip("Move Up");
                o->callback((Fl_Callback*)cb_m_effect_up);
                o->deactivate();
                }
                { Fl_Button* o = m_effect_down = new Fl_Button(30, 275, 25, 25, "@2->");
                o->tooltip("Move Down");
                o->callback((Fl_Callback*)cb_m_effect_down);
                o->deactivate();
                }
                o->end();
                }
                { Fl_Group* o = new Fl_Group(55, 275, 305, 25);
                { Fl_Button* o = m_remove_effect = new Fl_Button(55, 275, 155, 25, "Remove Effect");
                o->callback((Fl_Callback*)cb_m_remove_effect);
                o->deactivate();
                }
                { Fl_Button* o = m_edit_effect = new Fl_Button(210, 275, 150, 25, "Edit Effect");
                o->callback((Fl_Callback*)cb_m_edit_effect);
                o->deactivate();
                }
                o->end();
                Fl_Group::current()->resizable(o);
                }
                o->end();
              }
              o->end();
            }
            { Fl_Group* o = new Fl_Group(0, 75, 365, 230, "Special Clips");
              o->hide();
              { nle::SpecialClipsBrowser* o = special_clips = new nle::SpecialClipsBrowser(5, 80, 355, 220);
                o->box(FL_NO_BOX);
                o->color(FL_BACKGROUND2_COLOR);
                o->selection_color(FL_SELECTION_COLOR);
                o->labeltype(FL_NORMAL_LABEL);
                o->labelfont(0);
                o->labelsize(14);
                o->labelcolor(FL_FOREGROUND_COLOR);
                o->align(FL_ALIGN_BOTTOM);
                o->when(FL_WHEN_RELEASE_ALWAYS);
                Fl_Group::current()->resizable(o);
              }
              o->end();
            }
            { Fl_Group* o = titles_tab = new Fl_Group(0, 75, 365, 230, "Titles");
              o->hide();
              o->deactivate();
              { Fl_Input* o = titles_text = new Fl_Input(205, 80, 155, 220);
                o->type(4);
                o->callback((Fl_Callback*)cb_titles_text);
                Fl_Group::current()->resizable(o);
              }
              { Fl_Group* o = new Fl_Group(5, 80, 195, 220);
                o->box(FL_ENGRAVED_FRAME);
                { Fl_Value_Input* o = new Fl_Value_Input(95, 160, 100, 20, "Line Spacing");
                o->labelsize(12);
                o->maximum(5);
                o->step(0.5);
                o->hide();
                }
                { Fl_Choice* o = titles_fonts = new Fl_Choice(95, 85, 100, 20, "Font");
                o->down_box(FL_BORDER_BOX);
                o->labelsize(12);
                o->callback((Fl_Callback*)cb_titles_fonts);
                o->menu(menu_titles_fonts);
                }
                { Fl_Value_Input* o = titles_size = new Fl_Value_Input(95, 110, 100, 20, "Font Size");
                o->labelsize(12);
                o->minimum(10);
                o->maximum(200);
                o->step(2);
                o->value(20);
                o->callback((Fl_Callback*)cb_titles_size);
                }
                { Fl_Button* o = titles_color = new Fl_Button(95, 135, 100, 20, "Color");
                o->color(FL_BACKGROUND2_COLOR);
                o->labelsize(12);
                o->callback((Fl_Callback*)cb_titles_color);
                o->align(FL_ALIGN_LEFT);
                }
                { Fl_Slider* o = titles_x = new Fl_Slider(95, 185, 100, 20, "@<->");
                o->tooltip("Horizontal Text Alignment");
                o->type(5);
                o->value(0.5);
                o->callback((Fl_Callback*)cb_titles_x);
                o->align(FL_ALIGN_LEFT);
                }
                { Fl_Slider* o = titles_y = new Fl_Slider(95, 210, 100, 20, "@8<->");
                o->tooltip("Vertical Text Alignment");
                o->type(5);
                o->value(0.5);
                o->callback((Fl_Callback*)cb_titles_y);
                o->align(FL_ALIGN_LEFT);
                }
                { Fl_Box* o = new Fl_Box(100, 250, 25, 25);
                Fl_Group::current()->resizable(o);
                }
                o->end();
              }
              o->end();
            }
            o->end();
            Fl_Group::current()->resizable(o);
          }
          { Fl_Button* o = playButton = new Fl_Button(110, 305, 90, 40, "@>");
            o->tooltip("Play (F7)");
            o->shortcut(0xffc4);
            o->callback((Fl_Callback*)cb_playButton);
          }
          { Fl_Button* o = lastButton = new Fl_Button(310, 305, 55, 40, "@>|");
            o->tooltip("Goto End");
            o->callback((Fl_Callback*)cb_lastButton);
          }
          { Fl_Button* o = firstButton = new Fl_Button(0, 305, 55, 40, "@|<");
            o->tooltip("Goto Start");
            o->callback((Fl_Callback*)cb_firstButton);
          }
          { Fl_Button* o = backButton = new Fl_Button(55, 305, 55, 40, "@<|");
            o->tooltip("Skip Frame backwards");
            o->callback((Fl_Callback*)cb_backButton);
          }
          { Fl_Button* o = forwardButton = new Fl_Button(255, 305, 55, 40, "@|>");
            o->tooltip("Skip Frame forward");
            o->callback((Fl_Callback*)cb_forwardButton);
          }
          { Fl_Button* o = projectNameInput = new Fl_Button(0, 25, 365, 25, "Project Name");
            o->labelfont(1);
            o->callback((Fl_Callback*)cb_projectNameInput);
            o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
          }
          { Fl_Button* o = pauseButton = new Fl_Button(200, 305, 55, 40, "@||");
            o->callback((Fl_Callback*)cb_pauseButton);
          }
          { Fl_Button* o = pa_playButton = new Fl_Button(130, 305, 105, 40, "@>");
            o->tooltip("Play (F7)");
            o->shortcut(0xffc4);
            o->callback((Fl_Callback*)cb_pa_playButton);
            o->hide();
          }
          { Fl_Button* o = pa_lastButton = new Fl_Button(300, 305, 65, 40, "@>|");
            o->tooltip("Goto End");
            o->callback((Fl_Callback*)cb_pa_lastButton);
            o->hide();
          }
          { Fl_Button* o = pa_firstButton = new Fl_Button(0, 305, 65, 40, "@|<");
            o->tooltip("Goto Start");
            o->callback((Fl_Callback*)cb_pa_firstButton);
            o->hide();
          }
          { Fl_Button* o = pa_backButton = new Fl_Button(65, 305, 65, 40, "@<|");
            o->tooltip("Skip Frame backwards");
            o->callback((Fl_Callback*)cb_pa_backButton);
            o->hide();
          }
          { Fl_Button* o = pa_forwardButton = new Fl_Button(235, 305, 65, 40, "@|>");
            o->tooltip("Skip Frame forward");
            o->callback((Fl_Callback*)cb_pa_forwardButton);
            o->hide();
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 345, 700, 255);
        { Fl_Group* o = new Fl_Group(40, 345, 660, 255);
          { Flmm_Scalebar* o = scaleBar = new Flmm_Scalebar(40, 580, 640, 20);
            o->type(1);
            o->box(FL_FLAT_BOX);
            o->color(FL_DARK2);
            o->selection_color(FL_BACKGROUND_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(14);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->maximum(1024);
            o->slider_size(0.40404);
            o->callback((Fl_Callback*)cb_scaleBar);
            o->align(FL_ALIGN_BOTTOM);
            o->when(FL_WHEN_CHANGED);
          }
          { Fl_Group* o = new Fl_Group(40, 345, 660, 25);
            { Fl_Button* o = new Fl_Button(40, 345, 25, 25);
              o->tooltip("Snapping");
              o->type(1);
              o->value(1);
              o->image(image_snap);
              o->callback((Fl_Callback*)cb_1);
            }
            { nle::Ruler* o = new nle::Ruler(65, 345, 635, 25, "Ruler");
              o->box(FL_UP_BOX);
              o->color(FL_BACKGROUND_COLOR);
              o->selection_color(FL_BACKGROUND_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(14);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
              o->when(FL_WHEN_RELEASE);
              Fl_Group::current()->resizable(o);
            }
            o->end();
          }
          { Fl_Scrollbar* o = vScrollBar = new Fl_Scrollbar(680, 370, 20, 210);
            o->maximum(50);
            o->slider_size(0.40404);
            o->callback((Fl_Callback*)cb_vScrollBar);
          }
          { nle::TimelineScroll* o = scroll_area = new nle::TimelineScroll(40, 370, 640, 210);
            o->box(FL_NO_BOX);
            o->color(FL_BACKGROUND_COLOR);
            o->selection_color(FL_BACKGROUND_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(14);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->callback((Fl_Callback*)cb_scroll_area);
            o->align(FL_ALIGN_TOP);
            o->when(FL_WHEN_CHANGED);
            { nle::TimelineView* o = m_timelineView = new nle::TimelineView(40, 370, 640, 210);
              o->box(FL_NO_BOX);
              o->color(FL_BACKGROUND_COLOR);
              o->selection_color(FL_BACKGROUND_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(14);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->align(FL_ALIGN_TOP);
              o->when(FL_WHEN_RELEASE);
              o->end();
            }
            o->end();
            Fl_Group::current()->resizable(o);
          }
          o->end();
          Fl_Group::current()->resizable(o);
        }
        { Fl_Group* o = new Fl_Group(0, 345, 40, 255);
          o->labelsize(12);
          { Fl_Button* o = positioningButton = new Fl_Button(0, 370, 40, 40);
            o->tooltip("Positioning (S)");
            o->type(102);
            o->value(1);
            o->shortcut(0x73);
            o->image(image_tool_positioning);
            o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
          }
          { Fl_Button* o = automationsButton = new Fl_Button(0, 410, 40, 40);
            o->tooltip("Automations (A)");
            o->type(102);
            o->shortcut(0x61);
            o->image(image_tool_automations);
            o->align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE);
          }
          { Fl_Box* o = new Fl_Box(0, 490, 40, 70);
            o->box(FL_THIN_UP_BOX);
            Fl_Group::current()->resizable(o);
          }
          { Fl_Box* o = new Fl_Box(0, 345, 40, 25, "Tools");
            o->box(FL_UP_BOX);
            o->labelsize(12);
          }
          { Fl_Box* o = trashCan = new Fl_Box(0, 560, 40, 40);
            o->tooltip("Trash");
            o->box(FL_UP_BOX);
            o->image(image_trash_big);
          }
          { Fl_Button* o = razorButton = new Fl_Button(0, 450, 40, 40);
            o->tooltip("Split (R)");
            o->type(102);
            o->shortcut(0x72);
            o->image(image_razor);
            o->align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }
      o->end();
      Fl_Group::current()->resizable(o);
    }
    { Fl_Choice* o = projectChoice = new Fl_Choice(530, 0, 170, 25);
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_projectChoice);
    }
    o->size_range(450, 380);
    o->end();
  }
}

void NleUI::show( int argc, char **argv ) {
  g_fps = 25.0;
g_backseek = false;
g_scrollBar = scaleBar;
g_trashCan = trashCan;
scaleBar->slider_size_i(300);
mainWindow->show(argc, argv);
projectNameInput->label("Project 1");
g_snap = true;
g_use_jack_transport = true;
g_scrub_audio = true;
g_seek_audio = true;
scroll_area->type(0);
g_v_scrollbar = vScrollBar;
g_16_9 = false;
g_black_borders = false;
special_clips->add("Titles");
}

NleUI::~NleUI() {
  delete mainWindow;
}

int NleUI::automationsMode() {
  if ( positioningButton->value() ) {
	return 0;
} else if ( automationsButton->value() ) {
	return 1;
} else {
	return 2;
}
}

void NleUI::setEffectButtons() {
  nle::IVideoEffect* e = (nle::IVideoEffect*)effect_browser->data( effect_browser->value() );
if ( e && e->numParams() ) {
	m_edit_effect->activate();
} else {
	m_edit_effect->deactivate();
}

if ( effect_browser->value() <= 1 ) {
	m_effect_up->deactivate();
} else {
	m_effect_up->activate();
}
if ( effect_browser->value() == effect_browser->size() || effect_browser->value() == 0 ) {
	m_effect_down->deactivate();
} else {
	m_effect_down->activate();
}
if ( effect_browser->value() == 0 ) {
	m_remove_effect->deactivate();
} else {
	m_remove_effect->activate();
}
}

void NleUI::deactivate_titles() {
  titles_tab->deactivate();
}

void NleUI::activate_titles(int font, int size, const char* text, float x, float y, Fl_Color color ) {
  titles_fonts->value( font );
titles_size->value( size );
titles_x->value( x );
titles_y->value( y );
titles_text->value( text );
titles_tab->activate();
titles_color->color( color );
}

void NleUI::portaudio() {
  playButton->hide();
lastButton->hide();
firstButton->hide();
backButton->hide();
forwardButton->hide();
pauseButton->hide();

pa_playButton->show();
pa_lastButton->show();
pa_firstButton->show();
pa_backButton->show();
pa_forwardButton->show();
jackMenu->hide();
g_playButton = pa_playButton;
g_firstButton = pa_firstButton;
g_lastButton = pa_lastButton;
g_forwardButton = pa_forwardButton;
g_backButton = pa_backButton;
}

void NleUI::jack() {
  pa_playButton->hide();
pa_lastButton->hide();
pa_firstButton->hide();
pa_backButton->hide();
pa_forwardButton->hide();
pauseButton->show();

playButton->show();
lastButton->show();
firstButton->show();
backButton->show();
forwardButton->show();
jackMenu->show();
g_playButton = playButton;
g_firstButton = firstButton;
g_lastButton = lastButton;
g_forwardButton = forwardButton;
g_backButton = backButton;
}
Flmm_Scalebar* g_scrollBar;

void EncodeDialog::cb_Encode_i(Fl_Return_Button* o, void*) {
  if ( strcmp( "", export_filename->value() ) == 0 ) {
	if ( audio_codec_menu->value() < 0 && video_codec_menu->value() < 0 ) {
		fl_alert( "Please select a filename,\nas well as an Audio and Video Codec." );
		return;
	} else if ( audio_codec_menu->value() < 0 ) {
		fl_alert( "Please select a filename,\n as well as an Audio Codec." );
		return;
	} else if ( video_codec_menu->value() < 0 ) {
		fl_alert( "Please select a filename,\n as well as a Video Codec." );
		return;
	}
	fl_alert( "Please select a filename." );
	return;
}

if ( audio_codec_menu->value() < 0 || video_codec_menu->value() < 0 ) {
	fl_alert( "Please select an Audio and Video Codec" );
	return;
}

//nle::renderMovie();
go = true;
o->window()->hide();
}
void EncodeDialog::cb_Encode(Fl_Return_Button* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_Encode_i(o,v);
}

void EncodeDialog::cb_Cancel_i(Fl_Button* o, void*) {
  go = false;
o->window()->hide();
}
void EncodeDialog::cb_Cancel(Fl_Button* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_Cancel_i(o,v);
}

void EncodeDialog::cb_audio_codec_menu_i(Fl_Choice* o, void*) {
  audio_codec = o->menu()[o->value()].user_data();
m_codecParams->setAudioCodec( (lqt_codec_info_t*)audio_codec );
}
void EncodeDialog::cb_audio_codec_menu(Fl_Choice* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_audio_codec_menu_i(o,v);
}

void EncodeDialog::cb_video_codec_menu_i(Fl_Choice* o, void*) {
  video_codec = o->menu()[o->value()].user_data();
m_codecParams->setVideoCodec( (lqt_codec_info_t*)video_codec );
}
void EncodeDialog::cb_video_codec_menu(Fl_Choice* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_video_codec_menu_i(o,v);
}

Fl_Menu_Item EncodeDialog::menu_Samplerate[] = {
 {"48000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item EncodeDialog::menu_Framerate[] = {
 {"25 (PAL)", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item EncodeDialog::menu_frame_size_choice[] = {
 {"720x576 (PAL 4:3) DV, DVD", 0,  0, (void*)(&fs720x576), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"768x576 (PAL 4:3)", 0,  0, (void*)(&fs768x576), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"384x288 (PAL \275 4:3)", 0,  0, (void*)(&fs384x288), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"640x480 (VGA 4:3)", 0,  0, (void*)(&fs640x480), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"320x240 (QVGA 4:3)", 0,  0, (void*)(&fs320x240), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EncodeDialog::cb_audio_options_i(Fl_Button*, void*) {
  if ( audio_codec ) {
	Fl_Group::current( encodeDialog );
	CodecOptions dlg;
	dlg.m_audio = true;
	dlg.m_codecParams = m_codecParams;
	nle::setCodecInfo( &dlg, audio_codec );
	dlg.codecOptions->show();
	while (dlg.codecOptions->shown())
		Fl::wait();
};
}
void EncodeDialog::cb_audio_options(Fl_Button* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_audio_options_i(o,v);
}

void EncodeDialog::cb_video_options_i(Fl_Button*, void*) {
  if ( video_codec ) {
	Fl_Group::current( encodeDialog );
	CodecOptions dlg;
	dlg.m_audio = false;
	dlg.m_codecParams = m_codecParams;
	nle::setCodecInfo( &dlg, video_codec );
	dlg.codecOptions->show();
	while (dlg.codecOptions->shown())
		Fl::wait();
};
}
void EncodeDialog::cb_video_options(Fl_Button* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_video_options_i(o,v);
}

void EncodeDialog::cb_File_i(Fl_Button*, void*) {
  export_filename->value( fl_file_chooser( "Set Export Filename", 0, 0 ) );
}
void EncodeDialog::cb_File(Fl_Button* o, void* v) {
  ((EncodeDialog*)(o->parent()->user_data()))->cb_File_i(o,v);
}

EncodeDialog::EncodeDialog( nle::IVideoReader*, nle::IAudioReader*, nle::CodecParameters* codecParams ) {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = encodeDialog = new Fl_Double_Window(485, 340, "Render");
    w = o;
    o->user_data((void*)(this));
    { Fl_Return_Button* o = new Fl_Return_Button(250, 300, 200, 25, "Encode");
      o->callback((Fl_Callback*)cb_Encode);
      w->hotspot(o);
    }
    { Fl_Button* o = new Fl_Button(35, 300, 200, 25, "Cancel");
      o->callback((Fl_Callback*)cb_Cancel);
    }
    { Fl_Choice* o = audio_codec_menu = new Fl_Choice(145, 220, 205, 25, "Audio Codec");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_audio_codec_menu);
    }
    { Fl_Choice* o = video_codec_menu = new Fl_Choice(145, 100, 205, 25, "Video Codec");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_video_codec_menu);
    }
    { Fl_Choice* o = new Fl_Choice(145, 250, 205, 25, "Samplerate");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_Samplerate);
    }
    { Fl_Choice* o = new Fl_Choice(145, 130, 205, 25, "Framerate");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_Framerate);
    }
    { Fl_Choice* o = frame_size_choice = new Fl_Choice(145, 160, 205, 25, "Framesize");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_frame_size_choice);
    }
    { Fl_Box* o = new Fl_Box(0, 0, 485, 35, "Export");
      o->labelfont(1);
      o->labelsize(16);
    }
    { Fl_Button* o = audio_options = new Fl_Button(355, 220, 75, 25, "Options...");
      o->callback((Fl_Callback*)cb_audio_options);
    }
    { Fl_Button* o = video_options = new Fl_Button(355, 100, 75, 25, "Options...");
      o->callback((Fl_Callback*)cb_video_options);
    }
    export_filename = new Fl_File_Input(145, 35, 205, 35, "Filename");
    { Fl_Button* o = new Fl_Button(355, 45, 75, 25, "File...");
      o->callback((Fl_Callback*)cb_File);
    }
    { Fl_Box* o = new Fl_Box(35, 95, 415, 95, "Video");
      o->box(FL_ENGRAVED_FRAME);
      o->labelfont(1);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Box* o = new Fl_Box(35, 215, 415, 65, "Audio");
      o->box(FL_ENGRAVED_FRAME);
      o->labelfont(1);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    o->set_modal();
    o->end();
  }
  m_codecParams = codecParams;
}

void EncodeDialog::show() {
  audio_codec = 0;
video_codec = 0;
nle::setAudioCodecMenu( audio_codec_menu );
nle::setVideoCodecMenu( video_codec_menu );

video_codec_menu->value( nle::g_preferences->lastVideoCodec() );
audio_codec_menu->value( nle::g_preferences->lastAudioCodec() );
frame_size_choice->value( nle::g_preferences->lastFramesize() );
export_filename->value( nle::g_preferences->lastRenderFilename().c_str() );

video_codec = video_codec_menu->menu()[video_codec_menu->value()].user_data();
m_codecParams->setVideoCodec( (lqt_codec_info_t*)video_codec );
audio_codec = audio_codec_menu->menu()[audio_codec_menu->value()].user_data();
m_codecParams->setAudioCodec( (lqt_codec_info_t*)audio_codec );

encodeDialog->show();
}

int EncodeDialog::shown() {
  return encodeDialog->shown();
}

EncodeDialog::~EncodeDialog() {
  delete encodeDialog;
}

void* EncodeDialog::frameSize() {
  return frame_size_choice->mvalue()->user_data();
}

ChangesDialog::ChangesDialog() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = new Fl_Double_Window(410, 80, "Unsaved changes!");
    w = o;
    o->user_data((void*)(this));
    new Fl_Box(5, 10, 385, 25, "Save changes?");
    new Fl_Button(5, 50, 120, 25, "Don\'t Save");
    new Fl_Button(160, 50, 120, 25, "Cancel");
    new Fl_Return_Button(285, 50, 120, 25, "Save");
    o->end();
  }
}
Fl_Box *g_trashCan;
float g_fps;

void CodecOptions::cb_parameters_browser_i(Fl_Hold_Browser*, void*) {
  if ( parameters_browser->value() ) {
	nle::setCodecParameter( this, parameters_browser->data( parameters_browser->value() ) );
};
}
void CodecOptions::cb_parameters_browser(Fl_Hold_Browser* o, void* v) {
  ((CodecOptions*)(o->parent()->parent()->user_data()))->cb_parameters_browser_i(o,v);
}

void CodecOptions::cb_parameter_int_input_i(Fl_Value_Input* o, void*) {
  nle::ParameterValue val( (int)o->value() );
lqt_parameter_info_t* info = (lqt_parameter_info_t*)parameters_browser->data( parameters_browser->value() );
if ( m_audio ) {
	m_codecParams->setAudioParameter( info->name, val );
} else {
	m_codecParams->setVideoParameter( info->name, val );
};
}
void CodecOptions::cb_parameter_int_input(Fl_Value_Input* o, void* v) {
  ((CodecOptions*)(o->parent()->parent()->parent()->user_data()))->cb_parameter_int_input_i(o,v);
}

void CodecOptions::cb_parameter_string_input_i(Fl_Input* o, void*) {
  nle::ParameterValue val( o->value() );
lqt_parameter_info_t* info = (lqt_parameter_info_t*)parameters_browser->data( parameters_browser->value() );
if ( m_audio ) {
	m_codecParams->setAudioParameter( info->name, val );
} else {
	m_codecParams->setVideoParameter( info->name, val );
};
}
void CodecOptions::cb_parameter_string_input(Fl_Input* o, void* v) {
  ((CodecOptions*)(o->parent()->parent()->parent()->user_data()))->cb_parameter_string_input_i(o,v);
}

void CodecOptions::cb_parameter_stringlist_input_i(Fl_Choice* o, void*) {
  nle::ParameterValue val( o->text() );
lqt_parameter_info_t* info = (lqt_parameter_info_t*)parameters_browser->data( parameters_browser->value() );
if ( m_audio ) {
	m_codecParams->setAudioParameter( info->name, val );
} else {
	m_codecParams->setVideoParameter( info->name, val );
};
}
void CodecOptions::cb_parameter_stringlist_input(Fl_Choice* o, void* v) {
  ((CodecOptions*)(o->parent()->parent()->parent()->user_data()))->cb_parameter_stringlist_input_i(o,v);
}

void CodecOptions::cb_Cancel1_i(Fl_Button* o, void*) {
  o->window()->hide();
}
void CodecOptions::cb_Cancel1(Fl_Button* o, void* v) {
  ((CodecOptions*)(o->parent()->parent()->user_data()))->cb_Cancel1_i(o,v);
}

void CodecOptions::cb_Ok_i(Fl_Return_Button* o, void*) {
  o->window()->hide();
}
void CodecOptions::cb_Ok(Fl_Return_Button* o, void* v) {
  ((CodecOptions*)(o->parent()->parent()->user_data()))->cb_Ok_i(o,v);
}

CodecOptions::CodecOptions() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = codecOptions = new Fl_Double_Window(345, 305, "Codec Options");
    w = o;
    o->user_data((void*)(this));
    { Fl_Box* o = codec_label = new Fl_Box(0, 0, 345, 35, "Codec");
      o->labelfont(1);
      o->labelsize(16);
    }
    { Fl_Group* o = new Fl_Group(0, 35, 345, 230);
      { Fl_Hold_Browser* o = parameters_browser = new Fl_Hold_Browser(5, 40, 165, 220);
        o->box(FL_NO_BOX);
        o->color(FL_BACKGROUND2_COLOR);
        o->selection_color(FL_SELECTION_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)cb_parameters_browser);
        o->align(FL_ALIGN_BOTTOM);
        o->when(FL_WHEN_RELEASE_ALWAYS);
        Fl_Group::current()->resizable(o);
      }
      { Fl_Group* o = new Fl_Group(170, 35, 175, 230);
        { Fl_Value_Input* o = parameter_int_input = new Fl_Value_Input(175, 40, 165, 25);
          o->step(1);
          o->callback((Fl_Callback*)cb_parameter_int_input);
          o->deactivate();
        }
        { Fl_Input* o = parameter_string_input = new Fl_Input(175, 70, 165, 25);
          o->callback((Fl_Callback*)cb_parameter_string_input);
          o->deactivate();
        }
        { Fl_Choice* o = parameter_stringlist_input = new Fl_Choice(175, 100, 165, 25);
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_parameter_stringlist_input);
          o->deactivate();
        }
        { Fl_Box* o = new Fl_Box(230, 175, 25, 25);
          Fl_Group::current()->resizable(o);
        }
        o->end();
      }
      o->end();
      Fl_Group::current()->resizable(o);
    }
    { Fl_Group* o = new Fl_Group(0, 265, 345, 40);
      { Fl_Button* o = new Fl_Button(20, 275, 140, 25, "Cancel");
        o->callback((Fl_Callback*)cb_Cancel1);
        o->hide();
      }
      { Fl_Return_Button* o = new Fl_Return_Button(20, 275, 305, 25, "Ok");
        o->callback((Fl_Callback*)cb_Ok);
        Fl_Group::current()->resizable(o);
        w->hotspot(o);
      }
      o->end();
    }
    o->set_modal();
    o->end();
  }
}

CodecOptions::~CodecOptions() {
  delete codecOptions;
}

static const char *idata_logo[] = {
"128 128 4272 2",
"  \tc None",
". \tc #5C5C70",
"+ \tc #4E4E5C",
"@ \tc #59596B",
"# \tc #5C5C71",
"$ \tc #4B4B57",
"% \tc #5A5A5C",
"& \tc #5C5D60",
"* \tc #525362",
"= \tc #515161",
"- \tc #4B4B4C",
"; \tc #A3A3A3",
"> \tc #747474",
", \tc #515354",
"\' \tc #50515D",
") \tc #555567",
"! \tc #353638",
"~ \tc #7E7E7E",
"{ \tc #9E9E9E",
"] \tc #949494",
"^ \tc #939398",
"/ \tc #504F58",
"( \tc #45464E",
"_ \tc #5B5B6F",
": \tc #393A40",
"< \tc #2F3130",
"[ \tc #2B2D2C",
"} \tc #2D2F2E",
"| \tc #95949B",
"1 \tc #5E5E72",
"2 \tc #666677",
"3 \tc #898989",
"4 \tc #45464A",
"5 \tc #5A5A6D",
"6 \tc #3E3F47",
"7 \tc #383A3D",
"8 \tc #585869",
"9 \tc #575867",
"0 \tc #34383A",
"a \tc #36383E",
"b \tc #606070",
"c \tc #6A6972",
"d \tc #7B7B7B",
"e \tc #373838",
"f \tc #535658",
"g \tc #515261",
"h \tc #494854",
"i \tc #37383A",
"j \tc #535462",
"k \tc #5D5D72",
"l \tc #595A6C",
"m \tc #383A3F",
"n \tc #3D3E40",
"o \tc #828382",
"p \tc #A6A6A5",
"q \tc #717473",
"r \tc #333737",
"s \tc #4B4D58",
"t \tc #515060",
"u \tc #2E3032",
"v \tc #5D5D6C",
"w \tc #4F4F5A",
"x \tc #2F3030",
"y \tc #3B3B3B",
"z \tc #BDBDBD",
"A \tc #343636",
"B \tc #2E3131",
"C \tc #363938",
"D \tc #4F4F59",
"E \tc #5A5A6E",
"F \tc #565669",
"G \tc #343439",
"H \tc #41414B",
"I \tc #5D5D70",
"J \tc #2C2E2E",
"K \tc #2E302F",
"L \tc #2C2D2D",
"M \tc #303130",
"N \tc #3F4040",
"O \tc #A5A6A6",
"P \tc #44464E",
"Q \tc #58586B",
"R \tc #59596C",
"S \tc #3A3A40",
"T \tc #2D2E30",
"U \tc #4D4D57",
"V \tc #3B3B41",
"W \tc #2A2D2C",
"X \tc #2B2C2B",
"Y \tc #6D6D6D",
"Z \tc #7E7E7C",
"` \tc #777676",
" .\tc #57575A",
"..\tc #535463",
"+.\tc #43444C",
"@.\tc #2C2E2D",
"#.\tc #55545E",
"$.\tc #42424C",
"%.\tc #282A2A",
"&.\tc #2D2F2D",
"*.\tc #333534",
"=.\tc #666767",
"-.\tc #363636",
";.\tc #C4C4C4",
">.\tc #767677",
",.\tc #5B5D5F",
"\'.\tc #4C4E59",
").\tc #4A4B56",
"!.\tc #313332",
"~.\tc #2A2822",
"{.\tc #463A2A",
"].\tc #4B494D",
"^.\tc #49494D",
"/.\tc #252929",
"(.\tc #282B2C",
"_.\tc #2B2D2D",
":.\tc #282B2B",
"<.\tc #4C4C53",
"[.\tc #494951",
"}.\tc #272A2B",
"|.\tc #6D6E6E",
"1.\tc #A9A9A9",
"2.\tc #BCBCBC",
"3.\tc #B0B0B1",
"4.\tc #535456",
"5.\tc #4A4C56",
"6.\tc #333535",
"7.\tc #2B2A26",
"8.\tc #5F513D",
"9.\tc #9F9587",
"0.\tc #51483D",
"a.\tc #2A292B",
"b.\tc #292C2D",
"c.\tc #2A2E2F",
"d.\tc #282A29",
"e.\tc #484952",
"f.\tc #5B5B70",
"g.\tc #4D4D5B",
"h.\tc #2A2C2D",
"i.\tc #4A4A4A",
"j.\tc #979797",
"k.\tc #4C4C4D",
"l.\tc #6E6D6F",
"m.\tc #A9AAA9",
"n.\tc #46464B",
"o.\tc #57576A",
"p.\tc #36383A",
"q.\tc #2A2B28",
"r.\tc #4C4130",
"s.\tc #B6AEA3",
"t.\tc #E0DAD3",
"u.\tc #C0B9B0",
"v.\tc #6A6156",
"w.\tc #2D2E2B",
"x.\tc #2A2D2E",
"y.\tc #3B3C43",
"z.\tc #5D5D71",
"A.\tc #585761",
"B.\tc #282B2A",
"C.\tc #3B3D3C",
"D.\tc #B0B0B0",
"E.\tc #7E7F7D",
"F.\tc #4D4E4D",
"G.\tc #2F3032",
"H.\tc #383A3E",
"I.\tc #545565",
"J.\tc #3B3D41",
"K.\tc #2A2C2B",
"L.\tc #3F3627",
"M.\tc #A49C8E",
"N.\tc #E1DBD5",
"O.\tc #E1DAD4",
"P.\tc #E2DBD5",
"Q.\tc #CEC8C0",
"R.\tc #877D6F",
"S.\tc #393730",
"T.\tc #2A2C2C",
"U.\tc #36373B",
"V.\tc #5E5E71",
"W.\tc #48494E",
"X.\tc #292C2C",
"Y.\tc #2A2E2E",
"Z.\tc #353939",
"`.\tc #666868",
" +\tc #2F3233",
".+\tc #303435",
"++\tc #4A4C58",
"@+\tc #42434B",
"#+\tc #342D21",
"$+\tc #908575",
"%+\tc #D8D2CB",
"&+\tc #E0D9D2",
"*+\tc #E1DAD3",
"=+\tc #E0D8D1",
"-+\tc #D7D1CA",
";+\tc #9B9386",
">+\tc #454038",
",+\tc #2B2B2D",
"\'+\tc #50505B",
")+\tc #52525E",
"!+\tc #292C2B",
"~+\tc #292D2E",
"{+\tc #2C3030",
"]+\tc #2D3032",
"^+\tc #303234",
"/+\tc #2F3334",
"(+\tc #313335",
"_+\tc #454750",
":+\tc #494A56",
"<+\tc #2E3030",
"[+\tc #2A2820",
"}+\tc #7A6F5C",
"|+\tc #CCC4BC",
"1+\tc #DED6CE",
"2+\tc #E2DCD5",
"3+\tc #DFDAD4",
"4+\tc #ACA59A",
"5+\tc #564E42",
"6+\tc #3E3C3F",
"7+\tc #575666",
"8+\tc #505060",
"9+\tc #27292C",
"0+\tc #292A2B",
"a+\tc #2A2B2B",
"b+\tc #2A2E2D",
"c+\tc #2C2F2F",
"d+\tc #2F3031",
"e+\tc #2C2F2E",
"f+\tc #414248",
"g+\tc #565667",
"h+\tc #262724",
"i+\tc #60533E",
"j+\tc #C4BBB1",
"k+\tc #DCD4CC",
"l+\tc #DDD5CD",
"m+\tc #DFD8D0",
"n+\tc #E2DBD4",
"o+\tc #E1DBD4",
"p+\tc #E0D9D1",
"q+\tc #E3DDD7",
"r+\tc #E2DDD7",
"s+\tc #BDB5AC",
"t+\tc #625A4F",
"u+\tc #343232",
"v+\tc #4F4E5C",
"w+\tc #5B5B6A",
"x+\tc #333538",
"y+\tc #2B2D2E",
"z+\tc #303233",
"A+\tc #343637",
"B+\tc #323436",
"C+\tc #292927",
"D+\tc #4B3F2C",
"E+\tc #B7AFA3",
"F+\tc #D4CCC1",
"G+\tc #D8D0C5",
"H+\tc #DDD5CB",
"I+\tc #E2DCD6",
"J+\tc #CFC8C0",
"K+\tc #857B6E",
"L+\tc #2F2D28",
"M+\tc #212527",
"N+\tc #2A2B2C",
"O+\tc #292A2C",
"P+\tc #303036",
"Q+\tc #5D5E6F",
"R+\tc #5D5D6F",
"S+\tc #3C3D44",
"T+\tc #272A2A",
"U+\tc #292B2A",
"V+\tc #494A57",
"W+\tc #59596D",
"X+\tc #393B40",
"Y+\tc #292A29",
"Z+\tc #3E3627",
"`+\tc #A19787",
" @\tc #D9D1C8",
".@\tc #8B7851",
"+@\tc #96845F",
"@@\tc #D1C7BA",
"#@\tc #DCD4CB",
"$@\tc #DFD7CF",
"%@\tc #DFD8D1",
"&@\tc #D8D1C9",
"*@\tc #998F81",
"=@\tc #423D37",
"-@\tc #2A2A2B",
";@\tc #2B2C2C",
">@\tc #292B2B",
",@\tc #28292B",
"\'@\tc #2D2E31",
")@\tc #545463",
"!@\tc #5C5C6F",
"~@\tc #4C4C55",
"{@\tc #2C2D30",
"]@\tc #2C2D2E",
"^@\tc #42434A",
"/@\tc #30291B",
"(@\tc #84765F",
"_@\tc #D1C8BE",
":@\tc #DAD2C8",
"<@\tc #8B7B5C",
"[@\tc #79663C",
"}@\tc #A1906F",
"|@\tc #D4CBC0",
"1@\tc #DFD7D0",
"2@\tc #DBD4CD",
"3@\tc #ABA398",
"4@\tc #564E43",
"5@\tc #2D2C2C",
"6@\tc #29292D",
"7@\tc #4E4F5A",
"8@\tc #50505E",
"9@\tc #2B2C2E",
"0@\tc #2B2E2D",
"a@\tc #303131",
"b@\tc #3F4043",
"c@\tc #44454D",
"d@\tc #575769",
"e@\tc #4A4B58",
"f@\tc #28241C",
"g@\tc #62512D",
"h@\tc #917F5E",
"i@\tc #C4B8A7",
"j@\tc #CFC4B8",
"k@\tc #AA9A83",
"l@\tc #867553",
"m@\tc #806D4A",
"n@\tc #A6967B",
"o@\tc #D4CBBF",
"p@\tc #DBD3CA",
"q@\tc #D8CFC5",
"r@\tc #DDD5CC",
"s@\tc #DED7D0",
"t@\tc #685F51",
"u@\tc #26282A",
"v@\tc #4C4C52",
"w@\tc #313236",
"x@\tc #2A2B2D",
"y@\tc #2D2E2F",
"z@\tc #4E4F58",
"A@\tc #4C4C54",
"B@\tc #3C3E40",
"C@\tc #232321",
"D@\tc #594829",
"E@\tc #816E48",
"F@\tc #8A7651",
"G@\tc #9D8B6E",
"H@\tc #BFB1A0",
"I@\tc #CABEB0",
"J@\tc #A19076",
"K@\tc #67562C",
"L@\tc #715F33",
"M@\tc #B0A28A",
"N@\tc #D9D0C6",
"O@\tc #DBD2C9",
"P@\tc #DAD1C7",
"Q@\tc #CEC6BE",
"R@\tc #81786B",
"S@\tc #302D28",
"T@\tc #47474D",
"U@\tc #3B3D43",
"V@\tc #2B2E2E",
"W@\tc #54545D",
"X@\tc #5F5F72",
"Y@\tc #313333",
"Z@\tc #4E4F5C",
"`@\tc #262725",
" #\tc #4B3E29",
".#\tc #A49784",
"+#\tc #968467",
"@#\tc #84714C",
"##\tc #8D7A55",
"$#\tc #968363",
"%#\tc #B6A893",
"&#\tc #CABFB1",
"*#\tc #B4A591",
"=#\tc #887652",
"-#\tc #8F7D5E",
";#\tc #A4947A",
">#\tc #9B896A",
",#\tc #978565",
"\'#\tc #998668",
")#\tc #A7977C",
"!#\tc #C7BCAB",
"~#\tc #DED6CD",
"{#\tc #E0DAD2",
"]#\tc #D9D2CB",
"^#\tc #9A9184",
"/#\tc #3F3832",
"(#\tc #343339",
"_#\tc #595868",
":#\tc #494A51",
"<#\tc #272A29",
"[#\tc #2C2D2C",
"}#\tc #242828",
"|#\tc #343635",
"1#\tc #3A3D43",
"2#\tc #2B2C2A",
"3#\tc #3D3425",
"4#\tc #9D9180",
"5#\tc #D0C7BB",
"6#\tc #BCAE9C",
"7#\tc #958364",
"8#\tc #8E7A54",
"9#\tc #BDB09D",
"0#\tc #D4CABF",
"a#\tc #CDC3B5",
"b#\tc #B1A28D",
"c#\tc #B5A691",
"d#\tc #BFB29F",
"e#\tc #B7AA94",
"f#\tc #9A8867",
"g#\tc #89764F",
"h#\tc #94815B",
"i#\tc #E1D9D2",
"j#\tc #DED8D2",
"k#\tc #AEA69B",
"l#\tc #554E43",
"m#\tc #353434",
"n#\tc #404046",
"o#\tc #2A2C2A",
"p#\tc #2D2F30",
"q#\tc #585861",
"r#\tc #585862",
"s#\tc #2E3235",
"t#\tc #3B3C41",
"u#\tc #42444E",
"v#\tc #2C3031",
"w#\tc #3C3629",
"x#\tc #7B6C51",
"y#\tc #B9AC9C",
"z#\tc #CEC3B6",
"A#\tc #B5A792",
"B#\tc #907D5A",
"C#\tc #806D47",
"D#\tc #7D6A45",
"E#\tc #93805C",
"F#\tc #C1B4A1",
"G#\tc #D8CFC4",
"H#\tc #D6CDC2",
"I#\tc #D6CDC1",
"J#\tc #D8D0C6",
"K#\tc #D9D1C7",
"L#\tc #D6CDC3",
"M#\tc #BBAE99",
"N#\tc #8F7C57",
"O#\tc #978465",
"P#\tc #C8BDAE",
"Q#\tc #E3DED7",
"R#\tc #E4DFD9",
"S#\tc #E5DFDA",
"T#\tc #E5E0DB",
"U#\tc #BEB7AE",
"V#\tc #6B6153",
"W#\tc #2D2C2B",
"X#\tc #4D4D54",
"Y#\tc #595969",
"Z#\tc #34363B",
"`#\tc #35373A",
" $\tc #4E4F5E",
".$\tc #4A4B57",
"+$\tc #353129",
"@$\tc #604E26",
"#$\tc #917F60",
"$$\tc #A79680",
"%$\tc #BDAF9E",
"&$\tc #C6BAAB",
"*$\tc #CFC5B8",
"=$\tc #B7A894",
"-$\tc #8D7851",
";$\tc #7D6A42",
">$\tc #83704A",
",$\tc #998769",
"\'$\tc #C5B9A8",
")$\tc #CDC3B6",
"!$\tc #B9AC97",
"~$\tc #847149",
"{$\tc #9E8C6B",
"]$\tc #E5E0DA",
"^$\tc #E6E2DD",
"/$\tc #E8E4DF",
"($\tc #E6E2DC",
"_$\tc #CFC8C1",
":$\tc #7C7365",
"<$\tc #35322C",
"[$\tc #2D2E2D",
"}$\tc #35353C",
"|$\tc #5D5C6F",
"1$\tc #313433",
"2$\tc #525262",
"3$\tc #313334",
"4$\tc #2E2E2A",
"5$\tc #5D4C28",
"6$\tc #6F5A26",
"7$\tc #715E34",
"8$\tc #9B896F",
"9$\tc #AC9B86",
"0$\tc #BEB0A0",
"a$\tc #D0C6B9",
"b$\tc #AD9D86",
"c$\tc #89754A",
"d$\tc #7A673E",
"e$\tc #826F49",
"f$\tc #917D59",
"g$\tc #9E8B70",
"h$\tc #AA9984",
"i$\tc #B9AB98",
"j$\tc #DDD6CD",
"k$\tc #91805D",
"l$\tc #89764D",
"m$\tc #CCC2B5",
"n$\tc #E7E2DD",
"o$\tc #E3DDD6",
"p$\tc #DCD7D1",
"q$\tc #999184",
"r$\tc #433D33",
"s$\tc #57576B",
"t$\tc #494950",
"u$\tc #303231",
"v$\tc #44454E",
"w$\tc #333536",
"x$\tc #55472D",
"y$\tc #826F4B",
"z$\tc #836E42",
"A$\tc #735F2D",
"B$\tc #6A5934",
"C$\tc #9F8E74",
"D$\tc #BFB1A1",
"E$\tc #C2B5A5",
"F$\tc #C4B7A7",
"G$\tc #C4B8A9",
"H$\tc #B2A28C",
"I$\tc #8B774E",
"J$\tc #7E6A3F",
"K$\tc #816F4B",
"L$\tc #978566",
"M$\tc #917E5D",
"N$\tc #7E6A3E",
"O$\tc #A7977D",
"P$\tc #CCC0B4",
"Q$\tc #D7CEC3",
"R$\tc #B3A68F",
"S$\tc #B8AB98",
"T$\tc #DCD5CE",
"U$\tc #AFA69A",
"V$\tc #544C42",
"W$\tc #2B2A2B",
"X$\tc #494850",
"Y$\tc #555560",
"Z$\tc #2D2F2F",
"`$\tc #3A3C40",
" %\tc #3A3B40",
".%\tc #463D2C",
"+%\tc #847355",
"@%\tc #927F61",
"#%\tc #8E7B59",
"$%\tc #8A7756",
"%%\tc #514320",
"&%\tc #5B4D2B",
"*%\tc #97876A",
"=%\tc #B2A28E",
"-%\tc #BAAB99",
";%\tc #BFB2A1",
">%\tc #C5B8A9",
",%\tc #B1A28C",
"\'%\tc #907D59",
")%\tc #816D45",
"!%\tc #8B7853",
"~%\tc #9E8C6F",
"{%\tc #A7967E",
"]%\tc #AD9C86",
"^%\tc #A29174",
"/%\tc #D3C9BD",
"(%\tc #C0B4A1",
"_%\tc #B6A794",
":%\tc #DED7D1",
"<%\tc #BFB7AE",
"[%\tc #6B6054",
"}%\tc #322F2E",
"|%\tc #595860",
"1%\tc #5A5A6C",
"2%\tc #2D3033",
"3%\tc #3A3C3E",
"4%\tc #555565",
"5%\tc #5B5C70",
"6%\tc #41434D",
"7%\tc #292D2C",
"8%\tc #373022",
"9%\tc #6C5B35",
"0%\tc #AC9D89",
"a%\tc #99866B",
"b%\tc #99876B",
"c%\tc #6E5F42",
"d%\tc #45381A",
"e%\tc #45391A",
"f%\tc #645531",
"g%\tc #AA9A82",
"h%\tc #C7BBAC",
"i%\tc #D5CBC0",
"j%\tc #C0B3A2",
"k%\tc #94815E",
"l%\tc #847049",
"m%\tc #AA9982",
"n%\tc #C4B7A8",
"o%\tc #AB9A83",
"p%\tc #8A7A5B",
"q%\tc #C2B5A3",
"r%\tc #8E7B56",
"s%\tc #B3A490",
"t%\tc #E4DED8",
"u%\tc #CFC7BF",
"v%\tc #7D7264",
"w%\tc #353231",
"x%\tc #4B4B50",
"y%\tc #565666",
"z%\tc #37383B",
"A%\tc #414242",
"B%\tc #4E4F50",
"C%\tc #2C2E2F",
"D%\tc #303232",
"E%\tc #3C3D41",
"F%\tc #25231C",
"G%\tc #57451C",
"H%\tc #796432",
"I%\tc #74643E",
"J%\tc #7F6E4E",
"K%\tc #433819",
"L%\tc #3F3518",
"M%\tc #716240",
"N%\tc #B0A38E",
"O%\tc #B9AA98",
"P%\tc #C4B8A8",
"Q%\tc #BBAD99",
"R%\tc #B8AA97",
"S%\tc #806C45",
"T%\tc #A6957C",
"U%\tc #CBBFB2",
"V%\tc #CFC3B6",
"W%\tc #B4A691",
"X%\tc #AE9F88",
"Y%\tc #C4B8A6",
"Z%\tc #907C57",
"`%\tc #AD9F84",
" &\tc #DAD2C9",
".&\tc #DED7CF",
"+&\tc #E0D8D0",
"@&\tc #E3DED8",
"#&\tc #E5DFD9",
"$&\tc #D7D0C9",
"%&\tc #968C80",
"&&\tc #3E372F",
"*&\tc #2E302E",
"=&\tc #38393B",
"-&\tc #5C5C6C",
";&\tc #4C4D5D",
">&\tc #2B2C2F",
",&\tc #4E4E54",
"\'&\tc #5F5E72",
")&\tc #4B4B54",
"!&\tc #43444D",
"~&\tc #262520",
"{&\tc #483715",
"]&\tc #493C1A",
"^&\tc #584921",
"/&\tc #675733",
"(&\tc #8D7C5E",
"_&\tc #574822",
":&\tc #423718",
"<&\tc #584A28",
"[&\tc #9B8A6C",
"}&\tc #958260",
"|&\tc #9E8E6E",
"1&\tc #B2A38D",
"2&\tc #D1C7B9",
"3&\tc #DAD1C8",
"4&\tc #D6CEC3",
"5&\tc #C2B7A7",
"6&\tc #AA9C86",
"7&\tc #AE9D89",
"8&\tc #A7967F",
"9&\tc #A4927A",
"0&\tc #99876A",
"a&\tc #93805B",
"b&\tc #BDB19B",
"c&\tc #8F7F5E",
"d&\tc #89754D",
"e&\tc #BDB09B",
"f&\tc #DCD4CD",
"g&\tc #B2A99E",
"h&\tc #554D40",
"i&\tc #292A28",
"j&\tc #2A2D2B",
"k&\tc #5C5C6A",
"l&\tc #5B5B67",
"m&\tc #373938",
"n&\tc #323235",
"o&\tc #96969C",
"p&\tc #ABABAA",
"q&\tc #6D6E72",
"r&\tc #565668",
"s&\tc #343638",
"t&\tc #272826",
"u&\tc #3F3114",
"v&\tc #4A3C19",
"w&\tc #5F4F2A",
"x&\tc #958469",
"y&\tc #524528",
"z&\tc #493C1D",
"A&\tc #68593A",
"B&\tc #908060",
"C&\tc #857451",
"D&\tc #8E7C58",
"E&\tc #6B582C",
"F&\tc #AB9A82",
"G&\tc #C2B6A4",
"H&\tc #D2C8BD",
"I&\tc #D2C8BC",
"J&\tc #AB9A85",
"K&\tc #A08F74",
"L&\tc #9B896D",
"M&\tc #8C794D",
"N&\tc #BCAF9A",
"O&\tc #B6A894",
"P&\tc #6D5B31",
"Q&\tc #76653C",
"R&\tc #BEB19D",
"S&\tc #C0B9AF",
"T&\tc #6A6155",
"U&\tc #302F29",
"V&\tc #2A2E2C",
"W&\tc #53535E",
"X&\tc #5D5C71",
"Y&\tc #373839",
"Z&\tc #323433",
"`&\tc #333436",
" *\tc #5F5E62",
".*\tc #B2B2B2",
"+*\tc #ACACAC",
"@*\tc #A2A2A2",
"#*\tc #3F4142",
"$*\tc #342A16",
"%*\tc #50411A",
"&*\tc #443819",
"**\tc #5D4D25",
"=*\tc #938263",
"-*\tc #615237",
";*\tc #392F19",
">*\tc #43371B",
",*\tc #8D7D5E",
"\'*\tc #BEB09F",
")*\tc #998A6D",
"!*\tc #6E5B2B",
"~*\tc #6F5C31",
"{*\tc #968361",
"]*\tc #978560",
"^*\tc #B1A28A",
"/*\tc #AC9C87",
"(*\tc #988567",
"_*\tc #816D42",
":*\tc #857148",
"<*\tc #897650",
"[*\tc #87744F",
"}*\tc #998667",
"|*\tc #CFC4B7",
"1*\tc #8A7755",
"2*\tc #7A6840",
"3*\tc #94825D",
"4*\tc #DBD3C9",
"5*\tc #DED6CF",
"6*\tc #CDC5BD",
"7*\tc #7E7566",
"8*\tc #38352E",
"9*\tc #434449",
"0*\tc #34373B",
"a*\tc #2F3131",
"b*\tc #323332",
"c*\tc #777777",
"d*\tc #A7A7A7",
"e*\tc #565756",
"f*\tc #3C3E3D",
"g*\tc #404243",
"h*\tc #51515D",
"i*\tc #44454F",
"j*\tc #2D271B",
"k*\tc #58451A",
"l*\tc #50411B",
"m*\tc #51431F",
"n*\tc #8B7A5A",
"o*\tc #7E6E55",
"p*\tc #372D18",
"q*\tc #3B3018",
"r*\tc #584B2E",
"s*\tc #9F8F73",
"t*\tc #B2A591",
"u*\tc #B2A490",
"v*\tc #86724A",
"w*\tc #725E2E",
"x*\tc #A39377",
"y*\tc #C5B9AA",
"z*\tc #C3B6A7",
"A*\tc #B8A997",
"B*\tc #89744C",
"C*\tc #9A876B",
"D*\tc #A18F76",
"E*\tc #826E44",
"F*\tc #84714B",
"G*\tc #927F5C",
"H*\tc #AE9E86",
"I*\tc #B5A692",
"J*\tc #BBAE9B",
"K*\tc #C1B5A5",
"L*\tc #D6CFC7",
"M*\tc #948A7D",
"N*\tc #403A30",
"O*\tc #3E3F3F",
"P*\tc #605F6F",
"Q*\tc #404249",
"R*\tc #353736",
"S*\tc #363837",
"T*\tc #3A3C3B",
"U*\tc #3E403F",
"V*\tc #4C4D55",
"W*\tc #4B4C59",
"X*\tc #302D26",
"Y*\tc #524119",
"Z*\tc #5C4B1E",
"`*\tc #50411C",
" =\tc #726447",
".=\tc #92826A",
"+=\tc #3F341D",
"@=\tc #3A3018",
"#=\tc #423619",
"$=\tc #43371D",
"%=\tc #574825",
"&=\tc #988971",
"*=\tc #AF9F89",
"==\tc #998768",
"-=\tc #7C693E",
";=\tc #7D6B45",
">=\tc #AB9D84",
",=\tc #C3B7A7",
"\'=\tc #D5CCC1",
")=\tc #D3CABE",
"!=\tc #B6A895",
"~=\tc #AD9D88",
"{=\tc #A5947E",
"]=\tc #A4927B",
"^=\tc #B3A391",
"/=\tc #A29171",
"(=\tc #7F6A3D",
"_=\tc #7E6B46",
":=\tc #8C784E",
"<=\tc #8C7951",
"[=\tc #907C59",
"}=\tc #978463",
"|=\tc #968562",
"1=\tc #C6BAA9",
"2=\tc #D9D2C9",
"3=\tc #A99E8F",
"4=\tc #4D422E",
"5=\tc #343736",
"6=\tc #595966",
"7=\tc #4C4D56",
"8=\tc #282C2B",
"9=\tc #343735",
"0=\tc #3D3F3E",
"a=\tc #47484D",
"b=\tc #58586A",
"c=\tc #50505F",
"d=\tc #302F2B",
"e=\tc #5E4E30",
"f=\tc #857554",
"g=\tc #5B4B24",
"h=\tc #5E5030",
"i=\tc #95856D",
"j=\tc #4E422A",
"k=\tc #392E18",
"l=\tc #493C1B",
"m=\tc #382E18",
"n=\tc #362D18",
"o=\tc #4E3F1C",
"p=\tc #6A5B3E",
"q=\tc #85765C",
"r=\tc #615026",
"s=\tc #816E42",
"t=\tc #C2B4A4",
"u=\tc #C3B6A6",
"v=\tc #C1B4A5",
"w=\tc #B09F8A",
"x=\tc #938160",
"y=\tc #8A7751",
"z=\tc #B1A18E",
"A=\tc #C6BAAA",
"B=\tc #978460",
"C=\tc #846F45",
"D=\tc #83704B",
"E=\tc #8E7A56",
"F=\tc #B0A08A",
"G=\tc #8D7B57",
"H=\tc #867247",
"I=\tc #AFA18A",
"J=\tc #D0C5B9",
"K=\tc #CCC1B3",
"L=\tc #C8BDAF",
"M=\tc #A3947B",
"N=\tc #625642",
"O=\tc #31302A",
"P=\tc #3F3F40",
"Q=\tc #414150",
"R=\tc #47474A",
"S=\tc #383A39",
"T=\tc #414344",
"U=\tc #545564",
"V=\tc #5A5A6F",
"W=\tc #58586C",
"X=\tc #58586D",
"Y=\tc #565769",
"Z=\tc #2E2E2C",
"`=\tc #504226",
" -\tc #735F32",
".-\tc #88764F",
"+-\tc #9B8C71",
"@-\tc #9A8971",
"#-\tc #605237",
"$-\tc #3A2F18",
"%-\tc #46391A",
"&-\tc #3D3218",
"*-\tc #352C18",
"=-\tc #392F18",
"--\tc #403418",
";-\tc #4B3D1B",
">-\tc #4C3D1C",
",-\tc #72613F",
"\'-\tc #BBAD9C",
")-\tc #CBBFB1",
"!-\tc #CDC2B5",
"~-\tc #A8977E",
"{-\tc #8C7954",
"]-\tc #99886B",
"^-\tc #7C6941",
"/-\tc #67552C",
"(-\tc #C7BAAC",
"_-\tc #A19072",
":-\tc #847047",
"<-\tc #7E6C45",
"[-\tc #B7A992",
"}-\tc #988867",
"|-\tc #7C6A42",
"1-\tc #C3B6A5",
"2-\tc #BAAC9A",
"3-\tc #B4A690",
"4-\tc #B9AC96",
"5-\tc #9D8C73",
"6-\tc #6C5C40",
"7-\tc #353025",
"8-\tc #3B3B47",
"9-\tc #353635",
"0-\tc #373937",
"a-\tc #3B3D3F",
"b-\tc #5D5D6A",
"c-\tc #5C5C6D",
"d-\tc #4A4B4C",
"e-\tc #4F505C",
"f-\tc #555569",
"g-\tc #545467",
"h-\tc #535365",
"i-\tc #515163",
"j-\tc #515061",
"k-\tc #525162",
"l-\tc #555568",
"m-\tc #3A3B41",
"n-\tc #443B26",
"o-\tc #6A5626",
"p-\tc #746134",
"q-\tc #816C3F",
"r-\tc #7B6B49",
"s-\tc #42371A",
"t-\tc #473A1A",
"u-\tc #362C18",
"v-\tc #433719",
"w-\tc #3F3318",
"x-\tc #43371A",
"y-\tc #483B1E",
"z-\tc #67593D",
"A-\tc #95815F",
"B-\tc #B6A793",
"C-\tc #93805F",
"D-\tc #8D7A59",
"E-\tc #604F28",
"F-\tc #55461D",
"G-\tc #6C5A32",
"H-\tc #A29077",
"I-\tc #BBAC9A",
"J-\tc #C1B4A4",
"K-\tc #A49479",
"L-\tc #7E693C",
"M-\tc #75633D",
"N-\tc #A59579",
"O-\tc #75633B",
"P-\tc #897751",
"Q-\tc #B5A690",
"R-\tc #AE9E88",
"S-\tc #D2C8BB",
"T-\tc #CDC2B6",
"U-\tc #D7CEC4",
"V-\tc #92805D",
"W-\tc #A09074",
"X-\tc #AFA089",
"Y-\tc #BFB2A0",
"Z-\tc #A49279",
"`-\tc #9F8D71",
" ;\tc #917E5A",
".;\tc #6A572E",
"+;\tc #3C3526",
"@;\tc #2E2F2E",
"#;\tc #303038",
"$;\tc #5B5B69",
"%;\tc #404141",
"&;\tc #45464D",
"*;\tc #4A4955",
"=;\tc #494750",
"-;\tc #3F3E44",
";;\tc #343236",
">;\tc #302A2E",
",;\tc #2B2529",
"\';\tc #2F2D36",
");\tc #4B4B5C",
"!;\tc #42444D",
"~;\tc #39342A",
"{;\tc #67562F",
"];\tc #665326",
"^;\tc #766337",
"/;\tc #897551",
"(;\tc #84704A",
"_;\tc #5C4B20",
":;\tc #5B4A1F",
"<;\tc #51431D",
"[;\tc #3E3318",
"};\tc #483C20",
"|;\tc #5E4F2E",
"1;\tc #60502C",
"2;\tc #3B3118",
"3;\tc #675630",
"4;\tc #695831",
"5;\tc #705E35",
"6;\tc #826F46",
"7;\tc #88744C",
"8;\tc #7C6736",
"9;\tc #66532A",
"0;\tc #55451D",
"a;\tc #53441F",
"b;\tc #B1A18D",
"c;\tc #A99983",
"d;\tc #CABEB1",
"e;\tc #A18F71",
"f;\tc #776231",
"g;\tc #716039",
"h;\tc #867249",
"i;\tc #93805D",
"j;\tc #917D5A",
"k;\tc #836E43",
"l;\tc #7E6939",
"m;\tc #CBC0B3",
"n;\tc #C7BBAE",
"o;\tc #C0B2A3",
"p;\tc #CCC1B4",
"q;\tc #B1A18C",
"r;\tc #796841",
"s;\tc #948468",
"t;\tc #A8987D",
"u;\tc #D4CABE",
"v;\tc #BCAF9D",
"w;\tc #A49478",
"x;\tc #988663",
"y;\tc #8F7B55",
"z;\tc #4C412D",
"A;\tc #28292E",
"B;\tc #545466",
"C;\tc #464855",
"D;\tc #383A3B",
"E;\tc #444444",
"F;\tc #353636",
"G;\tc #323130",
"H;\tc #2B2A27",
"I;\tc #1D1A19",
"J;\tc #161513",
"K;\tc #110D0C",
"L;\tc #0B0706",
"M;\tc #0A0503",
"N;\tc #0E0805",
"O;\tc #0F0A08",
"P;\tc #26252D",
"Q;\tc #464656",
"R;\tc #505062",
"S;\tc #56566A",
"T;\tc #74644A",
"U;\tc #83724E",
"V;\tc #81704C",
"W;\tc #796539",
"X;\tc #7C6942",
"Y;\tc #5A4920",
"Z;\tc #665321",
"`;\tc #5A4A1E",
" >\tc #584925",
".>\tc #655632",
"+>\tc #816E4A",
"@>\tc #706143",
"#>\tc #77694D",
"$>\tc #4F4221",
"%>\tc #3D3118",
"&>\tc #4E401F",
"*>\tc #675835",
"=>\tc #524424",
"->\tc #483B1C",
";>\tc #786335",
">>\tc #786331",
",>\tc #635123",
"\'>\tc #4A3D1A",
")>\tc #6A5624",
"!>\tc #978564",
"~>\tc #B4A492",
"{>\tc #847352",
"]>\tc #82704C",
"^>\tc #A49379",
"/>\tc #B5A592",
"(>\tc #A9987E",
"_>\tc #AFA087",
":>\tc #77653C",
"<>\tc #6A5932",
"[>\tc #9D8A6F",
"}>\tc #B1A28E",
"|>\tc #A7957D",
"1>\tc #927F5D",
"2>\tc #7F6B41",
"3>\tc #827252",
"4>\tc #BEB1A0",
"5>\tc #C1B3A3",
"6>\tc #7D6C47",
"7>\tc #948366",
"8>\tc #AC9B84",
"9>\tc #BBAD9B",
"0>\tc #A29277",
"a>\tc #695934",
"b>\tc #8D7852",
"c>\tc #736038",
"d>\tc #6B592F",
"e>\tc #806C41",
"f>\tc #978666",
"g>\tc #645845",
"h>\tc #302F2C",
"i>\tc #38393D",
"j>\tc #545560",
"k>\tc #333433",
"l>\tc #252120",
"m>\tc #0C0707",
"n>\tc #070201",
"o>\tc #090603",
"p>\tc #060401",
"q>\tc #060301",
"r>\tc #070301",
"s>\tc #070303",
"t>\tc #1F1D22",
"u>\tc #373743",
"v>\tc #444453",
"w>\tc #4E4E60",
"x>\tc #515160",
"y>\tc #303132",
"z>\tc #665A47",
"A>\tc #BAB1A4",
"B>\tc #8D7952",
"C>\tc #625022",
"D>\tc #54441C",
"E>\tc #554622",
"F>\tc #72603C",
"G>\tc #534520",
"H>\tc #6F5D34",
"I>\tc #74623B",
"J>\tc #4B3E1B",
"K>\tc #4F411C",
"L>\tc #4F401B",
"M>\tc #493B1A",
"N>\tc #4D3E1B",
"O>\tc #463A19",
"P>\tc #3C3118",
"Q>\tc #3F3319",
"R>\tc #60502B",
"S>\tc #5D4B20",
"T>\tc #695628",
"U>\tc #A08F70",
"V>\tc #B5A693",
"W>\tc #6E5C2E",
"X>\tc #6B5932",
"Y>\tc #917E60",
"Z>\tc #86724C",
"`>\tc #A39477",
" ,\tc #B3A58F",
".,\tc #5B4C28",
"+,\tc #584924",
"@,\tc #A29178",
"#,\tc #AA9983",
"$,\tc #CEC4B7",
"%,\tc #AD9D87",
"&,\tc #8B7751",
"*,\tc #7D693E",
"=,\tc #7A6948",
"-,\tc #CBC0B2",
";,\tc #897652",
">,\tc #8D7C5D",
",,\tc #9B8868",
"\',\tc #88744B",
"),\tc #7C6B45",
"!,\tc #907D58",
"~,\tc #8F7D5C",
"{,\tc #958465",
"],\tc #A29175",
"^,\tc #C5BBB0",
"/,\tc #7F7566",
"(,\tc #39342B",
"_,\tc #3B3A42",
":,\tc #505163",
"<,\tc #2C2E31",
"[,\tc #2A2929",
"},\tc #181212",
"|,\tc #0B0202",
"1,\tc #0D0605",
"2,\tc #070603",
"3,\tc #020100",
"4,\tc #030200",
"5,\tc #18161A",
"6,\tc #2C2B35",
"7,\tc #393946",
"8,\tc #454555",
"9,\tc #4F4F61",
"0,\tc #37393C",
"a,\tc #574D3B",
"b,\tc #ACA294",
"c,\tc #CABEAF",
"d,\tc #AA997F",
"e,\tc #998766",
"f,\tc #917E5B",
"g,\tc #65542A",
"h,\tc #665632",
"i,\tc #54451E",
"j,\tc #7A6A4A",
"k,\tc #938165",
"l,\tc #4D3F1D",
"m,\tc #4A3C1A",
"n,\tc #7A6741",
"o,\tc #6B582E",
"p,\tc #54462A",
"q,\tc #4E4021",
"r,\tc #4D3E1C",
"s,\tc #6D5B37",
"t,\tc #847250",
"u,\tc #AC9C82",
"v,\tc #7C6735",
"w,\tc #8D7A5A",
"x,\tc #917E5E",
"y,\tc #7D6A40",
"z,\tc #BBAF9C",
"A,\tc #A89A82",
"B,\tc #554725",
"C,\tc #6A5931",
"D,\tc #695830",
"E,\tc #B0A38D",
"F,\tc #AD9E88",
"G,\tc #8C7850",
"H,\tc #7B673B",
"I,\tc #766540",
"J,\tc #B8AA95",
"K,\tc #CCC0B2",
"L,\tc #C1B4A3",
"M,\tc #8C7B59",
"N,\tc #867555",
"O,\tc #9C8969",
"P,\tc #968464",
"Q,\tc #8A7954",
"R,\tc #8F7E5C",
"S,\tc #A6967C",
"T,\tc #D2C9BE",
"U,\tc #C1B6A7",
"V,\tc #837660",
"W,\tc #453F35",
"X,\tc #393A3C",
"Y,\tc #2F3235",
"Z,\tc #232220",
"`,\tc #110C0B",
" \'\tc #0E0504",
".\'\tc #090100",
"+\'\tc #090202",
"@\'\tc #090403",
"#\'\tc #070402",
"$\'\tc #030301",
"%\'\tc #030302",
"&\'\tc #0D0D0E",
"*\'\tc #222228",
"=\'\tc #31313D",
"-\'\tc #3F3F4D",
";\'\tc #4A4A5B",
">\'\tc #3D3F45",
",\'\tc #484032",
"\'\'\tc #9B9181",
")\'\tc #D3CABF",
"!\'\tc #D1C7BB",
"~\'\tc #C0B3A1",
"{\'\tc #998664",
"]\'\tc #695832",
"^\'\tc #73623D",
"/\'\tc #65532A",
"(\'\tc #827254",
"_\'\tc #907D61",
":\'\tc #4B3D1D",
"<\'\tc #4E401E",
"[\'\tc #705D2D",
"}\'\tc #786436",
"|\'\tc #52441F",
"1\'\tc #3D3318",
"2\'\tc #6A5A39",
"3\'\tc #4A3D1C",
"4\'\tc #655531",
"5\'\tc #A39278",
"6\'\tc #BBAD9A",
"7\'\tc #C0B2A2",
"8\'\tc #948266",
"9\'\tc #7D6A44",
"0\'\tc #897959",
"a\'\tc #C9BDAF",
"b\'\tc #C7BAAB",
"c\'\tc #574821",
"d\'\tc #715E2F",
"e\'\tc #4E401C",
"f\'\tc #AC9E89",
"g\'\tc #AE9F89",
"h\'\tc #8B7750",
"i\'\tc #7F6B40",
"j\'\tc #A89980",
"k\'\tc #C8BBAD",
"l\'\tc #C8BCAD",
"m\'\tc #CABDAF",
"n\'\tc #8D7B59",
"o\'\tc #83714D",
"p\'\tc #9A8969",
"q\'\tc #A89880",
"r\'\tc #A79981",
"s\'\tc #B9AB99",
"t\'\tc #907F5D",
"u\'\tc #9E8D70",
"v\'\tc #AAA093",
"w\'\tc #544E41",
"x\'\tc #2A2A29",
"y\'\tc #2A2B29",
"z\'\tc #1B1917",
"A\'\tc #0A0301",
"B\'\tc #0D0302",
"C\'\tc #0C0201",
"D\'\tc #0A0101",
"E\'\tc #040402",
"F\'\tc #040404",
"G\'\tc #19191A",
"H\'\tc #3E3E41",
"I\'\tc #383844",
"J\'\tc #474757",
"K\'\tc #505063",
"L\'\tc #41424B",
"M\'\tc #3A362C",
"N\'\tc #8D816F",
"O\'\tc #CEC5BA",
"P\'\tc #CDC1B4",
"Q\'\tc #AD9D84",
"R\'\tc #988666",
"S\'\tc #948260",
"T\'\tc #BCAE9D",
"U\'\tc #B2A28F",
"V\'\tc #9B896E",
"W\'\tc #453919",
"X\'\tc #58471E",
"Y\'\tc #4D3F1B",
"Z\'\tc #423618",
"`\'\tc #453819",
" )\tc #423719",
".)\tc #3F3418",
"+)\tc #4F4123",
"@)\tc #816F49",
"#)\tc #AF9F88",
"$)\tc #C6B9AA",
"%)\tc #7E6F51",
"&)\tc #635434",
"*)\tc #75633C",
"=)\tc #6C5C38",
"-)\tc #635530",
";)\tc #B1A38E",
">)\tc #9B8A69",
",)\tc #7D6A41",
"\')\tc #625025",
"))\tc #52431E",
"!)\tc #665429",
"~)\tc #8C7B5C",
"{)\tc #8D7953",
"])\tc #806C44",
"^)\tc #514221",
"/)\tc #9C8D73",
"()\tc #C5B8AA",
"_)\tc #938262",
":)\tc #726240",
"<)\tc #9B8A6E",
"[)\tc #A29172",
"})\tc #B0A08B",
"|)\tc #78663D",
"1)\tc #988769",
"2)\tc #D0C6BA",
"3)\tc #BFB7AC",
"4)\tc #64594A",
"5)\tc #2F2F2B",
"6)\tc #242523",
"7)\tc #100E0C",
"8)\tc #070401",
"9)\tc #080401",
"0)\tc #0C0301",
"a)\tc #080000",
"b)\tc #050000",
"c)\tc #040100",
"d)\tc #060503",
"e)\tc #0E0F0F",
"f)\tc #414140",
"g)\tc #292928",
"h)\tc #767676",
"i)\tc #353639",
"j)\tc #5E5E6C",
"k)\tc #4C4C59",
"l)\tc #32302A",
"m)\tc #7A6E59",
"n)\tc #C8BFB4",
"o)\tc #B4A592",
"p)\tc #B5A593",
"q)\tc #736034",
"r)\tc #56471E",
"s)\tc #403518",
"t)\tc #413618",
"u)\tc #433718",
"v)\tc #403419",
"w)\tc #44381C",
"x)\tc #817255",
"y)\tc #B6A892",
"z)\tc #96866A",
"A)\tc #8E7D60",
"B)\tc #4D4122",
"C)\tc #564824",
"D)\tc #897657",
"E)\tc #A99881",
"F)\tc #BEB09E",
"G)\tc #736342",
"H)\tc #6B5933",
"I)\tc #50411E",
"J)\tc #6B5931",
"K)\tc #7B6A49",
"L)\tc #BBAC9B",
"M)\tc #B9AC99",
"N)\tc #C2B5A6",
"O)\tc #AA9A85",
"P)\tc #655530",
"Q)\tc #7F6B43",
"R)\tc #7D693F",
"S)\tc #8A7752",
"T)\tc #C0B2A1",
"U)\tc #C9BCAE",
"V)\tc #C5B8A8",
"W)\tc #908062",
"X)\tc #796742",
"Y)\tc #907E5D",
"Z)\tc #9C8C6D",
"`)\tc #635432",
" !\tc #908266",
".!\tc #9E8E74",
"+!\tc #D2C9BD",
"@!\tc #D5CDC3",
"#!\tc #D2CAC2",
"$!\tc #BAB3AA",
"%!\tc #665F54",
"&!\tc #1F1F1B",
"*!\tc #090705",
"=!\tc #080502",
"-!\tc #080200",
";!\tc #060000",
">!\tc #060101",
",!\tc #080404",
"\'!\tc #121211",
")!\tc #161716",
"!!\tc #3B3B3A",
"~!\tc #6C6C6C",
"{!\tc #727272",
"]!\tc #99999D",
"^!\tc #606072",
"/!\tc #545465",
"(!\tc #32312E",
"_!\tc #655845",
":!\tc #BFB5AA",
"<!\tc #C9BFB0",
"[!\tc #9C8B6E",
"}!\tc #89754E",
"|!\tc #8F7C59",
"1!\tc #776436",
"2!\tc #3E3218",
"3!\tc #7A6B4E",
"4!\tc #B3A692",
"5!\tc #5E4E2A",
"6!\tc #645225",
"7!\tc #45391B",
"8!\tc #5A4B26",
"9!\tc #9E8D71",
"0!\tc #A99882",
"a!\tc #78643C",
"b!\tc #665428",
"c!\tc #4A3D1B",
"d!\tc #534522",
"e!\tc #A0927A",
"f!\tc #A6967F",
"g!\tc #8B7C5E",
"h!\tc #B8A998",
"i!\tc #8C7A59",
"j!\tc #968365",
"k!\tc #4C3E1F",
"l!\tc #5F4E21",
"m!\tc #998968",
"n!\tc #99886A",
"o!\tc #6A5A33",
"p!\tc #82704F",
"q!\tc #7A6841",
"r!\tc #907F5E",
"s!\tc #B5A894",
"t!\tc #BAAD9B",
"u!\tc #C5BAAC",
"v!\tc #CDC5BC",
"w!\tc #C1BAB2",
"x!\tc #827F79",
"y!\tc #2C2B28",
"z!\tc #080500",
"A!\tc #060300",
"B!\tc #070200",
"C!\tc #070100",
"D!\tc #060200",
"E!\tc #0A0705",
"F!\tc #100F0F",
"G!\tc #1F201F",
"H!\tc #272827",
"I!\tc #383937",
"J!\tc #6E6E7F",
"K!\tc #3A3C3F",
"L!\tc #30312F",
"M!\tc #564C3B",
"N!\tc #ADA395",
"O!\tc #D1C8BC",
"P!\tc #978A72",
"Q!\tc #705B28",
"R!\tc #685424",
"S!\tc #413519",
"T!\tc #504323",
"U!\tc #BDAE9D",
"V!\tc #BDAF9F",
"W!\tc #72644A",
"X!\tc #5B4A20",
"Y!\tc #403519",
"Z!\tc #534528",
"`!\tc #837250",
" ~\tc #A08F77",
".~\tc #8F7D58",
"+~\tc #6D5A28",
"@~\tc #716247",
"#~\tc #A79781",
"$~\tc #645536",
"%~\tc #998B74",
"&~\tc #887653",
"*~\tc #8B7855",
"=~\tc #9D8B71",
"-~\tc #AC9B87",
";~\tc #857454",
">~\tc #5C4C24",
",~\tc #594A1F",
"\'~\tc #A5967D",
")~\tc #BFB2A2",
"!~\tc #9A8A6E",
"~~\tc #6E5D39",
"{~\tc #8F7D5B",
"]~\tc #8F7C56",
"^~\tc #A89882",
"/~\tc #A69985",
"(~\tc #B2ABA3",
"_~\tc #686561",
":~\tc #181716",
"<~\tc #040300",
"[~\tc #050200",
"}~\tc #040000",
"|~\tc #050100",
"1~\tc #0B0806",
"2~\tc #0F0E0E",
"3~\tc #161616",
"4~\tc #1E1F1F",
"5~\tc #262827",
"6~\tc #565662",
"7~\tc #3F4147",
"8~\tc #473F31",
"9~\tc #9A8F7E",
"0~\tc #918061",
"a~\tc #6A5723",
"b~\tc #614F20",
"c~\tc #584821",
"d~\tc #5B4C27",
"e~\tc #473919",
"f~\tc #69562B",
"g~\tc #887657",
"h~\tc #78694C",
"i~\tc #6A5D41",
"j~\tc #403619",
"k~\tc #4C3E1B",
"l~\tc #5E4E28",
"m~\tc #695937",
"n~\tc #584A2D",
"o~\tc #534521",
"p~\tc #423519",
"q~\tc #55482D",
"r~\tc #A29179",
"s~\tc #9C8A6C",
"t~\tc #6B5C3C",
"u~\tc #524524",
"v~\tc #A3937C",
"w~\tc #AF9F8B",
"x~\tc #BEAF9F",
"y~\tc #8F7E62",
"z~\tc #5C4B24",
"A~\tc #9B886D",
"B~\tc #958365",
"C~\tc #857041",
"D~\tc #6F5A27",
"E~\tc #6B5B3A",
"F~\tc #AEA18D",
"G~\tc #AF9F8A",
"H~\tc #B2A38E",
"I~\tc #B1A290",
"J~\tc #AEA190",
"K~\tc #998B76",
"L~\tc #8F8579",
"M~\tc #494440",
"N~\tc #050303",
"O~\tc #030100",
"P~\tc #070302",
"Q~\tc #0B0A08",
"R~\tc #111110",
"S~\tc #151615",
"T~\tc #1E1F1E",
"U~\tc #262727",
"V~\tc #494953",
"W~\tc #3B362D",
"X~\tc #CFC7BC",
"Y~\tc #D1C6BA",
"Z~\tc #67552A",
"`~\tc #5D4C1F",
" {\tc #635125",
".{\tc #6E5C33",
"+{\tc #4A3C1B",
"@{\tc #44381A",
"#{\tc #4C3E1D",
"${\tc #645122",
"%{\tc #816E47",
"&{\tc #796A4C",
"*{\tc #473B1D",
"={\tc #52431C",
"-{\tc #4E401B",
";{\tc #5A491F",
">{\tc #51421E",
",{\tc #6B5930",
"\'{\tc #493C1E",
"){\tc #44371A",
"!{\tc #827154",
"~{\tc #907C5B",
"{{\tc #705E3A",
"]{\tc #42361A",
"^{\tc #645636",
"/{\tc #8B7753",
"({\tc #938162",
"_{\tc #86724B",
":{\tc #857149",
"<{\tc #675732",
"[{\tc #9D8E78",
"}{\tc #C6BCAE",
"|{\tc #C3B9AE",
"1{\tc #756E66",
"2{\tc #27221F",
"3{\tc #030000",
"4{\tc #030101",
"5{\tc #0B0B09",
"6{\tc #111111",
"7{\tc #161717",
"8{\tc #1D1E1E",
"9{\tc #252626",
"0{\tc #45474D",
"a{\tc #474854",
"b{\tc #34312B",
"c{\tc #7C6F5C",
"d{\tc #C7BEB3",
"e{\tc #D3C9BE",
"f{\tc #9B8C74",
"g{\tc #67593C",
"h{\tc #B8AA98",
"i{\tc #4F4220",
"j{\tc #463919",
"k{\tc #493B1B",
"l{\tc #504221",
"m{\tc #725F34",
"n{\tc #826D40",
"o{\tc #78653A",
"p{\tc #80704E",
"q{\tc #594B2A",
"r{\tc #726241",
"s{\tc #695A38",
"t{\tc #746136",
"u{\tc #6D5A2A",
"v{\tc #635224",
"w{\tc #7A673F",
"x{\tc #5C4C25",
"y{\tc #483B1D",
"z{\tc #928062",
"A{\tc #705E39",
"B{\tc #3E331A",
"C{\tc #5D4D27",
"D{\tc #8C7957",
"E{\tc #7A6946",
"F{\tc #AD9C87",
"G{\tc #756441",
"H{\tc #69572F",
"I{\tc #5F4E27",
"J{\tc #6F5E39",
"K{\tc #B5A591",
"L{\tc #9A886D",
"M{\tc #534420",
"N{\tc #68572F",
"O{\tc #786434",
"P{\tc #66542B",
"Q{\tc #8B7D64",
"R{\tc #BAAD9D",
"S{\tc #A09079",
"T{\tc #B3A798",
"U{\tc #A89E94",
"V{\tc #524C47",
"W{\tc #171210",
"X{\tc #090503",
"Y{\tc #060100",
"Z{\tc #070504",
"`{\tc #1A1816",
" ]\tc #1A1714",
".]\tc #242625",
"+]\tc #404144",
"@]\tc #535364",
"#]\tc #2D2D2D",
"$]\tc #31302E",
"%]\tc #5C4E37",
"&]\tc #BCB3A8",
"*]\tc #BBAE9D",
"=]\tc #574A2E",
"-]\tc #514325",
";]\tc #9F917A",
">]\tc #8A7B60",
",]\tc #4F401C",
"\']\tc #4D3F1C",
")]\tc #443718",
"!]\tc #4C3F20",
"~]\tc #8B7C60",
"{]\tc #907C53",
"]]\tc #907C58",
"^]\tc #796535",
"/]\tc #736032",
"(]\tc #7E6B45",
"_]\tc #7C6C4C",
":]\tc #A6977F",
"<]\tc #917D5D",
"[]\tc #8B7752",
"}]\tc #826E47",
"|]\tc #7D6940",
"1]\tc #685629",
"2]\tc #4F411D",
"3]\tc #806E4D",
"4]\tc #837150",
"5]\tc #42361B",
"6]\tc #473B1F",
"7]\tc #685835",
"8]\tc #675736",
"9]\tc #79663F",
"0]\tc #4E3F1F",
"a]\tc #483B1A",
"b]\tc #56471F",
"c]\tc #8A7854",
"d]\tc #5E4D21",
"e]\tc #5B4B2B",
"f]\tc #826F47",
"g]\tc #715C28",
"h]\tc #5B4A22",
"i]\tc #837459",
"j]\tc #B3A696",
"k]\tc #A89C8E",
"l]\tc #847A70",
"m]\tc #403B36",
"n]\tc #0A0604",
"o]\tc #050201",
"p]\tc #0D0908",
"q]\tc #262422",
"r]\tc #45433F",
"s]\tc #514C47",
"t]\tc #2F2B24",
"u]\tc #252625",
"v]\tc #3A3B3C",
"w]\tc #555666",
"x]\tc #333336",
"y]\tc #3F3F44",
"z]\tc #52515D",
"A]\tc #3C3B3F",
"B]\tc #2E2D2C",
"C]\tc #4D3E29",
"D]\tc #9D9281",
"E]\tc #D0C8BE",
"F]\tc #D7CEC2",
"G]\tc #94866D",
"H]\tc #786A4B",
"I]\tc #6E6147",
"J]\tc #463A1B",
"K]\tc #4D4022",
"L]\tc #A0947D",
"M]\tc #C1B5A3",
"N]\tc #9E8D6E",
"O]\tc #8C7953",
"P]\tc #776338",
"Q]\tc #74623C",
"R]\tc #938062",
"S]\tc #948061",
"T]\tc #7F6C45",
"U]\tc #72613C",
"V]\tc #5B4B21",
"W]\tc #8F7C5D",
"X]\tc #5F502E",
"Y]\tc #6E5F40",
"Z]\tc #8F7B57",
"`]\tc #917F5F",
" ^\tc #827150",
".^\tc #6A582E",
"+^\tc #958264",
"@^\tc #816E49",
"#^\tc #5E4E27",
"$^\tc #5E4C1F",
"%^\tc #645121",
"&^\tc #604D20",
"*^\tc #5F4D1F",
"=^\tc #74602D",
"-^\tc #8C795A",
";^\tc #A6957E",
">^\tc #8A7750",
",^\tc #6B5726",
"\'^\tc #6C6047",
")^\tc #625B51",
"!^\tc #231F1C",
"~^\tc #080402",
"{^\tc #0B0302",
"]^\tc #110B09",
"^^\tc #2B2826",
"/^\tc #4B4845",
"(^\tc #67635F",
"_^\tc #746E69",
":^\tc #393834",
"<^\tc #363838",
"[^\tc #50505D",
"}^\tc #3B3B43",
"|^\tc #323337",
"1^\tc #4B4B4F",
"2^\tc #433927",
"3^\tc #877864",
"4^\tc #C9C1B6",
"5^\tc #5F5236",
"6^\tc #6C5E3E",
"7^\tc #695B3B",
"8^\tc #3E3418",
"9^\tc #4D4121",
"0^\tc #ADA18C",
"a^\tc #9E8F74",
"b^\tc #93815D",
"c^\tc #88744D",
"d^\tc #7D6941",
"e^\tc #948465",
"f^\tc #A29275",
"g^\tc #9C8970",
"h^\tc #968366",
"i^\tc #A89780",
"j^\tc #C1B3A4",
"k^\tc #A6957D",
"l^\tc #8F7B5A",
"m^\tc #8D7956",
"n^\tc #756130",
"o^\tc #5F5030",
"p^\tc #3A2F19",
"q^\tc #917D5B",
"r^\tc #958265",
"s^\tc #78663E",
"t^\tc #7A6536",
"u^\tc #5D4B21",
"v^\tc #6E5923",
"w^\tc #6B5722",
"x^\tc #675321",
"y^\tc #6D5928",
"z^\tc #988564",
"A^\tc #B1A390",
"B^\tc #AA9B87",
"C^\tc #8A795B",
"D^\tc #2A2415",
"E^\tc #080504",
"F^\tc #0B0704",
"G^\tc #140F0B",
"H^\tc #292520",
"I^\tc #47433E",
"J^\tc #6A6560",
"K^\tc #7F7972",
"L^\tc #504D47",
"M^\tc #272928",
"N^\tc #313231",
"O^\tc #474850",
"P^\tc #43434E",
"Q^\tc #2A2C2F",
"R^\tc #5E5D71",
"S^\tc #383229",
"T^\tc #6E5D47",
"U^\tc #B8AEA2",
"V^\tc #DCD4CA",
"W^\tc #CFC5B9",
"X^\tc #93856A",
"Y^\tc #493C1C",
"Z^\tc #5E5132",
"`^\tc #6D5E44",
" /\tc #413619",
"./\tc #6A5C3B",
"+/\tc #B8AD9A",
"@/\tc #B4A58F",
"#/\tc #806E45",
"$/\tc #726138",
"%/\tc #9E8C71",
"&/\tc #746135",
"*/\tc #79663D",
"=/\tc #9C896B",
"-/\tc #B7A895",
";/\tc #8B774F",
">/\tc #685525",
",/\tc #41361F",
"\'/\tc #867454",
")/\tc #826F4A",
"!/\tc #574721",
"~/\tc #816F4F",
"{/\tc #675421",
"]/\tc #614F1F",
"^/\tc #54451C",
"//\tc #635226",
"(/\tc #968463",
"_/\tc #B6A897",
":/\tc #AFA08F",
"</\tc #A49888",
"[/\tc #73695E",
"}/\tc #231D16",
"|/\tc #050101",
"1/\tc #181513",
"2/\tc #383431",
"3/\tc #4E4A44",
"4/\tc #615A50",
"5/\tc #73695D",
"6/\tc #5B554C",
"7/\tc #2D2D2B",
"8/\tc #343534",
"9/\tc #414349",
"0/\tc #535366",
"a/\tc #525264",
"b/\tc #4A4A56",
"c/\tc #2D3031",
"d/\tc #484957",
"e/\tc #33312A",
"f/\tc #5D4E38",
"g/\tc #ACA192",
"h/\tc #D7CFC6",
"i/\tc #8E7D5D",
"j/\tc #544621",
"k/\tc #B4A792",
"l/\tc #8D7F66",
"m/\tc #41351B",
"n/\tc #594D30",
"o/\tc #ADA28F",
"p/\tc #CBC1B3",
"q/\tc #B7A896",
"r/\tc #A39178",
"s/\tc #816E44",
"t/\tc #836E3E",
"u/\tc #AD9D85",
"v/\tc #9A886A",
"w/\tc #776645",
"x/\tc #3F3519",
"y/\tc #3E331C",
"z/\tc #6E6044",
"A/\tc #483C23",
"B/\tc #6E5E3F",
"C/\tc #837151",
"D/\tc #53441E",
"E/\tc #6F5D33",
"F/\tc #927E5E",
"G/\tc #6B592D",
"H/\tc #54451D",
"I/\tc #6A5832",
"J/\tc #978569",
"K/\tc #AFA08E",
"L/\tc #ADA08F",
"M/\tc #998D7F",
"N/\tc #565048",
"O/\tc #181412",
"P/\tc #040001",
"Q/\tc #060201",
"R/\tc #090604",
"S/\tc #16130F",
"T/\tc #211C11",
"U/\tc #383022",
"V/\tc #60584B",
"W/\tc #827B71",
"X/\tc #706A63",
"Y/\tc #2F302E",
"Z/\tc #323432",
"`/\tc #3B3D3E",
" (\tc #535362",
".(\tc #525260",
"+(\tc #53535D",
"@(\tc #555559",
"#(\tc #565554",
"$(\tc #525150",
"%(\tc #4F4D4E",
"&(\tc #4D4B4D",
"*(\tc #49464F",
"=(\tc #4B4A5B",
"-(\tc #525363",
";(\tc #323435",
">(\tc #5E5D6D",
",(\tc #30302C",
"\'(\tc #50422E",
")(\tc #9B8F7E",
"!(\tc #C9BEB0",
"~(\tc #9F8E75",
"{(\tc #78663C",
"](\tc #7F7050",
"^(\tc #A99B87",
"/(\tc #4B3D1C",
"((\tc #594D33",
"_(\tc #BAAF9D",
":(\tc #D9D1C6",
"<(\tc #BDB09F",
"[(\tc #BBAC9C",
"}(\tc #978462",
"|(\tc #7B6637",
"1(\tc #7E6938",
"2(\tc #95825F",
"3(\tc #A19075",
"4(\tc #A28F76",
"5(\tc #9E8C72",
"6(\tc #594B2C",
"7(\tc #534421",
"8(\tc #4E4122",
"9(\tc #473A1C",
"0(\tc #4B3E1F",
"a(\tc #705F37",
"b(\tc #51421C",
"c(\tc #61512B",
"d(\tc #9E8E75",
"e(\tc #A59887",
"f(\tc #897F73",
"g(\tc #3F3A34",
"h(\tc #0E0C09",
"i(\tc #050102",
"j(\tc #060302",
"k(\tc #110E0C",
"l(\tc #25221E",
"m(\tc #332F28",
"n(\tc #3B3427",
"o(\tc #423721",
"p(\tc #5A4D34",
"q(\tc #665B47",
"r(\tc #363531",
"s(\tc #2D2E2C",
"t(\tc #2F312E",
"u(\tc #4B4B59",
"v(\tc #52515F",
"w(\tc #535158",
"x(\tc #4E4D50",
"y(\tc #464546",
"z(\tc #434344",
"A(\tc #2E2E2B",
"B(\tc #29271C",
"C(\tc #222015",
"D(\tc #1D1A11",
"E(\tc #1B1811",
"F(\tc #181512",
"G(\tc #222125",
"H(\tc #37393B",
"I(\tc #454651",
"J(\tc #444247",
"K(\tc #443927",
"L(\tc #877965",
"M(\tc #C9C0B5",
"N(\tc #CDC2B4",
"O(\tc #94825E",
"P(\tc #87785B",
"Q(\tc #6D6045",
"R(\tc #C3B9AA",
"S(\tc #D1C7BC",
"T(\tc #B3A38F",
"U(\tc #B1A08C",
"V(\tc #8D7A58",
"W(\tc #826E46",
"X(\tc #A08E73",
"Y(\tc #8E7B58",
"Z(\tc #A6967D",
"`(\tc #7E6C49",
" _\tc #635229",
"._\tc #725E31",
"+_\tc #766440",
"@_\tc #66552F",
"#_\tc #705C2F",
"$_\tc #8C7A58",
"%_\tc #806D48",
"&_\tc #857556",
"*_\tc #70685B",
"=_\tc #262521",
"-_\tc #050402",
";_\tc #0B0805",
">_\tc #100D0A",
",_\tc #2B2724",
"\'_\tc #3D3935",
")_\tc #4F4943",
"!_\tc #5F574C",
"~_\tc #4A3E23",
"{_\tc #63563E",
"]_\tc #403C34",
"^_\tc #313230",
"/_\tc #3D3F3B",
"(_\tc #4F4F53",
"__\tc #58565D",
":_\tc #575557",
"<_\tc #4D4B4B",
"[_\tc #3F3B3A",
"}_\tc #33302C",
"|_\tc #27241E",
"1_\tc #16140C",
"2_\tc #15140C",
"3_\tc #100F09",
"4_\tc #0E0D06",
"5_\tc #0C0B01",
"6_\tc #0F0D03",
"7_\tc #0F0D04",
"8_\tc #13100D",
"9_\tc #212025",
"0_\tc #353440",
"a_\tc #444454",
"b_\tc #404146",
"c_\tc #333533",
"d_\tc #38383F",
"e_\tc #555564",
"f_\tc #48484D",
"g_\tc #373028",
"h_\tc #6D5D46",
"i_\tc #BAB1A5",
"j_\tc #A4957E",
"k_\tc #5D4C21",
"l_\tc #483B1B",
"m_\tc #82765C",
"n_\tc #D9D0C5",
"o_\tc #AD9D83",
"p_\tc #846F40",
"q_\tc #9C896C",
"r_\tc #9B886B",
"s_\tc #AB9B85",
"t_\tc #9A876D",
"u_\tc #A4927D",
"v_\tc #9A886C",
"w_\tc #9A876A",
"x_\tc #A18F78",
"y_\tc #837049",
"z_\tc #8D7B5A",
"A_\tc #57471E",
"B_\tc #5E4D1F",
"C_\tc #4E401D",
"D_\tc #705D33",
"E_\tc #766541",
"F_\tc #332A17",
"G_\tc #3A3017",
"H_\tc #6C5C3B",
"I_\tc #766544",
"J_\tc #8A785B",
"K_\tc #78694E",
"L_\tc #4B4539",
"M_\tc #11110C",
"N_\tc #040301",
"O_\tc #060402",
"P_\tc #120F0C",
"Q_\tc #2B2824",
"R_\tc #383430",
"S_\tc #4E4943",
"T_\tc #625C54",
"U_\tc #676053",
"V_\tc #473F2A",
"W_\tc #4F4C41",
"X_\tc #4C4F49",
"Y_\tc #52544E",
"Z_\tc #4E4E47",
"`_\tc #47443F",
" :\tc #3A3631",
".:\tc #2A2722",
"+:\tc #1D1A14",
"@:\tc #17140F",
"#:\tc #100D08",
"$:\tc #0A0702",
"%:\tc #0C0903",
"&:\tc #0F0C05",
"*:\tc #131006",
"=:\tc #110F04",
"-:\tc #0C0B02",
";:\tc #090804",
">:\tc #090902",
",:\tc #0A0906",
"\':\tc #181819",
"):\tc #27272E",
"!:\tc #32323D",
"~:\tc #3C3C49",
"{:\tc #4A4B55",
"]:\tc #545554",
"^:\tc #3C3C3B",
"/:\tc #333434",
"(:\tc #A1A19F",
"_:\tc #545354",
"::\tc #31322F",
"<:\tc #2B2D2A",
"[:\tc #2B2C2D",
"}:\tc #4E4F5B",
"|:\tc #585765",
"1:\tc #333437",
"2:\tc #5B4A31",
"3:\tc #CBC1B4",
"4:\tc #68562A",
"5:\tc #857658",
"6:\tc #CBC1B2",
"7:\tc #CEC2B5",
"8:\tc #907D55",
"9:\tc #766028",
"0:\tc #7A642E",
"a:\tc #836F3F",
"b:\tc #B0A086",
"c:\tc #9D8A72",
"d:\tc #A2917A",
"e:\tc #9C8A70",
"f:\tc #8C7956",
"g:\tc #988568",
"h:\tc #73613A",
"i:\tc #5F4E20",
"j:\tc #5C4B1F",
"k:\tc #473B23",
"l:\tc #524428",
"m:\tc #342B17",
"n:\tc #322915",
"o:\tc #504329",
"p:\tc #8A7A60",
"q:\tc #9A8973",
"r:\tc #92836F",
"s:\tc #695E4C",
"t:\tc #2C2923",
"u:\tc #060604",
"v:\tc #040501",
"w:\tc #060501",
"x:\tc #14120F",
"y:\tc #24211E",
"z:\tc #322F2B",
"A:\tc #46423D",
"B:\tc #5B554F",
"C:\tc #65605A",
"D:\tc #5D5B54",
"E:\tc #4F5249",
"F:\tc #3B3F37",
"G:\tc #303329",
"H:\tc #232319",
"I:\tc #1D1910",
"J:\tc #150F07",
"K:\tc #100C05",
"L:\tc #0F0C04",
"M:\tc #110E06",
"N:\tc #0D0A04",
"O:\tc #0E0B05",
"P:\tc #0D0A05",
"Q:\tc #0C0904",
"R:\tc #0A0701",
"S:\tc #080600",
"T:\tc #090904",
"U:\tc #0C0C0C",
"V:\tc #18181B",
"W:\tc #202026",
"X:\tc #292932",
"Y:\tc #3B3B48",
"Z:\tc #4D4D5E",
"`:\tc #5C5C68",
" <\tc #8B8B8D",
".<\tc #4D4D4C",
"+<\tc #474746",
"@<\tc #5F605E",
"#<\tc #676766",
"$<\tc #8F908E",
"%<\tc #333431",
"&<\tc #2D302F",
"*<\tc #494851",
"=<\tc #5A5A6A",
"-<\tc #2D2D28",
";<\tc #50432F",
"><\tc #928471",
",<\tc #A89884",
"\'<\tc #998867",
")<\tc #D8CEC3",
"!<\tc #B4A58E",
"~<\tc #725D28",
"{<\tc #6F5A23",
"]<\tc #6E5A25",
"^<\tc #9D8C6E",
"/<\tc #C4B6A7",
"(<\tc #A7977F",
"_<\tc #A18F77",
":<\tc #938061",
"<<\tc #6C5824",
"[<\tc #6C5823",
"}<\tc #322916",
"|<\tc #332A16",
"1<\tc #322815",
"2<\tc #584A2E",
"3<\tc #8C7B60",
"4<\tc #988771",
"5<\tc #90816F",
"6<\tc #50473A",
"7<\tc #1E1916",
"8<\tc #060404",
"9<\tc #050302",
"0<\tc #050300",
"a<\tc #040101",
"b<\tc #0A0605",
"c<\tc #191512",
"d<\tc #1E1C18",
"e<\tc #292622",
"f<\tc #393630",
"g<\tc #403C37",
"h<\tc #3E3B36",
"i<\tc #24221D",
"j<\tc #1C1A15",
"k<\tc #13130D",
"l<\tc #101008",
"m<\tc #100D04",
"n<\tc #110A01",
"o<\tc #140C03",
"p<\tc #110D02",
"q<\tc #0D0A03",
"r<\tc #090703",
"s<\tc #0D0C0A",
"t<\tc #171619",
"u<\tc #1F1F25",
"v<\tc #27272F",
"w<\tc #2E2E39",
"x<\tc #4E4E5F",
"y<\tc #5C5C6B",
"z<\tc #88888C",
"A<\tc #5D5D5C",
"B<\tc #3F3F3D",
"C<\tc #727372",
"D<\tc #5D5D5D",
"E<\tc #767574",
"F<\tc #2D302E",
"G<\tc #434247",
"H<\tc #34353A",
"I<\tc #2C2E2C",
"J<\tc #423727",
"K<\tc #7B6A53",
"L<\tc #AC9D8A",
"M<\tc #95835D",
"N<\tc #6D5823",
"O<\tc #705A24",
"P<\tc #796639",
"Q<\tc #B7A996",
"R<\tc #B0A08C",
"S<\tc #978467",
"T<\tc #A08E71",
"U<\tc #B3A48F",
"V<\tc #A18F74",
"W<\tc #705B24",
"X<\tc #5F4D20",
"Y<\tc #3A3019",
"Z<\tc #342A17",
"`<\tc #443A24",
" [\tc #695836",
".[\tc #51462C",
"+[\tc #352E25",
"@[\tc #0C0807",
"#[\tc #080405",
"$[\tc #060203",
"%[\tc #060202",
"&[\tc #070403",
"*[\tc #171410",
"=[\tc #14110C",
"-[\tc #1E1B15",
";[\tc #1C1913",
">[\tc #191611",
",[\tc #15120D",
"\'[\tc #110E09",
")[\tc #0F0C07",
"![\tc #0F0B05",
"~[\tc #0D0600",
"{[\tc #100B01",
"][\tc #0D0B00",
"^[\tc #0B0900",
"/[\tc #0B0801",
"([\tc #080501",
"_[\tc #110E0E",
":[\tc #26262F",
"<[\tc #2D2D38",
"[[\tc #353542",
"}[\tc #3D3D4B",
"|[\tc #454554",
"1[\tc #78787E",
"2[\tc #979695",
"3[\tc #3F3F3E",
"4[\tc #858585",
"5[\tc #B1B1B1",
"6[\tc #666665",
"7[\tc #585868",
"8[\tc #4E4E56",
"9[\tc #2D2E2E",
"0[\tc #373024",
"a[\tc #6B593D",
"b[\tc #BBB2A5",
"c[\tc #D5CCC0",
"d[\tc #CCC0B3",
"e[\tc #BAAD99",
"f[\tc #6F5A24",
"g[\tc #B8A895",
"h[\tc #9A876C",
"i[\tc #C5B9A9",
"j[\tc #988765",
"k[\tc #615025",
"l[\tc #5A491E",
"m[\tc #352B18",
"n[\tc #312814",
"o[\tc #342A15",
"p[\tc #65583F",
"q[\tc #A3937E",
"r[\tc #94856E",
"s[\tc #3F3521",
"t[\tc #18130C",
"u[\tc #080403",
"v[\tc #090505",
"w[\tc #060303",
"x[\tc #050202",
"y[\tc #120F0A",
"z[\tc #0E0B06",
"A[\tc #0B0803",
"B[\tc #090602",
"C[\tc #0A0903",
"D[\tc #090801",
"E[\tc #0C0A01",
"F[\tc #060400",
"G[\tc #100D09",
"H[\tc #191615",
"I[\tc #1E1D20",
"J[\tc #26252E",
"K[\tc #363643",
"L[\tc #3E3E4C",
"M[\tc #545468",
"N[\tc #5F5F73",
"O[\tc #9D9DA7",
"P[\tc #C4C5C4",
"Q[\tc #3D3E3D",
"R[\tc #626362",
"S[\tc #3B3C3B",
"T[\tc #575660",
"U[\tc #5A492F",
"V[\tc #A39684",
"W[\tc #C9BFB2",
"X[\tc #CEC3B5",
"Y[\tc #695623",
"Z[\tc #816E45",
"`[\tc #A7967C",
" }\tc #9F8C70",
".}\tc #8F7C5B",
"+}\tc #897549",
"@}\tc #C2B4A5",
"#}\tc #A8997F",
"$}\tc #7A6638",
"%}\tc #7A6431",
"&}\tc #322917",
"*}\tc #322816",
"=}\tc #312715",
"-}\tc #43361C",
";}\tc #695936",
">}\tc #8A7B67",
",}\tc #3A3326",
"\'}\tc #0F0B06",
")}\tc #0D0907",
"!}\tc #090504",
"~}\tc #0A0603",
"{}\tc #0F0B09",
"]}\tc #130F0C",
"^}\tc #13100B",
"/}\tc #110E08",
"(}\tc #080601",
"_}\tc #050401",
":}\tc #020101",
"<}\tc #050504",
"[}\tc #090907",
"}}\tc #181715",
"|}\tc #211F1F",
"1}\tc #262528",
"2}\tc #23232A",
"3}\tc #282831",
"4}\tc #30303B",
"5}\tc #40404F",
"6}\tc #4C4C5E",
"7}\tc #515164",
"8}\tc #6F6F7D",
"9}\tc #6A6A6C",
"0}\tc #2C2F2D",
"a}\tc #4F4E5D",
"b}\tc #595968",
"c}\tc #363635",
"d}\tc #2D2C29",
"e}\tc #4F412D",
"f}\tc #C3B9AC",
"g}\tc #87744A",
"h}\tc #655221",
"i}\tc #675526",
"j}\tc #8E7A51",
"k}\tc #8E7A55",
"l}\tc #9E907C",
"m}\tc #71613E",
"n}\tc #6B592C",
"o}\tc #685625",
"p}\tc #4B3E1C",
"q}\tc #312815",
"r}\tc #2F2713",
"s}\tc #5A4B27",
"t}\tc #5C4F30",
"u}\tc #2B261D",
"v}\tc #070503",
"w}\tc #070400",
"x}\tc #090501",
"y}\tc #090502",
"z}\tc #0E0A05",
"A}\tc #110D05",
"B}\tc #161209",
"C}\tc #16120A",
"D}\tc #141009",
"E}\tc #130F09",
"F}\tc #110D09",
"G}\tc #0F0C06",
"H}\tc #090601",
"I}\tc #040200",
"J}\tc #050404",
"K}\tc #0E0E0E",
"L}\tc #1F1F20",
"M}\tc #232326",
"N}\tc #222226",
"O}\tc #23232B",
"P}\tc #2A2A33",
"Q}\tc #4D4D5F",
"R}\tc #525265",
"S}\tc #525261",
"T}\tc #3D3D42",
"U}\tc #2E2F2F",
"V}\tc #43444A",
"W}\tc #5C5B69",
"X}\tc #48474F",
"Y}\tc #42382A",
"Z}\tc #80715D",
"`}\tc #BCB0A2",
" |\tc #C8BCAE",
".|\tc #86775C",
"+|\tc #524322",
"@|\tc #604E23",
"#|\tc #83704E",
"$|\tc #99866A",
"%|\tc #A29076",
"&|\tc #8D7A53",
"*|\tc #836E41",
"=|\tc #AC9C84",
"-|\tc #94866F",
";|\tc #4E4120",
">|\tc #483A1A",
",|\tc #3D3219",
"\'|\tc #312816",
")|\tc #352B16",
"!|\tc #5F5238",
"~|\tc #524936",
"{|\tc #221F19",
"]|\tc #080705",
"^|\tc #0E0A08",
"/|\tc #130F0E",
"(|\tc #14100C",
"_|\tc #141008",
":|\tc #151108",
"<|\tc #130F06",
"[|\tc #120E05",
"}|\tc #0F0B03",
"||\tc #0E0A03",
"1|\tc #0C0902",
"2|\tc #0E0B08",
"3|\tc #161512",
"4|\tc #272727",
"5|\tc #2B2B2E",
"6|\tc #27272C",
"7|\tc #26262E",
"8|\tc #2B2B35",
"9|\tc #33333E",
"0|\tc #424251",
"a|\tc #484858",
"b|\tc #3F4146",
"c|\tc #2B2E2C",
"d|\tc #37373B",
"e|\tc #494955",
"f|\tc #383126",
"g|\tc #6E5E47",
"h|\tc #B4A89A",
"i|\tc #93815F",
"j|\tc #544520",
"k|\tc #534526",
"l|\tc #827256",
"m|\tc #9C8A71",
"n|\tc #A29078",
"o|\tc #9E8C70",
"p|\tc #907C56",
"q|\tc #BEAF9E",
"r|\tc #352B17",
"s|\tc #332917",
"t|\tc #3B321A",
"u|\tc #2D2617",
"v|\tc #18150F",
"w|\tc #0D0B08",
"x|\tc #0B0804",
"y|\tc #120F0B",
"z|\tc #110D08",
"A|\tc #110D04",
"B|\tc #100C03",
"C|\tc #0F0B02",
"D|\tc #0D0900",
"E|\tc #080701",
"F|\tc #0A0902",
"G|\tc #14110F",
"H|\tc #24221F",
"I|\tc #302E2E",
"J|\tc #242428",
"K|\tc #25252B",
"L|\tc #25252E",
"M|\tc #2D2D37",
"N|\tc #343440",
"O|\tc #3C3C4A",
"P|\tc #434352",
"Q|\tc #4A4A5A",
"R|\tc #43434B",
"S|\tc #313234",
"T|\tc #46464C",
"U|\tc #5D4D34",
"V|\tc #A59888",
"W|\tc #C0B4A4",
"X|\tc #978567",
"Y|\tc #756132",
"Z|\tc #625330",
"`|\tc #A2927B",
" 1\tc #9B886C",
".1\tc #8F7B58",
"+1\tc #8C7852",
"@1\tc #B3A48D",
"#1\tc #98896E",
"$1\tc #312817",
"%1\tc #302716",
"&1\tc #2F2616",
"*1\tc #382F1A",
"=1\tc #685E4C",
"-1\tc #322D23",
";1\tc #191711",
">1\tc #211E19",
",1\tc #0E0A07",
"\'1\tc #0C0805",
")1\tc #120F09",
"!1\tc #130F0B",
"~1\tc #100C04",
"{1\tc #0E0A01",
"]1\tc #0C0900",
"^1\tc #0A0B01",
"/1\tc #080901",
"(1\tc #090803",
"_1\tc #26231F",
":1\tc #383532",
"<1\tc #3E3D3C",
"[1\tc #2C2B2F",
"}1\tc #25252C",
"|1\tc #282832",
"11\tc #373744",
"21\tc #4A4B53",
"31\tc #373837",
"41\tc #313331",
"51\tc #2B2D2B",
"61\tc #282A28",
"71\tc #52535F",
"81\tc #59596A",
"91\tc #353738",
"01\tc #2E2F2C",
"a1\tc #4E412C",
"b1\tc #8F816C",
"c1\tc #B4A694",
"d1\tc #7A6847",
"e1\tc #6B5D41",
"f1\tc #A2947B",
"g1\tc #A4947E",
"h1\tc #AE9E8A",
"i1\tc #8D784F",
"j1\tc #B7A893",
"k1\tc #B7A995",
"l1\tc #66562D",
"m1\tc #362C17",
"n1\tc #302816",
"o1\tc #2E2616",
"p1\tc #2E2617",
"q1\tc #383021",
"r1\tc #473F32",
"s1\tc #242019",
"t1\tc #120E08",
"u1\tc #110E0A",
"v1\tc #0E0A09",
"w1\tc #100C09",
"x1\tc #0E0B04",
"y1\tc #14110B",
"z1\tc #0B0800",
"A1\tc #0C0C03",
"B1\tc #080A02",
"C1\tc #0B0C06",
"D1\tc #1B1C15",
"E1\tc #303029",
"F1\tc #353431",
"G1\tc #313032",
"H1\tc #27262C",
"I1\tc #33333F",
"J1\tc #424250",
"K1\tc #5A5A6B",
"L1\tc #61616F",
"M1\tc #666672",
"N1\tc #6B6B76",
"O1\tc #6E6E76",
"P1\tc #6C6D70",
"Q1\tc #696A68",
"R1\tc #636560",
"S1\tc #595A54",
"T1\tc #4B4C45",
"U1\tc #3B3C36",
"V1\tc #2C2D29",
"W1\tc #232523",
"X1\tc #232524",
"Y1\tc #282927",
"Z1\tc #565665",
"`1\tc #303135",
" 2\tc #2F302D",
".2\tc #433A2C",
"+2\tc #7B6B55",
"@2\tc #A69884",
"#2\tc #A08F76",
"$2\tc #837351",
"%2\tc #9B8B6E",
"&2\tc #BDAE9E",
"*2\tc #8F7E5F",
"=2\tc #342C16",
"-2\tc #2F2717",
";2\tc #352D1E",
">2\tc #3F392C",
",2\tc #4E493F",
"\'2\tc #4C483E",
")2\tc #3D3A33",
"!2\tc #2E2A23",
"~2\tc #27231C",
"{2\tc #110C08",
"]2\tc #0F0B08",
"^2\tc #0F0B07",
"/2\tc #100D06",
"(2\tc #120F07",
"_2\tc #0A0700",
":2\tc #0D0B04",
"<2\tc #1A1B13",
"[2\tc #2D2E26",
"}2\tc #383932",
"|2\tc #2A2B27",
"12\tc #232324",
"22\tc #24242B",
"32\tc #292931",
"42\tc #2F2F39",
"52\tc #434353",
"62\tc #49495A",
"72\tc #575767",
"82\tc #61616C",
"92\tc #77777A",
"02\tc #848485",
"a2\tc #9B9A9E",
"b2\tc #96969A",
"c2\tc #838386",
"d2\tc #707070",
"e2\tc #61615F",
"f2\tc #5F605D",
"g2\tc #656661",
"h2\tc #6D6E68",
"i2\tc #6E6F68",
"j2\tc #505149",
"k2\tc #2B2C26",
"l2\tc #22231F",
"m2\tc #212221",
"n2\tc #4E4E5D",
"o2\tc #3F3F47",
"p2\tc #262928",
"q2\tc #373126",
"r2\tc #6E5D45",
"s2\tc #A79887",
"t2\tc #9F8D73",
"u2\tc #8D7C5B",
"v2\tc #C6B9AB",
"w2\tc #C2B6A8",
"x2\tc #BDB0A1",
"y2\tc #AD9F8B",
"z2\tc #64542D",
"A2\tc #372D17",
"B2\tc #3A3221",
"C2\tc #443D2F",
"D2\tc #5B574F",
"E2\tc #58554E",
"F2\tc #48453E",
"G2\tc #3F3B33",
"H2\tc #413C34",
"I2\tc #443F36",
"J2\tc #3C362E",
"K2\tc #1B150F",
"L2\tc #110E04",
"M2\tc #110C03",
"N2\tc #120C03",
"O2\tc #100B02",
"P2\tc #110D06",
"Q2\tc #1E1A12",
"R2\tc #2C2822",
"S2\tc #44423B",
"T2\tc #4B4C46",
"U2\tc #363633",
"V2\tc #161618",
"W2\tc #393947",
"X2\tc #40404E",
"Y2\tc #464655",
"Z2\tc #68696A",
"`2\tc #838381",
" 3\tc #AFAFAD",
".3\tc #9E9E9D",
"+3\tc #767678",
"@3\tc #515158",
"#3\tc #383840",
"$3\tc #34343C",
"%3\tc #303037",
"&3\tc #2B2B33",
"*3\tc #2B2B30",
"=3\tc #2E2E30",
"-3\tc #40413E",
";3\tc #6E6F6A",
">3\tc #73746D",
",3\tc #383931",
"\'3\tc #23251D",
")3\tc #45454E",
"!3\tc #47474F",
"~3\tc #2F302F",
"{3\tc #48484E",
"]3\tc #312E29",
"^3\tc #877556",
"/3\tc #9F8F76",
"(3\tc #B3A390",
"_3\tc #C5B9AB",
":3\tc #BBB0A2",
"<3\tc #B2A697",
"[3\tc #897A61",
"}3\tc #4B4025",
"|3\tc #4C4639",
"13\tc #5C574F",
"23\tc #5C554E",
"33\tc #4F4942",
"43\tc #433F38",
"53\tc #3B3730",
"63\tc #3B372F",
"73\tc #423C34",
"83\tc #3E382F",
"93\tc #3D362D",
"03\tc #383027",
"a3\tc #231C15",
"b3\tc #0B0703",
"c3\tc #0E0B03",
"d3\tc #0E0B02",
"e3\tc #110C02",
"f3\tc #150C02",
"g3\tc #170E03",
"h3\tc #120C02",
"i3\tc #2D2921",
"j3\tc #48443C",
"k3\tc #59554D",
"l3\tc #4F4C46",
"m3\tc #2C2B29",
"n3\tc #191918",
"o3\tc #141514",
"p3\tc #1A1B1B",
"q3\tc #303039",
"r3\tc #494959",
"s3\tc #4A4A58",
"t3\tc #2F2F32",
"u3\tc #4E4F4A",
"v3\tc #9FA09B",
"w3\tc #6B6B6E",
"x3\tc #393942",
"y3\tc #3A3A47",
"z3\tc #303136",
"A3\tc #525350",
"B3\tc #888982",
"C3\tc #3D3F35",
"D3\tc #36372D",
"E3\tc #3D3E39",
"F3\tc #232424",
"G3\tc #272828",
"H3\tc #504F5F",
"I3\tc #292B29",
"J3\tc #483920",
"K3\tc #74613E",
"L3\tc #B2A492",
"M3\tc #BEB1A2",
"N3\tc #C1B5A7",
"O3\tc #BEB3A5",
"P3\tc #B7AB9E",
"Q3\tc #ABA194",
"R3\tc #8E8577",
"S3\tc #615B4B",
"T3\tc #545048",
"U3\tc #4C4943",
"V3\tc #464039",
"W3\tc #433B34",
"X3\tc #3B322B",
"Y3\tc #362F27",
"Z3\tc #332D25",
"`3\tc #2A241B",
" 4\tc #292219",
".4\tc #362F25",
"+4\tc #3F362D",
"@4\tc #393027",
"#4\tc #342E28",
"$4\tc #0D0A01",
"%4\tc #0F0800",
"&4\tc #150B02",
"*4\tc #170D04",
"=4\tc #181008",
"-4\tc #2A251E",
";4\tc #48443E",
">4\tc #59564F",
",4\tc #5E5A54",
"\'4\tc #3D3933",
")4\tc #201F1D",
"!4\tc #151514",
"~4\tc #1A1B1A",
"{4\tc #1E1F20",
"]4\tc #34353D",
"^4\tc #4C4C5D",
"/4\tc #3F3F48",
"(4\tc #222322",
"_4\tc #282923",
":4\tc #A1A29C",
"<4\tc #505057",
"[4\tc #34343F",
"}4\tc #35353F",
"|4\tc #474846",
"14\tc #80817A",
"24\tc #303129",
"34\tc #45463E",
"44\tc #41423F",
"54\tc #212322",
"64\tc #4C4B54",
"74\tc #3F3E45",
"84\tc #413829",
"94\tc #786953",
"04\tc #AFA498",
"a4\tc #B0A394",
"b4\tc #AA9F91",
"c4\tc #A3998E",
"d4\tc #8F877D",
"e4\tc #706B63",
"f4\tc #534F47",
"g4\tc #45423A",
"h4\tc #3F3B34",
"i4\tc #3F3830",
"j4\tc #382F28",
"k4\tc #332A23",
"l4\tc #312821",
"m4\tc #18100C",
"n4\tc #0D0402",
"o4\tc #0B0301",
"p4\tc #150D08",
"q4\tc #382F25",
"r4\tc #3D372D",
"s4\tc #37322F",
"t4\tc #0D0A02",
"u4\tc #1A130B",
"v4\tc #2B231A",
"w4\tc #443C33",
"x4\tc #544F46",
"y4\tc #55514B",
"z4\tc #504D48",
"A4\tc #45413B",
"B4\tc #4C4741",
"C4\tc #312E28",
"D4\tc #1B1B19",
"E4\tc #1E1F1D",
"F4\tc #232423",
"G4\tc #373840",
"H4\tc #5B5C6B",
"I4\tc #555556",
"J4\tc #1E1F19",
"K4\tc #22231D",
"L4\tc #979893",
"M4\tc #8A8A89",
"N4\tc #45454C",
"O4\tc #31313C",
"P4\tc #383842",
"Q4\tc #71726F",
"R4\tc #4C4D47",
"S4\tc #363731",
"T4\tc #565752",
"U4\tc #1F2120",
"V4\tc #252726",
"W4\tc #454449",
"X4\tc #2A2B2A",
"Y4\tc #332F26",
"Z4\tc #665B48",
"`4\tc #888176",
" 5\tc #726B62",
".5\tc #4D4841",
"+5\tc #3A362F",
"@5\tc #38342C",
"#5\tc #3A362D",
"$5\tc #413B33",
"%5\tc #48433A",
"&5\tc #4A433A",
"*5\tc #463E36",
"=5\tc #3E352D",
"-5\tc #393029",
";5\tc #2A211A",
">5\tc #110804",
",5\tc #120904",
"\'5\tc #0A0201",
")5\tc #090200",
"!5\tc #1A120D",
"~5\tc #332D26",
"{5\tc #35312E",
"]5\tc #1D1916",
"^5\tc #131008",
"/5\tc #242119",
"(5\tc #39362D",
"_5\tc #524E46",
":5\tc #5D5850",
"<5\tc #544F48",
"[5\tc #48433C",
"}5\tc #49443E",
"|5\tc #4D463E",
"15\tc #5E574E",
"25\tc #696158",
"35\tc #4F4B45",
"45\tc #252523",
"55\tc #232522",
"65\tc #38393E",
"75\tc #515162",
"85\tc #525356",
"95\tc #2B2C25",
"05\tc #1B1C17",
"a5\tc #868781",
"b5\tc #939391",
"c5\tc #404045",
"d5\tc #2E2E38",
"e5\tc #3F3F4E",
"f5\tc #3F4047",
"g5\tc #6F706B",
"h5\tc #292A24",
"i5\tc #474842",
"j5\tc #4F504C",
"k5\tc #59586C",
"l5\tc #474750",
"m5\tc #313130",
"n5\tc #363129",
"o5\tc #28241D",
"p5\tc #191511",
"q5\tc #26211B",
"r5\tc #39332C",
"s5\tc #403A31",
"t5\tc #484138",
"u5\tc #514A40",
"v5\tc #575046",
"w5\tc #574F46",
"x5\tc #4E453B",
"y5\tc #41382F",
"z5\tc #3E352C",
"A5\tc #2B221A",
"B5\tc #201710",
"C5\tc #100703",
"D5\tc #160F0A",
"E5\tc #332F27",
"F5\tc #26231E",
"G5\tc #080503",
"H5\tc #0D0A06",
"I5\tc #1E1B14",
"J5\tc #35322B",
"K5\tc #4A473E",
"L5\tc #5B584F",
"M5\tc #4F4C45",
"N5\tc #444039",
"O5\tc #363025",
"P5\tc #474137",
"Q5\tc #595249",
"R5\tc #665E54",
"S5\tc #776F65",
"T5\tc #7E7569",
"U5\tc #6E675D",
"V5\tc #292B28",
"W5\tc #4D4D5C",
"X5\tc #2E2D23",
"Y5\tc #121008",
"Z5\tc #4C4C46",
"`5\tc #9A9B96",
" 6\tc #4C4C4E",
".6\tc #40404D",
"+6\tc #8B8C89",
"@6\tc #343531",
"#6\tc #1D1E18",
"$6\tc #464740",
"%6\tc #363735",
"&6\tc #222323",
"*6\tc #262726",
"=6\tc #54545F",
"-6\tc #2E2C2A",
";6\tc #24201D",
">6\tc #19140D",
",6\tc #201A12",
"\'6\tc #251E17",
")6\tc #3A352D",
"!6\tc #4F4A40",
"~6\tc #3F382F",
"{6\tc #423B31",
"]6\tc #574F45",
"^6\tc #5C544A",
"/6\tc #544C41",
"(6\tc #544C40",
"_6\tc #524A3F",
":6\tc #443C31",
"<6\tc #3A3228",
"[6\tc #2D241B",
"}6\tc #191008",
"|6\tc #221912",
"16\tc #2B221B",
"26\tc #1A110B",
"36\tc #221C14",
"46\tc #353229",
"56\tc #323027",
"66\tc #2B2B22",
"76\tc #1E1D17",
"86\tc #2B2A23",
"96\tc #4E4B44",
"06\tc #58554D",
"a6\tc #524E44",
"b6\tc #3F3B30",
"c6\tc #433E38",
"d6\tc #4D4740",
"e6\tc #574F47",
"f6\tc #5F564B",
"g6\tc #5B503D",
"h6\tc #726753",
"i6\tc #8D8377",
"j6\tc #938779",
"k6\tc #8E8579",
"l6\tc #3A3834",
"m6\tc #2B2B29",
"n6\tc #323231",
"o6\tc #505160",
"p6\tc #39373A",
"q6\tc #1B170C",
"r6\tc #1A1710",
"s6\tc #6E6B63",
"t6\tc #73736E",
"u6\tc #2E2E33",
"v6\tc #2C2C36",
"w6\tc #474758",
"x6\tc #484857",
"y6\tc #878583",
"z6\tc #4C4B43",
"A6\tc #070702",
"B6\tc #0E100C",
"C6\tc #2C2E28",
"D6\tc #2A2C27",
"E6\tc #202120",
"F6\tc #1E201F",
"G6\tc #3A3C44",
"H6\tc #4A4957",
"I6\tc #48464E",
"J6\tc #222019",
"K6\tc #1F1C15",
"L6\tc #2C2821",
"M6\tc #38332B",
"N6\tc #3B362E",
"O6\tc #514A42",
"P6\tc #4F483F",
"Q6\tc #3F372E",
"R6\tc #423930",
"S6\tc #484033",
"T6\tc #4B4336",
"U6\tc #3F372C",
"V6\tc #352D22",
"W6\tc #292117",
"X6\tc #2D241A",
"Y6\tc #342B22",
"Z6\tc #312921",
"`6\tc #3D3930",
" 7\tc #3A372F",
".7\tc #45433B",
"+7\tc #55554C",
"@7\tc #5A5B52",
"#7\tc #46443E",
"$7\tc #333026",
"%7\tc #2A2313",
"&7\tc #352D1D",
"*7\tc #463D2F",
"=7\tc #5B5246",
"-7\tc #736A5F",
";7\tc #7A7064",
">7\tc #867B6E",
",7\tc #938778",
"\'7\tc #8C7E67",
")7\tc #8F8064",
"!7\tc #9F9486",
"~7\tc #524E48",
"{7\tc #2C2E2B",
"]7\tc #343433",
"^7\tc #4D4C58",
"/7\tc #4C4C5C",
"(7\tc #24211C",
"_7\tc #23211B",
":7\tc #64635A",
"<7\tc #5D5D5A",
"[7\tc #26262D",
"}7\tc #878484",
"|7\tc #595349",
"17\tc #080A03",
"27\tc #14140E",
"37\tc #302E28",
"47\tc #33312E",
"57\tc #262421",
"67\tc #1F1C1B",
"77\tc #201E19",
"87\tc #26231C",
"97\tc #323024",
"07\tc #413F33",
"a7\tc #4D4B42",
"b7\tc #625D57",
"c7\tc #67625D",
"d7\tc #615D55",
"e7\tc #555148",
"f7\tc #443E35",
"g7\tc #443C34",
"h7\tc #4A4238",
"i7\tc #4B4338",
"j7\tc #443C2F",
"k7\tc #463E31",
"l7\tc #3E3629",
"m7\tc #362E21",
"n7\tc #3A3226",
"o7\tc #3E362B",
"p7\tc #3C342A",
"q7\tc #4E483F",
"r7\tc #57544C",
"s7\tc #5F5C55",
"t7\tc #57554C",
"u7\tc #38352C",
"v7\tc #232017",
"w7\tc #1D190C",
"x7\tc #2A220E",
"y7\tc #3D341F",
"z7\tc #63594C",
"A7\tc #6C6052",
"B7\tc #726453",
"C7\tc #837664",
"D7\tc #9C9082",
"E7\tc #A69A8C",
"F7\tc #AA9D8E",
"G7\tc #AFA293",
"H7\tc #A1947F",
"I7\tc #625B4D",
"J7\tc #2C2D2A",
"K7\tc #2D2F2C",
"L7\tc #2F312F",
"M7\tc #47444D",
"N7\tc #46464E",
"O7\tc #1C1C14",
"P7\tc #23221B",
"Q7\tc #5B5C53",
"R7\tc #585856",
"S7\tc #868381",
"T7\tc #5D574D",
"U7\tc #2B261C",
"V7\tc #161309",
"W7\tc #0F1006",
"X7\tc #0A0A03",
"Y7\tc #100F08",
"Z7\tc #17140E",
"`7\tc #221F1A",
" 8\tc #2F2C27",
".8\tc #43403A",
"+8\tc #656358",
"@8\tc #6E6C62",
"#8\tc #55544F",
"$8\tc #474744",
"%8\tc #434240",
"&8\tc #4C4A4C",
"*8\tc #474547",
"=8\tc #3C3937",
"-8\tc #3B3832",
";8\tc #403A32",
">8\tc #3B352C",
",8\tc #3E392E",
"\'8\tc #454034",
")8\tc #423B2F",
"!8\tc #41392D",
"~8\tc #3C3427",
"{8\tc #41392C",
"]8\tc #564E41",
"^8\tc #635C51",
"/8\tc #716D66",
"(8\tc #64615B",
"_8\tc #423E34",
":8\tc #282315",
"<8\tc #1D180A",
"[8\tc #241D0D",
"}8\tc #2B240F",
"|8\tc #42371F",
"18\tc #796D5B",
"28\tc #908577",
"38\tc #948778",
"48\tc #918371",
"58\tc #8D7D67",
"68\tc #9A8A75",
"78\tc #B7AB9C",
"88\tc #BEB2A4",
"98\tc #B9AC9D",
"08\tc #7F776D",
"a8\tc #343332",
"b8\tc #2E2F2D",
"c8\tc #2F3231",
"d8\tc #434047",
"e8\tc #4A4B51",
"f8\tc #181911",
"g8\tc #070801",
"h8\tc #171811",
"i8\tc #51524B",
"j8\tc #575856",
"k8\tc #4D4D5D",
"l8\tc #645E5A",
"m8\tc #565045",
"n8\tc #454136",
"o8\tc #323025",
"p8\tc #27281E",
"q8\tc #222319",
"r8\tc #25261C",
"s8\tc #2C2C22",
"t8\tc #3A3830",
"u8\tc #57544E",
"v8\tc #716E69",
"w8\tc #797671",
"x8\tc #62605A",
"y8\tc #3D3D39",
"z8\tc #232422",
"A8\tc #131315",
"B8\tc #282830",
"C8\tc #2B2B31",
"D8\tc #2C2A29",
"E8\tc #3E3A33",
"F8\tc #37332A",
"G8\tc #353027",
"H8\tc #3A352B",
"I8\tc #3E372C",
"J8\tc #3E352A",
"K8\tc #433B2F",
"L8\tc #4E4639",
"M8\tc #544C3F",
"N8\tc #4E483E",
"O8\tc #38342F",
"P8\tc #2C281F",
"Q8\tc #2C2513",
"R8\tc #251E0D",
"S8\tc #312710",
"T8\tc #382E13",
"U8\tc #4A3F24",
"V8\tc #897C69",
"W8\tc #A29587",
"X8\tc #B0A393",
"Y8\tc #AB9C8B",
"Z8\tc #A2907C",
"`8\tc #9E8D76",
" 9\tc #A6957F",
".9\tc #999185",
"+9\tc #3D3C39",
"@9\tc #313232",
"#9\tc #3D3B3F",
"$9\tc #59586B",
"%9\tc #484855",
"&9\tc #1B1E1A",
"*9\tc #070803",
"=9\tc #13140E",
"-9\tc #494A44",
";9\tc #585958",
">9\tc #4D4C59",
",9\tc #59534B",
"\'9\tc #565146",
")9\tc #4B483D",
"!9\tc #3F3E34",
"~9\tc #3A3B31",
"{9\tc #43453A",
"]9\tc #54554B",
"^9\tc #72736A",
"/9\tc #7B7C74",
"(9\tc #6C6C67",
"_9\tc #41413E",
":9\tc #171817",
"<9\tc #1D1E1D",
"[9\tc #433F3A",
"}9\tc #2C241F",
"|9\tc #342C26",
"19\tc #352D26",
"29\tc #352E26",
"39\tc #2C231C",
"49\tc #221811",
"59\tc #21170E",
"69\tc #1F150A",
"79\tc #231A0E",
"89\tc #282115",
"99\tc #28231D",
"09\tc #19160F",
"a9\tc #282113",
"b9\tc #2E2611",
"c9\tc #2F2610",
"d9\tc #423617",
"e9\tc #6A5C3F",
"f9\tc #A19483",
"g9\tc #B6A89A",
"h9\tc #BBAE9E",
"i9\tc #BEB0A1",
"j9\tc #BAAB9B",
"k9\tc #AE9D8A",
"l9\tc #A3917B",
"m9\tc #998B77",
"n9\tc #403E3A",
"o9\tc #2F302C",
"p9\tc #2F2F2D",
"q9\tc #373737",
"r9\tc #212324",
"s9\tc #050703",
"t9\tc #12130D",
"u9\tc #3A3B35",
"v9\tc #5E5F5B",
"w9\tc #2D2D35",
"x9\tc #565355",
"y9\tc #6A645B",
"z9\tc #666257",
"A9\tc #59574C",
"B9\tc #5F6056",
"C9\tc #787A70",
"D9\tc #93948C",
"E9\tc #7E7F7A",
"F9\tc #5A5A5A",
"G9\tc #353539",
"H9\tc #1E1E20",
"I9\tc #191A18",
"J9\tc #181918",
"K9\tc #1D1F1E",
"L9\tc #202121",
"M9\tc #262525",
"N9\tc #45444E",
"O9\tc #26262B",
"P9\tc #312C27",
"Q9\tc #140A07",
"R9\tc #170D0A",
"S9\tc #130B06",
"T9\tc #100803",
"U9\tc #130905",
"V9\tc #1B0F0A",
"W9\tc #1F120B",
"X9\tc #1D130B",
"Y9\tc #251F17",
"Z9\tc #221D13",
"`9\tc #221C0D",
" 0\tc #241D0E",
".0\tc #362C12",
"+0\tc #483C1E",
"@0\tc #7E7158",
"#0\tc #AEA192",
"$0\tc #B7A99B",
"%0\tc #BCAEA0",
"&0\tc #BFB2A3",
"*0\tc #C0B3A3",
"=0\tc #A49684",
"-0\tc #57534B",
";0\tc #30322F",
">0\tc #4F4F5C",
",0\tc #2C2D34",
"\'0\tc #080906",
")0\tc #191A14",
"!0\tc #1F2018",
"~0\tc #52524A",
"{0\tc #3D3D41",
"]0\tc #353541",
"^0\tc #524F57",
"/0\tc #79736C",
"(0\tc #888378",
"_0\tc #8B887D",
":0\tc #94948A",
"<0\tc #A7A89F",
"[0\tc #949591",
"}0\tc #5E5F5F",
"|0\tc #313136",
"10\tc #2E2F35",
"20\tc #333335",
"30\tc #3C3D43",
"40\tc #242525",
"50\tc #272725",
"60\tc #201815",
"70\tc #150A08",
"80\tc #160B08",
"90\tc #0C0402",
"00\tc #100804",
"a0\tc #140C09",
"b0\tc #120A07",
"c0\tc #1A110C",
"d0\tc #211813",
"e0\tc #2D2620",
"f0\tc #453D2E",
"g0\tc #292211",
"h0\tc #2A2211",
"i0\tc #504427",
"j0\tc #948772",
"k0\tc #B4A898",
"l0\tc #BBAEA0",
"m0\tc #BEB3A6",
"n0\tc #706B62",
"o0\tc #333330",
"p0\tc #313330",
"q0\tc #343633",
"r0\tc #3E3F4B",
"s0\tc #0D0E0D",
"t0\tc #23241D",
"u0\tc #1D1C14",
"v0\tc #26251D",
"w0\tc #43413F",
"x0\tc #34343E",
"y0\tc #54535B",
"z0\tc #89837E",
"A0\tc #C4BEB4",
"B0\tc #D1CEC3",
"C0\tc #CDCCC2",
"D0\tc #9B9B96",
"E0\tc #575758",
"F0\tc #2D2D33",
"G0\tc #41424D",
"H0\tc #323333",
"I0\tc #46464D",
"J0\tc #3F3E3C",
"K0\tc #312A29",
"L0\tc #3C3231",
"M0\tc #483E3D",
"N0\tc #59524F",
"O0\tc #6B6561",
"P0\tc #615B56",
"Q0\tc #3A3531",
"R0\tc #1D1814",
"S0\tc #2A251F",
"T0\tc #49423A",
"U0\tc #4B412F",
"V0\tc #4E432D",
"W0\tc #322913",
"X0\tc #3C3219",
"Y0\tc #BCB0A3",
"Z0\tc #BFB4A5",
"`0\tc #C3B7A8",
" a\tc #CBBEB0",
".a\tc #878076",
"+a\tc #373633",
"@a\tc #5B5B6E",
"#a\tc #151619",
"$a\tc #1D1D17",
"%a\tc #36332B",
"&a\tc #0D0B06",
"*a\tc #1C1914",
"=a\tc #333133",
"-a\tc #3A3A45",
";a\tc #505061",
">a\tc #5B5961",
",a\tc #A4A29E",
"\'a\tc #F3EFE6",
")a\tc #EDEAE0",
"!a\tc #B1AFA8",
"~a\tc #2E2E34",
"{a\tc #272730",
"]a\tc #3A3C3C",
"^a\tc #393A38",
"/a\tc #2C2C2A",
"(a\tc #545553",
"_a\tc #CFCFCB",
":a\tc #DBD9D5",
"<a\tc #E3DFDC",
"[a\tc #EDE7E5",
"}a\tc #E5E0DD",
"|a\tc #A8A5A1",
"1a\tc #585653",
"2a\tc #262626",
"3a\tc #1E1A13",
"4a\tc #483D2D",
"5a\tc #74695B",
"6a\tc #746754",
"7a\tc #756547",
"8a\tc #BEB1A3",
"9a\tc #C6BAAC",
"0a\tc #C7BBAD",
"aa\tc #9C9489",
"ba\tc #41403D",
"ca\tc #323431",
"da\tc #3C3E3F",
"ea\tc #30313C",
"fa\tc #0C0C0D",
"ga\tc #25231D",
"ha\tc #26221A",
"ia\tc #201D1E",
"ja\tc #323139",
"ka\tc #41414F",
"la\tc #4F4E5E",
"ma\tc #515059",
"na\tc #878586",
"oa\tc #D2D0CE",
"pa\tc #F9F8F6",
"qa\tc #D7D6D4",
"ra\tc #747374",
"sa\tc #36353C",
"ta\tc #414347",
"ua\tc #323430",
"va\tc #393838",
"wa\tc #DFDEDF",
"xa\tc #656664",
"ya\tc #343432",
"za\tc #AFAEAB",
"Aa\tc #F9FAF6",
"Ba\tc #FBFCF8",
"Ca\tc #FDFCF8",
"Da\tc #E9E7E4",
"Ea\tc #888582",
"Fa\tc #212128",
"Ga\tc #2B2C30",
"Ha\tc #2B2820",
"Ia\tc #594B36",
"Ja\tc #928675",
"Ka\tc #807049",
"La\tc #938265",
"Ma\tc #CDC1B3",
"Na\tc #ADA398",
"Oa\tc #484643",
"Pa\tc #333331",
"Qa\tc #333432",
"Ra\tc #393B3A",
"Sa\tc #585969",
"Ta\tc #212129",
"Ua\tc #121415",
"Va\tc #1D1D18",
"Wa\tc #29261E",
"Xa\tc #18130E",
"Ya\tc #110B08",
"Za\tc #16110F",
"`a\tc #282425",
" b\tc #3C3A3F",
".b\tc #44434C",
"+b\tc #494751",
"@b\tc #4B4953",
"#b\tc #4D4B54",
"$b\tc #4E4C53",
"%b\tc #545154",
"&b\tc #7F7C7D",
"*b\tc #BEBAB7",
"=b\tc #F2EFEB",
"-b\tc #F6F5F3",
";b\tc #C2C2C2",
">b\tc #5B5B61",
",b\tc #31313B",
"\'b\tc #484951",
")b\tc #38393A",
"!b\tc #858485",
"~b\tc #838584",
"{b\tc #595957",
"]b\tc #84807C",
"^b\tc #A8A296",
"/b\tc #F0EFE3",
"(b\tc #FAFAF5",
"_b\tc #E2E2DF",
":b\tc #80807E",
"<b\tc #2A2A2C",
"[b\tc #222229",
"}b\tc #383843",
"|b\tc #312F29",
"1b\tc #574934",
"2b\tc #988C79",
"3b\tc #BEB2A2",
"4b\tc #CEC2B6",
"5b\tc #BBB1A4",
"6b\tc #58544F",
"7b\tc #323230",
"8b\tc #373735",
"9b\tc #212328",
"0b\tc #181A18",
"ab\tc #222119",
"bb\tc #302D23",
"cb\tc #342F27",
"db\tc #352E28",
"eb\tc #35302A",
"fb\tc #332E2A",
"gb\tc #3D3835",
"hb\tc #3E3936",
"ib\tc #3F3A37",
"jb\tc #4C4744",
"kb\tc #928C88",
"lb\tc #BDBAB6",
"mb\tc #D9D6D2",
"nb\tc #E3E0DD",
"ob\tc #B1B0AF",
"pb\tc #504F56",
"qb\tc #30303A",
"rb\tc #686868",
"sb\tc #4C4C4B",
"tb\tc #6A6663",
"ub\tc #5A5249",
"vb\tc #88806D",
"wb\tc #E4E0CD",
"xb\tc #EBEBDF",
"yb\tc #828280",
"zb\tc #2D2D31",
"Ab\tc #24242C",
"Bb\tc #3D3D43",
"Cb\tc #32312D",
"Db\tc #928572",
"Eb\tc #C7BDB1",
"Fb\tc #76716A",
"Gb\tc #31312F",
"Hb\tc #323331",
"Ib\tc #353533",
"Jb\tc #4B4A52",
"Kb\tc #3C3D4A",
"Lb\tc #23211A",
"Mb\tc #29261D",
"Nb\tc #2C291F",
"Ob\tc #2A261C",
"Pb\tc #29241C",
"Qb\tc #2A241D",
"Rb\tc #2D2722",
"Sb\tc #2A2520",
"Tb\tc #25201C",
"Ub\tc #28221D",
"Vb\tc #2B241F",
"Wb\tc #2D2824",
"Xb\tc #3B3734",
"Yb\tc #484645",
"Zb\tc #3D3C43",
"`b\tc #424048",
" c\tc #3C3835",
".c\tc #3D3730",
"+c\tc #595244",
"@c\tc #98917E",
"#c\tc #E5E1D0",
"$c\tc #919087",
"%c\tc #2A2A2A",
"&c\tc #42424B",
"*c\tc #323330",
"=c\tc #423929",
"-c\tc #867662",
";c\tc #C4BBAF",
">c\tc #CDC4B9",
",c\tc #8C867D",
"\'c\tc #474649",
")c\tc #5C5B6F",
"!c\tc #484859",
"~c\tc #333239",
"{c\tc #2E2D2D",
"]c\tc #2C2A26",
"^c\tc #2B2921",
"/c\tc #27251C",
"(c\tc #242017",
"_c\tc #28231B",
":c\tc #2B2520",
"<c\tc #2D2723",
"[c\tc #2B2522",
"}c\tc #211D1B",
"|c\tc #221F1F",
"1c\tc #242226",
"2c\tc #27262E",
"3c\tc #353235",
"4c\tc #221E1B",
"5c\tc #544E3F",
"6c\tc #BDB8A7",
"7c\tc #AFAC9E",
"8c\tc #2D2D2A",
"9c\tc #111211",
"0c\tc #222325",
"ac\tc #3F3E4B",
"bc\tc #454551",
"cc\tc #2E2F31",
"dc\tc #383737",
"ec\tc #383936",
"fc\tc #3D362C",
"gc\tc #6F5E48",
"hc\tc #B8AEA1",
"ic\tc #9B9388",
"jc\tc #3B3A37",
"kc\tc #333230",
"lc\tc #333532",
"mc\tc #433F41",
"nc\tc #5B5A6C",
"oc\tc #383845",
"pc\tc #33333C",
"qc\tc #2F2E36",
"rc\tc #2F2F34",
"sc\tc #2D2C30",
"tc\tc #2D2B2E",
"uc\tc #2E2C2F",
"vc\tc #2D2B31",
"wc\tc #2B2A31",
"xc\tc #2A2932",
"yc\tc #2C2C35",
"zc\tc #2F2F3A",
"Ac\tc #4B4A57",
"Bc\tc #333136",
"Cc\tc #151110",
"Dc\tc #18130F",
"Ec\tc #1A1511",
"Fc\tc #211A14",
"Gc\tc #28231A",
"Hc\tc #AFAB9F",
"Ic\tc #6B6961",
"Jc\tc #161615",
"Kc\tc #1C1D1C",
"Lc\tc #323234",
"Mc\tc #414142",
"Nc\tc #424145",
"Oc\tc #5E5D6E",
"Pc\tc #35353A",
"Qc\tc #383530",
"Rc\tc #5C4D39",
"Sc\tc #A69B8C",
"Tc\tc #B0A89E",
"Uc\tc #494844",
"Vc\tc #32312F",
"Wc\tc #3C3939",
"Xc\tc #5A5869",
"Yc\tc #4D4C5B",
"Zc\tc #1A1919",
"`c\tc #100C0B",
" d\tc #130E09",
".d\tc #18110C",
"+d\tc #1C1811",
"@d\tc #767268",
"#d\tc #514F4A",
"$d\tc #2E302D",
"%d\tc #3B3B3D",
"&d\tc #3F4045",
"*d\tc #363631",
"=d\tc #504431",
"-d\tc #8C806E",
";d\tc #595650",
">d\tc #30302E",
",d\tc #393937",
"\'d\tc #595563",
")d\tc #57566A",
"!d\tc #515062",
"~d\tc #3E3C47",
"{d\tc #262326",
"]d\tc #1A1614",
"^d\tc #211E1C",
"/d\tc #201C18",
"(d\tc #140F0C",
"_d\tc #0A0502",
":d\tc #0A0601",
"<d\tc #17130D",
"[d\tc #444037",
"}d\tc #514E4A",
"|d\tc #161617",
"1d\tc #313233",
"2d\tc #52525D",
"3d\tc #3D392E",
"4d\tc #30312E",
"5d\tc #4D4C5A",
"6d\tc #433F44",
"7d\tc #55504F",
"8d\tc #7F7B77",
"9d\tc #A6A3A0",
"0d\tc #B8B7B4",
"ad\tc #AFAEAC",
"bd\tc #A19F9D",
"cd\tc #706C6A",
"dd\tc #2B2623",
"ed\tc #2F2A22",
"fd\tc #5C5651",
"gd\tc #262628",
"hd\tc #222423",
"id\tc #505058",
"jd\tc #5E5D6F",
"kd\tc #383A3A",
"ld\tc #535262",
"md\tc #5E5B61",
"nd\tc #8B8583",
"od\tc #D5D1CD",
"pd\tc #EDE9E5",
"qd\tc #D3CFCC",
"rd\tc #8D8A88",
"sd\tc #555555",
"td\tc #363537",
"ud\tc #313134",
"vd\tc #424144",
"wd\tc #4F4E4E",
"xd\tc #282826",
"yd\tc #060403",
"zd\tc #211913",
"Ad\tc #5A5349",
"Bd\tc #3B393E",
"Cd\tc #3A3B42",
"Dd\tc #303230",
"Ed\tc #353734",
"Fd\tc #595861",
"Gd\tc #383A3C",
"Hd\tc #2F312D",
"Id\tc #32342F",
"Jd\tc #3A3A3C",
"Kd\tc #5A5961",
"Ld\tc #878682",
"Md\tc #CFCBC5",
"Nd\tc #F6F3EE",
"Od\tc #F0EDE9",
"Pd\tc #9B9794",
"Qd\tc #525050",
"Rd\tc #323136",
"Sd\tc #2A2A32",
"Td\tc #2E2E32",
"Ud\tc #151312",
"Vd\tc #120C08",
"Wd\tc #443E34",
"Xd\tc #4B4849",
"Yd\tc #363642",
"Zd\tc #4A4A55",
"`d\tc #363835",
" e\tc #343536",
".e\tc #5B5B62",
"+e\tc #46474E",
"@e\tc #3A3939",
"#e\tc #545462",
"$e\tc #666566",
"%e\tc #A7A69C",
"&e\tc #EAE7DE",
"*e\tc #FAF7F0",
"=e\tc #E1DDD9",
"-e\tc #898684",
";e\tc #3C3A3E",
">e\tc #2C2B31",
",e\tc #100F0E",
"\'e\tc #342F2A",
")e\tc #504E4E",
"!e\tc #353540",
"~e\tc #3D3D40",
"{e\tc #353534",
"]e\tc #363836",
"^e\tc #363737",
"/e\tc #4B4C50",
"(e\tc #605F66",
"_e\tc #383A38",
":e\tc #333531",
"<e\tc #343634",
"[e\tc #353634",
"}e\tc #373736",
"|e\tc #5A5965",
"1e\tc #7B7A79",
"2e\tc #C6C4B9",
"3e\tc #F7F5E8",
"4e\tc #F6F4EB",
"5e\tc #C0BCB6",
"6e\tc #6D6967",
"7e\tc #323035",
"8e\tc #3A3A46",
"9e\tc #242328",
"0e\tc #2E2A28",
"ae\tc #504C4F",
"be\tc #48484C",
"ce\tc #3A3A37",
"de\tc #373936",
"ee\tc #383836",
"fe\tc #525263",
"ge\tc #6F6E74",
"he\tc #ADAAA9",
"ie\tc #EAE7E5",
"je\tc #FBF9F8",
"ke\tc #ECEAE5",
"le\tc #A39F9A",
"me\tc #545150",
"ne\tc #2B292F",
"oe\tc #292933",
"pe\tc #33323C",
"qe\tc #0E0B0A",
"re\tc #302C28",
"se\tc #4A494D",
"te\tc #3C3C39",
"ue\tc #373836",
"ve\tc #46464A",
"we\tc #5F5E6A",
"xe\tc #A4A2A1",
"ye\tc #E1E0DA",
"ze\tc #FAF8F4",
"Ae\tc #F9F7F5",
"Be\tc #D4D2D2",
"Ce\tc #787875",
"De\tc #4B4B49",
"Ee\tc #2F2F35",
"Fe\tc #3F3F4C",
"Ge\tc #181516",
"He\tc #585965",
"Ie\tc #3F403E",
"Je\tc #434445",
"Ke\tc #7B7A80",
"Le\tc #C0BFBA",
"Me\tc #F5F3EB",
"Ne\tc #FCFBF5",
"Oe\tc #EDEBE7",
"Pe\tc #B2AEAE",
"Qe\tc #605F5E",
"Re\tc #3D3D3D",
"Se\tc #2A2A34",
"Te\tc #454452",
"Ue\tc #231F1D",
"Ve\tc #403D36",
"We\tc #464849",
"Xe\tc #3B3D3A",
"Ye\tc #393B38",
"Ze\tc #393C39",
"`e\tc #414241",
" f\tc #565765",
".f\tc #949395",
"+f\tc #DFDED5",
"@f\tc #FCFBF0",
"#f\tc #F7F5EB",
"$f\tc #E0DED7",
"%f\tc #8E8B87",
"&f\tc #494644",
"*f\tc #343334",
"=f\tc #292930",
"-f\tc #484753",
";f\tc #2F2D25",
">f\tc #4B4842",
",f\tc #5C5C6E",
"\'f\tc #4D4F53",
")f\tc #3B3D3B",
"!f\tc #3C3D3B",
"~f\tc #3C3E3C",
"{f\tc #53515D",
"]f\tc #5E5D6A",
"^f\tc #A5A3A1",
"/f\tc #EEEDE2",
"(f\tc #FCFBEF",
"_f\tc #F1F0E4",
":f\tc #AFACA3",
"<f\tc #63605A",
"[f\tc #3B3835",
"}f\tc #323134",
"|f\tc #26262C",
"1f\tc #47464B",
"2f\tc #474537",
"3f\tc #55534E",
"4f\tc #52535C",
"5f\tc #41413F",
"6f\tc #5C5B70",
"7f\tc #71707B",
"8f\tc #C0BDBB",
"9f\tc #F4F3E9",
"0f\tc #EDECDF",
"af\tc #B8B7AA",
"bf\tc #686659",
"cf\tc #403D34",
"df\tc #363532",
"ef\tc #2C2C31",
"ff\tc #646150",
"gf\tc #3B3B49",
"hf\tc #5A5A69",
"if\tc #5D5C6C",
"jf\tc #939197",
"kf\tc #DBD9D7",
"lf\tc #EEEAE6",
"mf\tc #C1BEB8",
"nf\tc #3C3A30",
"of\tc #35332B",
"pf\tc #363535",
"qf\tc #27272D",
"rf\tc #58575D",
"sf\tc #6F6C5C",
"tf\tc #6D6A5B",
"uf\tc #42424A",
"vf\tc #797983",
"wf\tc #B9B7B9",
"xf\tc #EBE8E4",
"yf\tc #DFDCD8",
"zf\tc #85807C",
"Af\tc #3E3A37",
"Bf\tc #32302E",
"Cf\tc #333232",
"Df\tc #7D7973",
"Ef\tc #848171",
"Ff\tc #5A5855",
"Gf\tc #8B8C93",
"Hf\tc #D8D7D5",
"If\tc #EEEBE7",
"Jf\tc #C2BFBA",
"Kf\tc #5D5854",
"Lf\tc #3C3834",
"Mf\tc #403D3D",
"Nf\tc #333337",
"Of\tc #6D6A70",
"Pf\tc #908B7F",
"Qf\tc #6B6964",
"Rf\tc #42414B",
"Sf\tc #929299",
"Tf\tc #E2E3DF",
"Uf\tc #E8E6E1",
"Vf\tc #8C8782",
"Wf\tc #37322E",
"Xf\tc #4E4945",
"Yf\tc #504E4F",
"Zf\tc #55525D",
"`f\tc #817B73",
" g\tc #77746D",
".g\tc #474650",
"+g\tc #878891",
"@g\tc #E4E5E1",
"#g\tc #EAE9E5",
"$g\tc #76716B",
"%g\tc #37312D",
"&g\tc #4E4947",
"*g\tc #444144",
"=g\tc #595762",
"-g\tc #6D6662",
";g\tc #77716C",
">g\tc #4E4D56",
",g\tc #626272",
"\'g\tc #C9C9C8",
")g\tc #F7F7F3",
"!g\tc #9C9994",
"~g\tc #3A342F",
"{g\tc #5D5956",
"]g\tc #464447",
"^g\tc #5D5A65",
"/g\tc #6D6562",
"(g\tc #6F6864",
"_g\tc #514F58",
":g\tc #8A8A90",
"<g\tc #EEEEE3",
"[g\tc #F0F0E6",
"}g\tc #4B4541",
"|g\tc #585656",
"1g\tc #615E68",
"2g\tc #756D69",
"3g\tc #706865",
"4g\tc #504E57",
"5g\tc #AEADAB",
"6g\tc #F6F5E6",
"7g\tc #EEEEDF",
"8g\tc #5B5B51",
"9g\tc #55534F",
"0g\tc #313135",
"ag\tc #59596E",
"bg\tc #636169",
"cg\tc #7D7470",
"dg\tc #6F6766",
"eg\tc #4F4D58",
"fg\tc #807E7A",
"gg\tc #898877",
"hg\tc #838375",
"ig\tc #3D3D33",
"jg\tc #4D4D4B",
"kg\tc #666568",
"lg\tc #807D76",
"mg\tc #645F63",
"ng\tc #4C4B58",
"og\tc #4C4B47",
"pg\tc #3A382A",
"qg\tc #262318",
"rg\tc #37352B",
"sg\tc #565563",
"tg\tc #615F62",
"ug\tc #767472",
"vg\tc #5C5C62",
"wg\tc #4A4A59",
"xg\tc #393736",
"yg\tc #272217",
"zg\tc #120C06",
"Ag\tc #302B23",
"Bg\tc #565561",
"Cg\tc #615F64",
"Dg\tc #656368",
"Eg\tc #545460",
"Fg\tc #343135",
"Gg\tc #1B140D",
"Hg\tc #0D0701",
"Ig\tc #1F1813",
"Jg\tc #3D3936",
"Kg\tc #2D2D34",
"Lg\tc #575665",
"Mg\tc #5C5A63",
"Ng\tc #67646B",
"Og\tc #605E6A",
"Pg\tc #3B3A44",
"Qg\tc #16110E",
"Rg\tc #090301",
"Sg\tc #110B06",
"Tg\tc #27211B",
"Ug\tc #292629",
"Vg\tc #575768",
"Wg\tc #56565F",
"Xg\tc #636165",
"Yg\tc #68656E",
"Zg\tc #555464",
"`g\tc #1E1B1F",
" h\tc #0E0907",
".h\tc #080202",
"+h\tc #0D0706",
"@h\tc #1F1B1F",
"#h\tc #36343F",
"$h\tc #50505A",
"%h\tc #56575C",
"&h\tc #5D5D64",
"*h\tc #595866",
"=h\tc #201E23",
"-h\tc #0D090A",
";h\tc #0C0604",
">h\tc #181110",
",h\tc #201A1A",
"\'h\tc #302C31",
")h\tc #403F46",
"!h\tc #4A4953",
"~h\tc #4F4E5A",
"{h\tc #51505E",
"]h\tc #51505F",
"^h\tc #51505D",
"/h\tc #545461",
"(h\tc #2E2D37",
"_h\tc #1B191D",
":h\tc #0D0B0B",
"<h\tc #0A0606",
"[h\tc #0F0A09",
"}h\tc #181311",
"|h\tc #211E1B",
"1h\tc #282725",
"2h\tc #302D2E",
"3h\tc #36343A",
"4h\tc #42414C",
"5h\tc #4B4B5A",
"6h\tc #28272E",
"7h\tc #242329",
"8h\tc #24222A",
"9h\tc #302F38",
"0h\tc #444452",
"ah\tc #4C4B5C",
"                                                                             \
                                   . + @                                      \
                                                                              \
                       ",
"                                                                             \
                                 # $ % & * #                                  \
                                                                              \
                       ",
"                                                                             \
                                 = - ; > , \' .                               \
                                                                              \
                        ",
"                                                                             \
                               ) ! ~ { ] ^ / ( _                              \
                                                                              \
                       ",
"                                                                             \
                             _ : < [ } | 1 2 3 4 5                            \
                                                                              \
                       ",
"                                                                             \
                             6 7 8 9 0 a b c d e f g                          \
                                                                              \
                       ",
"                                                                             \
                         . h i j # k l m n o ] p q r s .                      \
                                                                              \
                       ",
"                                                                             \
                         t u v k k k k w x } y z A B C D E                    \
                                                                              \
                       ",
"                                                                             \
                       F G H k k k k I 7 J K L M x < N O P Q                  \
                                                                              \
                       ",
"                                                                             \
                     R S T U k k k _ V W } K } K K X Y Z `  ...               \
                                                                              \
                       ",
"                                                                             \
                   # +.K @.K #.. _ $.%.K } @.@.&.[ *.=.-.;.>.,.\'.#           \
                                                                              \
                        ",
"                                                                             \
                 # ).!.K @.~.{.].^./.(.} @.@._.:.<.[.}.|.1.2.3.4.5.5          \
                                                                              \
                       ",
"                                                                             \
               # * 6.K K 7.8.9.0.a.b.c._.@.[ d.e.# f.g.h.i.j.k.l.m.n.o.#      \
                                                                              \
                       ",
"                                                                             \
               Q p.} } q.r.s.t.u.v.w.x.@.@.W y.# k k z.A.B.C.D.E.F.G.H.I.     \
                                                                              \
                       ",
"                                                                             \
             R J.K } K.L.M.N.O.P.Q.R.S.J T.U.5 k k k V.W.X.Y.Z.`.K  +.+0 ++   \
                                                                              \
                       ",
"                                                                             \
           . @+< } } #+$+%+&+*+*+=+-+;+>+,+\'+k k k k )+!+h.x.~+c.{+]+^+/+(+_+\
E                                                                             \
                        ",
"                                                                             \
           :+<+K @.[+}+|+1+*+2+2+&+*+3+4+5+6+7+k k 8+9+T.0+a+_.{+b+c+G.d+e+B f\
+g+                                                                           \
                       ",
"                                                                             \
         = x } [ h+i+j+k+l+m+n+2+o+p+q+r+s+t+u+v+w+x+B.[ [ K.T.y+z+<+h.K } @.@\
.A+= #                                                                        \
                       ",
"                                                                             \
       o.B+[ K.C+D+E+F+G+H+1+m+m+I+o+q+2+*+J+K+L+M+B.[ [ K.N+O+P+Q+R+S+T+U+@.@\
.} <+V+#                                                                      \
                       ",
"                                                                             \
     W+X+[ K.Y+Z+`+ @.@+@@@#@1+$@o+%@t.2+*+P.&@*@=@-@;@K.>@,@\'@)@k k !@~@{@]@\
} @.@.} ^@E                                                                   \
                        ",
"                                                                             \
   _ @+@.[ U+/@(@_@:@<@[@}@|@#@$@=+p+1@*+*+*+*+2@3@4@5@T.O+6@7@z.k k k 8@9@9@J\
 @.0@a@b@c@d@                                                                 \
                       ",
"                                                                             \
 # e@J @.U+f@g@h@i@j@k@l@m@n@o@p@q@r@1+l+&+*+*+*+s@s+t@;@u@v@z.k k k d@w@T.x@y\
@[ }.z@k A@B@g #                                                              \
                       ",
"                                                                             \
 = <+@.@.C@D@E@F@G@H@I@J@K@L@M@N@p@O@p@P@r@%@*+*+*+&+Q@R@S@T@. k k I U@!+[ @.@\
.e+V@W@X@4 <+Y@Z@#                                                            \
                       ",
"                                                                            o\
.z+[ [ `@ #.#+#@###$#%#&#*#=#-#;#>#,#\'#)#!#~#{#*+*+*+*+]#^#/#(#_#k :#<#[ @.@.\
[#W T+}#|#[ @.@.K ( E                                                         \
                        ",
"                                                                          E 1\
#e+[ 2#3#4#5#6#7#@#.@8#9#0#a#b#c#d#e#f#g#h#9#l+i#o+n+o+n+j#k#l#m#n#X.T.@.} @.o\
#p#q#r#s#0@J } @.< t#)                                                        \
                       ",
"                                                                        _ u#v\
#0@} w#x#y#z#z#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O#P#1+*+Q#R#S#T#N.U#V#W#K.@.K.@.[#d\
.X#z.k Y#Z#<+} } [ @.`# $                                                     \
                       ",
"                                                                      # .$<+_\
.[ +$@$#$$$%$&$*$=$-$;$>$,$\'$)$0#N@r@1+r@!$~${$P@p+]$^$/$($o+o+_$:$<$[$@.@.[ \
}$|$k k k g 1$K } } } } K e@.                                                 \
                        ",
"                                                                      2$3$[ [\
 4$5$6$7$8$9$0$&#a$b$c$d$e$f$g$h$i$K#j$r@o@k$l$m$$@n+n$/$T#q+o$o+p$q$r$>@]@6@s\
$k k k k t$u$u$K } } } } } v$E                                                \
                       ",
"                                                                    d@w$@.[ @\
.x$y$z$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$P@Q$R$=#S$1+&+q+n+2+S#2+*+o+T$U$V$W$X$z\
.k k k Y$Z$K !.!.< } } @.} } `$d@                                             \
                       ",
"                                                                  E  %@.[ [$.\
%+%@%#%$%%%&%*%=%-%;%>%,%\'%)%!%~%{%]%^%A#/%(%\'%_%r@p+*+*+2+q+o+*+n+O.:%<%[%}\
%|%V.k 1%2%_.K u$!.*.K 0@@.< } @.3%4%#                                        \
                         ",
"                                                                5%6%7%W X 8%9\
%0%a%b%c%d%e%f%g%h%i%G#i%j%k%l%m%D$n%o%p%F$q%r%s%#@1+%@&+&+p+t.*+t%T#q+&+u%v%w\
%x%y%z%U+K.K K <+u$A%B%C%@.@.@.D%E%)+.                                        \
                       ",
"                                                                :+_.W [ F%G%H\
%I%h$J%K%L%M%N%O%P%Q%q@#@a$R%S%T%U%V%W%X%&$Y%Z%`% &l+k+.&m+$@+&*+@&#&q+*+*+$&%\
&&&O+!+K.@.@.&.*&=&-&z.;&>&@.*&,&\'&)&!&f.                                    \
                        ",
"                                                              = z+[ [ ~&{&]&^\
&/&(&_&:&<&[&}&|&1&2&3&4&5&6&7&8&9&0&a&b&K#a$c&d&e&O@r@k+$@$@1@t.*+O.P.O.2+&+f\
&g&h&i&K.@.J j&[$k&k k k l&m&n&8+k o&p&q&8                                    \
                       ",
"                                                            r&s&} @.t&u&v&e%w\
&x&y&z&A&B&C&D&E&F&Y%G&H&H&I&J&K&L&##!%M&N&J#O&P&Q&R&O@#@ &1+1@$@1+1+m+*+*+*+=\
+s@S&T&U&@.V&:.W&X&k k k * Y&Z&`& *.*+*@*#*y%#                                \
                       ",
"                                                          E  %[ K.o#$*%*&***=\
*-*;*>*,*\'*)*!*~*{*]*^*z#&#H&/*(*_*:*<*[*}*j%|*1*2*3*P#4*J##@~#5*1+$@%@&+*+o+\
*+O.&+6*7*8*!+9*z.k k k 5 0*a**.|#b*c*d*e*f*g*h*5%                            \
                        ",
"                                                        . i*@.U+U+j*k*l*m*n*o\
*p*q*r*s*t*u*k$v*w*x*y*z*Q$H#A*8#B*C*D*E*F*G*H*I*J*K*P#H#K#:@#@~#$@1+$@=+*+*+n\
+*+m+$@L*M*N*O*P*k k . Q*0@< Z&Z&Z&!.R*S*T*f*U*V*_                            \
                       ",
"                                                      # W*[ [ K.X*Y*Z*`* =.=+\
=@=#=$=%=&=*===-=;=>=\'*,=\'=)=!=~={=]=^=/=(=_=:=~%<=[=}=|=1=J##@#@r@~#$@.&1@=\
+{#=+m+=+$@2=3=4=5=6=1 7=8=K < u$Z&*.u$!.9=m&C.0=U*a=b=      # # # # f.f.f.f.#\
 #                       ",
"                                                      c=z+[ K.d=e=f=g=h=i=j=k\
=l=m=n=o=p=q=r=s=t=/%I@u=&$>%v=w=x=y=z=A=B=C=D=E=F=6#G=H=I=J=K=*$4*~#1+1+l+r@L\
#p@1+1@l+#@L=M=N=O=P=_.@.K K K < d.Q=-&R=|#S=T*C.T=4 U=# f.f.V=E W+W=W=W=X=W+_\
 # #                   ",
"                                                    Y=U.[ K.Z=`= -.-+-@-#-$-%\
-&-*-=-----;->-,-\'->%)-!-~-{-]-^-/-M$s%(-P%_-:-<-Z%[-}-|-1-(-2-P%J#p@#@#@#@N@\
3-4-q@l+r@p@z#H*5-6-7-} } @.} K _.8-# k 1%Q*9-0-a-b-c-d-e-Q s$f-g-h-i-j-k-i-l-\
W=V=#                   ",
"                                                  E m-} K._.n-o-p-q-:=r-s-&*t\
-u-$-v-&-q*w-x-y-z-A-B-~=C-D-E-F-G-H-I-J-I@&$K-L-M-c$N-O-P-Q-R-Q%S-Q$/%T-U-J=V\
-W-X-H#:@I&Y-Z-`- ;.;+;@;< C%9@#;E k k k b=u$m&a-$;c-%;C.&;g.*;=;-;;;>;,;\';);\
g-W=_ #                 ",
"                                                # !;@.@.[ ~;{;];^;/;(;_;:;<;[\
;};|;1;2;@=2;%-3;4;5;6;7;8;9;0;a;[*;%b;c;u=d;n%e;f;g;h;i;O#j;k;l;f#m;n;o;n%p;q\
;r;s;t;u;v;w;x;}&y;<*D#z;*&p#A;B;k k k # C;Y@R*R*D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R\
;S;V=#                 ",
"                                              # g.b+!+U+<$T;U;V;W;X;Y;Z;`; >.\
>+>@>#>$>v-%>@=&>*>=>->;>>>,>\'>)>!>~>{>]>^>/>(>J=_>:><>[>}>|>o%1>2>3>4>!-J-5>\
I@=$6>7>8>9>0>a>b>c>d>e>f>g>h>i>z.k k k j>h.!.!.*.k>k>l>m>n>M;o>p>q>r>s>t>u>v>\
w>F E #                 ",
"                                              x>y>0@W d=z>A>j%k$B><-C>D>E>F>/\
&G>H>I>J>K>L>M>N>O>P>Q>R> -S>T>U>V>2-W>X>Y>Z>`>@@ ,.,+,@,#,\'-$,%,&,*,=,S$!-z#\
z#-,i$;,>,,,\',),!,~,{,],y*^,/,(,_,b=k :,<,K < M b*[,},|,1,r>r>2,3,4,2,5,6,7,8\
,9,o.V=#                 ",
"                                            r&0,@.K.w.a,b,F+)=c,d,e,f,g,h,+,i\
,j,{%k,l,m,n,o,D>&*$-p,q,r,s,t,F$-,u,v,w,x,y,z,K=A,B,C,I>D,E,H#!-F,G,H,I,J,K,!\
-h%j%L,M,N,O,F&P,Q,R,S,T,H#U,V,W,X,#.Y,K.} [$@;Z,`, \'.\'+\'@\'#\'4,$\'%\'&\'*\
\'=\'-\';\'h-X=f.#                 ",
"                                          _ >\'K @.&.,\'\'\')\'Q$\'=0#!\'~\'{\
\']\'^\'/\'(\'V>h$_\':\'<\'[\'}\'|\'&*1\'2\'3\'4\'5\'6\'&$7\'$#C-8\'9\'0\'a\'b\
\'),c\'d\'T>e\'f\'!\'j@)-g\'h\'i\'I>j\'k\'l\'m\'m\'5>n\'o\'p\'q\'r\')#s\'|*K=t\
\'u\'v\'w\'x\'K.K.K.y\'z\'o>A\'B\'C\'D\'n>#\'E\'F\'G\'y H\'I\'J\'K\'o.V=#     \
              ",
"                                          L\'} } } M\'N\'O\'I#|@|@\'=H#0#P\'Q\
\'R\'S\'T\'U\'V\'5;W\'[;X\'Y\'Z\'`\' ).)+)@)#),=$)%)&)*)=)-);)U%>),)\')))!)~)s\
%P\'!\'|*>%b${)])^)/)j%u=()6#-%_):)<)[)})z*O&|)1)2) &3)4)5)K.6)7)8)9).\'0)0)a)\
b)c)d)e)f)g)h)i)j)F E f.                    ",
"                                      # k)< } @.l)m)n)H#\'=\'=H#Q$G#Q$)=l\'7&\
o)p)8$q)r)s) ).)t)%-u)v)w)x)y)|*z)A)B) )C)D)E)F)g%G)H)I)J)K)7\'L)M)j@!-I@N)O)<\
>P)Q)R)S)/=T)U)V)W)X)Y)Z)`) !.!g\'+!@!#!$!%!&!*!=!8)-!a).\'.\';!>!,!\'!)!!!~!{\
!]!^!E f.                      ",
"                                      /!3$} } (!_!:!H#Q$H#Q$Q$Q$G#\'=<![!}!|!\
1*1!i,#=s)2!.)&*%-#=&-3!v;!-4!5!6!e\'7!@=8!9!0!}>a!b!c!d!e!J-f!g!P\'K,k\'h!i!G\
-j!0&~$k!l!m!U)F$_%n!o!p!q!r!s!t!u!v!w!x!y!d)8)z!A!B!;!b)C!D!E!F!)!G!H!I!h)J!E\
 f.                        ",
"                                    d@K!< < L!M!N!H#H#Q$H#H#Q$Q$H#O!P!];Q!R!X\
\'e\'v-S!#=.) )m,v-.)T!x=U!V!W!t)X!e%e%Y!Z!`! ~.~+~G>v-@~\'-#~$~%~U)U)n%Z-&~*~\
=~-~;~>~,~\'~(-,=)~,=!~~~{~]~X%^~/~(~_~:~$\'<~c)[~}~D!|~|~9)1~2~3~4~5~@;e 6~E \
f.                          ",
"                                  _ 7~u$u$@;8~9~)\'Q$\'=\'=H#H#Q$Q$|@K=0~a~b~\
c~d~#=q*v- )t)l=&*s)e~f~g~h~i~j~[;K%#=k~l~H-m~n~o~K>p~q~r~s~t~u~v~w~x~L)y~z~E&\
}*A~B~C~D~E~F~n%(-k\'G~H~A#I~J~K~L~M~N~O~3,4,[~}~}~P~c)[~Q~R~S~T~U~@.R*V~E #  \
                           ",
"                                # v$K < @.W~N\'X~G#H#H#H#Q$G#G#H#Y~y*Z~`~ {S>\
.{;-.)L%t)+{W\'@{#{6!${%{&{*{L%v-={-{l*;{,>>{,{\'{){Q>!{~{{{]{G-G@Z%q;_%^{l=W;\
/{({\'-m%_{:{<{[{z*(-5\'z*}{|{s.1{2{|~c)|~|~|~8)3{O~[~4{5{6{7{8{9{K |#0{W+#   \
                            ",
"                                a{D%x K b{c{d{G#Q$Q$Q$Q$Q$G#H#e{p;f{<\'t)#=g{\
h{i{s)W\'o=j{k{l{m{l;7;n{o{p{q{r{s{t{u{v{z~.{w{x{y{p,z{A{B{C{f$D{E{F{p)G{e\'H{\
I{J{K{L{M{N{O{P{Q{J-R{S{T{U{V{W{X{r>|~|~|~|~Y{C!c)Z{`{ ]7{8{.]@.9-+]d@#       \
                          ",
"                              @],+#]L $]%]&]K#G#H#Q$Q$Q$G#Q$|@j@*]=]s)---];]>\
]L%j{,]\'])]!]~]U>{]]]f$^]/](]_]:]<][]}!}]|]E&1]2]3]4]5]6]7]#$8]<>/*8&9]-{0]a]\
b]c]4;d]e]f]g]h]i]j]k]l]m]n]n]o]|~|~|~|~|~C!.\'p]q]r]s]t]u];@u$v]w]#          \
                         ",
"                            o.x]y]z]A]B]C]D]E]G+F]G#G#G#q@Q$e{K,G][;.)]{H]I] \
)@{;-+{J]K]L]*$M]N]E#\'%O]P]Q]*]O%+#R]a%8&S]T]U]V]W]X]k=Y]Z]`] ^.^+^@^#^$^%^&^\
*^=^q!8!-^;^>^,^={\'^)^!^Y{q>r>~^D!|~|~|~Y{{^]^^^/^(^_^:^} u$<^[^#         # #\
 # # f.f.f.f.# #         ",
"                          E }^|^V.k R+1^a+2^3^4^N@:@N@:@K#Q$!\'J-5^W\'t)6^7^&\
-&-8^\'>;-9^0^i%Q$\'=!-a^b^c^d^e^T\'f^g^h^i^j^k^l^m^n^o^p^p*+)=,q^r^s^t^x{u^v^\
w^v^x^y^z^[]^>A^B^C^E-D^E^D!r>c)r>F^D!}~}~|~r>G^H^I^J^K^L^M^N^|#O^f.# # # f.f.\
_ E W+W+W=W=W=W+E _ # #     ",
"                        # P^Q^g+k k k R^E;e+S^T^U^:@V^4*K#Q$W^X^Y^a]Z^S$`^ /-\
-s)v-./+/H#q@N@q@|@2)@/#/$/H@;%%/&/*/=/-/5>q;;/>/Q>m=,/6]Q>\'/G{)/!/~/.^{/]/`;\
^///(/C$_/:/</[/}/|/c)c)}~r>[~c)3{3{D!#\'1/2/3/4/5/6/7/M 8/9/E V=E W+W=s$S;f-g\
-0/a/a/@]@]h-l-W=V=f.    ",
"                        b/c/d/# k k k y%x } @.e/f/g/h/#@N@\'=!-i/X!j/k/l/m/S!\
.)n/o/p/\'=q@N@K#U-\'=2)K=B-H~q/U!r/s/C>t/u/H@-%v/w/x/y/z/A/=-B/C/D/E/F/G/D>\'\
>c!H/I/J/K/L/M/N/O/P~P/|/|/}~Q/c)[~o]P~R/S/T/U/V/W/X/(!Y/Z/`/@]o.f-g-h-@]2$ (.\
(+(@(#($(%(&(*(=(g-W=_ #   ",
"                      -(;(i)5 k k k >(z%U+} @.} ,(\'()(E]:@\'=!(~({(](^(K]+{/\
(((_(/%Q$G#:(K#q@Q$e{z#n%<(G$[(}({-|(1(2(3(0!4(5(6([;7(8(=-J]9(Z!0(a;a(2]v-.)b\
(c(Q)d(e(f(g(h(o>o]|/i(|/|~|~c)c)j(k(l(m(n(o(p(q(r(s(t(*.u(@] (v(#.w(x(y(z(-.A\
(B(C(D(E(F(G(Q=R;F E #   ",
"                    E H(u$B I(. k V.J(K.} } @.K } @.K(L(M(\'=N(J,O(j%P(K>2]Q(\
R(|@Q$G#G+:@:(G#H#S(a\'T(V!T\'U({*V(W(X(-%%/Y(O#Z(`(l,t-P>v- _._+_@_q* >q*q*L>\
#_$_%_&_*_=_-_;_X{q>i(i(|~|~|~[~[~>_,_\'_)_!_~_{_]_} ^_/_(___:_<_[_}_|_E(1_2_3\
_4_5_6_7_8_9_0_a_w>l-W+f.  ",
"                  E b_c_N^u$K.d_e_T@L [#K @.@.0@Z$f_L g_h_i_I&R-d#j_k_l_m_)$H\
#Q$Q$G#G+n_G#Q$I&P\'o_p_q_r_(/}>s_t_u_v_@%w_x_y_z_A_B_$-u-C_D_E_J>F_G_P>7!H_I_\
J_K_L_M_N_O_|/r>i(i(|/|~|~o]o]P_Q_R_S_T_U_V_W_X_Y_Z_`_ :.:+:@:#:$:%:&:*:=:-:;:\
>:,:\':):!:~:Q;R;F E #   ",
"                  f.{:]:^:N^/:(:_:::<:} } K e+[:}:1 |:1:L+2:e(3:%$i;4:5:6:Q$G\
#G#G#G#G+G#Q$e{7:h%8:9:0:a:b:-/c:x_d:e:f:g:7#{-h:i:j:k{m=Y!k:l:2;m:n:o:p:q:r:s\
:t:u:v:w:c)}~3{i(i(|~|~D!R/x:y:z:A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:L:S:T:U:V\
:W:X:!:Y:a_Z:0/W=_ #   ",
"                    # `: <.<+<@<#<$<%<s(K &<[ *<z.k k =<p.-<;<><,<\'%\'<*$)<n\
_G+G#Q$G#G#H#e{z#)-!<~<{<]<^</<=%{=u_D*(<k^_<:<C-<<[<j:v)P>S!m:}<|<1<2<3<4<5<6\
<7<8<9<$\'0<|~|~a<3{}~}~3{b<c<d<e<f<g<h<S@i<j<k<l<m<n<o<p<m<q<R:$:Q:$:$:r<s<t<\
u<v<w<u>-\'J\'x<0/s$V=#     ",
"                        y<z<A<B<C<D<E<#(F<0@G<R+k k k |$H<X I<J<K<L<2)G#G#K#G\
+q@G#G#Q$|@|*U%>%M<N<O<P<Q<O%U!R<S<T<E$F$U<V<p{[<W<X<Y<Z<m=F_n:n:`<+_ [.[+[@[s\
>#[$[%[|/Q/c)i(3{3{3{&[*[8_=[-[;[>[,[\'[)[#:)[\'[![~[{[][^[/[/[z!([;__[G\'W::[\
<[[[}[|[);i-l-W=_ # #     ",
"                          5 1[2[3[4[5[6[u$D%7[k k k z.8[a+K.9[e+0[a[b[a$H#N@K\
#N@G#Q$c[!\'d[U)e[^]f[W<^%V>g[U(h[%/4>z*i[y*j[k[l[%^b(m[}<}<n[o[p[q[r[s[t[u[v[\
,!w[x[a<i(a<}~3{3{a<|/n])[;_)[O:O:y[#:z[z[Q:$:A[A[B[C[D[E[F[q>G[H[I[u<J[w<K[L[\
8,);K\'M[s$E f.#         ",
"                            N[O[P[Q[R[S[@.6.4%k k k T[0+@.[ @.@.} 5)U[V[W[I&q\
@Q$H#c[@@X[I@$)S,Y[[<Z[`[`- }.}+}-/@}F$,=@}#}$}%}A_P>&}n[*}=}-};}>},}\'}n])}X{\
Q/%[!}|/i(}~|~9)~})}{}]}^}^}O:/}\'[#:P:A[Q:A[$:A[(}_}:}<}[}}}|}1}2}3}4}I\'5}J\
\'6}7}f-W=E f.# #           ",
"                              N[8}9}Z&} @.0}! a}z.b}J @.@.@.} } Y+c}d}e}><f}7\
:@@I&J=z#U%l\'D$g}h}i}b%(*j}}!k}#)7\'@}N)D$l}m}n}o}p}m:&}q}r}m=s}t}u}v}w}x}y}~\
^P~Q/u[P~L;z}A}B}C}D}E}F}Q:([%:G})[P:A[$:$:H}A!8)I}J}K}L}M}N}O}P}=\'7,5}J\'Q}R\
}f-W=E f.# #               ",
"                                # S}T}u$@.@.[ y>a=n [ } @.@.U}a+V}W}X};@Y}Z}`\
} | |)-K,I@;%.|+|@|#|$|%|&|*|=|o;j^@}t=-|;|>|,|Q>m=&}&}\'|)|!|~|{|]|B[([w}[~[~\
=!^|{}/|(|_|:|<|[|}|[|A}||1|N:N:P:Q:$:$:8)8)q>2|3|4|5|6|7|8|9|Y:0|a|x<R}F W=E \
f.#                     ",
"                                # # o.b|< [ K.d.[ c|@.} } _.[#d|1%k # e|]@f|g\
|h|N)5>>%9>i|j|k|l|m|n|o|p|#)j^j^@}@}q|N{b(P>*-r|s|&}\'|u-t|u|v|w|o>8)w}([x|P:\
)[y|]}]}z|A}:|<|[|[|A|B|C|D|E|F|A[A[$:x|R/G|H|I|J|K|L|M|N|O|P|Q|9,0/F X=V=f.# \
                        ",
"                            # f.f.E W+Q R|[$U+d.d.K.[ @.} I<S|Y#k k k k T|a+O\
=U|V|W|-%X|Y|Z|`| 1.1+1G,@1@}@}t=J-7\'#1<;Y!r|&}$1%1&1*1=1-1;1>1=[,1\'1A[&:)1\
\'[#:\'[^}!1~1B|<|:|A|B|C|{1D|]1^1/1E|(1)[_1:1<1[1}1|14}11-\'8,);R;g-s$W+V=f.#\
                             ",
"                      # # f.E X=o.l-g-0/4%2131415161H!d.d.U~71V=# # k 8191K.[\
 01a1b1c1d1e1f1g1h1F/i1j1n%E$E$E$7\'k1l1&*m1F_n1o1p1q1r1s1t1z[/}u1v1w1G[)[&:x1\
G}y[y1t1[|B|B|A|[|}|{1D|z1A1B1C1D1E1F1G1H1P;8|I1Y:J1a|Q}7}l-s$E f.# #         \
                        ",
"                    # f.E W=F K1L1M1N1O1P1Q1R1S1T1U1V1W1X1Y1Z1o.W+f.E `1a+@.[\
 [$ 2.2+2@2h$#2$2%2J@j1b\'y*,=P%j^&2*2;-=2}<-2;2>2,2\'2)2!2~2{28)n])}]2^2O:q<q\
</2(2/2C|B|B|C|C|A}||}|_2:2<2[2}2|212223242[[}[5262w>R}F W=E f.# #            \
                         ",
"                # # _ W=F 72829202a2b2c2d2e2f2g2h2i2j2k2l2m2a-n2M[o.o2p2[ } }\
 &.L 51q2r2s2t2%,u25>k\'k\'v2G$w2x2y2z2A2B2C2,2D2E2F2G2H2I2J2K2D!|~~}\'1Q:N:x1\
x1L:L2M2N2O2A|A|}|~1P2Q2R2S2T2U2G!V2P}9|W2X2Y2);R;0/o.X=V=f.#                 \
                          ",
"              # f.E s$i-U Z2`2 3.3+3@3#3$3%3&3*3=3-3;3>3,3\'3w.Q^)3!3X1U+[ @.\
&.@.~3{31:]32:^3/3(3@}k\'v2_3w2:3<3[3}3|313233343536373839303a3j(Q/r>b3A[%:q<c\
3d3e3f3g3h3B|A|C}i3j3k3l3m3n3o3p3q3O|P|r3x<a/l-s$W+_ # #                      \
                         ",
"            # _ X=M[s3t3u3v3p&w3x3N|[[117,y3y37,11N|z3A3B3C3D3E35~F3G3K.} } &\
.@;H3k 5 S I3J3K3L3\'-M3N3O3P3Q3R3S3T3U3V3W3X3Y3Z3`3 4.4+4@4#4v13{Q/y}([/[1|$4\
$4%4&4*4=4-4;4>4,4l3\'4)4!4~4{4]4Q;^4K\'g-o.X=E f.# #                         \
                          ",
"          # V=Q 7[/4(4_4:4j.<4[4[[y3L[Q=v>8,Y2|[525}O|}4|41424344454X1d.@.[$M\
^64z.k z._ 742#849404a4b4c4d4e4f4g4h4G2i4j4k4l4m4n4o4p4q4r4s41/c)D!B[B[$:R:t4}\
|u4v4w4x4y4z4A4B433C4D4E4F4G4Z:a/l-W=E _ f.# #                                \
                       ",
"        # f.W=H4I4J4K4L4M4N4O4u>L[v>r3^49,R;K\'R;9,^4a|Q=P4Q4R4S4T4b*U4V4K.[#\
y]V.# # f.!@W4X4X Y4Z4`4 5.5+5@5#5$5%5&5*5=5-5;5>5,5\'5)5!5~5{5]5o]x}([B[%:^5/\
5(5_5:5<5[5}5|51525354555`@6575F W=E f.# #                                    \
                         ",
"        f.W+M[859505a5b5c5d5K[e5a|w>R}l-o.s$W=W=o.l-a/);0|f5g5h5i5j5G!545~L W\
}V=V=E k5l5U~K.m5F1n5o5p5q5r5s5t5u5v5w5x5y5z5A5B5>5C50)D5E5<$F5G5$:H5I5J5K5L5M\
5N5O5P5Q5R5S5T5U5y!`@V5!.h-W+V=f.#                                            \
                       ",
"      # _ s$W5X5Y5Z5`5 6P}9|-\'62i-F W=E _ f.f.f.f.E W=0/);.6+6@6#6$6%6T~&6*6\
V~F F l-=6X4$]-6;6>6,6\'6)6!6~6{6]6^6/6(6_6:6<6[6}6|616263646566676869606a6b6c\
6d6e6f6g6h6i6j6k6l6m6s(n6o6f.# #                                              \
                         ",
"      # W+0/p6q6r6s6t6u6v6Y:w6i-s$E f.# #       # # _ W=7}x6y6z6A6B6C6D6E6m2F\
6G6H6I6h>J6I5K6L6M6N6I2O6P6Q6R6_6/6h&S6T6S6U6V6W6X6Y6Z6`6 7.7+7@7#7$7%7&7*7=7-\
7;7>7,7\'7)7!7~7m6{7]7^7#                                                     \
                        ",
"      f.s$/7(7(2_7:7<7[7!:J1x<F E #                 # E M[);}7|7[|D[17273747m\
3576777879707a7y4b7c7d7e7I2f7g7h7i7S6j7T6k7l7m7n7o7p7q7r7s7t7u7v7w7x7y7z7A7B7C\
7D7E7F7G7H7I7J7K7L7M7f.                                                       \
                       ",
"    # V=F N7O7:2P7Q7R7:[u>Q;R}X=f.                  # V=F Z:S7T7U7V7W7X7Y7Z7>\
[`7 8.8r7+8@8#8$8%8&8*8=8-863;8>8,8\'8)8!8~8~8{8r1]8^8/8(8_8:8<8[8}8|818283848\
586878889808a8b8c8d8E                                                         \
                        ",
"    # E l-e8f8g8h8i8j83}y362g-E #                   # V=F k8l8m8n8o8p8q8r8s8t\
8u8v8w8x8y8z87{A8B842d58|C8D8E8F8`6G8H8I8J8K8L8T6M8N8O8P8Q8R8S8T8U8V8W8F7X8Y8Z\
8`8 9y*.9+9~3@9#9$9                                                           \
                       ",
"    # E g-%9&9*9=9-9;9X:Y:;\'M[E #                   # W+g->9,9\'9)9!9~9{9]9^\
9/9(9_9(4:9:9~4<9#;-\'5}e5}[O48{[9}9|919293949596979899909a9b9c9d9e9f9a4g998h9\
i9j9k9l9m9n9o9p9q9g+                                                          \
                          ",
"    # E l-Q|r9s9t9u9v9w97,r30/E #                 # V=s$75x9y9z9A9B9C9D9E9F9G\
9H9I9J9~4K9L9M9N9Z:w>x<x6O9F4P9Q9R9m4S9T9U9V9W9X9Y9Z9`9 0.0+0@0#0$0%0M3&0j^z*>\
%*0=0-0;0 2]7>0                                                               \
                       ",
"    # V=F Z:,0\'0)0!0~0{0]0|[i-s$f.#           # # V=W=h-^0/0(0_0:0<0[0}0|0:[\
v69|10.]m2X1V4M^20+(S;r&3040506070809000a0b0c0d0e0i4f0g0h0i0j0k0l0M3v=u=z*y*(-\
a\'m0n0o0p0q021#                                                              \
                         ",
"      f.W=R;r0s0t0u0v0w0x0-\');g-X=_ f.# # # f._ W+o.a/y0z0A0B0C0D0E0F0L|M|]0\
O|52r3G0~3I3U+[ U+H0[.I0!+K.J0K0L0M0N0O0P0Q0R0S0T0U0V0W0X04#Y0Z0J-`0z*G$y*k\' \
au!.a+ap0q04 @a                                                               \
                         ",
"      # W+0/a|#a$a%a&a*a=a-aP|6}0/S;W=W+W+W+W=S;g-;a>a,a\'a)a!aD<~a{aw<K[L[|[\
);R;0/S;x>]ap0;0*&^a3[/ag)(a_a:a<a[a}a|a1a2a\'!3a4a5a6am,7a8a9av2y*&$$)v20aI@K\
=aaba%<cada@                                                                  \
                         ",
"      # V=S;x<eafagahaz}b3iajakar3Q}R;a/R}7}75lamanaoapaqarasav6O4I\'e5J\'6}7\
}l-W=E _ f.E tauacavawaxayazaAaBaCaDaEaW$Fa3}Ga8{HaIaJaKaLa0$l\')-U)l\'U)a\'I@\
MaNaOaPaQaRaSa                                                                \
                            ",
"        f.X=R}|[TaUaVaWaXaYaZa`a b.b+b@b#b$b%b&b*b=b-b;b>b,bO4I\'e5Q;6}a/f-W=\
E f.# #     @a\'b)b!b~b{b]b^b/b(b_b:b<b[bv6}bx]F3U+|b1b2b3b,=y*(-I@)-)-K=4b5b6\
b7bQa8b)+#                                                                    \
                         ",
"        # V=F Q}L[9b0babbbcbdbebfbgbhbibjbO0kblbmbnbobpbqbN|O|a_);7}f-W=E f.#\
         # f.W++ rbsbtbubvbwbxbybzbAb42Y:Bb.]X4U}~3Cba1DbEbU%0ah%K=|*2)^,FbGbH\
bIbJb#                                                                        \
                       ",
"          f.X=h-Q|Kb{@LbMbNbObPbQbRbSbTbUbVbTbWbXbYbZb42]0L[a|9,g-W=E f.#    \
     # # V=X=F ;a`b c.c+c@c#c$c%c7|4}O|&cX o#&.u$u$41*c=c-c;c)=z#K=!\'>c,cya7b\
%<\'c)c                                                                       \
                         ",
"          # _ s$7}!cL[~c{c]c^c/c(c_cQb:c<c[c}c|c1c2c42u>5}Q|i-F W+f.#        \
   # _ W+S;a/e|3c4c<c295c6c7c8c9c0cacbccc[ *&t(p0!.@9dcecfcgchcH#i%j@icjckclcm\
cnc                                                                           \
                       ",
"            # V=s$7};\'Q=ocpcqcrcsctcuctcvcwcxcyczc]0~:v>);R}s$E f.#         \
# f.E s$B;AcBcCcDcEcFcGc\'9HcIcJcS~KcLcMc{7< < L7ca&.NcOc) PcQcRcSc@!TcUcVcHbW\
cXc                                                                           \
                         ",
"            # # E s$h-Z:J\'Q=O|oc[[N|I1I1[4[[I\'Y:-\'52r39,g-W=V=#         # \
# V=W=l-Yc_,Zc`cG^{2 d.d+d`6@d#d9cJ9E6*6o#$d< Z/p0^_%dy<k k s$&d*d=d-d;d>dPa,d\
\'dX&                                                                         \
                           ",
"              # # V=X=f-a/w>);a|Q;a_v>52v>8,J\'Q|6}R;0/S;W+_ #         # f.W+\
)d!d~d{d]d^dH|/d(d_d:d#:<d[d}d|d~454M^K.K Z&!.lc1dl&k k k k 2dcao03d>d4dQa^0z.\
                                                                              \
                        ",
"                  # f.E X=o.l-0/R}7}K\'K\'i-a/h-g-F s$W+V=f.#       # f.E W=g\
-5d6d7d8d9d0dadbdcdddv}=!:dedfdwcgdhdM^K.< |#Z&Y@idz.k k k jdkduaq0Z&Z/7bW4z. \
                                                                              \
                         ",
"                      # f._ V=E W+W+X=X=X=W+E E _ f.# #       # # _ W+f-ldmdn\
dodpdqdrdsdtdudvdwdxdydC!zdAdBdu>Cd*&o#[ DdEd41Fdk k k . GdHdIdca41HbJdd@     \
                                                                              \
                       ",
"                            # # # # f.f.f.# # # #           # f.E s$h-KdLdMdN\
dOdPdQdRd):{a3}3}SdTdUdj(VdWdXdYd|[ZdF;[#K `dq0 e.e\'&. +eHdcac_Z/lc@e)@      \
                                                                              \
                        ",
"                                                          # _ W+F #e$e%e&e*e=\
e-e;eSdv6O4[[oc7,11!:>e,eR/\'e)e!eP|R;2$~e{e0-]e|#^e/e(e_e:elc<e[e}e)+#       \
                                                                              \
                        ",
"                                                      # # V=W=g-|e1e2e3e4e5e6\
e7eP}4}I\'-\'a_a|r3J\'J18e9e&[0eae[40|9,s$81bece0-0-de9-deEd<eEd%6eeX##       \
                                                                              \
                          ",
"                                                    # f.W+o.fegeheiejekelemen\
eoeI1O|8,^4i-0/g-R}x<|[peqerese]00|9,s$f.. mateS=0-S*0-]eR*ueeeve#            \
                                                                              \
                       ",
"                                                  # V=W=l-wexeyezeAeBeCeDeEeP\
}N|e5r3R;l-W=W+E X=l-x<FeGes4Zbu>a_R;W=f.  # HeIe0-S=Ram&0-deJe1%             \
                                                                              \
                       ",
"                                              # f.E s$8 KeLeMeNeOePeQeRe~aSeN\
|Q=;\'a/o.E f.# # f.W=R}TeUeVe}^y3J\'7}X=f.    z.=<WeXeYeRaZe`e f             \
                                                                              \
                         ",
"                                            # f.E o.v .f+f@f#f$f%f&f*f=fSe]0Q\
=);h-s$V=# #     # W+g--f;f>f}bL[Q|0/W+#         ,f\'f)f!f~f{f#               \
                                                                              \
                        ",
"                                          # _ X=f-]f^f/f(f_f:f<f[f}f|fv6110|^\
40/W=V=#         # W+0/1f2f3f8eQ=^4M[E #           z.4f5fJb6f                 \
                                                                              \
                       ",
"                                      # f.E s$) 7f8f9f0fafbfcfdfef:[4}Y:|[x<g\
-X=_ #         # f.W=75M5ffQdgfa_9,S;V=#             z.hf#                    \
                                                                              \
                       ",
"                                    # f.W+F ifjfkflfmfIcnfofpfqfP}[4L[a|9,l-W\
+f.#           # E f-rfsftfufL[a|7}W=f.#                                      \
                                                                              \
                       ",
"                                  # _ W+Q vfwfxfyfzfAfBfCfefB8zcoc0|);a/S;E f\
.#           # f.W=g+DfEfFfY:J1);g-W+f.                                       \
                                                                              \
                       ",
"                                # f.W=@ GfHfIfJfKfLfMfNf7|8|]0L[Q;x<g-W=V=f.#\
           # f.W+l-OfPfQfRfL[Q;9,S;V=#                                        \
                                                                              \
                       ",
"                                f.W+1%SfTfUfVfWfXfYfEeX:O4Y:v>);7}F W+f.#    \
           f.E o.Zf`f g.gL[P|^40/X=f.                                         \
                                                                              \
                       ",
"                              # E F +g@g#g$g%g&g*g2cM|u>5}!cR;M[W=E f.#      \
       # f.E o.=g-g;g>g-\'P|627}s$V=#                                         \
                                                                              \
                        ",
"                              f.W=,g\'g)g!g~g{g]g}1d5W2v>^4R}o.W+f.# #       \
      # f.E o.^g/g(g_gJ152r39,F E f.                                          \
                                                                              \
                        ",
"                            # V=F :g<g[g<f}g|g2cv6y3Y2w>g-W=V=f.#            \
   # f.E s$1g2g3g4gP|a_629,l-W+f.#                                            \
                                                                              \
                       ",
"                            # E d@5g6g7g8g9g0g3}u>|[9,f-W+f.#                \
 # f.agb=bgcgdgeg|[Q;;\'9,M[X=f.#                                             \
                                                                              \
                        ",
"                            f.X=B;fggghgigjg[74}X2Q}f-W+f.#               # #\
 _ X=7[kglgmgngQ;a|^4K\'f-X=f.#                                               \
                                                                              \
                        ",
"                            f.W=feogpgqgrgReB8K[Q;R}W=f.#               # f.V\
=W=sgtgugvgwga|Q|Q}a/F W+f.#                                                  \
                                                                              \
                       ",
"                            f.W=;axgygzgAgvaP}7,!c0/W+f.#           # # _ E d\
@BgCgDgEgQ|Q|);9,0/o.W+f.#                                                    \
                                                                              \
                       ",
"                            f.W=R;FgGgHgIgJgKgocJ\'R}W=_ f.# # # # # f.V=R Lg\
MgNgOg8+^4^4w>i-g-s$E f.#                                                     \
                                                                              \
                        ",
"                            f.X=a/PgQgRgSgTgUg!e0|Q}g-s$W+V=_ f.f._ E VgWgXgY\
gZgx<x<9,K\'0/F X=V=# #                                                       \
                                                                              \
                        ",
"                            # E g-|[`g hB!.h+h@h#h|[^47}g-S;W=R k5y%$h%h&h*h7\
59,R;7}0/F W=E f.#                                                            \
                                                                              \
                       ",
"                            # V=F x<Y:=h-h%[;h>h,h\'h)h!h~h{hc=]hv+^h/hy%B;a/\
7}R}0/f-s$W+_ f.#                                                             \
                                                                              \
                        ",
"                              f.X=0/;\'L[(h_h:h<h[h}h|h1h2h3h4h5hi-l-l-g-g-g-\
M[F s$W+V=f.#                                                                 \
                                                                              \
                        ",
"                              # V=s$a/Q|Q=oc(h6h7h8h6h9h8e0hahK\'0/f-F S;S;s$\
W=W+V=f.# #                                                                   \
                                                                              \
                        ",
"                                # V=s$h-Q}w60|L[O|}[-\'0|Q;;\'9,R}f-s$W=W+W+E\
 _ f.# #                                                                      \
                                                                              \
                         ",
"                                  # _ X=F R}9,^462!c62);x<K\'0/F W=E V=f.f.# \
#                                                                             \
                                                                              \
                        ",
"                                    # f.E X=o.l-0/h-h-0/M[S;W=W+_ f.# #      \
                                                                              \
                                                                              \
                       ",
"                                        # f._ E W+W+X=W+E V=f.f.#            \
                                                                              \
                                                                              \
                       ",
"                                            # # # # # # # #                  \
                                                                              \
                                                                              \
                       "
};
static Fl_Pixmap image_logo(idata_logo);

void AboutDialog::cb_Close_i(Fl_Return_Button* o, void*) {
  o->window()->hide();
}
void AboutDialog::cb_Close(Fl_Return_Button* o, void* v) {
  ((AboutDialog*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

AboutDialog::AboutDialog() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = aboutDialog = new Fl_Double_Window(340, 370, "About Dialog");
    w = o;
    o->user_data((void*)(this));
    { Fl_Box* o = new Fl_Box(0, 0, 340, 155);
      o->image(image_logo);
    }
    { Fl_Box* o = new Fl_Box(0, 155, 340, 30, "Open Movie Editor");
      o->labelfont(1);
      o->labelsize(16);
    }
    { Fl_Box* o = new Fl_Box(0, 210, 340, 40, "(C)opyright 2005, 2006 Richard Spindler");
      o->labelsize(12);
    }
    { Fl_Box* o = version_box = new Fl_Box(0, 185, 340, 25, "0.0.0");
      o->labelfont(1);
    }
    new Fl_Box(0, 250, 340, 25, "Open Movie Editor is FREE Software (GPL)");
    new Fl_Box(0, 275, 340, 25, "http://openmovieeditor.sourceforge.net/");
    { Fl_Return_Button* o = new Fl_Return_Button(10, 335, 320, 25, "Close");
      o->callback((Fl_Callback*)cb_Close);
      w->hotspot(o);
    }
    o->set_modal();
    o->end();
  }
  version_box->label( VERSION );
}

void AboutDialog::show() {
  aboutDialog->show();
}

int AboutDialog::shown() {
  return aboutDialog->shown();
}

AboutDialog::~AboutDialog() {
  delete aboutDialog;
}
Fl_Button* g_playButton;
Fl_Button* g_firstButton;
Fl_Button* g_lastButton;
Fl_Button* g_backButton;
Fl_Button* g_forwardButton;
bool g_snap;
bool g_backseek;
bool g_use_jack_transport;
bool g_scrub_audio;
bool g_seek_audio;
Fl_Scrollbar* g_v_scrollbar;
bool g_16_9;
bool g_black_borders;
