/***************************************************************************
                          openmosixview.cpp  -  description
                             -------------------
    begin                : Son Jul 14 10:15:18 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include "openmosixview.h"
#include "filesave.xpm"
#include "fileopen.xpm"
#include "filenew.xpm"
#include "white.xpm"
#include "red.xpm"
#include "green.xpm"
#include "black.xpm"
#include "helpicon.xpm"
#include "remote.xpm"
#include "hosti_g.xpm"
#include "proc_g.xpm"
#include "load.xpm"
#include "comment.xpm"
#include "config.xpm"
#include "speed.xpm"
#include "migrator.xpm"
#include "ende.xpm"
#include "clear.xpm"
#include "load2.xpm"
#include "collector.xpm"
#include "fileopen_hell.xpm"
#include "filefind.xpm"
#include "apply.xpm"
#include "cancel.xpm"
#include "whatis.xpm"
#include "migmon.xpm"
#include "tdmon.xpm"



// constructor
OpenMosixViewApp::OpenMosixViewApp()
{
  setCaption("openMosixview " VERSION);

  clusternodes=0;
  restart=0;

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
	initActions();
	initMenuBar();
	initStatusBar();
	viewStatusBar->setOn(true);
	load_config();
	drawcluster();
}

// destructor
OpenMosixViewApp::~OpenMosixViewApp()
{
}


// ################################# helping functions ############################

  int file_exist(string filename)
{
	std::ifstream readfilename(filename.c_str());
	if (readfilename) {
		readfilename.close();
		return 1;
		} else {
		return 0;
	}
}

int string2int(const string s) {
        if (s.length() == 0) {
                return -1;
        } else {
                return(atoi(s.c_str()));
        }
}

string int2string(const int i) {
        char buf[12];
        sprintf(buf,"%d",i);
        return(string(buf));
}


int64_t string2ll(const string s) {
 if (s.length() == 0) {
   return -1;
   } else {
   return(atoll(s.c_str()));
  }
}


int min(int eins, int zwei) {
	if(eins>zwei) {
		return zwei;
		} else {
		return eins;
	}
}

int max(int eins, int zwei) {
 	if(eins<zwei) {
		return zwei;
		} else {
		return eins;
	}
}


// ################################# PUBLIC ############################

/** initializes all QActions of the application */
void OpenMosixViewApp::initActions(){

	QPixmap openIcon, saveIcon, newIcon, end, proc, white_pix, whatsthat, help, loadicon, migmonicon, tmon;
	newIcon = QPixmap(filenew);
	openIcon = QPixmap(fileopen);
	saveIcon = QPixmap(filesave);
	white_pix= QPixmap(white_xpm);
	end = QPixmap(ende);
	proc = QPixmap(proc_g);
	whatsthat = QPixmap(whatis);
	help = QPixmap(helpicon);
	loadicon = QPixmap(load);
	migmonicon = QPixmap(migmon_xpm);
	tmon = QPixmap(tdmon);

        QFont smfont1("helvetica");
        smfont1.setPixelSize(10);
			
	// init actions
  fileQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
  fileQuit->setStatusTip(tr("Quits the application"));
  fileQuit->setWhatsThis(tr("Exit\n\nQuits the application"));
  connect(fileQuit, SIGNAL(activated()), this, SLOT(slotFileQuit()));

  viewStatusBar = new QAction(tr("Statusbar"), tr("&Statusbar"), 0, this, 0, true);
  viewStatusBar->setStatusTip(tr("Enables/disables the statusbar"));
  viewStatusBar->setWhatsThis(tr("Statusbar\n\nEnables/disables the statusbar"));
  connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));

  helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
  helpAboutApp->setStatusTip(tr("About the application"));
  helpAboutApp->setWhatsThis(tr("About\n\nAbout the application"));
  connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

	QWhatsThis::add(this,"Control your openMosix-Cluster with openMosixview.\nThis GUI will help you manage the configuration, load and process-migration.\n");

  // background on top
  ontop= new QLabel(this,"ontop");
  ontop->setGeometry(0,0,740,90);
  ontop->setMinimumSize(0,0);
  ontop->raise();


	// the toolbar
	fileOpen = new QToolButton(ontop, "run programm");
	fileOpen->setGeometry(0,25,25,25);
	fileOpen->setPixmap(openIcon);
	connect(fileOpen, SIGNAL(clicked()), this, SLOT(slotFileOpen()));
	QWhatsThis::add(fileOpen ,"Use the advanced-execution dialog to start applications on your cluster.");

	configsave = new QToolButton(ontop, "config save");
	configsave->setGeometry(25,25,25,25);
	configsave->setPixmap(saveIcon);
	connect(configsave, SIGNAL(clicked()), this, SLOT(save_config()));
	QWhatsThis::add(configsave ,"This buttons saves your rsh/ssh-configuration.");

	exec_procbox = new QToolButton(ontop, "local processbox");
	exec_procbox->setGeometry(50,25,25,25);
	exec_procbox->setPixmap(proc);
	connect(exec_procbox, SIGNAL(clicked()), this, SLOT(proc_box()));
	QWhatsThis::add(exec_procbox ,"Open openMosixprocs on this node. It is a graphical process-list like top.");

	analyzer = new QToolButton(ontop, "analyzer");
	analyzer->setGeometry(75,25,25,25);
	analyzer->setPixmap(loadicon);
	connect(analyzer, SIGNAL(clicked()), this, SLOT(start_openMosixanalyzer()));
	QWhatsThis::add(analyzer ,"Open the openMosixanalyzer, a graphical display for logfiles from the openMosixcollcetor.");

	migmon = new QToolButton(ontop, "migmon");
	migmon->setGeometry(100,25,25,25);
	migmon->setPixmap(migmonicon);
	connect(migmon, SIGNAL(clicked()), this, SLOT(start_openMosixmigmon()));
	QWhatsThis::add(migmon ,"Open the openMosixmigmon, a graphical display for process migration.");



  if(file_exist(threedmosmon)) {

  	tdmosmon = new QToolButton(ontop, "analyzer");
  	tdmosmon->setGeometry(125,25,25,25);
  	tdmosmon->setPixmap(tmon);
  	connect(tdmosmon, SIGNAL(clicked()), this, SLOT(start_3dmosmon()));
  	QWhatsThis::add(tdmosmon ,"Starts the 3dmosmon, a 3d openMosix monitor applet.");

  	helpme = new QToolButton(ontop, "whatisthis");
  	helpme->setGeometry(150,25,25,25);
  	helpme->setPixmap(help);
  	connect(helpme, SIGNAL(clicked()), this, SLOT(slotHelp()));
  	QWhatsThis::add(helpme ,"Open the openMosixview-help dialog.");

  	whatisthis = new QToolButton(ontop, "whatisthis");
  	whatisthis->setGeometry(175,25,25,25);
  	whatisthis->setPixmap(whatsthat);
  	connect(whatisthis, SIGNAL(clicked()), this, SLOT(slot_whatisthis()));
  	QWhatsThis::add(whatisthis ,"Enter the what-is-this mode. Click on any item on the GUI and what-is-this will explain howto use it.");

    } else {

  	helpme = new QToolButton(ontop, "whatisthis");
  	helpme->setGeometry(125,25,25,25);
  	helpme->setPixmap(help);
  	connect(helpme, SIGNAL(clicked()), this, SLOT(slotHelp()));
  	QWhatsThis::add(helpme ,"Open the openMosixview-help dialog.");

  	whatisthis = new QToolButton(ontop, "whatisthis");
  	whatisthis->setGeometry(150,25,25,25);
  	whatisthis->setPixmap(whatsthat);
  	connect(whatisthis, SIGNAL(clicked()), this, SLOT(slot_whatisthis()));
  	QWhatsThis::add(whatisthis ,"Enter the what-is-this mode. Click on any item on the GUI and what-is-this will explain howto use it.");
  }

	label_refresh1= new QLabel(ontop,"refresh1");
	label_refresh1->setGeometry(230,27,45,20);
	label_refresh1->setMinimumSize(0,0);
	label_refresh1->setText("refresh");
	label_refresh1->setMargin(1);
	QWhatsThis::add(label_refresh1 ,"set the timeout value in seconds for the main refresh");
	
	refreshtimeoutbox= new QSpinBox(ontop, "refresh");
	refreshtimeoutbox->setGeometry(280,27,35,20);
	refreshtimeoutbox->setMinimumSize(0,0);
	refreshtimeoutbox->setValue(5);
	refreshtimeoutbox->setMinValue(1);
	refreshtimeoutbox->setMaxValue(60);
	QWhatsThis::add(refreshtimeoutbox ,"set the timeout value in seconds for the main refresh");

	label_refresh2= new QLabel(ontop,"refresh2");
	label_refresh2->setGeometry(315,27,20,20);
	label_refresh2->setMinimumSize(0,0);
	label_refresh2->setText("s");
	label_refresh2->setMargin(1);
	QWhatsThis::add(label_refresh2 ,"set the timeout value in seconds for the main refresh");
					
	label_collector1= new QLabel(ontop,"collector1");
	label_collector1->setGeometry(560,25,160,20);
	label_collector1->setMinimumSize(0,0);
	label_collector1->setText("openMosixcollector status");
	label_collector1->setMargin(1);

	label_collector2= new QLabel(ontop,"collector2");
	label_collector2->setGeometry(550,30,10,10);
	label_collector2->setMinimumSize(0,0);
	label_collector2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	label_collector2->setText("");
	label_collector2->setMargin(1);


   // here we start to draw the static cluster widgets
	QLabel_clusterid= new QLabel(ontop,"id");
	QLabel_clusterid->setGeometry(10,50,20,20);
	QLabel_clusterid->setMinimumSize(0,0);
	QLabel_clusterid->setText("id");
	QLabel_clusterid->setMargin(0);

	QLabel_clusternodes= new QLabel(ontop,"clusternodes");
	QLabel_clusternodes->setGeometry(45,50,80,20);
	QLabel_clusternodes->setMinimumSize(0,0);
	QLabel_clusternodes->setText("clusternodes");
	QLabel_clusternodes->setMargin(0);

	QPushButton_all_nodes= new QPushButton("all-nodes", ontop);
	QPushButton_all_nodes->setName("all-nodes");
	QPushButton_all_nodes->setGeometry(45,70,105,20);
	QPushButton_all_nodes->setMinimumSize(0,0);
	QPushButton_all_nodes->setText("all-nodes");
	QObject::connect(QPushButton_all_nodes, SIGNAL(clicked()), this, SLOT( neuwin()) );
	QWhatsThis::add(QPushButton_all_nodes ,"Click to configure all nodes You can execute the most common mosctl-command or stop/start openMosix.\n");

	// the cluster id label
	QLabel_clusterid_label= new QLabel(ontop,"NoName");
	QLabel_clusterid_label->setGeometry(5,70,40,20);
	QLabel_clusterid_label->setMinimumSize(0,0);
	QLabel_clusterid_label->setBackgroundPixmap(QPixmap(white_pix));
	QLabel_clusterid_label->setFont(smfont1);
	QLabel_clusterid_label->setText("all");
	QLabel_clusterid_label->setMargin(0);
	QLabel_clusterid_label->setAlignment( AlignVCenter | AlignCenter );
	QLabel_clusterid_label->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QWhatsThis::add(QLabel_clusterid_label ,"This row shows the overall informations about your cluster.");

	QProgressBar_balance= new QProgressBar(ontop, "overall");
	QProgressBar_balance->setGeometry(150,70,150,20);
	QProgressBar_balance->setMinimumSize(0,0);
	QProgressBar_balance->setTotalSteps(200);
	QProgressBar_balance->setProgress(200);
	QWhatsThis::add(QProgressBar_balance ,"This progressbar shows how good the loadbalancing works. It displays the diffrence between the min. and max. load values for the whole cluster.");

  QLabel_balance= new QLabel(ontop,"NoName");
  QLabel_balance->setGeometry(150,50,160,20);
  QLabel_balance->setMinimumSize(0,0);
  QLabel_balance->setText("load-balancing efficiency");
  QLabel_balance->setMargin(1);

 	QProgressBar_overall= new QProgressBar(ontop, "overall");
	QProgressBar_overall->setGeometry(315,70,130,20);
	QProgressBar_overall->setMinimumSize(0,0);
	QProgressBar_overall->setTotalSteps(100);
	QWhatsThis::add(QProgressBar_overall ,"This progressbar displays the mean load of your cluster.\n");

  QLabel_overall_load= new QLabel(ontop,"overall load");
  QLabel_overall_load->setGeometry(315,50,160,20);
  QLabel_overall_load->setMinimumSize(0,0);
  QLabel_overall_load->setText("overall load");
  QLabel_overall_load->setMargin(1);

  QLabel_overall_memory= new QProgressBar(ontop,"overallmem");
  QLabel_overall_memory->setGeometry(460,70,130,20);
  QLabel_overall_memory->setTotalSteps(100);
  QLabel_overall_memory->setProgress(0);
  QWhatsThis::add(QLabel_overall_memory ,"This box shows the overall used memory of your cluster.\n");

  QLabel_overall_memory1= new QLabel(ontop,"NoName");
  QLabel_overall_memory1->setGeometry(455,50,160,20);
  QLabel_overall_memory1->setMinimumSize(0,0);
  QLabel_overall_memory1->setText("overall used memory");
  QLabel_overall_memory1->setMargin(1);

  QLabel_overall_mem= new QLabel(ontop,"allmem");
  QLabel_overall_mem->setGeometry(600,70,60,20);
  QLabel_overall_mem->setMinimumSize(0,0);
  QLabel_overall_mem->setBackgroundPixmap(QPixmap(white_pix));

  QLabel_overall_mem->setNum(0);
  QLabel_overall_mem->setMargin(0);
  QLabel_overall_mem->setAlignment( AlignVCenter | AlignCenter );
  QLabel_overall_mem->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  QWhatsThis::add(QLabel_overall_mem ,"This box shows whole memory of your cluster.\n");

  QLabel_overall_mem1= new QLabel(ontop,"mb");
  QLabel_overall_mem1->setGeometry(660,70,25,20);
  QLabel_overall_mem1->setMinimumSize(0,0);
  QLabel_overall_mem1->setText("MB");
  QLabel_overall_mem1->setMargin(1);

  QLabel_overall_mem2= new QLabel(ontop,"all mem");
  QLabel_overall_mem2->setGeometry(595,50,70,20);
  QLabel_overall_mem2->setMinimumSize(0,0);
  QLabel_overall_mem2->setText("all memory");
  QLabel_overall_mem2->setMargin(1);

  QLabel_allcpu= new QLabel(ontop,"allcpu");
  QLabel_allcpu->setGeometry(685,70,30,20);
  QLabel_allcpu->setMinimumSize(0,0);
  QLabel_allcpu->setBackgroundPixmap(QPixmap(white_pix));
  QLabel_allcpu->setNum(0);
  QLabel_allcpu->setMargin(0);
  QLabel_allcpu->setAlignment( AlignVCenter | AlignCenter );
  QLabel_allcpu->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  QWhatsThis::add(QLabel_allcpu ,"This box shows how many processors your cluster has.\n");

  QLabel_allcpu1= new QLabel(ontop,"allcpu");
  QLabel_allcpu1->setGeometry(680,50,45,20);
  QLabel_allcpu1->setMinimumSize(0,0);
  QLabel_allcpu1->setText("all cpu");
  QLabel_allcpu1->setMargin(1);

}



void OpenMosixViewApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

	
	fileMenu=new QPopupMenu();
	fileMenu->insertItem("run programm", this, SLOT(slotFileOpen()), 0, ID_FILE_OPEN);
	fileMenu->insertSeparator();
	fileQuit->addTo(fileMenu);

	confmenu=new QPopupMenu();
	confmenu->setCheckable(true);
	confmenu->insertItem("use ssh", this, SLOT(setsshconfig()), 0, ID_SSH);
	confmenu->setItemChecked(ID_SSH, false);
	confmenu->insertSeparator();
	confmenu->insertItem("save conf", this, SLOT(save_config()), 0, ID_SAVE);

	viewMenu=new QPopupMenu();
	viewMenu->setCheckable(true);
	viewStatusBar->addTo(viewMenu);

	helpMenu=new QPopupMenu();
	helpMenu->insertItem("Help",this, SLOT(slotHelp()), 0, ID_HELP_ABOUT);
	helpMenu->insertSeparator();
	helpMenu->insertItem("What is this", this, SLOT(slot_whatisthis()), 0, ID_HELP_WHATIS);
	helpMenu->insertSeparator();
	helpMenu->insertItem("About...", this, SLOT(slotHelpAbout()), 0, ID_HELP_HELP);

	collector_start_stop=new QPopupMenu();
	collector_start_stop->insertItem("start", this, SLOT(start_openMosixcollector()), 0, ID_COL_START);
	collector_start_stop->insertSeparator();
	collector_start_stop->insertItem("stop", this, SLOT(stop_openMosixcollector()), 0, ID_COL_STOP);
	collector_start_stop->insertSeparator();
	collector_start_stop->insertItem("checkpoint", this, SLOT(checkpoint_openMosixcollector()), 0, ID_COL_CHECK);
	collector_start_stop->insertSeparator();
	collector_start_stop->insertItem("save history", this, SLOT(restart_openMosixcollector()), 0, ID_COL_SHIST);
	collectormenu=new QPopupMenu();
	collectormenu->insertItem("openMosixcollector", collector_start_stop);


	menuBar()->insertItem(tr("&File"), fileMenu);
	menuBar()->insertItem(tr("&View"), viewMenu);
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("&Config"), confmenu);
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("Collector"), collectormenu);
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("&Help"), helpMenu);

}



void OpenMosixViewApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message("Ready.");
}



// converts a cluster id to an hostname
string OpenMosixViewApp::getnodename(string node) {
	// gather nodes hostname
	string which;
	char zeile[201];
	string nodename;
	which = which + clustercommand + " whois ";
	which = which + node + " > /tmp/nodes.tmp";
	system(which.c_str());
	if (file_exist("/tmp/nodes.tmp")) {
		std::ifstream readnodename("/tmp/nodes.tmp");
		if (readnodename) {
			readnodename.getline(zeile, 200);
			nodename.erase();
			nodename= nodename+zeile;
			readnodename.close();
			} else {
			cout << "could not read from /tmp/nodes.tmp"  << endl;
			return 0;
		}
	}
   return nodename;
}


// returns howmany nodes we are
int OpenMosixViewApp::gethowmanynodes() {
	struct dirent **namelist;
	int n;
	int howmanynodes=0;

	n = scandir(clusterdirectory, &namelist, 0, 0);
	if (n < 0) {
		return 0;
		} else {
		while(n--) {
			if(!strchr(namelist[n]->d_name, '.')) {
				howmanynodes++;
				free(namelist[n]);
			}
		}
		free(namelist);
	return howmanynodes;
	}	
}


 // check if the cluster-config changed
 bool OpenMosixViewApp::checknodes() {
	if (gethowmanynodes()==clusternodes) {
		return true;
		} else {
   	return false;
	}
}


// returns values from /proc interface
string OpenMosixViewApp::getprocvalue( string nodeid, string what ) {


	string tmpstr;
	string cread;
	char zeile[21];
	tmpstr=tmpstr + clusterdirectory + nodeid + "/" + what;
	std::ifstream readval(tmpstr.c_str());
	if (readval) {
		readval.getline(zeile, 20);
		cread.erase();
		cread=cread+ zeile;
		readval.close();
		if(string2int(cread)<0) {
			return "0";
			} else {
			return cread;
		}
		} else {
		cout << "could not read from " << clusterdirectory << what << tmpstr << endl;
    // count up restart / if restart i bigger than 10 we redraw
    // because the cluster-config might have changed
    restart++;
		return "0";
	}
}



// ################################# PUBLIC SLOTS ############################


  // exits the Application
void OpenMosixViewApp::slotFileQuit()
{
  statusBar()->message("Exiting application...");
      qApp->quit();
}

  //turn Statusbar on or off
void OpenMosixViewApp::slotViewStatusBar(bool toggle)
{
  statusBar()->message("Toggle statusbar...");
  if (toggle == false)
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }
  statusBar()->message("Ready.");
}


// about ...
void OpenMosixViewApp::slotHelpAbout()
{
  QMessageBox::about(this,tr("About..."),
                      tr("openMosixView\nVersion " VERSION "\n(c) 2002 by Matt Rechenburg") );
}


// the help-method
void OpenMosixViewApp::slotHelp() {

  QPixmap white_pix, help, prem, conf, com, lo, procicon_g, smile, migrat, load_icon, collector_icon, open_icon, finder;
	white_pix= QPixmap(white_xpm);
	help = QPixmap(helpicon);
	prem = QPixmap(remote);
	conf = QPixmap(config);
	lo = QPixmap(load);
	com = QPixmap(comment);
	procicon_g= QPixmap(proc_g);
	smile = QPixmap(speed);
	migrat = QPixmap(migrator);
	load_icon = QPixmap(load2);
	collector_icon = QPixmap(collector);
	open_icon = QPixmap(fileopen_hell);
	finder = QPixmap(filefind);

	QTabDialog *tabs = new QTabDialog();
	tabs->setGeometry(200,50,300,200);
	tabs->resize(530, 300);
        QFont font3("helvetica");
        font3.setPixelSize(12);
        tabs->setFont(font3);
			
	QLabel *a = new QLabel(tabs, 0, 0);
	a->setGeometry(5,5,20,20);
	a->resize(200, 200);
	a->setMargin(3);
	a->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	a->setBackgroundPixmap(QPixmap(white_pix));
	a->setText("Help on openMosixview\n\nopenMosixview is designed to manage openMosix-Cluster.\n"	\
	"(more information about openMosix on www.openmosix.org)\n" \
	"It gives an overview of what happen on your system(s)\nand helps to distribute processes to the best available nodes\n" \
	"automatically or manually. The configuration of each.\n" \
	"cluster-member can be changed by dialog-windows.\n\n" \
	"I hope this free software is usefull for you and your are\n" \
	"invited to send me your comments or wanted features.\n\n" \
	"M. Rechenburg / mosixview@t-online.de");

	QLabel *b = new QLabel(tabs, 0, 0);
	b->setGeometry(5,5,20,20);
	b->resize(200, 200);
	b->setMargin(3);
	b->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	b->setBackgroundPixmap(QPixmap(white_pix));
	b->setText("Config your cluster\n\nIf you click on an host-button a configuration-dialog will pop up\n"	\
	"The following most common use openMosix-commands can be execute\n" \
	"on every cluster-node:\n" \
	"automigration on/off, quiet yes/no, bring/lstay yes/no,\n" \
	"expel yes/no, openMosix stop/start.\n\n");

	QLabel *c = new QLabel(tabs, 0, 0);
	c->setGeometry(5,5,20,20);
	c->resize(200, 200);
	c->setMargin(3);
	c->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	c->setBackgroundPixmap(QPixmap(white_pix));
	c->setText("Set the speed/priority of each node\n\nYou can adjust the openMosix-speed with the sliders for each node.\n"	\
	"Processes will easier migrate to cluster-nodes with more openMosix-speed.\n" \
	"Just increase the speed of one host which less load and the load\n" \
	"will also increase because openMosix 'thinks' that this host can handle\n" \
	"more processes and will migrate processes to.\n" \
	"If an host has too much load, decrease the speed and the load will\n" \
	"decrease, too.\n\n" \
	"Use the speed-sliders to set the priority for each cluster-member.\n" \
	"Of course you can change this also at runtime.\n" \
	"Managing the load-balancing manually or automatically is easy now.\n");

	QLabel *d = new QLabel(tabs, 0, 0);
	d->setGeometry(5,5,20,20);
	d->resize(200, 200);
	d->setMargin(3);
	d->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	d->setBackgroundPixmap(QPixmap(white_pix));
	d->setText("Load and Memory on your cluster\n\n"	\
	"The two progressbars are displaying the load and memory values\n" \
	"on your cluster.\n" \
	"\n" \
	"Memory is count in percent of used memory on each cluster-node.\n" \
	"The whole physical available memory is shown on the left of the\n" \
	"memory-progressbar.\n" \
	"\n" \
	"The load is count in percent too so it just gives you an overview\n" \
	"of the load. It does not exactly represent the the value of\n" \
	"/proc/hpc/nodes/x/load of each node!\n" \
	"\n");

	QLabel *e = new QLabel(tabs, 0, 0);
	e->setGeometry(5,5,20,20);
	e->resize(200, 200);
	e->setMargin(3);
	e->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	e->setBackgroundPixmap(QPixmap(white_pix));
	e->setText("Processes on your cluster\n\nClick on the local procbox button and\n"	\
	"you can watch all your running processes on the local maschine.\n" \
	"(you should start all procs from your 'local-node' because then\n" \
	"they appear in the process-list as local)\n" \
	"The processes are sorted by the column you click on.\n" \
	"Just double-click on a process and a new dialog-box will appear\n" \
	"in which you can choose the host you want the process to migrate\n" \
	"to. The second column shows the openMosix-node number on which the\n" \
	"process is running. 0 stands for local, any other number is remote.\n" \
	"Remote processes are easy to recognize by the green proc-icon.\n" \
	"Unmoveable processes will appear with a lock icon!\n");

	QLabel *f = new QLabel(tabs, 0, 0);
	f->setGeometry(5,5,20,20);
	f->resize(200, 200);
	f->setMargin(3);
	f->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	f->setBackgroundPixmap(QPixmap(white_pix));
	f->setText("Managing procs from remote nodes\n\nBy clicking on the button below the processbox you can influence\n"	\
	"the processes from remote nodes running on this host.\n" \
	"The popup-window will show how many procs from remote are\n" \
	"currently migrated to this host and from where they come from.\n" \
	"\n" \
	"You can migrate one processes back to its home node or to the\n" \
	"best available node in your cluster. If you choose the second\n" \
	"possibility openMosix decides where the proc will go.\n" \
	"(this can also influenced by the speed-sliders)\n" \
	"\n" \
	"\n");

	QLabel *g = new QLabel(tabs, 0, 0);
	g->setGeometry(5,5,20,20);
	g->resize(200, 200);
	g->setMargin(3);
	g->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	g->setBackgroundPixmap(QPixmap(white_pix));
	g->setText("Remote processbox\n\nIn the configuration window of each host you can\n"	\
	"click on the remote-procbox-button to open a remote migrator-box.\n" \
	"If properly installed on each cluster-node this button executes a\n" \
	"xhost +hostname local on your maschine to allow remote X-apps to be\n" \
	"displayed. After that it runs a rsh (or ssh) to the node which opens the process-box.\n" \
  "\n" \
	"If you are logged on your cluster from a remote workstation put your local hostname\n" \
	"in the edit-box below the 'remote proc-box'-button. Then the openMosixview_client will\n" \
	"be displayed on your workstations display and not on the display of the\n" \
	"cluster-node you are logged on (add 'xhost +clusternode' at your workstation).\n");

	QLabel *h = new QLabel(tabs, 0, 0);
	h->setGeometry(5,5,20,20);
	h->resize(200, 200);
	h->setMargin(3);
	h->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	h->setBackgroundPixmap(QPixmap(white_pix));
	h->setText("Help on openMosixAnalyzer\n\n"	\
	"Use the openMosixAnalyzer to analyze the logfiles produced by\n" \
	"the openMosixcollector.\n" \
	"The openMosixCollector is a daemon running on one cluster-node.\n" \
	"It saves the load+mem+more dynamical informations of each node.\n" \
	"openMosixanalyzer analyzes these log-files from the directory /tmp/openmosixcollector\n" \
	"and produces a graphical overview of the load- and memory history.\n" \
	"All openMosix-tools can be managed from the main openMosixview-application.\n" \
	"You can even set checkpoints everytime you want. These checkpoints\n" \
	"are marked in the openMosixAnalyzer. ");

	QLabel *i = new QLabel(tabs, 0, 0);
	i->setGeometry(5,5,20,20);
	i->resize(200, 200);
	i->setMargin(3);
	i->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	i->setBackgroundPixmap(QPixmap(white_pix));
	i->setText("openMosixCollector\n"	\
	"The openMosixCollector is a small daemon started on one cluster-member.\n" \
	"It collects the load/mem/procs of all cluster-nodes to /tmp/openmosixview/*\n" \
	"and writes a  PID-file to /tmp/mosixcollector.pid.\n" \
	"openmosixcollector -d			// starts the collector as a daemon\n" \
	"openmosixcollector -k			// stops the collector\n" \
	"openmosixcollector -c			// write a checkpoint to the history\n" \
	"openmosixcollector -r			// saves the history and start a new one\n" \
	"				// (automatically executed once a day!)\n" \
	"openmosixcollector -help		// print out a short help\n" \
	"openmosixcollector -h			// print out a short help\n");

	QLabel *j = new QLabel(tabs, 0, 0);
	j->setGeometry(5,5,20,20);
	j->resize(200, 200);
	j->setMargin(3);
	j->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	j->setBackgroundPixmap(QPixmap(white_pix));
	j->setText("openMosixAnalyzer\n\n"	\
	"The openMosixAnalyzer analyzes the data collected by openMosixCollector\n" \
	"in a graphical way. By default it displays the current dataset\n" \
	"from the directory /tmp/openmosixcollector/* but of course you can open older\n" \
	"history logfiles by the filemenu.\n" \
	".\n");

	QLabel *k = new QLabel(tabs, 0, 0);
	k->setGeometry(5,5,20,20);
	k->resize(200, 200);
	k->setMargin(3);
	k->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	k->setBackgroundPixmap(QPixmap(white_pix));
	k->setText("Comments on openMosixview\n\n"	\
	"I am looking forward to any comment, bug report or\n" \
	"wanted features.\n" \
	"I also want to use this for saying thanks all\n" \
	"developers/contributors for the great work they do on openMosix.\n" \
	"Thanks to all testers of openMosixview who report bugs/probs ot me.\n" \
	"Last but not least a warm thanks also to my wife who\n" \
	"gives me the time for developing, clustering, linuxing,\n" \
	"fixing problems, installing, trying new software.....\n" \
	"\n" \
	"Hope you have fun with openMosixview.\n");

	tabs->addTab(a, help,  "general");
	tabs->addTab(b, conf,  "config");
	tabs->addTab(c, smile, "speed");
	tabs->addTab(d, lo, "load");
	tabs->addTab(e, procicon_g, "procs");
	tabs->addTab(f, prem, "remote");
	tabs->addTab(g, migrat, "migrator");
	tabs->addTab(h, help, "load/collector");
	tabs->addTab(i, collector_icon, "openMosixcollector");
	tabs->addTab(j, load_icon, "openMosixanalyzer");
	tabs->addTab(k, com, "comments");
	tabs->show();
}


// scrolls the main groupbox-widget
void OpenMosixViewApp::scroll_view( int value ) {
	int current_h=0;
	current_h=QGroupBox_1->height();
	QGroupBox_1->setGeometry(0, -value+90, 720, current_h);
}



// opens the configuration window for one or all nodes
void OpenMosixViewApp::neuwin() {

	const  char *hostname;
	string gethostcommand;
	const QObject *button = sender();
	char *displays;
	displays = new char[100];
	int entries=0;
  string myhostname;
	char zeile[201];

	QPixmap white_pix, conf, end, migrat, clearit, applyit, blacky, cancelit;
	white_pix= QPixmap(white_xpm);
	conf = QPixmap(config);
	end = QPixmap(ende);
	migrat= QPixmap(migrator);
	clearit= QPixmap(clear);
	applyit= QPixmap(apply);
 	QPixmap hosti;
	hosti= QPixmap(hosti_g);
	blacky = QPixmap(black_xpm);
	cancelit = QPixmap(cancel);

	hostname=button->name();

	std::ifstream readhostname("/proc/sys/kernel/hostname");
	if (readhostname) {
		readhostname.getline(zeile, 200);
		myhostname.erase();
		myhostname= myhostname+zeile;
		readhostname.close();
		} else {
		cout << "could not read from /proc/sys/kernel/hostname"  << endl;
		myhostname.erase();
		myhostname= myhostname+"localhost";
	}


	// background widget for the configuration dialog
	hinten1= new QWidget(0, hostname);
	hinten1->setGeometry(50,30,50,110);
	hinten1->setMinimumSize(0,0);
	hinten1->resize(260, 320);
	hinten1->setFixedSize(260, 305);
        QFont font1("helvetica");
        font1.setPixelSize(12);
	hinten1->setFont(font1);

	// groups all buttons
	QGroupBox *backr = new QGroupBox("",hinten1);
	backr->setGeometry(5, 30, 255,205);
	backr->setMinimumSize(0,0);
	backr->resize(250, 270);

	// headline for configuration window
 	QLabel_config_title= new QLabel(hinten1,hostname);
	QLabel_config_title->setGeometry(30,10,200,20);
	QLabel_config_title->setMinimumSize(0,0);
	QLabel_config_title->setText("openMosix-configuration");
	QLabel_config_title->setMargin(2);

	// config icon
	QLabel_config_icon= new QLabel(hinten1,hostname);
	QLabel_config_icon->setGeometry(10,10,20,20);
	QLabel_config_icon->setMinimumSize(0,0);
	QLabel_config_icon->setPixmap(conf);

	// node label
	QLabel_config_node= new QLabel(hinten1,hostname);
	QLabel_config_node->setGeometry(10,40,80,20);
	QLabel_config_node->setMinimumSize(0,0);
	QLabel_config_node->setText("node :");
	QLabel_config_node->setMargin(2);

	// here the ip-address (sender-button) is displayed
	QLabel_hostconf= new QLabel(hinten1,hostname);
	QLabel_hostconf->setGeometry(100,40,120,20);
	QLabel_hostconf->setMinimumSize(0,0);
	QLabel_hostconf->setMargin(2);
	QLabel_hostconf->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QLabel_hostconf->setText(hostname);
	QLabel_hostconf->setBackgroundPixmap(QPixmap(white_pix));

	// the automigration "on" button
	QPushButton_config_automig_on= new QPushButton(backr,hostname);
	QPushButton_config_automig_on->setGeometry(10,40,40,20);
	QPushButton_config_automig_on->setMinimumSize(0,0);
	QPushButton_config_automig_on->setText("on");
	QPushButton_config_automig_on->setToggleButton (TRUE);
	QWhatsThis::add(QPushButton_config_automig_on,"Click this button to enable\nauto-migration for this host.\n");
	QObject::connect(   QPushButton_config_automig_on, SIGNAL(clicked()), this, SLOT( action_migration()) );

	// the automigration "off" button
	QPushButton_config_automig_off= new QPushButton(backr,hostname);
	QPushButton_config_automig_off->setGeometry(50,40,40,20);
	QPushButton_config_automig_off->setMinimumSize(0,0);
	QPushButton_config_automig_off->setText("off");
	QPushButton_config_automig_off->setToggleButton (TRUE);
	QWhatsThis::add(QPushButton_config_automig_off,"Click this button to disable\nauto-migration for this host.\n");
	QObject::connect(   QPushButton_config_automig_off, SIGNAL(clicked()), this, SLOT( action_nomigration()) );

	// the automigration label
	QLabel_config_automig_label= new QLabel(backr,"automigration");
	QLabel_config_automig_label->setGeometry(100,40,140,20);
	QLabel_config_automig_label->setMinimumSize(0,0);
	QLabel_config_automig_label->setText("auto-migration on/off");
	QLabel_config_automig_label->setMargin(2);

	// the mosctl quiet->yes button
	QLabel_config_quiet_yes= new QPushButton(backr,hostname);
	QLabel_config_quiet_yes->setGeometry(10,60,40,20);
	QLabel_config_quiet_yes->setMinimumSize(0,0);
	QLabel_config_quiet_yes->setText("yes");
	QLabel_config_quiet_yes->setToggleButton (TRUE);
	QObject::connect(QLabel_config_quiet_yes, SIGNAL(clicked()), this, SLOT( action_quiet()));
	QWhatsThis::add(QLabel_config_quiet_yes,"Click this button to execute\nmosctl quiet on this host.\n");

	// the mosctl quiet->no button
	QLabel_config_quiet_no= new QPushButton(backr,hostname);
	QLabel_config_quiet_no->setGeometry(50,60,40,20);
	QLabel_config_quiet_no->setMinimumSize(0,0);
	QLabel_config_quiet_no->setText("no");
	QLabel_config_quiet_no->setToggleButton (TRUE);
	QObject::connect(QLabel_config_quiet_no, SIGNAL(clicked()), this, SLOT( action_noquiet()));
	QWhatsThis::add(QLabel_config_quiet_no,"Click this button to execute\nmosctl noquiet on this host.\n");

	// the mosctl quiet label
	QLabel_config_quiet_label= new QLabel(backr,"quiet");
	QLabel_config_quiet_label->setGeometry(100,60,140,20);
	QLabel_config_quiet_label->setMinimumSize(0,0);
	QLabel_config_quiet_label->setText("talk to others nodes");
	QLabel_config_quiet_label->setMargin(2);

	// the lstay button
	QPushButton_config_lstay= new QPushButton(backr,hostname);
	QPushButton_config_lstay->setGeometry(10,80,40,20);
	QPushButton_config_lstay->setMinimumSize(0,0);
	QPushButton_config_lstay->setText("yes");
	QPushButton_config_lstay->setToggleButton (TRUE);
	QObject::connect(QPushButton_config_lstay, SIGNAL(clicked()), this, SLOT( action_lstay()) );
	QWhatsThis::add(QPushButton_config_lstay,"Click this button to execute\nmosctl lstay on this host.\n");

	// the nolstay button
	QPushButton_config_nolstay= new QPushButton(backr,hostname);
	QPushButton_config_nolstay->setGeometry(50,80,40,20);
	QPushButton_config_nolstay->setMinimumSize(0,0);
	QPushButton_config_nolstay->setText("no");
	QPushButton_config_nolstay->setToggleButton (TRUE);
	QObject::connect(QPushButton_config_nolstay, SIGNAL(clicked()), this, SLOT( action_nolstay()) );
	QWhatsThis::add(QPushButton_config_nolstay,"Click this button to execute\nmosctl nolstay on this host.\n");

	// the lstay/nolstay label
 	QPushButton_config_lstay_label= new QLabel(backr,"lstay");
	QPushButton_config_lstay_label->setGeometry(100,80,140,20);
	QPushButton_config_lstay_label->setMinimumSize(0,0);
	QPushButton_config_lstay_label->setText("local procs stay");
	QPushButton_config_lstay_label->setMargin(2);

	// the mosctl block button
	QPushButton_config_block= new QPushButton(backr,hostname);
	QPushButton_config_block->setGeometry(10,100,40,20);
	QPushButton_config_block->setMinimumSize(0,0);
	QPushButton_config_block->setText("yes");
	QPushButton_config_block->setToggleButton (TRUE);
	QObject::connect( QPushButton_config_block, SIGNAL(clicked()), this, SLOT( action_block()) );
	QWhatsThis::add(QPushButton_config_block,"Click this button to execute\nmosctl block on this host.\n");

	// the mosctl noblock button
	QPushButton_config_noblock= new QPushButton(backr,hostname);
	QPushButton_config_noblock->setGeometry(50,100,40,20);
	QPushButton_config_noblock->setMinimumSize(0,0);
	QPushButton_config_noblock->setText("no");
	QPushButton_config_noblock->setToggleButton (TRUE);
	QObject::connect( QPushButton_config_noblock, SIGNAL(clicked()), this, SLOT( action_noblock()) );
	QWhatsThis::add(QPushButton_config_noblock,"Click this button to execute\nmosctl noblock on this host.\n");

	// the mosctl block label
	QPushButton_config_noblock_label= new QLabel(backr,"block");
	QPushButton_config_noblock_label->setGeometry(100,100,140,20);
	QPushButton_config_noblock_label->setMinimumSize(0,0);
	QPushButton_config_noblock_label->setText("send away guest procs");
	QPushButton_config_noblock_label->setMargin(2);

	// the cluster start button
	QPushButton_config_cluster_start= new QPushButton(backr,hostname);
	QPushButton_config_cluster_start->setGeometry(10,120,40,20);
	QPushButton_config_cluster_start->setMinimumSize(0,0);
	QPushButton_config_cluster_start->setToggleButton (TRUE);
	QPushButton_config_cluster_start->setText("start");
	QObject::connect( QPushButton_config_cluster_start, SIGNAL(clicked()), this, SLOT( action_start()) );
	QWhatsThis::add(QPushButton_config_cluster_start,"Click this button to start\nmosix on this host.\n");

	// the cluster stop button
	QPushButton_config_cluster_stop= new QPushButton(backr,hostname);
	QPushButton_config_cluster_stop->setGeometry(50,120,40,20);
	QPushButton_config_cluster_stop->setMinimumSize(0,0);
	QPushButton_config_cluster_stop->setToggleButton (TRUE);
	QPushButton_config_cluster_stop->setText("stop");
	QObject::connect( QPushButton_config_cluster_stop, SIGNAL(clicked()), this, SLOT( action_stop()) );
	QWhatsThis::add(QPushButton_config_cluster_stop,"Click this button to stop\nmosix on this host.\n");

	// the cluster start/stop button-label
	QPushButton_config_cluster_label= new QLabel(backr,"start/stop");
	QPushButton_config_cluster_label->setGeometry(100,120,140,20);
	QPushButton_config_cluster_label->setMinimumSize(0,0);
	QPushButton_config_cluster_label->setText("start/stop");
	QPushButton_config_cluster_label->setMargin(2);

	// apply the configuration
	QPushButton_config_applyconfig = new QPushButton(applyit, hostname, backr);
	QPushButton_config_applyconfig->setGeometry(10,145,80,20);
	QPushButton_config_applyconfig->setMinimumSize(0,0);
	QPushButton_config_applyconfig->setText("apply");
	QPushButton_config_applyconfig->setName(hostname);
	QWhatsThis::add(QPushButton_config_applyconfig,"Click this button to apply the changes\n");
	QObject::connect( QPushButton_config_applyconfig, SIGNAL(clicked()), this, SLOT( apply_changes()) );

	// cancel the configuration
	QPushButton_config_cancelconfig= new QPushButton(cancelit, hostname, backr);
	QPushButton_config_cancelconfig->setGeometry(100,145,80,20);
	QPushButton_config_cancelconfig->setMinimumSize(0,0);
	QPushButton_config_cancelconfig->setText("cancel");
	QWhatsThis::add(QPushButton_config_cancelconfig,"Click this button to apply the changes\n");
	QObject::connect( QPushButton_config_cancelconfig, SIGNAL(clicked()), this, SLOT( cancel_changes()) );

	// seperator
	label_rule= new QLabel(backr,"rule");
	label_rule->setGeometry(5,200,240,1);
	label_rule->setMinimumSize(0,0);
	label_rule->setBackgroundPixmap(blacky);

	// open a remote console button
	QPushButton_config_remoteconsole= new QPushButton(hosti, hostname, backr);
	QPushButton_config_remoteconsole->setGeometry(10,170,80,20);
	QPushButton_config_remoteconsole->setMinimumSize(0,0);
	QPushButton_config_remoteconsole->setText("console");
	QPushButton_config_remoteconsole->setName(hostname);
	QWhatsThis::add(QPushButton_config_remoteconsole,"Open a remote console. Insert your workstation-hostname in the box below if you work from remote\n");
	QObject::connect( QPushButton_config_remoteconsole, SIGNAL(clicked()), this, SLOT( open_remotecon()) );

	// open a remote processbox (openMosixviewClient)
	QPushButton_config_remotebox= new QPushButton(migrat, hostname, backr);
	QPushButton_config_remotebox->setGeometry(100,170,140,20);
	QPushButton_config_remotebox->setMinimumSize(0,0);
	QPushButton_config_remotebox->setText("remote proc-box");
	QPushButton_config_remotebox->setName(hostname);
	QWhatsThis::add(QPushButton_config_remotebox,"Open a remote process box. Insert your workstation-hostname in the box below if you work from remote\n");
	QObject::connect( QPushButton_config_remotebox, SIGNAL(clicked()), this, SLOT( open_remoteprocs()) );

	// -display label
	QLabel_config_display= new QLabel(backr,hostname);
	QLabel_config_display->setGeometry(10,210,50,20);
	QLabel_config_display->setMinimumSize(0,0);
	QLabel_config_display->setText("-display");
	QLabel_config_display->setMargin(1);

	// insert -display widget
	display_edit= new QComboBox(TRUE, backr, "display");
	display_edit->setGeometry(65,210,110,20);
	display_edit->setMinimumSize(0,0);
	display_edit->setMaxCount(10);

	// the display history
	if(file_exist("/root/.openMosixview.disp")) {
		std::ifstream configdisplay("/root/.openMosixview.disp");
		if(configdisplay) {
			while((configdisplay.getline(displays, 1000))&&(entries<10)) {
				display_edit->insertItem(displays, -1);
				entries++;
			}
			configdisplay.close();	
		}
	}
	display_edit->setEditText(myhostname.c_str());

	QLabel_config_display2= new QLabel(backr,hostname);
	QLabel_config_display2->setGeometry(175,210,5,20);
	QLabel_config_display2->setMinimumSize(0,0);
	QLabel_config_display2->setText(":");

	display_one= new QSpinBox(backr, "display1");
	display_one->setGeometry(180,210,30,20);
	display_one->setMinimumSize(0,0);

	QLabel_config_display1= new QLabel(backr,hostname);
	QLabel_config_display1->setGeometry(210,210,5,20);
	QLabel_config_display1->setMinimumSize(0,0);
	QLabel_config_display1->setText(".");

	display_two= new QSpinBox(backr, "display1");
	display_two->setGeometry(215,210,30,20);
	display_two->setMinimumSize(0,0);

	// clear the edit display box
	QPushButton_clear= new QPushButton(clearit, hostname, backr);
	QPushButton_clear->setGeometry(10,240,60,20);
	QPushButton_clear->setMinimumSize(0,0);
	QPushButton_clear->setText("clear");
	QWhatsThis::add(QPushButton_clear,"clear the edit-box above\n");
	QObject::connect( QPushButton_clear, SIGNAL(clicked()), display_edit, SLOT(clearEdit()) );

	// clear the display history
	QPushButton_chistory= new QPushButton(backr, hostname);
	QPushButton_chistory->setGeometry(80,240,90,20);
	QPushButton_chistory->setMinimumSize(0,0);
	QPushButton_chistory->setText("clear history");
	QWhatsThis::add(QPushButton_chistory,"clear the history\n");
	QObject::connect( QPushButton_chistory, SIGNAL(clicked()), this, SLOT(clear_history()) );


	// close the configuration windows
	QPushButton_config_closewindow= new QPushButton(end, hostname, backr);
	QPushButton_config_closewindow->setGeometry(180,240,60,20);
	QPushButton_config_closewindow->setMinimumSize(0,0);
	QPushButton_config_closewindow->setText("close");
	QWhatsThis::add(QPushButton_config_closewindow,"Close configuration-window\n");
	QObject::connect( QPushButton_config_closewindow, SIGNAL(clicked()), hinten1, SLOT( close()) );

	hinten1->show();
}



// close the configuration window
void OpenMosixViewApp::close_config() {
	delete hinten1;
}


// draws the cluster-widgets on the main groupbox
void OpenMosixViewApp::drawcluster() {

	struct dirent **namelist;
	int n;
 	int labelheight=5;
	int current_h=0;
	QPixmap white_pix;
	white_pix= QPixmap(white_xpm);
        QFont smfont1("helvetica");
        smfont1.setPixelSize(10);
						
	// empty nodelist
	nodelist.clear();

	// create main cluster widget
	QGroupBox_1= new QGroupBox(this,"main-cluster");
	QGroupBox_1->setGeometry(0,90,720,10);
	QGroupBox_1->setMinimumSize(0,0);
	QGroupBox_1->setTitle("");
	QGroupBox_1->stackUnder(ontop);

	QScrollBar_1= new QScrollBar(this,"scroll");
	QScrollBar_1->setMinimumSize(0,0);
	QScrollBar_1->setSteps(60,320);
	QObject::connect(QScrollBar_1, SIGNAL(sliderMoved ( int )), this, SLOT(scroll_view( int  )) );
	QObject::connect(QScrollBar_1, SIGNAL(valueChanged ( int )), this, SLOT(scroll_view( int  )) );

	// fill nodelist
	n = scandir(clusterdirectory, &namelist, 0, 0);
	if (n < 0) {
		perror("scandir");
		} else {
		while(n--) {
			if(!strchr(namelist[n]->d_name, '.')) {
				// add node id to nodelist
				nodelist.push_front(namelist[n]->d_name);
				free(namelist[n]);
			}

		}
		free(namelist);

		// here the dynamic widgets are created
		list<string>::iterator p = nodelist.begin();
		int h=0;
		while (p != nodelist.end()) {
			string nodename = getnodename(*p);
			string nodeidtxt=(string)*p;

			// the node label
			QLabel_stat[h]= new QLabel(QGroupBox_1,"NoName");
			QLabel_stat[h]->setGeometry(5,labelheight,40,20);
			QLabel_stat[h]->setMinimumSize(0,0);
			QLabel_stat[h]->setBackgroundPixmap(QPixmap(white_pix));
			QLabel_stat[h]->setFont(smfont1);
			QLabel_stat[h]->setText(nodeidtxt.c_str());
			QLabel_stat[h]->setMargin(0);
			QLabel_stat[h]->setAlignment( AlignVCenter | AlignCenter );
			QLabel_stat[h]->setFrameStyle( QFrame::Panel | QFrame::Sunken );
			QWhatsThis::add(QLabel_stat[h] ,"This box shows the status of the openMosix-node. Green for available, red for down.\n");

			// the nodes pushbutton labed with its ip-address			
			QPushButton_host[h]= new QPushButton(nodename.c_str(), QGroupBox_1);
			QPushButton_host[h]->setName(nodename.c_str());
			QPushButton_host[h]->setGeometry(45,labelheight,105,20);
			QPushButton_host[h]->setMinimumSize(0,0);
			QPushButton_host[h]->setText(nodename.c_str());
			QObject::connect( 	QPushButton_host[h], SIGNAL(clicked()), this, SLOT( neuwin()) );
			QWhatsThis::add(QPushButton_host[h] ,"Click to configure this node You can execute the most common mosctl-command or stop/start openMosix.\n");

			// the famous speed-slider
		  QSlider_host[h]= new QSlider(QGroupBox_1, nodename.c_str());
		  QSlider_host[h]->setGeometry(155,labelheight,110,20);
		  QSlider_host[h]->setMinimumSize(0,0);
		  QSlider_host[h]->setTracking(false);
		  QSlider_host[h]->setValue(0);
		  QSlider_host[h]->setRange(0,100000);
		  QSlider_host[h]->setTickInterval ( 10000 );
		  QSlider_host[h]->setTickmarks ( QSlider::Below );
		  QSlider_host[h]->setOrientation(QSlider::Horizontal);
			QObject::connect(QSlider_host[h], SIGNAL(sliderMoved(int)), this, SLOT(setspeed(int)));
			QWhatsThis::add(QSlider_host[h] ,"Change the speed+priority of this host in your cluster. Processes will easier migrate to a node with a higher speed-value.\n");

			// the lcd display for speed
			QLCDNumber_host[h]= new QLCDNumber(QGroupBox_1, nodename.c_str());
			QLCDNumber_host[h]->setGeometry(265,labelheight,50,20);
			QLCDNumber_host[h]->setMinimumSize(0,0);
			QLCDNumber_host[h]->display("0");
			QLCDNumber_host[h]->setNumDigits(6);
			QLCDNumber_host[h]->setSegmentStyle (QLCDNumber::Flat);
			QObject::connect(  QSlider_host[h], SIGNAL(valueChanged(int)),   QLCDNumber_host[h], SLOT(display(int)) );
			QWhatsThis::add(QLCDNumber_host[h] ,"The LCD-number shows the current openMosix-speed of this host.\n");

			//the progressbar for each nodes load
			QProgressBar_host[h]= new QProgressBar(QGroupBox_1, nodename.c_str());
			QProgressBar_host[h]->setGeometry(315,labelheight,130,20);
			QProgressBar_host[h]->setMinimumSize(0,0);
			QProgressBar_host[h]->setTotalSteps (100);
			QWhatsThis::add(QProgressBar_host[h] ,"These progressbars gives you an overview of the load on your cluster.\n");

			//the progressbar for each nodes memory
			QProgressBar_mem[h]= new QProgressBar(QGroupBox_1, nodename.c_str());
			QProgressBar_mem[h]->setGeometry(460,labelheight,130,20);
			QProgressBar_mem[h]->setMinimumSize(0,0);
			QProgressBar_mem[h]->setTotalSteps(100);
			QWhatsThis::add(QProgressBar_mem[h] ,"These progressbars gives you an overview of the memory on your cluster.\n");

			// howmany memory this node has
		  QLabel_memo[h]= new QLabel(QGroupBox_1, nodename.c_str());
		  QLabel_memo[h]->setGeometry(600,labelheight,60,20);
		  QLabel_memo[h]->setMinimumSize(0,0);
		  QLabel_memo[h]->setNum(0);
		  QLabel_memo[h]->setMargin(1);
  		  QLabel_memo[h]->setBackgroundPixmap(QPixmap(white_pix));
  		  QLabel_memo[h]->setAlignment( AlignVCenter | AlignCenter );
		  QLabel_memo[h]->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		  QWhatsThis::add(QLabel_memo[h] ,"This box shows the memory of one node of your cluster\n");

			// howmany cpus this node has
			QLabel_howmany_cpus[h]= new QLabel(QGroupBox_1, nodename.c_str());
			QLabel_howmany_cpus[h]->setGeometry(685,labelheight,30,20);
		 	QLabel_howmany_cpus[h]->setMinimumSize(0,0);
			QLabel_howmany_cpus[h]->setMargin(1);
			QLabel_howmany_cpus[h]->setBackgroundPixmap(QPixmap(white_pix));
		 	QLabel_howmany_cpus[h]->setAlignment( AlignVCenter | AlignCenter );
			QLabel_howmany_cpus[h]->setFrameStyle( QFrame::Panel | QFrame::Sunken );
			QWhatsThis::add(QLabel_howmany_cpus[h] ,"This box shows how many CPUs this node has.\n");

			// adjust the wigdets
			labelheight=labelheight+20;
			current_h=QGroupBox_1->height();
			current_h=current_h+20;
			QGroupBox_1->setGeometry(0, 90, 720, current_h);

			p++;
			h++;
		}

		// display the main-cluster widget
		QScrollBar_1->setGeometry(720,90,20,this->height()-110);
		QScrollBar_1->setRange(0, h*20);
		QScrollBar_1->show();
		QGroupBox_1->show();

		internalTimer = new QTimer( QGroupBox_1, "intern" );
		QObject::connect( internalTimer, SIGNAL(timeout()), this, SLOT(refresh()) );
		QObject::connect( refreshtimeoutbox, SIGNAL(valueChanged( int )), this, SLOT(adjusttimer( int )) );
		internalTimer->start(5000);
	        refresh();
	}
}




// if the cluster configuration changed we have to redraw
void OpenMosixViewApp::redrawcluster() {
	delete QGroupBox_1;
	delete QScrollBar_1;
	drawcluster();
}


// ########################## the main refresh ####################
void OpenMosixViewApp::refresh() {

	int load_percent, omemory_percent, omemo;
	int oload, ocpus, ospeed;
  int64_t omem, otmem;
	string tmpstr;
	string nodename;
	string creadload, creadmem, creadtmem, ccpus, creadspeed;
	int allcpus=0;
	int mean=0;
	int online=0;
	int mem_mean=0;
	int allmemo=0;
	int mem_mean_percent=0;
	int diff=0;
	int mini=200;
	int maxi=0;

	QPixmap green_pix, red_pix;
	green_pix= QPixmap(green_xpm);
	red_pix= QPixmap(red_xpm);

	// check if the cluster configuration changed
	if((checknodes()) && (restart<10)){

		// entering the main refresh cycle
		int h=0;
		list<string>::iterator p = nodelist.begin();
		while (p != nodelist.end()) {
			string nodeid;
			nodeid=nodeid+(string)*p;

			// ############### speed ########################
			ospeed=string2int(getprocvalue(nodeid, "speed"));
			QSlider_host[h]->setValue(ospeed);
			QLCDNumber_host[h]->display(ospeed);
			if(ospeed>0) {
				QLabel_stat[h]->setBackgroundPixmap(QPixmap(green_pix));
				online++;
				} else {
				QLabel_stat[h]->setBackgroundPixmap(QPixmap(red_pix));
			}
			// ############### speed ########################

			// ############### load ########################
			oload=string2int(getprocvalue(nodeid, "load"));

			if (oload>0) {
				if(oload>200) {
					oload=200;
				}
				load_percent=(oload*100)/200;
				QProgressBar_host[h]->reset ();
				QProgressBar_host[h]->setProgress(load_percent);
				mini=min(mini, load_percent);
				maxi=max(maxi, load_percent);
				mean=mean+oload;
            } else {
				QProgressBar_host[h]->reset();
				QProgressBar_host[h]->setProgress(0);
				// node is online but has no load
				if(ospeed>0) {
					mini=0;
				}
			}

			// ############### load ########################

			// ############### mem ########################
      omem=string2ll(getprocvalue(nodeid, "mem"));
			omem=omem/1048576;
			otmem=string2ll(getprocvalue(nodeid, "tmem"));
			otmem=otmem/1048576;
			omemo = otmem-omem;

			if((omemo>0) && (otmem>0)) {
				omemory_percent=(omemo*100)/otmem;
 				QProgressBar_mem[h]->reset();
				QProgressBar_mem[h]->setProgress(omemory_percent);
        QLabel_memo[h]->setNum((int)otmem);
				allmemo=allmemo+otmem;
				mem_mean=mem_mean+omemo;
				} else {
   			QProgressBar_mem[h]->reset();
				QProgressBar_mem[h]->setProgress(0);
				QLabel_memo[h]->setNum(0);
			}
			// ############### mem ########################

			// ############### cpus ########################
			ocpus=string2int(getprocvalue(nodeid, "cpus"));
			QLabel_howmany_cpus[h]->setNum(ocpus);
			allcpus=allcpus+ocpus;
			// ############### cpus ########################

			p++;
			h++;
		}			// end of the main refresh cycle

		// check if the openMosixcollector is running
		if(file_exist(collectorpid)) {
			label_collector2->setBackgroundPixmap(QPixmap(green_pix));
			} else {
			label_collector2->setBackgroundPixmap(QPixmap(red_pix));
		}

 		// refresh the overall values
		diff=maxi-mini;
		maxi=200;
		mini=0;
		if(online>0) {
			mean=mean/online;
			mean=(mean*100)/200;
			// set the clusterlabel green
			QLabel_clusterid_label->setBackgroundPixmap(QPixmap(green_pix));
			if(allmemo>0) {
				mem_mean_percent=(mem_mean*100)/allmemo;
				} else {
				mem_mean_percent=0;
			}
			} else {
			mean=0;
			mem_mean_percent=0;
			// set the clusterlabel red
			QLabel_clusterid_label->setBackgroundPixmap(QPixmap(red_pix));
		}

		QProgressBar_balance->setProgress(200-diff);
		QProgressBar_overall->setProgress(mean);
		QLabel_overall_memory->setProgress(mem_mean_percent);
		QLabel_overall_mem->setNum(allmemo);
		QLabel_allcpu->setNum(allcpus);

		} else {
		// we have to redraw the main widget because the cluster configuration changed
		cout << "cluster config changed! redraw cluster now." << endl;
		setclusternodes(gethowmanynodes());
    restart=0;
   	redrawcluster();
	}

}


// set the clusternodes value
void OpenMosixViewApp::setclusternodes(int nodes) {
	clusternodes=nodes;
}


// enter what is this mode
void OpenMosixViewApp::slot_whatisthis()
{
QWhatsThis::enterWhatsThisMode();
}


// sets the sshconfig value to the right config
void OpenMosixViewApp::setsshconfig() {
	if (confmenu->isItemChecked(ID_SSH)) {
		confmenu->setItemChecked(ID_SSH, false);
		sshconfig=0;
		} else {
		confmenu->setItemChecked(ID_SSH, true);
		sshconfig=1;
	}
}


// sets the speed of one node
void OpenMosixViewApp::setspeed(int speed) {

	string nodespeed;
	string speedcommand;
	string speedoutput;
	int error;
	const  char *hostname;
	const QObject *button = sender();
	hostname=button->name();

	if (speed<0) {
  	speed=0;
	}
	nodespeed=nodespeed + int2string(speed);

	if(sshconfig) {
		speedcommand = speedcommand + "ssh ";
		} else {
		speedcommand = speedcommand + "rsh ";
	}
	speedcommand = speedcommand + hostname;
	speedcommand = speedcommand + " ";
	speedcommand = speedcommand + clustercommand;
	speedcommand = speedcommand +  " setspeed ";
	speedcommand = speedcommand + nodespeed;

	if((error=system(speedcommand.c_str())) > 0) {
		speedoutput = speedoutput + "cannot set speed on ";
		speedoutput = speedoutput + hostname;
	  statusBar()->message(speedoutput.c_str());
		} else {
		speedoutput = "set speed to ";
		speedoutput = speedoutput +  nodespeed;
		speedoutput = speedoutput + " on ";
		speedoutput = speedoutput + hostname;
		statusBar()->message(speedoutput.c_str());
	}
}



void OpenMosixViewApp::save_config()
{
	string saveoutput;
	std::ofstream saveconf(configfile);
	if (saveconf) {
		saveconf << sshconfig;
		saveconf.close();
		saveoutput = saveoutput + "configuration saved";
		statusBar()->message(saveoutput.c_str());
		} else {
		cout << "could not write to " << configfile << endl;
		saveoutput = saveoutput + "could not save the configuration";
		statusBar()->message(saveoutput.c_str());
	}
}


void OpenMosixViewApp::load_config()
{
	string loadoutput;
	char loadsshconfig;

	if (file_exist(configfile)) {
		std::ifstream loadconf(configfile);
		if (loadconf) {
			loadconf.get(loadsshconfig);
			if(loadsshconfig=='1') {
				// ssh
				sshconfig=1;
				confmenu->setItemChecked(ID_SSH, true);
	   		} else {
		      // rsh
				sshconfig=0;
				confmenu->setItemChecked(ID_SSH, false);
				}
				loadconf.close();
				loadoutput = loadoutput + "configuration loaded";
				statusBar()->message(loadoutput.c_str());
				} else {
				cout << "could not read from " << configfile << endl;
				loadoutput = loadoutput + "could not load the configuration";
				statusBar()->message(loadoutput.c_str());
			}
			}  else {
   		// no config-file found
	      // rsh
			sshconfig=0;
			confmenu->setItemChecked(ID_SSH, false);
		}
	}



void OpenMosixViewApp::action_stop() {
	if(QPushButton_config_cluster_start->isOn()) {
		QPushButton_config_cluster_start->setOn(false);
	}
}
void OpenMosixViewApp::action_start() {
	if(QPushButton_config_cluster_stop->isOn()) {
		QPushButton_config_cluster_stop->setOn(false);
	}
}
void OpenMosixViewApp::action_lstay(){
	if(QPushButton_config_nolstay->isOn()) {
		QPushButton_config_nolstay->setOn(false);
	}
}
void OpenMosixViewApp::action_nolstay(){
	if(QPushButton_config_lstay->isOn()) {
		QPushButton_config_lstay->setOn(false);
	}
}
void OpenMosixViewApp::action_migration(){
	if(QPushButton_config_automig_off->isOn()) {
		QPushButton_config_automig_off->setOn(false);
	}
}
void OpenMosixViewApp::action_nomigration(){
	if(QPushButton_config_automig_on->isOn()) {
		QPushButton_config_automig_on->setOn(false);
	}
}
void OpenMosixViewApp::action_block(){
	if(QPushButton_config_noblock->isOn()) {
		QPushButton_config_noblock->setOn(false);
	}
}
void OpenMosixViewApp::action_noblock(){
	if(QPushButton_config_block->isOn()) {
		QPushButton_config_block->setOn(false);
	}
}
void OpenMosixViewApp::action_noquiet(){
	if(QLabel_config_quiet_yes->isOn()) {
		QLabel_config_quiet_yes->setOn(false);
	}
}
void OpenMosixViewApp::action_quiet(){
	if(QLabel_config_quiet_no->isOn()) {
		QLabel_config_quiet_no->setOn(false);
	}
}


void OpenMosixViewApp::clear_history() {
	string clearhistory_output;
	if(file_exist(displayfile)) {
		if (!remove(displayfile)) {
			clearhistory_output = clearhistory_output + "history cleared";
			statusBar()->message(clearhistory_output.c_str());
			} else {
			clearhistory_output = clearhistory_output + "could not clear history";
			statusBar()->message(clearhistory_output.c_str());
			}		
	} else {
	clearhistory_output = clearhistory_output + "no history file to clear";
	statusBar()->message(clearhistory_output.c_str());
	}
}



void OpenMosixViewApp::cancel_changes() {
  QPushButton_config_automig_on->setOn(false);
  QPushButton_config_automig_off->setOn(false);
  QPushButton_config_lstay->setOn(false);
  QPushButton_config_nolstay->setOn(false);
  QPushButton_config_block->setOn(false);
  QPushButton_config_noblock->setOn(false);
  QLabel_config_quiet_yes->setOn(false);
  QLabel_config_quiet_no->setOn(false);
  QPushButton_config_cluster_start->setOn(false);
  QPushButton_config_cluster_stop->setOn(false);
}





void OpenMosixViewApp::open_remotecon() {

	const char *hostname;
	const QObject *button = sender();
	hostname=button->name();
	string remotecon_output;
	string xhostcommand;
	string remoteconsole;
	char *display;
	display = new char[100];
	int error;
	int entries;
	int neu=0;
	FILE *fp;

   remotecon_output = remotecon_output + "open a remote console";
	statusBar()->message(remotecon_output.c_str());
	remotecon_output.erase();

	if (display_edit->currentText().isEmpty()) {
		// we have no display !
		remotecon_output = remotecon_output + "could not open remote console! display is empty.";
		statusBar()->message(remotecon_output.c_str());
		remotecon_output.erase();
		} else {
		// fill display
		strcpy(display, "");
		strcat(display, display_edit->currentText());
		strcat(display, ":");
		strcat(display, display_one->text());
		strcat(display, ".");
		strcat(display, display_two->text());
		strcat(display, "&");

		// check for all nodes
		if(QLabel_hostconf->text()=="all-nodes") {
			// set xhost +
			xhostcommand = xhostcommand + "xhost +";
			if((error=system(xhostcommand.c_str())) > 0) {
			   remotecon_output = remotecon_output + "cannot set xhost +";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
	  	      } else {
			   remotecon_output = remotecon_output + "set xhost +";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
			}

         list<string>::iterator p = nodelist.begin();
			while (p != nodelist.end()) {
				string nodeid;
				nodeid=nodeid+(string)*p;
				string thisnodename;
				thisnodename = thisnodename + getnodename(nodeid);

				// check for ssh/rsh
				if (sshconfig) {
					remoteconsole = remoteconsole + "ssh ";
					} else {
					remoteconsole = remoteconsole + "rsh ";
				}
				remoteconsole = remoteconsole + thisnodename;
				remoteconsole = remoteconsole + " `which xterm` -display ";
				remoteconsole = remoteconsole + display;

				if((error=system(remoteconsole.c_str())) > 0) {
				   remotecon_output = remotecon_output + "failed to open a remote console";
					statusBar()->message(remotecon_output.c_str());
					remotecon_output.erase();
					} else {
				   remotecon_output = remotecon_output + "open a remote console";
					statusBar()->message(remotecon_output.c_str());
					remotecon_output.erase();
				}

				remoteconsole.erase();
				p++;
  			} // end of allnodes

			} else {
			// set xhost + hostname
			xhostcommand = xhostcommand + "xhost +";
			xhostcommand = xhostcommand + hostname;
			if((error=system(xhostcommand.c_str())) > 0) {
			   remotecon_output = remotecon_output + "cannot set xhost + for remote host";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
	  	      } else {
			   remotecon_output = remotecon_output + "set xhost + for remote host";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
			}
			// check for ssh/rsh
			if (sshconfig) {
				remoteconsole = remoteconsole + "ssh ";
				} else {
				remoteconsole = remoteconsole + "rsh ";
			}
			remoteconsole = remoteconsole + hostname;
			remoteconsole = remoteconsole + " `which xterm` -display ";
			remoteconsole = remoteconsole + display;

			if((error=system(remoteconsole.c_str())) > 0) {
			   remotecon_output = remotecon_output + "failed to open a remote console";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
				} else {
			   remotecon_output = remotecon_output + "open a remote console";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
			}
			remoteconsole.erase();
		}

		// end of command
		// insert the display in the display history if required
		for(entries=0; entries<display_edit->count(); entries++) {
			if(strcmp(display_edit->currentText(), display_edit->text(entries))==0) {
				neu=1;
			}
		}
		if (!neu) {
			display_edit->insertItem(display_edit->currentText(), 0);
		}
		string savedisplay;
      if ((fp=fopen(displayfile, "w"))!=NULL) {
			for(entries=0; entries<display_edit->count(); entries++) {
				fputs(display_edit->text(entries), fp);
				fputs("\n", fp);
			}
			fclose(fp);
			} else {
			savedisplay = savedisplay + "could not write hostlist to ";
			savedisplay = savedisplay + displayfile;
			statusBar()->message(savedisplay.c_str());
		}

	}  // end of command

}




 void OpenMosixViewApp::apply_changes() {

	string config_automigration;
	string config_quiet;
	string config_lstay;
	string config_block;
	string config_startstop;
	string command_automigration;
	string command_quiet;
	string command_lstay;
	string command_block;
	string command_startstop;
	string remote_command;
	string remote_startstop_command;
	string command_output;
	const char *hostname;
	const QObject *button = sender();
	hostname=button->name();
	int error;
	int need_automigration=0;
	int need_lstay=0;
	int need_block=0;
	int need_quite=0;
	int need_startstop=0;



	if(	QPushButton_config_automig_on->isOn()) {
		config_automigration = config_automigration + " nostay";
		need_automigration=1;
	}
	if(	QPushButton_config_automig_off->isOn()) {
		config_automigration = config_automigration + " stay";
		need_automigration=1;
	}
	if(	QPushButton_config_lstay->isOn()) {
		config_lstay = config_lstay + " lstay";
		need_lstay=1;
	}
	if(	QPushButton_config_nolstay->isOn()) {
		config_lstay = config_lstay + " nolstay";
		need_lstay=1;
	}
	if(	QPushButton_config_block->isOn()) {
		config_block = config_block + " block";
		need_block=1;
	}
	if(	QPushButton_config_noblock->isOn()) {
		config_block = config_block + " noblock";
		need_block=1;
	}
	if(	QLabel_config_quiet_yes->isOn()) {
		config_quiet = config_quiet + " noquiet";
		need_quite=1;
	}
	if(	QLabel_config_quiet_no->isOn()) {
		config_quiet = config_quiet + " quiet";
		need_quite=1;
	}
	if(	QPushButton_config_cluster_start->isOn()) {
		config_startstop = config_startstop + " start";
		need_startstop=1;
	}
	if(	QPushButton_config_cluster_stop->isOn()) {
		config_startstop = config_startstop + " stop";
		need_startstop=1;
	}


		// check for all nodes
		if(QLabel_hostconf->text()=="all-nodes") {

			list<string>::iterator p = nodelist.begin();
			while (p != nodelist.end()) {
				string nodeid;
				nodeid=nodeid+(string)*p;
				string thisnodename;
				thisnodename = thisnodename + getnodename(nodeid);
				// check for ssh/rsh
				if (sshconfig) {
					remote_command = remote_command + "ssh ";
					} else {
					remote_command = remote_command + "rsh ";
				}
				remote_command = remote_command + thisnodename;
				remote_command = remote_command + " ";
				remote_command = remote_command + clustercommand;
				remote_command = remote_command + " ";

				if(need_automigration) {
					command_automigration = command_automigration + remote_command;
					command_automigration = command_automigration + config_automigration;
					if((error=system(command_automigration.c_str())) > 0) {
					   command_output = command_output + "failed to execute ";
					   command_output = command_output +  command_automigration;
						statusBar()->message(command_output.c_str());
						command_output.erase();
					}
					command_automigration.erase();
				}

				if(need_lstay) {
					command_lstay = command_lstay + remote_command;
					command_lstay = command_lstay + config_lstay;
					if((error=system(command_lstay.c_str())) > 0) {
					   command_output = command_output + "failed to execute ";
					   command_output = command_output +  command_lstay;
						statusBar()->message(command_output.c_str());
					command_output.erase();
					}
					command_lstay.erase();
				}

				if(need_block) {
					command_block = command_block + remote_command;
					command_block = command_block + config_block;
					if((error=system(command_block.c_str())) > 0) {
					   command_output = command_output + "failed to execute ";
					   command_output = command_output +  command_lstay;
						statusBar()->message(command_output.c_str());
						command_output.erase();
					}
					command_block.erase();
				}

				if(need_quite) {
					command_quiet = command_quiet + remote_command;
					command_quiet = command_quiet + config_quiet;
					if((error=system(command_quiet.c_str())) > 0) {
					   command_output = command_output + "failed to execute ";
					   command_output = command_output +  command_lstay;
						statusBar()->message(command_output.c_str());
						command_output.erase();
					}
					command_quiet.erase();
				}

				if(need_startstop) {
					// check for ssh/rsh
					if (sshconfig) {
						remote_startstop_command = remote_startstop_command + "ssh ";
						} else {
						remote_startstop_command = remote_startstop_command + "rsh ";
					}
					remote_startstop_command = remote_startstop_command + thisnodename;
					remote_startstop_command = remote_startstop_command + " ";

					if(file_exist(init1)) {
						command_startstop = command_startstop + remote_startstop_command;
						command_startstop = command_startstop + init1;
						command_startstop = command_startstop + " ";
						command_startstop = command_startstop + config_startstop;

  						if((error=system(command_startstop.c_str())) > 0) {
						   command_output = command_output + "failed to execute ";
						   command_output = command_output +  command_lstay;	
							statusBar()->message(command_output.c_str());
							command_output.erase();
						}
						command_startstop.erase();
						} else if (file_exist(init2)) {

						command_startstop = command_startstop + remote_startstop_command;
						command_startstop = command_startstop + init2;
						command_startstop = command_startstop + " ";
						command_startstop = command_startstop + config_startstop;

						if((error=system(command_startstop.c_str())) > 0) {
						   command_output = command_output + "failed to execute ";
						   command_output = command_output +  command_lstay;
							statusBar()->message(command_output.c_str());
							command_output.erase();
						}
						command_startstop.erase();
						} else {
					   command_output = command_output + "init script not found";
					   command_output = command_output +  command_lstay;
						statusBar()->message(command_output.c_str());
						command_output.erase();
					}           	
	   		}
   	      remote_command.erase();

				p++;
  			} // end of allnodes


			} else {

			// check for ssh/rsh
			if (sshconfig) {
				remote_command = remote_command + "ssh ";
				} else {
				remote_command = remote_command + "rsh ";
			}
			remote_command = remote_command + hostname;
			remote_command = remote_command + " ";
			remote_command = remote_command + clustercommand;
			remote_command = remote_command + " ";

			if(need_automigration) {
				command_automigration = command_automigration + remote_command;
				command_automigration = command_automigration + config_automigration;
				if((error=system(command_automigration.c_str())) > 0) {
				   command_output = command_output + "failed to execute ";
				   command_output = command_output +  command_automigration;
					statusBar()->message(command_output.c_str());
					command_output.erase();
				}
				command_automigration.erase();
			}


			if(need_lstay) {
				command_lstay = command_lstay + remote_command;
				command_lstay = command_lstay + config_lstay;
				if((error=system(command_lstay.c_str())) > 0) {
				   command_output = command_output + "failed to execute ";
				   command_output = command_output +  command_lstay;
					statusBar()->message(command_output.c_str());
					command_output.erase();
				}
				command_lstay.erase();
			}

			if(need_block) {
				command_block = command_block + remote_command;
				command_block = command_block + config_block;
				if((error=system(command_block.c_str())) > 0) {
				   command_output = command_output + "failed to execute ";
				   command_output = command_output +  command_lstay;
					statusBar()->message(command_output.c_str());
					command_output.erase();
				}
				command_block.erase();
			}

			if(need_quite) {
				command_quiet = command_quiet + remote_command;
				command_quiet = command_quiet + config_quiet;
				if((error=system(command_quiet.c_str())) > 0) {
				   command_output = command_output + "failed to execute ";
				   command_output = command_output +  command_lstay;
					statusBar()->message(command_output.c_str());
					command_output.erase();
				}
				command_quiet.erase();
			}



			if(need_startstop) {
				// check for ssh/rsh
				if (sshconfig) {
					remote_startstop_command = remote_startstop_command + "ssh ";
					} else {
					remote_startstop_command = remote_startstop_command + "rsh ";
				}
				remote_startstop_command = remote_startstop_command + hostname;
				remote_startstop_command = remote_startstop_command + " ";

				if(file_exist(init1)) {

					command_startstop = command_startstop + remote_startstop_command;
					command_startstop = command_startstop + init1;
					command_startstop = command_startstop + " ";
					command_startstop = command_startstop + config_startstop;

					if((error=system(command_startstop.c_str())) > 0) {
					   command_output = command_output + "failed to execute ";
					   command_output = command_output +  command_lstay;
						statusBar()->message(command_output.c_str());
						command_output.erase();
					}
					command_startstop.erase();
					} else if (file_exist(init2)) {

					command_startstop = command_startstop + remote_startstop_command;
					command_startstop = command_startstop + init2;
					command_startstop = command_startstop + " ";
					command_startstop = command_startstop + config_startstop;

					if((error=system(command_startstop.c_str())) > 0) {
					   command_output = command_output + "failed to execute ";
					   command_output = command_output +  command_lstay;
						statusBar()->message(command_output.c_str());
						command_output.erase();
					}
					command_startstop.erase();
					} else {
				   command_output = command_output + "init script not found";
				   command_output = command_output +  command_lstay;
					statusBar()->message(command_output.c_str());
					command_output.erase();
				}           	
   		}

		}  // end of command
}










void OpenMosixViewApp::slotFileOpen()
{

	int fromnode=50000;
	int tonode=0;
	QPixmap end, procicon_g, white_pix, host;
	end = QPixmap(ende);
	procicon_g= QPixmap(proc_g);
	white_pix= QPixmap(white_xpm);
	host= QPixmap(hosti_g);

	list<string>::iterator p = nodelist.begin();
	while (p != nodelist.end()) {
		int id;
		string nodeid;
		nodeid=nodeid+(string)*p;


		id = string2int(nodeid);
		fromnode=min(fromnode, id);
		tonode=max(tonode, id);
		p++;
		} // end of while loop

	statusBar()->message("running programm...");
	QString fileName = QFileDialog::getOpenFileName(0,0,this);

	if (!fileName.isEmpty())  {
		hinten2= new QWidget(0, fileName);
		hinten2->setGeometry(100,130,50,110);
		hinten2->setMinimumSize(0,0);
		hinten2->resize(400, 280);
		hinten2->setFixedSize(400, 280);
	        QFont font2("helvetica");
	        font2.setPixelSize(12);
	        hinten2->setFont(font2);

		exec_label1 = new QLabel("",hinten2);
		exec_label1->setGeometry(35,5,220,20);
		exec_label1->setMinimumSize(0,0);
		exec_label1->setText("openMosixview Advanced Execution");

		exec_label2= new QLabel("",hinten2);
		exec_label2->setGeometry(5,5,20,20);
		exec_label2->setMinimumSize(0,0);
		exec_label2->setPixmap(procicon_g);

		QButtonGroup *back1 = new QButtonGroup("",hinten2);
		back1->setGeometry(5, 30, 245,215);
		back1->setMinimumSize(0,0);
		back1->resize(390, 240);
		back1->setExclusive(true);

		QPushButton_exe_end= new QPushButton(end, "close", back1);
		QPushButton_exe_end->setGeometry(320,210,60,20);
		QPushButton_exe_end->setMinimumSize(0,0);
		QPushButton_exe_end->setText("close");
		QObject::connect( QPushButton_exe_end, SIGNAL(clicked()), hinten2, SLOT(close()) );
		QWhatsThis::add(QPushButton_exe_end,"Close the advanced\nexecution dialog.");

		QPushButton_exe= new QPushButton(procicon_g, "execute", back1);
		QPushButton_exe->setGeometry(150,210,150,20);
		QPushButton_exe->setMinimumSize(0,0);
		QPushButton_exe->setText("execute");
		QObject::connect( QPushButton_exe, SIGNAL(clicked()), this, SLOT(execute_it()) );
		QWhatsThis::add(QPushButton_exe,"Click this button to execute\nthe the commandline.");

		QPushButton_parallel_exe= new QPushButton(procicon_g, "execute parallel", back1);
		QPushButton_parallel_exe->setGeometry(150,210,150,20);
		QPushButton_parallel_exe->setMinimumSize(0,0);
		QPushButton_parallel_exe->setText("parallel execute");
		QPushButton_parallel_exe->hide();
		QPushButton_parallel_exe->setEnabled(false);
		QObject::connect( QPushButton_parallel_exe, SIGNAL(clicked()), this, SLOT(parallel_execute_it()) );
		QWhatsThis::add(QPushButton_parallel_exe,"Click this button to execute\nthe the commandline parallel on\nseveral cluster-nodes.");

		QGroupBox *chooser = new QGroupBox("host-chooser",back1);
		chooser->setGeometry(150,70,100,150);
		chooser->setMinimumSize(0,0);
		chooser->resize(190, 120);

		lcd_host_chooser=new QLCDNumber(chooser, "lcdhostchooser");
		lcd_host_chooser->setGeometry(120, 60, 55, 20);
		lcd_host_chooser->setNumDigits(7);
		lcd_host_chooser->display(fromnode);
		lcd_host_chooser->setSegmentStyle(QLCDNumber::Flat);

		host_chooser= new QDial(chooser, "hostchooser");
		host_chooser->setGeometry(10, 25, 80, 80);
		host_chooser->setMinValue(fromnode);
		host_chooser->setMaxValue(tonode);
		host_chooser->setLineStep(1);
		host_chooser->setNotchesVisible(true);
		host_chooser->setValue(fromnode);
		QObject::connect( host_chooser, SIGNAL(valueChanged(int)), lcd_host_chooser, SLOT(display(int)) );
		QWhatsThis::add(host_chooser,"Choose a openMosix-node for running the command on.");

		nomig_check= new QRadioButton(back1, "nomig");
		nomig_check->setGeometry(10,50,100,20);
		nomig_check->setText("no migration");
		QObject::connect(nomig_check, SIGNAL(clicked()), chooser, SLOT(hide()) );
		QObject::connect(nomig_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(nomig_check,"Runs a non migrating job.");

		runhome_check= new QRadioButton(back1, "runhome");
		runhome_check->setGeometry(10,70,100,20);
		runhome_check->setText("run home");
		QObject::connect(runhome_check, SIGNAL(clicked()), chooser, SLOT(hide()) );
		QObject::connect(runhome_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(runhome_check,"Runs a job on the home node.");

		runon_check= new QRadioButton(back1, "runon");
		runon_check->setGeometry(10,90,100,20);
		runon_check->setText("run on");
		runon_check->setChecked(true);
		QObject::connect(runon_check, SIGNAL(clicked()), chooser, SLOT(show()) );
		QObject::connect(runon_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(runon_check,"Runs a job on one openMosix-node.");

		cpu_check= new QRadioButton(back1, "cpujob");
		cpu_check->setGeometry(10,110,100,20);
		cpu_check->setText("cpu job");
		QObject::connect(cpu_check, SIGNAL(clicked()), chooser, SLOT(show()) );
		QObject::connect(cpu_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(cpu_check,"Runs a cpu-intensive job on one openMosix-node.");

		iojob_check= new QRadioButton(back1, "iojob");
		iojob_check->setGeometry(10,130,100,20);
		iojob_check->setText("io job");
		QObject::connect(iojob_check, SIGNAL(clicked()), chooser, SLOT(show()) );
		QObject::connect(iojob_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(iojob_check,"Runs a io-intensive job on one openMosix-node.");

		nodecay_check= new QRadioButton(back1, "nodecay");
		nodecay_check->setGeometry(10,150,100,20);
		nodecay_check->setText("no decay");
		QObject::connect(nodecay_check, SIGNAL(clicked()), chooser, SLOT(show()) );
		QObject::connect(nodecay_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(nodecay_check,"Runs job with no decay on one openMosix-node.");

		slowdecay_check= new QRadioButton(back1, "slowdecay");
		slowdecay_check->setGeometry(10,170,100,20);
		slowdecay_check->setText("slow decay");
		QObject::connect(slowdecay_check, SIGNAL(clicked()), chooser, SLOT(show()) );
		QObject::connect(slowdecay_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(slowdecay_check,"Runs job with slow decay on one openMosix-node.");

		fastdecay_check= new QRadioButton(back1, "fastdecay");
		fastdecay_check->setGeometry(10,190,100,20);
		fastdecay_check->setText("fast decay");
		QObject::connect(fastdecay_check, SIGNAL(clicked()), chooser, SLOT(show()) );
		QObject::connect(fastdecay_check, SIGNAL(clicked()), this, SLOT(no_parallel()) );
		QWhatsThis::add(fastdecay_check,"Runs job with fast decay on one openMosix-node.");

		parallel_check= new QRadioButton(back1, "parallel");
		parallel_check->setGeometry(10,210,100,20);
		parallel_check->setText("parallel");
		QObject::connect(parallel_check, SIGNAL(clicked()), chooser, SLOT(hide()) );
		QObject::connect(parallel_check, SIGNAL(clicked()), this, SLOT(parallel_command()) );
		QWhatsThis::add(parallel_check,"Runs parallel command on several openMosix-nodes.");

		command_line= new QLineEdit(back1, "commandline");
		command_line->setGeometry(5, 10, 370,20);
		command_line->setMinimumSize(0,0);
		command_line->setMaxLength(290);
		command_line->setText(fileName);
		QWhatsThis::add(command_line,"You can specify the way how\nthis command should be executed.");

		option_label1 = new QLabel("options",back1);
		option_label1->setGeometry(5,30,370,20);
		option_label1->setMinimumSize(0,0);
		option_label1->setText("(you can now specify additional command-line arguments)");

		option_label2 = new QLabel("options1",chooser);
		option_label2->setGeometry(100, 15, 80, 40);
		option_label2->setMinimumSize(0,0);
		option_label2->setText("run job on\ncluster-node");

		option_label3 = new QLabel("nodeicon",chooser);
		option_label3->setGeometry(100, 60, 20, 20);
		option_label3->setMinimumSize(0,0);
		option_label3->setPixmap(host);

		node_hint = new QLabel("hint",chooser);
		node_hint->setGeometry(130, 85, 20, 20);
		node_hint->setMinimumSize(0,0);
		node_hint->setText("");
		node_hint->hide();

		hinten2->show();

		parallel_label1 = new QLabel("exe parallel",back1);
		parallel_label1->setGeometry(150, 70, 170, 20);
		parallel_label1->setMinimumSize(0,0);
		parallel_label1->setText("Execute this command parallel");
		parallel_label1->hide();

		parallel_label2 = new QLabel("exe parallel",back1);
		parallel_label2->setGeometry(150, 100, 80, 20);
		parallel_label2->setMinimumSize(0,0);
		parallel_label2->setText("from node");
		parallel_label2->hide();

		parallel_label3 = new QLabel("exe parallel",back1);
		parallel_label3->setGeometry(150, 130, 80, 20);
		parallel_label3->setMinimumSize(0,0);
		parallel_label3->setText("up to node");
		parallel_label3->hide();

		parallel_from= new QSpinBox(back1, "from");
		parallel_from->setGeometry(220,100,60,20);
		parallel_from->setMinimumSize(0,0);
		parallel_from->setMinValue(fromnode);
		parallel_from->setMaxValue(tonode);
		parallel_from->setValue(fromnode);
		parallel_from->hide();
		QObject::connect(parallel_from, SIGNAL(valueChanged(int)), this, SLOT(sync_qspinbox(int)));
		QWhatsThis::add(parallel_from,"Specify the first node on which\nthe command should be executed.");

		parallel_to= new QSpinBox(back1, "to");
		parallel_to->setGeometry(220,130,60,20);
		parallel_to->setMinimumSize(0,0);
		parallel_to->setMinValue(fromnode);
		parallel_to->setMaxValue(tonode);
		parallel_to->setValue(tonode);
		parallel_to->hide();
		QObject::connect(parallel_to, SIGNAL(valueChanged(int)), this, SLOT(sync_qspinbox(int)));
		QWhatsThis::add(parallel_to,"Specify the last node on which\nthe command should be executed.");

		} else {
    statusBar()->message("running aborted");
  }

}








void OpenMosixViewApp::execute_it() {

	char *temp;
	temp = new char[50];
	string statusmessage;
	string how;
	int error;

	if (nomig_check->isOn()) {
		how = how + "nomig ";
		statusmessage = statusmessage + "run a local, non migrating job";
		statusBar()->message(statusmessage.c_str());
	}

	if (runhome_check->isOn()) {
		how = how + "runhome ";
		statusmessage = statusmessage + "run a local job";
		statusBar()->message(statusmessage.c_str());
	}

	if (runon_check->isOn()) {
		how = how + "runon ";
	  	node_hint->setNum(lcd_host_chooser->intValue());
	  	strcpy(temp, " ");
	  	strcat(temp, node_hint->text());
	  	strcat(temp, " ");
		how = how + temp;
		statusmessage = statusmessage + "run a local job";
		statusmessage = statusmessage + temp;
		statusBar()->message(statusmessage.c_str());
	}


	if (cpu_check->isOn()) {
		how = how + "cpujob ";
	  	node_hint->setNum(lcd_host_chooser->intValue());
	  	strcpy(temp, " ");
	  	strcat(temp, node_hint->text());
	  	strcat(temp, " ");
		how = how + temp;
		statusmessage = statusmessage + "run a cpujob on openMosix-node ";
		statusmessage = statusmessage + temp;
		statusBar()->message(statusmessage.c_str());
	}

	if (iojob_check->isOn()) {
		how = how + "iojob ";
	  	node_hint->setNum(lcd_host_chooser->intValue());
	  	strcpy(temp, " ");
	  	strcat(temp, node_hint->text());
	  	strcat(temp, " ");
		how = how + temp;
		statusmessage = statusmessage + "run a iojob on openMosix-node ";
		statusmessage = statusmessage + temp;
		statusBar()->message(statusmessage.c_str());
	}

	if (nodecay_check->isOn()) {
		how = how + "nodecay ";
	  	node_hint->setNum(lcd_host_chooser->intValue());
	  	strcpy(temp, " ");
	  	strcat(temp, node_hint->text());
	  	strcat(temp, " ");
		how = how + temp;
		statusmessage = statusmessage + "run a nodecay job on openMosix-node ";
		statusmessage = statusmessage + temp;
		statusBar()->message(statusmessage.c_str());
	}

	if (slowdecay_check->isOn()) {
		how = how + "slowdecay ";
	  	node_hint->setNum(lcd_host_chooser->intValue());
	  	strcpy(temp, " ");
	  	strcat(temp, node_hint->text());
	  	strcat(temp, " ");
		how = how + temp;
		statusmessage = statusmessage + "run a slowdecay job on openMosix-node ";
		statusmessage = statusmessage + temp;
		statusBar()->message(statusmessage.c_str());
	}

	if (fastdecay_check->isOn()) {
		how = how + "fastdecay ";
	  	node_hint->setNum(lcd_host_chooser->intValue());
	  	strcpy(temp, " ");
	  	strcat(temp, node_hint->text());
	  	strcat(temp, " ");
		how = how + temp;
		statusmessage = statusmessage + "run a fastdecay job on openMosix-node ";
		statusmessage = statusmessage + temp;
		statusBar()->message(statusmessage.c_str());
	}

	strcpy(temp, " ");
	strcat(temp, command_line->text());
	how = how + temp;
	how = how + "&";
	if ((error=system(how.c_str())) > 0) {
		statusBar()->message("could not execute");
		}
}






void OpenMosixViewApp::parallel_command() {
	QPushButton_exe->hide();
	QPushButton_exe->setEnabled(false);
	QPushButton_parallel_exe->show();
	QPushButton_parallel_exe->setEnabled(true);
	parallel_from->show();
	parallel_to->show();
	parallel_label1->show();
	parallel_label2->show();
	parallel_label3->show();
}

void OpenMosixViewApp::no_parallel() {
	QPushButton_exe->show();
	QPushButton_exe->setEnabled(true);
	QPushButton_parallel_exe->hide();
	QPushButton_parallel_exe->setEnabled(false);
	parallel_from->hide();
	parallel_to->hide();
	parallel_label1->hide();
	parallel_label2->hide();
	parallel_label3->hide();
}






void OpenMosixViewApp::parallel_execute_it() {

	int error=0;
	string exec_command;
	string remote_command;
	string command_output;
   char *temp;
	temp = new char[100];

	if(sshconfig) {
		remote_command=remote_command + "ssh ";
		} else {
		remote_command=remote_command + "rsh ";
	}

	int h=0;
	list<string>::iterator p = nodelist.begin();
	while (p != nodelist.end()) {
		int id;
		string nodeid;
		nodeid=nodeid+(string)*p;
		id = string2int(nodeid);
			if ((id>=parallel_from->value()) && (id<=parallel_to->value())) {
			strcpy(temp, "");
			strcat(temp, QPushButton_host[h]->text());
			exec_command = exec_command + remote_command;
			exec_command = exec_command + temp;
			exec_command = exec_command + " ";
			strcpy(temp, "");
			strcat(temp, command_line->text());
			exec_command = exec_command + temp;
			exec_command = exec_command + " ";
			if((error=system(exec_command.c_str())) > 0) {
			   command_output = command_output + "failed to execute ";
			   command_output = command_output +  exec_command;
				statusBar()->message(command_output.c_str());
				command_output.erase();
			}
			exec_command.erase();
		}
		p++;
		h++;
	} // end of while loop
}


void OpenMosixViewApp::sync_qspinbox(int val) {

	if (parallel_from->value()>parallel_to->value()) {
	  parallel_from->setValue(parallel_to->value());
	}
	val=val;
}


void OpenMosixViewApp::proc_box() {
	string procboxoutput;
	procboxoutput.erase();
	if (!system("mosrun -h openmosixprocs &")) {
		procboxoutput = 	procboxoutput + "open openMosixprocs";
		} else {
		procboxoutput = 	procboxoutput + "could not open openMosixprocs";
	}
	statusBar()->message(procboxoutput.c_str());
}




void OpenMosixViewApp::open_remoteprocs() {

	const char *hostname;
	const QObject *button = sender();
	hostname=button->name();
	string remotecon_output;
	string xhostcommand;
	string remoteconsole;
	char *display;
	display = new char[100];
	int error;
	int entries;
	int neu=0;
	FILE *fp;

   remotecon_output = remotecon_output + "open a remote console";
	statusBar()->message(remotecon_output.c_str());
	remotecon_output.erase();

	if (display_edit->currentText().isEmpty()) {
		// we have no display !
		remotecon_output = remotecon_output + "could not open remote openMosixprocs! display is empty.";
		statusBar()->message(remotecon_output.c_str());
		remotecon_output.erase();
		} else {
		// fill display
		strcpy(display, "");
		strcat(display, display_edit->currentText());
		strcat(display, ":");
		strcat(display, display_one->text());
		strcat(display, ".");
		strcat(display, display_two->text());
		strcat(display, "&");

		// check for all nodes
		if(QLabel_hostconf->text()=="all-nodes") {
			// set xhost +
			xhostcommand = xhostcommand + "xhost +";
			if((error=system(xhostcommand.c_str())) > 0) {
			   remotecon_output = remotecon_output + "cannot set xhost +";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
	  	      } else {
			   remotecon_output = remotecon_output + "set xhost +";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
			}

         list<string>::iterator p = nodelist.begin();
			while (p != nodelist.end()) {
				string nodeid;
				nodeid=nodeid+(string)*p;
				string thisnodename;
				thisnodename = thisnodename + getnodename(nodeid);

				// check for ssh/rsh
				if (sshconfig) {
					remoteconsole = remoteconsole + "ssh ";
					} else {
					remoteconsole = remoteconsole + "rsh ";
				}
				remoteconsole = remoteconsole + thisnodename;
				remoteconsole = remoteconsole + " `which openmosixprocs` -display ";
				remoteconsole = remoteconsole + display;

				if((error=system(remoteconsole.c_str())) > 0) {
				   remotecon_output = remotecon_output + "failed to open openMosixprocs";
					statusBar()->message(remotecon_output.c_str());
					remotecon_output.erase();
					} else {
				   remotecon_output = remotecon_output + "open openMosixprocs";
					statusBar()->message(remotecon_output.c_str());
					remotecon_output.erase();
				}

				remoteconsole.erase();
				p++;
  			} // end of allnodes

			} else {
			// set xhost + hostname
			xhostcommand = xhostcommand + "xhost +";
			xhostcommand = xhostcommand + hostname;
			if((error=system(xhostcommand.c_str())) > 0) {
			   remotecon_output = remotecon_output + "cannot set xhost + for remote host";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
	  	      } else {
			   remotecon_output = remotecon_output + "set xhost + for remote host";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
			}
			// check for ssh/rsh
			if (sshconfig) {
				remoteconsole = remoteconsole + "ssh ";
				} else {
				remoteconsole = remoteconsole + "rsh ";
			}
			remoteconsole = remoteconsole + hostname;
			remoteconsole = remoteconsole + " `which openmosixprocs` -display ";
			remoteconsole = remoteconsole + display;

			if((error=system(remoteconsole.c_str())) > 0) {
			   remotecon_output = remotecon_output + "failed to open openMosixprocs";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
				} else {
			   remotecon_output = remotecon_output + "open openMosixprocs";
				statusBar()->message(remotecon_output.c_str());
				remotecon_output.erase();
			}
			remoteconsole.erase();
		}

		// end of command
		// insert the display in the display history if required
		for(entries=0; entries<display_edit->count(); entries++) {
			if(strcmp(display_edit->currentText(), display_edit->text(entries))==0) {
				neu=1;
			}
		}
		if (!neu) {
			display_edit->insertItem(display_edit->currentText(), 0);
		}
		string savedisplay;
      if ((fp=fopen(displayfile, "w"))!=NULL) {
			for(entries=0; entries<display_edit->count(); entries++) {
				fputs(display_edit->text(entries), fp);
				fputs("\n", fp);
			}
			fclose(fp);
			} else {
			savedisplay = savedisplay + "could not write hostlist to ";
			savedisplay = savedisplay + displayfile;
			statusBar()->message(savedisplay.c_str());
		}

	}  // end of command

}






// managing the openMosixcollector
void OpenMosixViewApp::start_openMosixcollector() {
	int error;
	string startopenmosixcollector;
	startopenmosixcollector.erase();
	startopenmosixcollector = startopenmosixcollector + "/etc/init.d/openmosixcollector start";
	if((error=system(startopenmosixcollector.c_str())) > 0) {
		cout << "cannot start the openMosixcollector!" << endl;
	}
}

void OpenMosixViewApp::stop_openMosixcollector() {
	int error;
	string stopopenmosixcollector;
	stopopenmosixcollector.erase();
	stopopenmosixcollector = stopopenmosixcollector + "/etc/init.d/openmosixcollector stop";
	if((error=system(stopopenmosixcollector.c_str())) > 0) {
		cout << "cannot stop the openMosixcollector!" << endl;
		statusBar()->message("cannot stop the openMosixcollector!");
		} else {
		statusBar()->message("stopped the openMosixcollector");
	}
}


void OpenMosixViewApp::checkpoint_openMosixcollector() {
	int error;
	string checkpointopenmosixcollector;
	checkpointopenmosixcollector.erase();
	checkpointopenmosixcollector = checkpointopenmosixcollector + "/etc/init.d/openmosixcollector checkpoint";
	if((error=system(checkpointopenmosixcollector.c_str())) > 0) {
		cout << "cannot checkpoint the openMosixcollector!" << endl;
		statusBar()->message("cannot checkpoint the openMosixcollector!");
		} else {
		statusBar()->message("checkpointed the openMosixcollector");
	}
}


void OpenMosixViewApp::restart_openMosixcollector() {
	int error;
	string restartopenmosixcollector;
	restartopenmosixcollector.erase();
	restartopenmosixcollector = restartopenmosixcollector + "/etc/init.d/openmosixcollector restart";
	if((error=system(restartopenmosixcollector.c_str())) > 0) {
		cout << "cannot restart the openMosixcollector!" << endl;
		statusBar()->message("cannot restart the openMosixcollector!");
		} else {
		statusBar()->message("restarted the openMosixcollector");
	}
}



// starts the openMosixananlyzer
void OpenMosixViewApp::start_openMosixanalyzer() {
	int error;
	string startopenmosixanalyzer;
	startopenmosixanalyzer.erase();
	startopenmosixanalyzer = startopenmosixanalyzer + "mosrun -h openmosixanalyzer&";
	if((error=system(startopenmosixanalyzer.c_str())) > 0) {
		cout << "cannot start the openMosixanalyzer!" << endl;
		statusBar()->message("cannot start the openMosixanalyzer!");
		} else {
		statusBar()->message("started the openMosixanalyzer");
	}
}


// starts the openMosixmigmon
void OpenMosixViewApp::start_openMosixmigmon() {
	int error;
	string startopenmosixmigmon;
	startopenmosixmigmon.erase();
	startopenmosixmigmon = startopenmosixmigmon + "mosrun -h openmosixmigmon&";
	if((error=system(startopenmosixmigmon.c_str())) > 0) {
		cout << "cannot start the openMosixmigmon!" << endl;
		statusBar()->message("cannot start the openMosixmigmon!");
		} else {
		statusBar()->message("started the openMosixmigmon");
	}
}




// starts the 3dmosmon
void OpenMosixViewApp::start_3dmosmon() {
	int error;
	string start3dmosmon;
	start3dmosmon.erase();
	start3dmosmon = start3dmosmon + threedmosmon;
  if(file_exist(start3dmosmon)) {
  	start3dmosmon = start3dmosmon + " localhost &";
  	if((error=system(start3dmosmon.c_str())) > 0) {
  		cout << "cannot start the 3dmosmon!" << endl;
  		statusBar()->message("cannot start 3dmosmon!");
  		} else {
  		statusBar()->message("started 3dmosmon");
  	}
    } else {
  	statusBar()->message("cannot start 3dmosmon!");
  }
}


// to adjust the timer
void OpenMosixViewApp::adjusttimer(int val) {
	int secval=val*1000;
	internalTimer->changeInterval(secval);
	string refreshmes;
        refreshmes = "set refresh timeout to ";
        refreshmes = refreshmes	+ int2string(val);
        refreshmes = refreshmes	+ " seconds";
	statusBar()->message(refreshmes.c_str());
}






