/***************************************************************************
                          openmosixprocs.cpp  -  description
                             -------------------
    begin                : Don Jul 25 13:55:26 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qaccel.h>
#include "openmosixprocs.h"


#include "white.xpm"
#include "hosti.xpm"
#include "proc.xpm"
#include "proc_g.xpm"
#include "proc_remote.xpm"
#include "refresh.xpm"
#include "speed.xpm"
#include "gohome.xpm"
#include "kill.xpm"
#include "ende.xpm"
#include "proc_cant.xpm"
#include "whatis.xpm"


OpenMosixprocsApp::OpenMosixprocsApp()
{
  string myhostname;
  string headline;
	char zeile[201];
	std::ifstream readhostname("/proc/sys/kernel/hostname");
	if (readhostname) {
		readhostname.getline(zeile, 200);
		myhostname.erase();
		myhostname= myhostname+zeile;
		readhostname.close();
		} else {
		cout << "could not read from /proc/sys/kernel/hostname"  << endl;
		myhostname.erase();
		myhostname= myhostname+"localhost";
	}
  headline.erase();
  headline = headline + "processes on ";
  headline = headline + myhostname.c_str();
	setCaption(tr(headline.c_str()));

	// init methods
	initActions();
	initStatusBar();
}


OpenMosixprocsApp::~OpenMosixprocsApp()
{
}



// ################################# helping functions ############################

  int file_exist(string filename)
{
	std::ifstream readfilename(filename.c_str());
	if (readfilename) {
		readfilename.close();
		return 1;
		} else {
		return 0;
	}
}


int string2int(const string s) {
        if (s.length() == 0) {
                return -1;
        } else {
                return(atoi(s.c_str()));
        }
}

string int2string(const int i) {
        char buf[12];
        sprintf(buf,"%d",i);
        return(string(buf));
}


string readfromproc(string pid, string what) {
 char zeile[201];
 string temps, tempret;
 temps = temps + "/proc/";
 temps = temps + pid;
 temps = temps + "/";
 temps = temps + what;
 std::ifstream readprocval(temps.c_str());
 if (readprocval) {
  readprocval.getline(zeile, 200);
  tempret.erase();
  tempret= tempret+zeile;
  readprocval.close();
  } else {
  tempret="0";
 }
 return tempret;
}



// converts a cluster id to an hostname
string OpenMosixprocsApp::getnodename(string node) {
	// gather nodes hostname
	string which;
	char zeile[201];
	string nodename;
	which = which + clustercommand + " whois ";
	which = which + node + " > /tmp/nodes.tmp";
	system(which.c_str());
	if (file_exist("/tmp/nodes.tmp")) {
		std::ifstream readnodename("/tmp/nodes.tmp");
		if (readnodename) {
			readnodename.getline(zeile, 200);
			nodename.erase();
			nodename= nodename+zeile;
			readnodename.close();
			} else {
			cout << "could not read from /tmp/nodes.tmp"  << endl;
			return 0;
		}
	}
   unlink("/tmp/nodes.tmp");
   return nodename;

}





/** initializes all QActions of the application */
void OpenMosixprocsApp::initActions(){

	string username;
	char zeile[201];
	typedef string::size_type where;
	where whereitis;

	QPixmap white_pix, fresh, end, what;
	white_pix= QPixmap(white_xpm);
	fresh = QPixmap(refresh);
	end = QPixmap(ende);
	what = QPixmap(whatis);

	QPushButton_refresh= new QPushButton(fresh, "NoName", this);
	QPushButton_refresh->setGeometry(25,5,70,20);
	QPushButton_refresh->setMinimumSize(0,0);
	QPushButton_refresh->setText("refresh");
	QObject::connect( QPushButton_refresh, SIGNAL(clicked()), this, SLOT( fill_procbox()) );
	QWhatsThis::add(QPushButton_refresh,"Click this button to refresh\nthe processbox.");

	QLabel_current_proc_label= new QLabel(this,"NoName");
	QLabel_current_proc_label->setGeometry(350,5,130,20);
	QLabel_current_proc_label->setMinimumSize(0,0);
	QLabel_current_proc_label->setText("last managed process:");
	QLabel_current_proc_label->setMargin(2);

	QLabel_current_proc= new QLabel(this,"NoName");
	QLabel_current_proc->setGeometry(280,5,70,20);
	QLabel_current_proc->setMinimumSize(0,0);
	QLabel_current_proc->setBackgroundPixmap(QPixmap(white_pix));
	QLabel_current_proc->setText("");
	QLabel_current_proc->setMargin(2);
	QLabel_current_proc->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QLabel_current_proc->setAlignment( AlignVCenter | AlignRight );
	QWhatsThis::add(QLabel_current_proc,"This box shows the current\nmanaged process.");

	userbox = new QComboBox(this);
	userbox->setGeometry(95,5,100,20);
	userbox->setMinimumSize(0,0);
	userbox->resize(100, 20);
	QObject::connect(userbox, SIGNAL(activated(int)), this, SLOT(sync_user(int)) );
	QWhatsThis::add(userbox,"Select the user (or all) for a more selective view\n.");

	userbox->insertItem("all", -1);
	std::ifstream readpasswd("/etc/passwd");
	if (readpasswd) {
		while(readpasswd.getline(zeile, 200)) {
			username.erase();
			username= username+zeile;
			whereitis = username.find_first_of(":");
			username = username.substr(0, whereitis);
			userbox->insertItem(username.c_str(), -1);
		}
		readpasswd.close();
		} else {
		cout << "could not open /etc/passwd for reading" << endl;
	}

	user_select_label= new QLabel(this,"NoName");
	user_select_label->setGeometry(5,70,70,20);
	user_select_label->setMinimumSize(0,0);
	user_select_label->setText("all");

	QLabel_userbox= new QLabel(this,"NoName");
	QLabel_userbox->setGeometry(200,5,60,20);
	QLabel_userbox->setMinimumSize(0,0);
	QLabel_userbox->setMargin(0);
	QLabel_userbox->setText("processes");
	QWhatsThis::add(QLabel_userbox,"Select the user (or all) for a more selective view\n.");

	processbox = new QListView(this);
	processbox->setGeometry(5,30,50,100);
	processbox->setMinimumSize(0,0);
	processbox->setAllColumnsShowFocus(1);
	processbox->addColumn("pid");
	processbox->addColumn("n#");
	processbox->addColumn("lock");
	processbox->addColumn("nmigs");
	processbox->addColumn("miggr");
	processbox->addColumn("stat");
	processbox->addColumn("cmdline");
	processbox->addColumn("nice  id");
	processbox->setSorting(2, TRUE);
	processbox->setColumnAlignment (0, AlignLeft);
	processbox->setColumnAlignment (1, AlignLeft);
	processbox->setColumnAlignment (2, AlignLeft);
	processbox->setColumnAlignment (3, AlignLeft);
	processbox->setColumnAlignment (4, AlignLeft);
	processbox->setItemMargin(2);
	processbox->resize(350, 300);
	QObject::connect( processbox, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT( migrator(QListViewItem *)));
	QWhatsThis::add(processbox,"This box displays the\nprocesses on this node.\nDouble-click a process\nfor managing it.");

	QObject::connect( processbox, SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int )), this, SLOT(startpidlog(QListViewItem *, const QPoint &, int )));

	what_this_button = new QToolButton(this, "whatsthis");
	what_this_button->setGeometry(5,5,20,20);
	what_this_button->setPixmap(what);
	connect(what_this_button, SIGNAL(clicked()), this, SLOT(slot_whatisthis()));

	QPushButton_1= new QPushButton(end, "NoName", this);
	QPushButton_1->setGeometry(280,380,60,20);
	QPushButton_1->setMinimumSize(0,0);
	QPushButton_1->setText("quit");
	QObject::connect(QPushButton_1, SIGNAL(clicked()), qApp, SLOT(quit()) );
	QWhatsThis::add(QPushButton_1,"Close the the processbox.");

	QPushButton_rem= new QPushButton(this,"NoName");
	QPushButton_rem->setGeometry(5,380,160,20);
	QPushButton_rem->setMinimumSize(0,0);
	QPushButton_rem->setText("manage procs from remote");
	QWhatsThis::add(QPushButton_rem,"Click this button to manage processes\ncurrently migraged to the node.");
	QObject::connect( QPushButton_rem, SIGNAL(clicked()), this, SLOT( remoteproc()) );

	QLabel_howmany_procs= new QLabel(this,"howmany");
	QLabel_howmany_procs->setGeometry(200,360,50,20);
	QLabel_howmany_procs->setMinimumSize(0,0);
	QLabel_howmany_procs->setBackgroundPixmap(QPixmap(white_pix));
	QLabel_howmany_procs->setText("");
	QLabel_howmany_procs->setMargin(2);
	QLabel_howmany_procs->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QLabel_howmany_procs->setAlignment( AlignVCenter | AlignRight );
	QWhatsThis::add(QLabel_howmany_procs,"This box displays howmany processes are currently running on this system.");

	QLabel_howmany_label= new QLabel(this,"NoName");
	QLabel_howmany_label->setGeometry(260,360,140,20);
	QLabel_howmany_label->setMinimumSize(0,0);
	QLabel_howmany_label->setText("processes on this system");


	QTimer *proctimer = new QTimer( this, "procs" );
	proctimer->start(5000);
	connect( proctimer, SIGNAL(timeout()), this, SLOT(fill_procbox()) );
	fill_procbox();


}


void OpenMosixprocsApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(tr("Ready."), 2000);
}



void OpenMosixprocsApp::slot_whatisthis()
{
QWhatsThis::enterWhatsThisMode();
}




void OpenMosixprocsApp::fill_procbox() {

	DIR *dir;
	FILE *fp;
	struct dirent *dir_info;
	string processname;
	string temp;
	string cmdlinevalue, wherevalue, cannotvalue, processnicevalue, statusvalue, lockvalue, nmigsvalue, miggroupvalue, niceanduser;
	char *userid;
	userid = new char[50];
	char *userid1;
	userid1 = new char[50];
	char *stat;
	char *cmdtmp;
	cmdtmp = new char[50];
	char *cmdtmp1;
	cmdtmp1 = new char[50];
	stat = new char[50];
  	string procdir = "/proc/";
	string stripwhere;
	string statusoutput;
	char zeile[201];
	int proc_nice=0;
	int current_procprio=0;
	int raus=0;
 	int howmanyprocs=0;
	int vscrollvalue=0;
	int hscrollvalue=0;
	
 	QPixmap procicon, remoteprocicon, cantprocicon;
	procicon= QPixmap(proc);
	remoteprocicon= QPixmap(proc_remote);
	cantprocicon= QPixmap(proc_cant);


  // get the scrollbarvalues
  QScrollBar *vscrollbar, *hscrollbar;
  vscrollbar = processbox->verticalScrollBar();
  hscrollbar = processbox->horizontalScrollBar();

  vscrollvalue=vscrollbar->value();
  hscrollvalue=hscrollbar->value();


	processbox->clear();

	if ((dir=opendir("/proc"))!=NULL) {

		while ((dir_info = readdir(dir))!=NULL) {
			processname.erase();
			processname = processname + dir_info->d_name;

			if((strchr(processname.c_str(), '1'))||(strchr(processname.c_str(), '2'))||(strchr(processname.c_str(), '3'))||(strchr(processname.c_str(), '4'))||(strchr(processname.c_str(), '5'))||(strchr(processname.c_str(), '6'))||(strchr(processname.c_str(), '7'))||(strchr(processname.c_str(), '8'))||(strchr(processname.c_str(), '9')) ) {

				howmanyprocs++;

				temp.erase();
				temp = temp + procdir;
				temp = temp + processname;
				temp = temp + "/status";
				if ((fp=fopen(temp.c_str(), "r"))!=NULL) {
				 fscanf(fp, "%s %s", cmdtmp, cmdtmp1);
				 raus=0;
				 while ((fgets(zeile, 200, fp) != NULL)&&(raus==0) ) {
				  if (strstr(zeile, "TracerPid:")) {
				   fscanf(fp, "%s %s", userid1, userid);
				   raus=1;
				  }
				 }
				fclose(fp);
				}

				 cmdlinevalue = cmdtmp1;

				 wherevalue.erase();
				 wherevalue=readfromproc(processname, "where");

				 lockvalue.erase();
				 lockvalue=readfromproc(processname, "lock");

				 nmigsvalue.erase();
				 nmigsvalue=readfromproc(processname, "nmigs");

				 cannotvalue.erase();
				 cannotvalue=readfromproc(processname, "cantmove");

				 miggroupvalue.erase();
				 miggroupvalue=readfromproc(processname, "miggroup");
				 if (string2int(miggroupvalue)>1000) {
				  miggroupvalue="0";
				 }
			 
	  			 temp.erase();
				 temp = temp + procdir;
				 temp = temp + processname;
				 temp = temp + "/stat";
				 if ((fp=fopen(temp.c_str(), "r"))!=NULL) {
			 	  fscanf(fp, "%s", stat);
		 		  fscanf(fp, "%s", stat);
				  fscanf(fp, "%s", stat);
				  fclose(fp);
				 }
				
				// priority
				proc_nice = atoi(processname.c_str());
				current_procprio = getpriority(PRIO_PROCESS, proc_nice);
				processnicevalue = int2string(current_procprio);
				// here we merge together nice + user because the processbox
				// can only stand 8 columns
				niceanduser.erase();
				niceanduser=niceanduser + processnicevalue;
				niceanduser=niceanduser + "       ";
				niceanduser=niceanduser + userid;

				if ((!strcmp(user_select_label->text(), userid)) || (!strcmp(user_select_label->text(), "all")))  {
					QListViewItem *i1;

//					i1 = new QListViewItem(processbox, processname.c_str(), wherevalue.c_str(), lockvalue.c_str(), nmigsvalue.c_str(), stat, cmdlinevalue.c_str(), processnicevalue.c_str(), userid);
i1 = new QListViewItem(processbox, processname.c_str(), wherevalue.c_str(), lockvalue.c_str(), nmigsvalue.c_str(), miggroupvalue.c_str(), stat, cmdlinevalue.c_str(), niceanduser.c_str());

					
					if ((string2int(wherevalue.c_str()))==0) {
						if( (!strstr(cannotvalue.c_str(), "init_proc"))&&(!strstr(cannotvalue.c_str(), "clone_vm"))&&(!strstr(cannotvalue.c_str(), "daemon"))&&(!strstr(cannotvalue.c_str(), "monkey"))&&(!strstr(cannotvalue.c_str(), "mmap_dev")) ) {
							i1->setPixmap(0, procicon);
							} else {
							i1->setPixmap(0, cantprocicon);
						}
				      } else {
						i1->setPixmap(0, remoteprocicon);
					}
				} //stcmp if
			}
		} //while
		closedir(dir);
	} //if

  QLabel_howmany_procs->setNum(howmanyprocs);
	statusoutput.erase();
	statusoutput = statusoutput + "";
	statusBar()->message(statusoutput.c_str());

  // set the scrollbarvalues to the the values before the refresh
  vscrollbar->setValue(vscrollvalue);
  hscrollbar->setValue(hscrollvalue);

}


void OpenMosixprocsApp::sync_user(int index) {
	char *sub_string;
	sub_string = new char[50];
	char *temp1;
	temp1 = new char[200];
	char *temp2;
	temp2 = new char[200];
	FILE *fp;
	index=index;
	if ((fp=fopen("/etc/passwd", "r"))!=NULL) {
		while(!feof(fp)) {
			if ((fgets(temp1, 190, fp))!=NULL) {
				sub_string=strtok(temp1, ":");
				strcpy(temp2, "");
				strcpy(temp2, sub_string);
				sub_string=strtok(NULL, ":");
				sub_string=strtok(NULL, ":");
				if(!strcmp(userbox->currentText(), temp2)) {
				  user_select_label->setText(sub_string);
				}
				while ( (sub_string=strtok(NULL, ":")) != NULL) {
			}
		}
	}
	fclose(fp);
	}
	if(!strcmp(userbox->currentText(), "all")) {
	  user_select_label->setText("all");
	}
	delete [] temp1;
	delete [] temp2;
	delete [] sub_string;
}





void OpenMosixprocsApp::remoteproc() {

	int procs=0;
	DIR *dir;
	struct dirent *dir_info;
	FILE *fp;
	char *from;
	from = new char[6];
	char *ip_from;
	ip_from = new char[20];

	string temppath;
	string processname;
	string statusoutput;

 	QPixmap white_pix;
	white_pix= QPixmap(white_xpm);
	QPixmap procicon_g, home, smile;
	procicon_g= QPixmap(proc_g);
	home= QPixmap(gohome);
	smile = QPixmap(speed);

	QTabDialog *rem = new QTabDialog();
	rem->setGeometry(600,250,300,200);
	rem->resize(430, 300);

	if ((dir=opendir(remotedir))!=NULL) {
		while ((dir_info = readdir(dir))!=NULL) {
			processname.erase();
			processname = processname + dir_info->d_name;
			if((strchr(processname.c_str(), '1'))||(strchr(processname.c_str(), '2'))||(strchr(processname.c_str(), '3'))||(strchr(processname.c_str(), '4'))||(strchr(processname.c_str(), '5'))||(strchr(processname.c_str(), '6'))||(strchr(processname.c_str(), '7'))||(strchr(processname.c_str(), '8'))||(strchr(processname.c_str(), '9')) ) {
				procs++;
				temppath.erase();
				temppath = temppath + remotedir;
				temppath = temppath + processname;
				temppath = temppath + "/from";
				if ((fp=fopen(temppath.c_str(), "r"))!=NULL) {
					fscanf(fp, "%s %s", from, ip_from);
					fclose(fp);
				}
				rem_processbox[procs] = new QLabel(rem);
				rem_processbox[procs]->setGeometry(10,10,300,300);
				rem_processbox[procs]->setMinimumSize(0,0);

				rem_from_who_label[procs] = new QLabel(rem_processbox[procs]);
				rem_from_who_label[procs]->setGeometry(10,10,140,20);
				rem_from_who_label[procs]->setMinimumSize(0,0);
				rem_from_who_label[procs]->setMargin(3);
				rem_from_who_label[procs]->setText("from openMosix-node");

				rem_from_who[procs] = new QLabel(rem_processbox[procs]);
				rem_from_who[procs]->setGeometry(145,10,50,20);
				rem_from_who[procs]->setMinimumSize(0,0);
				rem_from_who[procs]->setMargin(3);
				rem_from_who[procs]->setFrameStyle( QFrame::Panel | QFrame::Sunken );
				rem_from_who[procs]->setFont(QFont( "helvetica", 10 ));
				rem_from_who[procs]->setBackgroundPixmap(QPixmap(white_pix));
				rem_from_who[procs]->setText(from);
				QWhatsThis::add(rem_from_who[procs],"This box shows the mosix-ID from the\nnode the process is currently running on.");

				rem_from_ip_label[procs] = new QLabel(rem_processbox[procs]);
				rem_from_ip_label[procs]->setGeometry(195,10,100,20);
				rem_from_ip_label[procs]->setMinimumSize(0,0);
				rem_from_ip_label[procs]->setMargin(3);
				rem_from_ip_label[procs]->setText("with IP-adress");

				rem_from_ip[procs] = new QLabel(rem_processbox[procs]);
				rem_from_ip[procs]->setGeometry(290,10,100,20);
				rem_from_ip[procs]->setMinimumSize(0,0);
				rem_from_ip[procs]->setMargin(3);
				rem_from_ip[procs]->setFrameStyle( QFrame::Panel | QFrame::Sunken );
				rem_from_ip[procs]->setBackgroundPixmap(QPixmap(white_pix));
				rem_from_ip[procs]->setText(ip_from);
				QWhatsThis::add(rem_from_ip[procs],"This box shows the ip-adress from the\nnode the process is currently running on.");

				rem_gohome[procs]=  new QPushButton(home, dir_info->d_name, rem_processbox[procs]);
				rem_gohome[procs]->setGeometry(10,65,120,25);
				rem_gohome[procs]->setMinimumSize(0,0);
				rem_gohome[procs]->setText("goto home node");
				rem_gohome[procs]->setName(dir_info->d_name);
				QObject::connect( rem_gohome[procs], SIGNAL(clicked()), this, SLOT( remote_gohome()) );
				QWhatsThis::add(rem_gohome[procs],"Click this button to migrate\nthe process to its\nhome node.");

				rem_gobest[procs]=  new QPushButton(smile, dir_info->d_name, rem_processbox[procs]);
				rem_gobest[procs]->setGeometry(10,95,120,25);
				rem_gobest[procs]->setMinimumSize(0,0);
				rem_gobest[procs]->setText("goto best node");
			 	rem_gobest[procs]->setName(dir_info->d_name);
				QObject::connect( rem_gobest[procs], SIGNAL(clicked()), this, SLOT( remote_gobest()) );
				QWhatsThis::add(rem_gobest[procs],"Click this button to migrate\nthe process to the\nbest-available node.");

				rem->addTab(rem_processbox[procs], procicon_g, dir_info->d_name);

				rem_identity[procs] = new QLabel(rem_processbox[procs]);
				rem_identity[procs]->setGeometry(145,40,120,20);
				rem_identity[procs]->setMinimumSize(0,0);
				rem_identity[procs]->setMargin(3);
				rem_identity[procs]->setText("remote identity");

				qtchild_identity[procs] = new QMultiLineEdit(rem_processbox[procs], "status");
			 	qtchild_identity[procs]->setGeometry(145,65,120,140);
				qtchild_identity[procs]->setReadOnly(TRUE);
				temppath.erase();
				temppath = temppath + remotedir;
				temppath = temppath + processname;
				temppath = temppath + "/identity";
				QFile fpidentity(temppath.c_str());
				if ( fpidentity.open(IO_ReadOnly) ) {
					QTextStream tidentity( &fpidentity );
					QString sidentity;
					while ( !tidentity.eof() ) {
						sidentity = tidentity.readLine();
						sidentity = sidentity.simplifyWhiteSpace();
				   qtchild_identity[procs]->insertLine(sidentity,-1);
					}
					fpidentity.close();
				}
				qtchild_identity[procs]->setReadOnly(TRUE);
				qtchild_identity[procs]->setBackgroundPixmap(QPixmap(white_pix));
				QWhatsThis::add(qtchild_identity[procs],"This box shows status information\nof the process\ncurrently migrated to this node.");


				rem_stats[procs] = new QLabel(rem_processbox[procs]);
				rem_stats[procs]->setGeometry(270,40,100,20);
				rem_stats[procs]->setMinimumSize(0,0);
				rem_stats[procs]->setMargin(3);
				rem_stats[procs]->setText("statistics");

				qtchild[procs] = new QMultiLineEdit(rem_processbox[procs], "status");
			 	qtchild[procs]->setGeometry(270,65,140,140);
				qtchild[procs]->setReadOnly(TRUE);
				temppath.erase();
				temppath = temppath + remotedir;
				temppath = temppath + processname;
				temppath = temppath + "/stats";
				QFile fp(temppath.c_str());
				if ( fp.open(IO_ReadOnly) ) {
					QTextStream t( &fp );
					QString s;
					while ( !t.eof() ) {
						s = t.readLine();
						s = s.simplifyWhiteSpace();
				   qtchild[procs]->insertLine(s,-1);
					}
					fp.close();
				}
				qtchild[procs]->setReadOnly(TRUE);
				qtchild[procs]->setBackgroundPixmap(QPixmap(white_pix));
				QWhatsThis::add(qtchild[procs],"This box shows status information\nof the process\ncurrently migrated to this node.");

	    }
		} //while
	closedir(dir);
	} //if


	if (procs==0) {
		rem_processbox[procs] = new QLabel(rem);
		rem_processbox[procs]->setGeometry(10,10,300,300);
		rem_processbox[procs]->setMinimumSize(0,0);
		rem_from_who_label[procs] = new QLabel(rem_processbox[procs]);
		rem_from_who_label[procs]->setGeometry(10,10,200,60);
		rem_from_who_label[procs]->setMinimumSize(0,0);
		rem_from_who_label[procs]->setMargin(3);
		rem_from_who_label[procs]->setBackgroundPixmap(QPixmap(white_pix));
		rem_from_who_label[procs]->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		rem_from_who_label[procs]->setText("No processes from remote\nnodes running on this host!");
		rem->addTab(rem_processbox[procs], procicon_g, "none");
	}


	howmanyremote = new QLabel(rem);
	howmanyremote->setGeometry(10,270,40,20);
	howmanyremote->setMinimumSize(0,0);
	howmanyremote->setMargin(2);
	howmanyremote->setBackgroundPixmap(QPixmap(white_pix));
	howmanyremote->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	howmanyremote->setAlignment( AlignVCenter | AlignRight );
	howmanyremote->setNum(procs);

	howmanyremote_label = new QLabel(rem);
	howmanyremote_label->setGeometry(55,270,250,20);
	howmanyremote_label->setMinimumSize(0,0);
	howmanyremote_label->setMargin(1);
	howmanyremote_label->setText("remote processes running on this node");

	statusoutput.erase();
	statusoutput = statusoutput + "showing the processes currently migrated to this hosts";
	statusBar()->message(statusoutput.c_str());
	rem->show();
	QWhatsThis::add(rem,"This box shows the processes currently\nmigrated to this host.");
	delete [] from;
	delete [] ip_from;
}




void OpenMosixprocsApp::migrator(QListViewItem *index) {

	char *temp;
	temp = new char[100];
	char *temp1;
	temp1 = new char[100];
	char *temp2;
	temp2 = new char[100];
	string cannot;
	string temppath;
	string statusoutput;
	string tmpoutput;
	char zeile[201];
	int current_proc=0;
	int current_prio=0;
	struct dirent **namelist;
	int n;

 	QPixmap white_pix;
	white_pix= QPixmap(white_xpm);
 	QPixmap host, migrat, home, smile, killit, end, cantprocicon;
	host= QPixmap(hosti);
	migrat= QPixmap(speed);
	home= QPixmap(gohome);
	smile = QPixmap(speed);
	killit = QPixmap(kill);
	end = QPixmap(ende);
	cantprocicon= QPixmap(proc_cant);

	hinten = new QWidget(0, "");
	hinten->setGeometry(300,300,50,110);
	hinten->setMinimumSize(0,0);
	hinten->resize(400, 450);
	hinten->setFixedSize(400, 470);

	QGroupBox *background = new QGroupBox("",hinten);
	background->setGeometry(5,25,50,130);
	background->setMinimumSize(0,0);
	background->resize(390, 440);

	QGroupBox *miglefttop = new QGroupBox("",background);
	miglefttop->setGeometry(5,30,100,100);
	miglefttop->setMinimumSize(0,0);
	miglefttop->resize(200, 120);

	QGroupBox *migrightbottom = new QGroupBox("",background);
	migrightbottom->setGeometry(210,120,100,50);
	migrightbottom->setMinimumSize(0,0);
	migrightbottom->resize(175, 55);

	QLabel *QLabel_proc = new QLabel("",migrightbottom);
	QLabel_proc->setGeometry(5,10,20,30);
	QLabel_proc->setMinimumSize(0,0);
	QLabel_proc->resize(140, 40);



	QLabel *headline_information = new QLabel("",background);
	headline_information->setGeometry(5,5,150,25);
	headline_information->setMinimumSize(0,0);
	headline_information->setText("process informations:");

	QLabel *headline_administration = new QLabel("",background);
	headline_administration->setGeometry(210,5,150,25);
	headline_administration->setMinimumSize(0,0);
	headline_administration->setText("process administration:");


	strcpy(temp, "");
	strcat(temp, index->text(0));
	strcpy(temp1, "");
	strcat(temp1, index->text(1));
	strcpy(temp2, "");
	strcat(temp2, index->text(2));

	QLabel *info_pid = new QLabel("",miglefttop);
	info_pid->setGeometry(5,5,190,20);
	info_pid->setMinimumSize(0,0);
  tmpoutput.erase();
  tmpoutput = tmpoutput + "PID : ";
  tmpoutput = tmpoutput + temp;
	info_pid->setText(tmpoutput.c_str());

	QLabel *info_where = new QLabel("",miglefttop);
	info_where->setGeometry(5,25,190,20);
	info_where->setMinimumSize(0,0);
  tmpoutput.erase();
  tmpoutput = tmpoutput + "running : ";
	if (strcmp(temp1, "0")) {
		tmpoutput = tmpoutput + "on node ";
		tmpoutput = tmpoutput + temp1;
		} else {
		tmpoutput = tmpoutput + "local";
	}
	info_where->setText(tmpoutput.c_str());

	QLabel *info_lock = new QLabel("",miglefttop);
	info_lock->setGeometry(5,45,190,20);
	info_lock->setMinimumSize(0,0);
  tmpoutput.erase();
  tmpoutput = tmpoutput + "locked : ";

	QLabel *info_mig = new QLabel("",miglefttop);
	info_mig->setGeometry(5,65,190,20);
	info_mig->setMinimumSize(0,0);

	QLabel *info_nomig = new QLabel("",miglefttop);
	info_nomig->setGeometry(5,85,190,20);
	info_nomig->setMinimumSize(0,0);
	info_nomig->setText("");


	QPushButton_71= new QPushButton(end, "close", background);
	QPushButton_71->setGeometry(325,415,60,20);
	QPushButton_71->setMinimumSize(0,0);
	QPushButton_71->setText("close");
	QObject::connect( QPushButton_71, SIGNAL(clicked()), hinten, SLOT( close()) );
	QWhatsThis::add(QPushButton_71,"Close the migrator-box.");


	QPushButton_home= new QPushButton(home, index->text(0), background);
	QPushButton_home->setGeometry(325,180,60,20);
	QPushButton_home->setMinimumSize(0,0);
	QPushButton_home->setText("home");
	QPushButton_home->setName(index->text(0));
	QObject::connect( QPushButton_home, SIGNAL(clicked()), this, SLOT( migratehome()) );
	QWhatsThis::add(QPushButton_home,"Click this button to migrate\nthe process to its\nhome-node.");

	QPushButton_best= new QPushButton(smile, index->text(0), background);
	QPushButton_best->setGeometry(325,200,60,20);
	QPushButton_best->setMinimumSize(0,0);
	QPushButton_best->setText("best");
	QPushButton_best->setName(index->text(0));
	QObject::connect( QPushButton_best, SIGNAL(clicked()), this, SLOT( migratebest()) );
	QWhatsThis::add(QPushButton_best,"Click this button to migrate\nthe process to the\nbest-available node.");

	QPushButton_lock= new QPushButton(background, index->text(0));
	QPushButton_lock->setGeometry(325,220,60,20);
	QPushButton_lock->setMinimumSize(0,0);
	QPushButton_lock->setText("lock");
	QPushButton_lock->setName(index->text(0));
	QWhatsThis::add(QPushButton_lock,"Click this button to lock the current process.");

	QPushButton_unlock= new QPushButton(background, index->text(0));
	QPushButton_unlock->setGeometry(325,240,60,20);
	QPushButton_unlock->setMinimumSize(0,0);
	QPushButton_unlock->setText("unlock");
	QPushButton_unlock->setName(index->text(0));
	QWhatsThis::add(QPushButton_unlock,"Click this button to unlock the current process.");

	if (strcmp(temp2, "0")) {
  	QPushButton_lock->setDisabled(true);
		tmpoutput = tmpoutput + "yes";
		} else {
  	QPushButton_unlock->setDisabled(true);
		tmpoutput = tmpoutput + "no";
	}

	info_lock->setText(tmpoutput.c_str());
	QObject::connect( QPushButton_lock, SIGNAL(clicked()), this, SLOT( lockproc()) );
	QObject::connect( QPushButton_unlock, SIGNAL(clicked()), this, SLOT( unlockproc()) );


	pidlog_button= new QPushButton(background,index->text(0));
	pidlog_button->setGeometry(325,260,60,20);
 	pidlog_button->setMinimumSize(0,0);
	pidlog_button->setText("pidlog");
	QObject::connect(pidlog_button, SIGNAL(clicked()), this, SLOT(startpidlog()) );
	QWhatsThis::add(pidlog_button,"This starts the openMosixpidlog for this process");

	sigstop_button= new QPushButton(background,index->text(0));
	sigstop_button->setGeometry(325,280,60,20);
 	sigstop_button->setMinimumSize(0,0);
	sigstop_button->setText("sigstop");
	QObject::connect(sigstop_button, SIGNAL(clicked()), this, SLOT(action_sigstop()) );
	QWhatsThis::add(sigstop_button,"This button sends a\nkill -SIGSTOP\nsignal to the process.\nThe process will\nstop immediatly");

	sigcont_button= new QPushButton(background,index->text(0));
	sigcont_button->setGeometry(325,300,60,20);
	sigcont_button->setMinimumSize(0,0);
	sigcont_button->setText("sigcont");
	QObject::connect( sigcont_button, SIGNAL(clicked()), this, SLOT(action_sigcont()) );
	QWhatsThis::add(sigcont_button,"This button sends a\nkill -SIGCONT\nsignal to the process.\nThe process will\ncontinue immediatly");

	QPushButton_72= new QPushButton(killit, index->text(0), background);
	QPushButton_72->setGeometry(325,320,60,20);
	QPushButton_72->setMinimumSize(0,0);
	QPushButton_72->setText("kill");
	QPushButton_72->setName(index->text(0));
	QObject::connect( QPushButton_72, SIGNAL(clicked()), this, SLOT( killproc()) );
	QWhatsThis::add(QPushButton_72,"Click this button to kill\nthe process.");



	home_label = new QLabel("",background);
	home_label->setGeometry(215,180,110,20);
	home_label->setMinimumSize(0,0);
	home_label->setText("send to home node");

	best_label = new QLabel("",background);
	best_label->setGeometry(215,200,110,20);
	best_label->setMinimumSize(0,0);
	best_label->setText("send to best mode");

	lock_label = new QLabel("",background);
	lock_label->setGeometry(215,220,110,20);
	lock_label->setMinimumSize(0,0);
	lock_label->setText("lock process");

	unlock_label = new QLabel("",background);
	unlock_label->setGeometry(215,240,110,20);
	unlock_label->setMinimumSize(0,0);
	unlock_label->setText("unlock process");

	pidlog_label = new QLabel("",background);
	pidlog_label->setGeometry(215,260,110,20);
	pidlog_label->setMinimumSize(0,0);
	pidlog_label->setText("log process");

	sigstop_label = new QLabel("",background);
	sigstop_label->setGeometry(215,280,110,20);
	sigstop_label->setMinimumSize(0,0);
	sigstop_label->setText("send SIGSTOP");

	sigcont_label = new QLabel("",background);
	sigcont_label->setGeometry(215,300,110,20);
	sigcont_label->setMinimumSize(0,0);
	sigcont_label->setText("send SIGCONT");

	home_label1 = new QLabel("",background);
	home_label1->setGeometry(215,320,110,20);
	home_label1->setMinimumSize(0,0);
	home_label1->setText("kill process");


	QListBox *hostbox = new QListBox(background);
	hostbox->setGeometry(210,30,175,100);
	hostbox->setMinimumSize(0,0);
	hostbox->resize(175, 100);
	QWhatsThis::add(hostbox,"This box displays all openMosix-nodes\nto which the process could be migrated.\nJust double-click a node\nfor migrating the process to.");

	strcpy(temp, "");
	strcat(temp, index->text(0));
	temppath.erase();
	temppath = temppath + "/proc/";
	temppath = temppath + temp;
	temppath = temppath + "/cantmove";
	cannot.erase();
	std::ifstream readcannotmove(temppath.c_str());
	if (readcannotmove) {
		readcannotmove.getline(zeile, 200);
		cannot= cannot+zeile;
		readcannotmove.close();
	}


	if( (!strstr(cannot.c_str(), "init_proc"))&&(!strstr(cannot.c_str(), "clone_vm"))&&(!strstr(cannot.c_str(), "daemon"))&&(!strstr(cannot.c_str(), "monkey"))&&(!strstr(cannot.c_str(), "mmap_dev")) ) {

		// fill nodelist
		nodelist.clear();
		n = scandir(clusterdirectory, &namelist, 0, 0);
		if (n < 0) {
			perror("scandir");
			} else {
			while(n--) {
				if(!strchr(namelist[n]->d_name, '.')) {
					// add node id to nodelist
					nodelist.push_front(namelist[n]->d_name);
					free(namelist[n]);
				}
			}
			free(namelist);

			list<string>::iterator p = nodelist.begin();
			while (p != nodelist.end()) {
				string nodename = getnodename(*p);
				int nodeid=string2int(*p);
				hostbox->insertItem(host, nodename.c_str(), nodeid);
	       	p++;
			}
		}

		QObject::connect( hostbox, SIGNAL(selected(int)), this, SLOT( migrateto( int )) );
		QLabel_current_proc->setText(index->text(0));
		QLabel_current_proc->setBackgroundPixmap(QPixmap(white_pix));
		strcpy(temp, "");
		strcat(temp, index->text(0));
		strcpy(temp1, "");
		strcat(temp1, index->text(1));
		tmpoutput.erase();
		tmpoutput = tmpoutput + "doubleclick a node for\nmigrating PID ";
		tmpoutput = tmpoutput + temp;
		QLabel_proc->setText(tmpoutput.c_str());
    info_mig->setText("migratable : yes");
    info_nomig->setText("");
		} else {
		hostbox->insertItem(host, "not migratable", -1);
		hostbox->setDisabled(true);
		strcpy(temp, "");
		strcat(temp, index->text(0));
		tmpoutput.erase();
		tmpoutput = tmpoutput + "PID ";
		tmpoutput = tmpoutput + temp;
		tmpoutput = tmpoutput + " is unmoveable!";
		QLabel_proc->setText(tmpoutput.c_str());
    info_mig->setText("migratable : no, because it is a");
  	info_nomig->setText(cannot.c_str());
		QPushButton_home->setDisabled(true);
		QPushButton_best->setDisabled(true);
  	QPushButton_lock->setDisabled(true);
  	QPushButton_unlock->setDisabled(true);
	}



	prio_label1 = new QLabel("",hinten);
	prio_label1->setGeometry(235,420,20,20);
	prio_label1->setMinimumSize(0,0);
	prio_label1->setText("-20");

	prio_label2 = new QLabel("",hinten);
	prio_label2->setGeometry(355,420,20,20);
	prio_label2->setMinimumSize(0,0);
	prio_label2->setText("20");

	prio_label3 = new QLabel("",hinten);
	prio_label3->setGeometry(300,420,20,20);
	prio_label3->setMinimumSize(0,0);
	prio_label3->setText("0");

	prio_label4 = new QLabel("",hinten);
	prio_label4->setGeometry(220,375,170,20);
	prio_label4->setMinimumSize(0,0);
	prio_label4->setText("(fast)  renice process  (slow)");

	current_proc = atoi(index->text(0));
	current_prio = getpriority(PRIO_PROCESS, current_proc);

	proc_prio= new QSlider(hinten,index->text(0));
	proc_prio->setGeometry(240,400,130,20);
	proc_prio->setMinimumSize(0,0);
	proc_prio->setTracking(false);
	proc_prio->setRange(0, 40);
	proc_prio->setValue(current_prio+20);
	proc_prio->setTickInterval (2);
	proc_prio->setTickmarks ( QSlider::Below );
	proc_prio->setOrientation(QSlider::Horizontal);
	QObject::connect(proc_prio, SIGNAL(valueChanged(int)), this, SLOT(setprocprio(int)) );
	QWhatsThis::add(proc_prio,"You can set the nice-value\nfor the process with\nthis slider.");

	proc_titel = new QLabel("",hinten);
	proc_titel->setGeometry(25,5,150,20);
	proc_titel->setMinimumSize(0,0);
	proc_titel->setText("openMosixprocs-Migrator");

	pix_titel = new QLabel("",hinten);
	pix_titel->setGeometry(5,5,20,20);
	pix_titel->setMinimumSize(0,0);
	pix_titel->setPixmap(migrat);

	procstat = new QMultiLineEdit(hinten, "status");
	procstat->setGeometry(10,160,200,300);
	procstat->setReadOnly(TRUE);
	QWhatsThis::add(procstat,"This box shows the status information\nof this process.");

	strcpy(temp, "");
	strcat(temp, index->text(0));
	temppath.erase();
	temppath = temppath + "cat /proc/";
	temppath = temppath + temp;
	temppath = temppath + "/status > /tmp/stat.temp";
	if(!system(temppath.c_str())) {
		temppath.erase();
		temppath = temppath + "/tmp/stat.temp";
		QFile fp1(temppath.c_str());
   	if ( fp1.open(IO_ReadOnly) ) {
			QTextStream t1( &fp1 );
			QString s1;
   		while ( !t1.eof() ) {
				s1 = t1.readLine();
				s1 = s1.simplifyWhiteSpace();
				procstat->insertLine(s1,-1);
			}
			fp1.close();
		}
		} else {
		procstat->insertLine("could not get status",-1);
	}
	unlink("/tmp/stat.temp");
	procstat->setReadOnly(TRUE);
	procstat->setBackgroundPixmap(QPixmap(white_pix));
	hinten->show();
}




void OpenMosixprocsApp::killproc() {
	int error;
	const char *cproc;
	const QObject *button = sender();
	cproc=button->name();
	string killcommand;
	string killoutput;

	killcommand.erase();
	killcommand = killcommand + "kill ";
	killcommand = killcommand + cproc;
	if((error=system(killcommand.c_str())) > 0) {
		killoutput.erase();
		killoutput = killoutput + "cannot kill proc ";
		killoutput = killoutput + cproc;
		} else {
		killoutput.erase();
		killoutput = killoutput + "killed PID ";
		killoutput = killoutput + cproc;
	}
	statusBar()->message(killoutput.c_str());
}




void OpenMosixprocsApp::migrateto(int index) {
	int error;
	const char *cproc;
	cproc=(const char *)QLabel_current_proc->text();
	string migratecommandline;
	string migrateoutput;

	index++;
	list<string>::iterator p = nodelist.begin();
	int h=0;
	string nodeid=*p;
	while ((p != nodelist.end()) && (h!=index)) {
		nodeid=*p;
     	p++;
		h++;
	}
	migratecommandline.erase();
	migratecommandline = migratecommandline + migratecommand;
	migratecommandline = migratecommandline + " ";
	migratecommandline = migratecommandline + cproc;
	migratecommandline = migratecommandline + " ";
	migratecommandline = migratecommandline + nodeid;
	migrateoutput.erase();
	if((error=system(migratecommandline.c_str())) > 0) {
		migrateoutput = migrateoutput + "cannot migrate PID ";
		migrateoutput = migrateoutput + cproc;
		migrateoutput = migrateoutput + " to node ";
		migrateoutput = migrateoutput + nodeid;
		} else {
 		migrateoutput = migrateoutput + "PID ";
		migrateoutput = migrateoutput + cproc;
		migrateoutput = migrateoutput + " migrated to node ";
		migrateoutput = migrateoutput + nodeid;
	}
	statusBar()->message(migrateoutput.c_str());
}



void OpenMosixprocsApp::migratebest() {
	int error;
	const char *cproc;
	cproc=(const char *)QLabel_current_proc->text();
	string migratecommandline;
	string migrateoutput;
	migratecommandline.erase();
	migratecommandline = migratecommandline + migratecommand;
	migratecommandline = migratecommandline + " ";
	migratecommandline = migratecommandline + cproc;
	migratecommandline = migratecommandline + " balance";
	migrateoutput.erase();
	if((error=system(migratecommandline.c_str())) > 0) {
		migrateoutput = migrateoutput + "cannot balance PID ";
		migrateoutput = migrateoutput + cproc;
		} else {
 		migrateoutput = migrateoutput + "balanced PID ";
		migrateoutput = migrateoutput + cproc;
	}
	statusBar()->message(migrateoutput.c_str());
}



void OpenMosixprocsApp::migratehome() {
	int error;
	const char *cproc;
	cproc=(const char *)QLabel_current_proc->text();
	string migratecommandline;
	string migrateoutput;

	migratecommandline.erase();
	migratecommandline = migratecommandline + migratecommand;
	migratecommandline = migratecommandline + " ";
	migratecommandline = migratecommandline + cproc;
	migratecommandline = migratecommandline + " home";
	migrateoutput.erase();
	if((error=system(migratecommandline.c_str())) > 0) {
		migrateoutput = migrateoutput + "cannot bring PID ";
		migrateoutput = migrateoutput + cproc;
		migrateoutput = migrateoutput + " home";
		} else {
 		migrateoutput = migrateoutput + "bring PID ";
		migrateoutput = migrateoutput + cproc;
		migrateoutput = migrateoutput + " home";
	}
	statusBar()->message(migrateoutput.c_str());
}



void OpenMosixprocsApp::remote_gohome() {
	const char *proctab;
	const QObject *button = sender();
	proctab=button->name();
	string remotegohomecommand;
	string remotegohomeoutput;
	remotegohomecommand.erase();
	remotegohomeoutput.erase();
	remotegohomecommand = remotegohomecommand + remotedir;
	remotegohomecommand = remotegohomecommand + proctab;
	remotegohomecommand = remotegohomecommand + "/goto";
	std::ofstream remoteghfile(remotegohomecommand.c_str());
	if (remoteghfile) {
		remoteghfile << "0";
		remoteghfile.close();
		remotegohomeoutput = 	remotegohomeoutput +"send ";
		remotegohomeoutput = 	remotegohomeoutput + proctab;
		remotegohomeoutput = 	remotegohomeoutput + " home";
		} else {
		remotegohomeoutput = 	remotegohomeoutput +"could not send ";
		remotegohomeoutput = 	remotegohomeoutput + proctab;
		remotegohomeoutput = 	remotegohomeoutput + " home";
	}
	statusBar()->message(remotegohomeoutput.c_str());
}


void OpenMosixprocsApp::remote_gobest() {
	const char *proctab;
	const QObject *button = sender();
	proctab=button->name();
	string remotegobestcommand;
	string remotegobestoutput;
	remotegobestcommand.erase();
	remotegobestoutput.erase();
	remotegobestcommand = remotegobestcommand + remotedir;
	remotegobestcommand = remotegobestcommand + proctab;
	remotegobestcommand = remotegobestcommand + "/goto";
	std::ofstream remotegbfile(remotegobestcommand.c_str());
	if (remotegbfile) {
		remotegbfile << "-1";
		remotegbfile.close();
		remotegobestoutput = 	remotegobestoutput +"send ";
		remotegobestoutput = 	remotegobestoutput + proctab;
		remotegobestoutput = 	remotegobestoutput + " to best available node";
		} else {
		remotegobestoutput = 	remotegobestoutput +"could not send ";
		remotegobestoutput = 	remotegobestoutput + proctab;
		remotegobestoutput = 	remotegobestoutput + " to best available node";
	}
	statusBar()->message(remotegobestoutput.c_str());
}


void OpenMosixprocsApp::action_sigstop() {
	int error;
	const char *cproc;
	const QObject *button = sender();
	cproc=button->name();
	string killcommand;
	string killoutput;

	killcommand.erase();
	killcommand = killcommand + "kill -SIGSTOP ";
	killcommand = killcommand + cproc;
	if((error=system(killcommand.c_str())) > 0) {
		killoutput.erase();
		killoutput = killoutput + "cannot send SIGSTOP to process ";
		killoutput = killoutput + cproc;
		} else {
		killoutput.erase();
		killoutput = killoutput + "send SIGSTOP to  PID ";
		killoutput = killoutput + cproc;
	}
	statusBar()->message(killoutput.c_str());
}



void OpenMosixprocsApp::action_sigcont() {
	int error;
	const char *cproc;
	const QObject *button = sender();
	cproc=button->name();
	string killcommand;
	string killoutput;

	killcommand.erase();
	killcommand = killcommand + "kill -SIGCONT ";
	killcommand = killcommand + cproc;
	if((error=system(killcommand.c_str())) > 0) {
		killoutput.erase();
		killoutput = killoutput + "cannot send SIGCONT to process ";
		killoutput = killoutput + cproc;
		} else {
		killoutput.erase();
		killoutput = killoutput + "send SIGCONT to  PID ";
		killoutput = killoutput + cproc;
	}
	statusBar()->message(killoutput.c_str());
}


void OpenMosixprocsApp::setprocprio(int prio) {
	const char *procpid;
	const QObject *button = sender();
	procpid=button->name();
	string setprocpriooutput;
	string setprocpriocommand;
	setprocpriooutput.erase();
	setprocpriocommand.erase();
	setprocpriocommand = setprocpriocommand + "renice ";
	setprocpriocommand = setprocpriocommand + int2string(prio-20);
	setprocpriocommand = setprocpriocommand + " ";
	setprocpriocommand = setprocpriocommand + procpid;
	if (!system(setprocpriocommand.c_str())) {
		setprocpriooutput = setprocpriooutput + "renice successfull";
		} else {
		setprocpriooutput = setprocpriooutput + "renice failed";
	}
	statusBar()->message(setprocpriooutput.c_str());
}



void OpenMosixprocsApp::lockproc() {

	const char *procpid;
	const QObject *button = sender();
	procpid=button->name();
	string lockpid;
	string lockpidoutput;
	lockpidoutput.erase();
	lockpid.erase();
	lockpid = lockpid + "/proc/";
	lockpid = lockpid + procpid;
	lockpid = lockpid + "/lock";
	std::ofstream proclockfile(lockpid.c_str());
	if (proclockfile) {
		proclockfile << "1";
		proclockfile.close();
		lockpidoutput = lockpidoutput + "successfully locked process";
    QPushButton_lock->setDisabled(true);
    QPushButton_unlock->setDisabled(false);
		} else {
		lockpidoutput = lockpidoutput + "failed to lock the process";
	}
	statusBar()->message(lockpidoutput.c_str());

}


void OpenMosixprocsApp::unlockproc() {
	const char *procpid;
	const QObject *button = sender();
	procpid=button->name();
	string unlockpid;
	string unlockpidoutput;
	unlockpidoutput.erase();
	unlockpid.erase();
	unlockpid = unlockpid + "/proc/";
	unlockpid = unlockpid + procpid;
	unlockpid = unlockpid + "/lock";
	std::ofstream proclockfile(unlockpid.c_str());
	if (proclockfile) {
		proclockfile << "0";
		proclockfile.close();
		unlockpidoutput = unlockpidoutput + "successfully unlocked process";
    QPushButton_lock->setDisabled(false);
    QPushButton_unlock->setDisabled(true);
		} else {
		unlockpidoutput = unlockpidoutput + "failed to unlock the process";
	}
	statusBar()->message(unlockpidoutput.c_str());
}



void OpenMosixprocsApp::startpidlog(QListViewItem *index, const QPoint &, int) {

	QString openpidlogoutput;
	QString openpidlogcommand;

	openpidlogcommand = openpidlogcommand + "openmosixpidlog ";
	openpidlogcommand = openpidlogcommand + index->text(0);
	openpidlogcommand = openpidlogcommand + " &";

	if (!system(openpidlogcommand)) {
		openpidlogoutput = openpidlogoutput + "starting openMosixpidlog";
		} else {
		openpidlogoutput = openpidlogoutput + "could not start openMosixpidlog";
	}
	statusBar()->message(openpidlogoutput);

}


void OpenMosixprocsApp::startpidlog() {

	const char *procpid;
	const QObject *button = sender();
	procpid=button->name();
	QString openpidlogoutput;
	QString openpidlogcommand;

	openpidlogcommand = openpidlogcommand + "openmosixpidlog ";
	openpidlogcommand = openpidlogcommand + procpid;
	openpidlogcommand = openpidlogcommand + " &";

	if (!system(openpidlogcommand)) {
		openpidlogoutput = openpidlogoutput + "starting openMosixpidlog";
		} else {
		openpidlogoutput = openpidlogoutput + "could not start openMosixpidlog";
	}
	statusBar()->message(openpidlogoutput);

}




