/***************************************************************************
                          openmosixmigmon.cpp  -  description
                             -------------------
    begin                : Son Jan  5 15:59:03 CET 2003
    copyright            : (C) 2003 by Matt
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include "openmosixmigmon.h"

#include "helpicon.xpm"
#include "migmonback.xpm"
#include "whatis.xpm"
#include "white.xpm"


// constructor
OpenMosixmigmonApp::OpenMosixmigmonApp()
{

  dragging = false;

  QPixmap whatisthis;
  whatisthis = QPixmap(whatis);

  setCaption(tr("openMosixmigmon " VERSION));
  this->setGeometry(100, 100, ewide, eheight+25);
  this->setFixedSize(ewide, eheight+25);
  this->setclusternodes(gethowmanynodes());

  QLabel_pg= new QLabel(this,"");
  QLabel_pg->setGeometry(5, 0, 100, 25);
  QLabel_pg->setMinimumSize(0,0);
  QLabel_pg->setMargin(1);
  QLabel_pg->setText("Process groups:");

  pggroup= new QButtonGroup(this, "pggroup");
  pggroup->setGeometry(110,0,ewide-145,25);

  pg1 = new QRadioButton(pggroup, "1");
  pg1->setGeometry(5,2,40,21);
  pg1->setText("1");
  pg1->setBackgroundColor(Qt::white);
  pg1->setChecked(true);

  pg2 = new QRadioButton(pggroup, "2");
  pg2->setGeometry(50,2,40,21);
  pg2->setText("2");
  pg2->setBackgroundColor(Qt::cyan);

  pg3 = new QRadioButton(pggroup, "3");
  pg3->setGeometry(95,2,40,21);
  pg3->setText("3");
  pg3->setBackgroundColor(Qt::blue);

  pg4 = new QRadioButton(pggroup, "4");
  pg4->setGeometry(140,2,40,21);
  pg4->setText("4");
  pg4->setBackgroundColor(Qt::yellow);

  pg5 = new QRadioButton(pggroup, "5");
  pg5->setGeometry(185,2,40,21);
  pg5->setText("5");
  pg5->setBackgroundColor(Qt::magenta);

  pg6 = new QRadioButton(pggroup, "6");
  pg6->setGeometry(230,2,40,21);
  pg6->setText("6");
  pg6->setBackgroundColor(Qt::darkGreen);

  pg7 = new QRadioButton(pggroup, "7");
  pg7->setGeometry(275,2,40,21);
  pg7->setText("7");
  pg7->setBackgroundColor(Qt::darkBlue);

  pg8 = new QRadioButton(pggroup, "8");
  pg8->setGeometry(320,2,40,21);
  pg8->setText("8");
  pg8->setBackgroundColor(Qt::darkRed);

  pg9 = new QRadioButton(pggroup, "9");
  pg9->setGeometry(365,2,40,21);
  pg9->setText("9");
  pg9->setBackgroundColor(Qt::darkMagenta);

  pg10 = new QRadioButton(pggroup, "10");
  pg10->setGeometry(410,2,40,21);
  pg10->setText("10");
  pg10->setBackgroundColor(Qt::darkYellow);


  connect(pg1, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg2, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg3, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg4, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg5, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg6, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg7, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg8, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg9, SIGNAL(clicked()), this, SLOT(setpg()));
  connect(pg10, SIGNAL(clicked()), this, SLOT(setpg()));


  helpme = new QToolButton(this, "whatisthis");
  helpme->setGeometry(ewide-25, 0,25,25);
  helpme->setPixmap(whatisthis);
  connect(helpme, SIGNAL(clicked()), this, SLOT(slotHelp()));

  updatenodes();
  updatetimer = new QTimer( this, "intern" );
  QObject::connect( updatetimer, SIGNAL(timeout()), this, SLOT(redraw()) );
  updatetimer->start(10000);


}


// destructor
OpenMosixmigmonApp::~OpenMosixmigmonApp()
{
}




//############# helping functions #####################

int file_exist(string filename) {
  std::ifstream readfilename(filename.c_str());
  if (readfilename) {
  readfilename.close();
    return 1;
    } else {
    return 0;
  }
}


int string2int(const string s) {
  if (s.length() == 0) {
    return -1;
    } else {
    return(atoi(s.c_str()));
   }
}

string int2string(const int i) {
  char buf[12];
  sprintf(buf,"%d",i);
  return(string(buf));
}




string onlyfirstpart(string firstpart) {
string endstr;
string::iterator p = firstpart.begin();
	for (p=firstpart.begin(); p!=firstpart.end(); p++) {
		string tmpstr;
		tmpstr = *p;
		if(tmpstr==" ") {
			return endstr;
		}
		endstr = endstr + tmpstr;
	}
	return endstr;
}


//############# method implementations #####################


 // check if the cluster-config changed
bool OpenMosixmigmonApp::checknodes() {
	if (gethowmanynodes()==clusternodes) {
		return true;
		} else {
   	return false;
	}
}


// set the clusternodes value
void OpenMosixmigmonApp::setclusternodes(int nodes) {
	clusternodes=nodes;
}

// returns howmany nodes we are
int OpenMosixmigmonApp::gethowmanynodes() {
	struct dirent **namelist;
	int n;
	int howmanynodes=0;

	n = scandir(clusterdirectory, &namelist, 0, 0);
	if (n < 0) {
		return 0;
		} else {
		while(n--) {
			if(!strchr(namelist[n]->d_name, '.')) {
				howmanynodes++;
				free(namelist[n]);
			}
		}
		free(namelist);
	return howmanynodes;
	}	
}


// converts a cluster id to an hostname
int OpenMosixmigmonApp::getmynodeID() {
// gather nodes id
  char buf[100];
  snprintf(buf, sizeof(buf), "%s whois", clustercommand);
  FILE *p = popen(buf, "r");
  if (!p)
   return 0;
  fgets(buf, sizeof(buf), p);
  pclose(p);
  char *ptr = strchr(buf, '#');
  if (!ptr)
   return 0;

  return atoi(ptr+1);
  
}




void OpenMosixmigmonApp::updatenodes() {

  QPixmap help, backgr;
  help = QPixmap(helpicon);
  backgr = QPixmap(migmonback);

  struct dirent **namelist;
  int n;
  int howmany=0;
  double nodeangle;
  double nodeX, nodeY;
  double noderadialvalue;
  int nodes=1;
  double mainradialvalue=0;
  string myid;

  QFont font("helvetica");
  font.setPixelSize(10);

  // who am i
  myid = int2string(getmynodeID());

  // the main label
  QLabel_main= new QLabel(this,"1");
  QLabel_main->setGeometry(0, 25, int(eheight), int(ewide));
  QLabel_main->setMinimumSize(0,0);
  QLabel_main->setBackgroundPixmap(backgr);

  // unselect button
  unselect = new QToolButton(QLabel_main, "unselect");
  unselect->setGeometry(5, 5,60,25);
  unselect->setText("unselect");
  connect(unselect, SIGNAL(clicked()), this, SLOT(unselectpg()));

  // unselect all button
  clearmiggroups = new QToolButton(QLabel_main, "all");
  clearmiggroups->setGeometry(65, 5,30,25);
  clearmiggroups->setText("all");
  connect(clearmiggroups, SIGNAL(clicked()), this, SLOT(unselectall()));

  // refresh label
  label_refresh1= new QLabel(QLabel_main,"refresh1");
  label_refresh1->setGeometry(ewide-105,5,45,20);
  label_refresh1->setMinimumSize(0,0);
  label_refresh1->setText("refresh");
  label_refresh1->setMargin(1);
  QWhatsThis::add(label_refresh1 ,"set the timeout value in seconds for the main refresh");

  // refresh spinbox
  refreshtimeoutbox= new QSpinBox(QLabel_main, "refresh");
  refreshtimeoutbox->setGeometry(ewide-60,5,35,20);
  refreshtimeoutbox->setMinimumSize(0,0);
  refreshtimeoutbox->setValue(10);
  refreshtimeoutbox->setMinValue(1);
  refreshtimeoutbox->setMaxValue(60);
  QObject::connect( refreshtimeoutbox, SIGNAL(valueChanged( int )), this, SLOT(adjusttimer( int )) );
  QWhatsThis::add(refreshtimeoutbox ,"set the timeout value in seconds for the main refresh");

  // refresh label
  label_refresh2= new QLabel(QLabel_main,"refresh2");
  label_refresh2->setGeometry(ewide-25,5,20,20);
  label_refresh2->setMinimumSize(0,0);
  label_refresh2->setText("s");
  label_refresh2->setMargin(1);
  QWhatsThis::add(label_refresh2 ,"set the timeout value in seconds for the main refresh");


  // the main node
  QLabel_tux= new nodewidget(QLabel_main, myid.c_str());
  QLabel_tux->setGeometry(int(xcenter)-10,int(ycenter)-10,20,20);
  QLabel_tux->setMinimumSize(0,0);
  QLabel_tux->setPixmap(help);
  QLabel_tux->setFrameStyle( QFrame::Panel | QFrame::Sunken );


  QLabel_myid= new nodewidget(QLabel_main, myid.c_str());
  QLabel_myid->setGeometry(int(xcenter)-10,int(ycenter)+10,40,20);
  QLabel_myid->setMinimumSize(0,0);
  QLabel_myid->setFont(font);
  QLabel_myid->setText("");
  QLabel_myid->setFrameStyle( QFrame::Panel | QFrame::Sunken );



  // empty nodelist
  nodelist.clear();

  // fill nodelist
  n = scandir(clusterdirectory, &namelist, 0, 0);
  if (n < 0) {
    perror("scandir");
    } else {
    while(n--) {
      if(!strchr(namelist[n]->d_name, '.')) {
      // add node id to nodelist
      nodelist.push_front(omnode(string2int(namelist[n]->d_name), 0, 0));
      howmany++;
      free(namelist[n]);
      }
    }
    free(namelist);

    // adjust clusternodes
    setclusternodes(howmany);

    // check that we are not alone
    // prevents from dividing through zero
    if(howmany>1) {

      // here we calculate the space between the nodes
      nodeangle = 360/(howmany-1);
      noderadialvalue = ((2*pi)/360)*nodeangle;


       // here the dynamic widgets are created
      list<omnode>::iterator p = nodelist.begin();
      while (p != nodelist.end()) {

        omnode iternode = *p;
        int omid = iternode.getnodeid();
        string nodeidtxt=int2string(omid);

        // check that we are not displaying myself
        if(strcmp(nodeidtxt.c_str(), myid.c_str())) {

          mainradialvalue = mainradialvalue + noderadialvalue;
          nodeX = cos(mainradialvalue);
          nodeY = sin(mainradialvalue);
          nodeX = nodeX*(circlewide/2);
          nodeY = nodeY*(circlewide/2);
          nodeX = xcenter+nodeX;
          nodeY = ycenter+nodeY;

          // store the node position
          // here we have to use p to make the changes on the real nodeslist
          p->setposition(int(nodeX), int(nodeY));

          // all the nodes
          QLabel_nodes[nodes]= new nodewidget(QLabel_main,nodeidtxt.c_str());
          QLabel_nodes[nodes]->setGeometry(int(nodeX),int(nodeY),20,20);
          QLabel_nodes[nodes]->setMinimumSize(0,0);
          QLabel_nodes[nodes]->setPixmap(help);
          QLabel_nodes[nodes]->setFrameStyle( QFrame::Panel | QFrame::Sunken );

          QLabel_nodeID[nodes]= new nodewidget(QLabel_main,nodeidtxt.c_str());
          QLabel_nodeID[nodes]->setGeometry(int(nodeX),int(nodeY+20),40,20);
          QLabel_nodeID[nodes]->setMinimumSize(0,0);
          QLabel_nodeID[nodes]->setFont(font);
          QLabel_nodeID[nodes]->setText(nodeidtxt.c_str());
          QLabel_nodeID[nodes]->setFrameStyle( QFrame::Panel | QFrame::Sunken );

          nodes++;

          } else {

          // label myself with the my nodeID
          QLabel_myid->setText(nodeidtxt.c_str());

        } // end of myself-check
        p++;

      } // end of while

      } else {
      // we are alone
      QLabel_myid->setText(myid.c_str());
    }

    QLabel_main->show();
    QTimer *processtimer = new QTimer( QLabel_main, "QLabel_main" );
    connect( processtimer, SIGNAL(timeout()), this, SLOT(fillprocesslist()) );
    processtimer->start(2000);

    fillprocesslist();


  }

}




void OpenMosixmigmonApp::redraw() {
  if(!checknodes()) {
    delete QLabel_main;
    updatenodes();
  }
}


// ############# process handling methods ################

char *OpenMosixmigmonApp::readproc(int pid, const char *what) {
  static char buf[500];
  snprintf(buf, sizeof(buf), "/proc/%d/%s", pid, what);
  FILE *f = fopen(buf, "r");
  strcpy(buf, "");
  if (!f)
  return buf;

  fgets(buf, sizeof(buf), f);
  fclose(f);
  return buf;
}
	

void OpenMosixmigmonApp::fillprocesslist() {

  DIR *dir;
  struct dirent *dir_info;
  string processname;
  string processtip;
  string temp;
  string wherevalue;
  string cmdlinevalue;
  string procdir = "/proc/";
  string stripwhere;
  int pid;
  int home;
  int createnew=0;
  int testpid1=0;
  int testpid2=0;
  int stillthere=0;
  char *cmdtmp;
  cmdtmp = new char[50];
  char *cmdtmp1;
  cmdtmp1 = new char[50];
  FILE *fp;				

  // get a copy from the process-list
  list<oMProc> processlist_copy = processlist;
  processlist.clear();

	if ((dir=opendir("/proc"))!=NULL) {

		while ((dir_info = readdir(dir))!=NULL) {
			processname.erase();
      processtip.erase();
			processname = processname + dir_info->d_name;

			if((strchr(processname.c_str(), '1'))||(strchr(processname.c_str(), '2'))||(strchr(processname.c_str(), '3'))||(strchr(processname.c_str(), '4'))||(strchr(processname.c_str(), '5'))||(strchr(processname.c_str(), '6'))||(strchr(processname.c_str(), '7'))||(strchr(processname.c_str(), '8'))||(strchr(processname.c_str(), '9')) ) {


			pid = string2int(processname);
				
                      // Linux never reassigns pids < 300
                      // those tend to be kernel threads and daemons
                         if (pid < 300)
                          continue;

                         char *p = readproc(pid, "lock");
                         if (p[0] == '1')
                          continue; // process locked

                         p = readproc(pid, "cantmove");
                         if (strlen(p) > 1)
                          continue; // process can't move

                         temp.erase();
                         temp = temp + procdir;
                         temp = temp + processname;
                         temp = temp + "/status";
                         if ((fp=fopen(temp.c_str(), "r"))!=NULL) {
                          fscanf(fp, "%s %s", cmdtmp, cmdtmp1);
                          fclose(fp);
                         }
				
			 cmdlinevalue = cmdtmp1;
                         home = atoi(readproc(pid, "where"));
			

        // insert the process into the processlist
        processlist.push_back(oMProc(pid, home, cmdlinevalue));
        processtip = processtip + processname;
        processtip = processtip + ",";
        processtip = processtip + cmdlinevalue;

        // if the "old" processlist has any members
        if (!processlist_copy.size()) {
          singleproc[pid] = new procwidget(QLabel_main,processtip.c_str());

          } else {
          // check if the pid was in the "old" processlist
          createnew=0;
          list<oMProc>::iterator q = processlist_copy.begin();
          while (q != processlist_copy.end()) {
            oMProc oldproc =*q;
            if (oldproc.getompid()==pid) {
              // it was there
              createnew=1;
            }
            q++;
          }
          if(createnew==0) {
            // create it
//            cout << "new processe created" << endl;
            singleproc[pid] = new procwidget(QLabel_main,processtip.c_str());
          }

        }

			}
		} //while
		closedir(dir);
	} //if


  // now check if there are any processes
  // which are not there any more
  list<oMProc>::iterator w = processlist_copy.begin();
  while (w != processlist_copy.end()) {
    oMProc isprocstillthere1 =*w;
    testpid1 = isprocstillthere1.getompid();

    stillthere=0;
    list<oMProc>::iterator o = processlist.begin();
    while (o != processlist.end()) {
      oMProc isprocstillthere2 =*o;
      testpid2 = isprocstillthere2.getompid();

      if (testpid1==testpid2) {
        // it is still there
        stillthere=1;
      }
     o++;
    }
    if(stillthere==0) {
      // it is not there any more we delete -> singleproc instance
//      cout << "a process exits" << endl;
      delete singleproc[testpid1];
    }
    w++;
  }


  // trigger to draw the processlist
  QLabel_main->repaint();
  drawprocesslist();

}




int OpenMosixmigmonApp::gethowmanyprocs() {
 return int(processlist.size());
}



void OpenMosixmigmonApp::drawprocesslist() {

  int howmanyprocs = gethowmanyprocs();
  double procangle=0;
  double procradialvalue=0;
  double mainprocradialvalue=0;
  double procX, procY;
  double remoteX=0.0, remoteY=0.0;
  int remoteproccount=0;

  double remoteprocangle=0;
  double remoteprocradialvalue=0;
  double remotemainprocradialvalue=0;
  double remprocX, remprocY;
  int migratedprocs=0;
  int whichremoteproc=0;
  int whichsingleproc=0;

  // calculate the processcircle
  procangle = howmanyprocs ? 360/(howmanyprocs) : 0;
  procradialvalue = ((2*pi)/360)*procangle;
   
  // draws the nodecircle
  QPainter ncircle(QLabel_main);
  ncircle.setPen(QPen(Qt::black, 0, SolidLine));
  ncircle.drawEllipse(0, 0, eheight, ewide);

  // here we go through the processlist and draw
  list<oMProc>::iterator p = processlist.begin();
  while (p != processlist.end()) {
    // get a pointer to a proc
    oMProc proc =*p;

    mainprocradialvalue = mainprocradialvalue + procradialvalue;
    procX = cos(mainprocradialvalue);
    procY = sin(mainprocradialvalue);
    procX = procX*(circlewide/4);
    procY = procY*(circlewide/4);
    procX = xcenter+procX;
    procY = ycenter+procY;


    whichsingleproc = proc.getompid();

    // get the miggroup
    singleproc[whichsingleproc]->applymiggroup();


    if(proc.islocal()) {
    // it is a local proc

      singleproc[whichsingleproc]->setGeometry(int(procX),int(procY),6,6);
      singleproc[whichsingleproc]->setMinimumSize(0,0);
     if(!singleproc[whichsingleproc]->is_selected()) {
        singleproc[whichsingleproc]->setBackgroundColor(Qt::black);
     }
      singleproc[whichsingleproc]->show();

      // update the omproc x+y pos on the real object (not on the copy)
      p->setProc(0, int(procX), int(procY));

      } else {

     // it is a remote proc
      // here we have to find an intelligent way to draw the
      // process at the remote node
      // remote node X value
      list<omnode>::iterator rempnode = nodelist.begin();
      while(rempnode != nodelist.end()) {
        omnode realnode =*rempnode;
        if(realnode.getnodeid() == proc.ishere()) {
         remoteX=realnode.getXpos();
         remoteY=realnode.getYpos();
        }
        rempnode++;
      }

      // draw the process at the remote node

      // count howmany remote process are on this node
      list<oMProc>::iterator hmremote = processlist.begin();
      while(hmremote != processlist.end()) {
        oMProc migprocs =*hmremote;
        if(!migprocs.islocal()) {
          migratedprocs++;
        }
        hmremote++;
      }

      // which remote processes is this
      whichremoteproc++;

     // calculate the remote processcircle
     remoteprocangle = 360/migratedprocs+1;
     remoteprocradialvalue = ((2*pi)/360)*remoteprocangle;

     remotemainprocradialvalue = remoteprocradialvalue*whichremoteproc;

     remprocX = cos(remotemainprocradialvalue);
     remprocY = sin(remotemainprocradialvalue);
     remprocX = remprocX*45;
     remprocY = remprocY*45;
     remprocX = remoteX+remprocX+7;
     remprocY = remoteY+remprocY+7;

     // calculate the remote processcircle
     // the paint device for the nodescircles
     QPainter nodescircles(QLabel_main);
     nodescircles.setPen(QPen(Qt::black, 0, SolidLine));
     nodescircles.drawEllipse(int(remoteX-40),int(remoteY-40),100,100);

     // draw a line from the home-position to the remote position
     nodescircles.setPen(QPen(Qt::black, 0, DotLine));
     nodescircles.moveTo(int(procX), int(procY));
     nodescircles.lineTo(int(remprocX), int(remprocY));

     // here we have the data for the remote process circle together
     // and now we draw the remote process
     singleproc[whichsingleproc]->setGeometry(int(remprocX),int(remprocY),6,6);
     singleproc[whichsingleproc]->setMinimumSize(0,0);
     // ajust the color only if the proc is not selected
     if(!singleproc[whichsingleproc]->is_selected()) {
        singleproc[whichsingleproc]->setBackgroundColor(Qt::green);
     }
     singleproc[whichsingleproc]->show();

     // update the omproc x+y pos on the real object (not on the copy)
     p->setProc(proc.ishere(), int(remprocX), int(remprocY));

     migratedprocs=0;
     remoteproccount=0;

    } // end of if-remote-or-local

//    singleproc->show();

    p++;
  }


}





void OpenMosixmigmonApp::paintEvent(QPaintEvent *) {

   // this->fillprocesslist();

}







// the help-method
void OpenMosixmigmonApp::slotHelp() {

  QPixmap help, white_pix;
	help = QPixmap(helpicon);
  white_pix = QPixmap(white_xpm);

	QTabDialog *tabs = new QTabDialog();
	tabs->setGeometry(200,50,20,20);
	tabs->resize(300, 600);

        QFont tfont("helvetica");
        tfont.setPixelSize(12);
	tabs->setFont(tfont);
	
	QLabel *a = new QLabel(tabs, 0, 0);
	a->setGeometry(5,5,20,20);
	a->resize(300, 600);
	a->setMargin(3);
	a->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	a->setBackgroundPixmap(QPixmap(white_pix));
	a->setText("openMosixmigmon Help\n\n" \
        "General:\n" \
        "The openMosixmigmon is a monitor for migrations in your openMosix-cluster.\n" \
        "It displays all your nodes as little penguins sitting in a circle.\n" \
        "-> nodes-circle\n" \
        "The main penguin is the node on which openMosixmigmon runs and around\n" \
        "this node it shows its processes also in a circle of small black squares.\n" \
        "-> main process-circle\n" \
        "If a process migrates to one of the nodes the node gets an own process-circle\n" \
        "and the process moved from the main process-circle to the remote process-circle.\n" \
        "Then the process is marked green and draws a line from its origin to its\n" \
        "remote location to visualize the migration.\n" \
        "\n" \
        "\n" \
        "Tooltips:\n" \
        "If you hold your mouse above a process it will show you its PID and commandline\n" \
        "in a small tooltip-window.\n" \
        "\n" \
        "\n" \
        "Drag'n Drop!\n" \
        "The openMosixmigmon is fully Drag'n Drop enabled.\n" \
        "You can grab (drag) any process and drop them to any of your nodes (those penguins)\n" \
        "and the process will move there.\n" \
        "If you double-click a process on a remote node it will be send home immediately.\n" \
        "\n" \
        "\n" \
        "I hope you have much fun with it ;)\n" \
        "\n" \
        "\nM. Rechenburg / mosixview@t-online.de");


	tabs->addTab(a, help,  "general");
	tabs->show();
}





void OpenMosixmigmonApp::setpg() {

	const char *whichpg;
  const QObject *button = sender();
	whichpg=button->name();
  // set the name
  QLabel_main->setName(whichpg);


}




void OpenMosixmigmonApp::unselectpg() {

  int whichsingleproc;
  QString activepg=QLabel_main->name();
  int apg=activepg.toInt();

  // here we go through the processlist and draw
  list<oMProc>::iterator p = processlist.begin();
  while (p != processlist.end()) {
    // get a pointer to a proc
    oMProc proc =*p;
    whichsingleproc = proc.getompid();
    if(singleproc[whichsingleproc]->getmiggroup()==apg) {
     singleproc[whichsingleproc]->setmiggroup(0);
    }
   p++;
  }
}




void OpenMosixmigmonApp::unselectall() {

  int whichsingleproc;
  QString activepg=QLabel_main->name();

  // here we go through the processlist and draw
  list<oMProc>::iterator p = processlist.begin();
  while (p != processlist.end()) {
    // get a pointer to a proc
    oMProc proc =*p;
    whichsingleproc = proc.getompid();
    singleproc[whichsingleproc]->setmiggroup(0);
   p++;
  }
}



// to adjust the timer
void OpenMosixmigmonApp::adjusttimer(int val) {
        int secval=val*1000;
        updatetimer->changeInterval(secval);
        string refreshmes;
        refreshmes = "set refresh timeout to ";
        refreshmes = refreshmes + int2string(val);
        refreshmes = refreshmes + " seconds";
        cout << refreshmes << endl;
}









