/***************************************************************************
                          clustermem.cpp  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "clustermem.h"
#include "white.xpm"

clustermem::clustermem(QWidget *parent, const char *name ) : QWidget(parent,name) {
}
clustermem::~clustermem(){
}


void clustermem::paintEvent(QPaintEvent *) {
	int oload, obalance, oallmem, ousedmem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=0;
	int minutes = 360;
	QPainter p(this);
	QPainter p1(this);
	const char *nodefilename;
	nodefilename = this->name();

	QPixmap white_pix;
	white_pix= QPixmap(white_xpm);

        QFont hfont("helvetica");
        hfont.setPixelSize(8);

	p.setWindow(0, 0, 4320, 120);
	p.setPen(Qt::black);
	p.drawRect(0, 20, 4320, 100);

	// percent
	p.setFont(hfont);
	p.drawText( 5, 30, "100%" );
	p.drawText( 5, 75, "50%" );
	p.drawText( 5, 115, "0%" );

	// scala
	for(int i=6;i<=4320; i=i+6) {
		p.moveTo(i, 120);
		p.lineTo(i, 117);
	}
	for(int i=360;i<=4320; i=i+360) {
		p.moveTo(i, 120);
		p.lineTo(i, 20);
	}


	if((readfile=fopen(nodefilename, "r")) == NULL) {
		cout << "could not open openMosix data information file" << nodefilename << endl;
		} else {
		p1.moveTo(0, 100);
		while  ((!feof(readfile))&&(j<4320)) {
			fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &obalance, &oallmem, &ousedmem, &cpus);
			if(oload==-999) {
				QPainter p2(this);
				p2.setPen(Qt::blue);
				p2.moveTo(j, 120);
				p2.lineTo(j, 20);
				} else {

				// here comes the timeline
				if (minutes >=360) {

					// timeline
					QLabel_timeline= new QLabel(this,"start-date");
					QLabel_timeline->setGeometry(j,0,120,20);
					QLabel_timeline->setMinimumSize(0,0);
					QLabel_timeline->setBackgroundPixmap(QPixmap(white_pix));
					QLabel_timeline->setText(when);
					QLabel_timeline->setMargin(0);
					QLabel_timeline->setAlignment( AlignVCenter | AlignCenter );
					QLabel_timeline->setFrameStyle( QFrame::Panel | QFrame::Sunken );
					QWhatsThis::add(QLabel_timeline ,"This is the date/time when the openMosixcollector gathered the cluster informations.");
					QLabel_timeline->show();

					minutes = 0;
				}

				// here we paint
				j++;
				minutes++;
				p1.lineTo(j, 120-ousedmem);
			}
		}
		fclose(readfile);
	}
}






