/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/

	
/* Heap-consing subprims, except for those associated with &rest args. */

	include(lisp.s)
	_beginfile

_spentry(conslist)
	__(mr arg_z,rnil)
/* do list*: last arg in arg_z, all others vpushed, nargs set to #args vpushed. */
_spentry(conslist_star)
	.globl init_list_from_stack
	__(cmplwi cr1,nargs,0x4000)
	__(cmpwi nargs,0)
	__(add imm0,nargs,nargs)
	__(blt+ cr1,1f)
	__(subi imm1,imm0,4)
	__(box_fixnum(arg_x,imm1))
	__(li arg_y,subtag_u8_vector<<fixnumshift)
	__(uuo_xalloc(arg_y,arg_x,arg_y))
	__(stw rzero,misc_header_offset(arg_y))
	__(mr arg_y,rzero)
	__(b 2f)	
1:	__(stwux rzero,freeptr,imm0)
2:	__(la initptr,-8+fulltag_cons(freeptr))
	__(b init_list_from_stack)
init_list_from_stack_loop:
	__(lwz temp0,0(vsp))
	__(cmpwi nargs,fixnum_one)
	__(la vsp,4(vsp))
	__(stw arg_z,cons.[cdr](initptr))
	__(subi nargs,nargs,fixnum_one)
	__(stw temp0,cons.[car](initptr))
	__(mr arg_z,initptr)
	__(subi initptr,initptr,8)
init_list_from_stack:
	__(bne init_list_from_stack_loop)
	__(mr initptr,freeptr)
	__(blr)


_spentry(newblocktag)
	__(ref_global(imm0,block_tag_counter))
	__(addi imm0,imm0,1<<num_subtag_bits)
	__(cmpwi imm0,0)
	__(ori arg_z,imm0,subtag_block_tag)
	__(beq- 1f)
	__(set_global(imm0,block_tag_counter))
	__(blr)
1:
cons_nil_nil:
	__(stwu rzero,cons.size(freeptr))
	__(la arg_z,fulltag_cons(initptr))
	__(stw rnil,cons.[car](arg_z))
	__(stw rnil,cons.[cdr](arg_z))
	__(mr initptr,freeptr)
	__(blr)

_spentry(newgotag)
	__(ref_global(imm0,go_tag_counter))
	__(addi imm0,imm0,1<<num_subtag_bits)
	__(cmpwi imm0,0)
	__(ori arg_z,imm0,subtag_go_tag)
	__(beq- cons_nil_nil)
	__(set_global(imm0,go_tag_counter))
	__(blr)

/* Allocate a "fulltag_misc" object.  On entry, arg_y contains the element */
/* count (boxed) and  arg_z contains the subtag (boxed).  Both of these  */
/* parameters must be "reasonable" (the  subtag must be valid, the element */
/* count must be of type (unsigned-byte 24).  */
/* On exit, arg_z contains the (properly tagged) misc object; it'll have a */
/* proper header on it and its contents will be 0.  initptr and freeptr will  */
/* both have advanced to the following doubleword boundary.  imm0 contains  */
/* the object's header (fulltag = fulltag_immheader or fulltag_nodeheader.) */
/* This is intended for things like "make-array" and "%make-bignum" and the  */
/* like.  Things that involve creating small objects of known size can usually */
/* do so inline with less hair. */

/* If this has to go out-of-line (to GC or whatever), it should do so via a  */
/* trap (or should otherwise ensure that both the LR and CTR are preserved  */
/* where the GC can find them.) */


_spentry(misc_alloc)
	__(extract_unsigned_byte_bits_(imm2,arg_y,24))
	__(unbox_fixnum(imm0,arg_z))
	__(extract_fulltag(imm1,imm0))
	__(bne- cr0,9f)
	__(cmpwi cr0,imm1,fulltag_nodeheader)
	__(mr imm3,imm0)
	__(cmplwi cr1,imm0,max_32_bit_ivector_subtag)
	__(rlwimi imm0,arg_y,num_subtag_bits-fixnum_shift,0,31-num_subtag_bits	/* imm0 now = header */)
	__(mr imm2,arg_y)
	__(beq cr0,1f)	/* do probe if node object (fixnum element count = byte count). */
	__(cmplwi cr0,imm3,max_16_bit_ivector_subtag)
	__(bng cr1,1f)	/* do probe if 32-bit imm object */
	__(cmplwi cr1,imm3,max_8_bit_ivector_subtag)
	__(srwi imm2,imm2,1)
	__(bgt cr0,2f)
	__(bgt cr1,1f)
	__(srwi imm2,imm2,1)
/* imm2 now = byte count.  Add 4 for header, 7 to align, then clear low three bits. */
1:
	__(addi imm2,imm2,4+7)
	__(clrrwi imm2,imm2,3)
/* The freepointer needs to advance by imm2 bytes, if possible.  Advancing it may write to a protected */
/* group of 8 4K pages, and doing so may trigger a GC.  That's all transparent to us. */
/* What's not transparent is that we can only do this if we're allocating 32K bytes or less; otherwise, */
/* we'll have to think a bit harder. */
	__(cmplwi imm2,0x8000)
	__(bgt 3f)
	__(stwux rzero,freeptr,imm2)
	__(stw imm0,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(blr)
2:
	__(cmplwi imm3,subtag_double_float_vector)
	__(slwi imm2,arg_y,1)
	__(beq 1b)
	__(addi imm2,arg_y,7<<fixnumshift)
	__(srwi imm2,imm2,fixnumshift+3)
	__(b 1b)
/* We're trying to allocate 32K bytes or more.  First, we should see if that's sensible; then, if so, we */
/* should see if we need to "manually" invoke a full gc, then we should touch each page group between  */
/* here and there and we're done. */
3:
	__(uuo_xalloc(arg_z,arg_y,arg_z))
	__(blr)
9:
	__(uuo_interr(error_object_not_unsigned_byte_24,arg_y))

/* Like misc_alloc (a LOT like it, since it does most of the work), but takes */
/* an initial-value arg in arg_z, element_count in arg_x, subtag in arg_y. */
/* Calls out to %init-misc, which does the rest of the work. */

_spentry(misc_alloc_init)
	__(mflr loc_pc)
	__(create_lisp_frame())
	__(stw fn,lisp_frame.savefn(sp))
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw vsp,lisp_frame.savevsp(sp))
	__(li fn,0)
	__(mr temp0,arg_z)		/* initval */
	__(mr arg_z,arg_y)		/* subtag */
	__(mr arg_y,arg_x)		/* element-count */
	__(bl misc_alloc)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz vsp,lisp_frame.savevsp(sp)) /* vsp may have moved to the bottom of a new stack segment */
	__(discard_lisp_frame())
	__(la fname,nrs.init_misc(rnil))
	__(set_nargs(2))
	__(mr arg_y,temp0)
	__(jump_fname())

	_endfile

	