;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

; Dumplisp.lisp

(in-package :ccl)

(defvar *save-exit-functions* nil 
  "List of (0-arg)functions to call before saving memory image")

(defvar *restore-lisp-functions* nil
  "List of (0-arg)functions to call after restoring saved image")


(declaim (special *lisp-system-pointer-functions*)) ; defined in l1-init.

(defun kill-lisp-pointers ()
  (setq * nil ** nil *** nil + nil ++ nil +++ nil - nil
        / nil // nil /// nil
        *open-file-streams* nil
         @ nil)
  (setq *eval-queue* nil)
  
  (if (boundp '*window-object-hash*)
    (clrhash (symbol-value '*window-object-hash*)))
  (setq *selected-window* nil)
  (setf (*%saved-method-var%*) nil)
  (setq *%periodic-tasks%* nil)
  (setq *event-dispatch-task* nil)
  (setq *module-file-alist* nil)        ; nuke paths to lisp 
  )


; this needs work for the new world order
(defun save-application (filename
                         &rest rest
                         &key toplevel-function
			 init-file
                         error-handler application-class
			 clear-clos-caches compress )
  (declare (ignore toplevel-function error-handler application-class
                   resources clear-clos-caches compress init-file))
  (apply #'process-interrupt
                *initial-process*
                #'%save-application-internal
                filename
                rest))

(defun %save-application-internal (filename &key
                                            toplevel-function  ;???? 
                                            error-handler ; meaningless unless application-class or *application* not lisp-development..
                                            application-class
                                            compress
					    (init-file nil init-file-p)
                                            (clear-clos-caches t))  
  (when (and application-class (neq  (class-of *application*)
                                     (if (symbolp application-class)
                                       (find-class application-class)
                                       application-class)))
    (setq *application* (make-instance application-class)))
  (when (not toplevel-function)
    (setq toplevel-function 
          #'(lambda ()
              (toplevel-function *application*
				 (if init-file-p
				   init-file
				   (application-init-file *application*))))))
  (when error-handler
    (make-application-error-handler *application* error-handler))
  
  (prepare-to-quit)
  (if clear-clos-caches (clear-clos-caches))
  (save-image (let ((fd (open-dumplisp-file filename)))
                #'(lambda () (%save-application fd compress)))
              ;This is a bit bogus.  Specifying an init-file arg means requesting
              ;the usual lisp startup actions (load init file, print greeting and
              ;run *lisp-startup-functions*).  Really should have some more
              ;explicit arguments for specifying this stuff.
              toplevel-function))

(defun save-image (save-function toplevel-function)
  (let ((toplevel (%set-toplevel)))
      (%set-toplevel #'(lambda ()
                         (setq *interrupt-level* -1)
                         (%set-toplevel toplevel)       ; in case *save-exit-functions* error
                         (dolist (f *save-exit-functions*)
                           (funcall f))
                         (kill-lisp-pointers)
                         (%set-toplevel
                          #'(lambda ()
                              (%set-toplevel toplevel-function)
                              (restore-lisp-pointers)))   ; do startup stuff
                         (funcall save-function)))
      (toplevel)))

(defun open-dumplisp-file (filename)
  (when (probe-file filename)
    (delete-file filename))
  (setq filename (%create-file filename :if-exists :error))
  (fd-open filename (logior #o01 #o01000 #o0100)))


(defun %save-application (fd &optional compress)
  (let* ((err (if compress
		(%%save-compressed-application fd)
		(%%save-application fd))))
    (unless (eql err 0)
      (%err-disp err))))
  

#+ppc-target
(defppclapfunction %%save-application ((fd arg_z))
  (uuo_xalloc rzero rnil fd)
  (blr))
#+ppc-target
(defppclapfunction %%save-compressed-application ((fd arg_z))
  (uuo_xalloc rzero imm0 fd)
  (blr))
#+sparc-target
(defsparclapfunction %%save-application ((fd %arg_z))
  (retl)
  (uuo_xalloc %rzero %rnil fd))
   

(defun restore-lisp-pointers ()
  (restore-pascal-functions)
  (refresh-external-entrypoints)
  (dolist (f (reverse *lisp-system-pointer-functions*))
    (funcall f))
  (setq *foreground* t)                 ; Necessary if you save a world under MultiFinder and run it in UniFinder.
  (let ((restore-lisp-fns *restore-lisp-functions*)
        (user-pointer-fns *lisp-user-pointer-functions*)
        (lisp-startup-fns *lisp-startup-functions*))
    (unwind-protect
      (with-simple-restart (abort "Abort (possibly crucial) startup functions.")
        (let ((call-with-restart
               #'(lambda (f)
                   (with-simple-restart 
                     (continue "Skip (possibly crucial) startup function ~s."
                               (if (symbolp f) f (function-name f)))
                     (funcall f)))))
          (dolist (f restore-lisp-fns) (funcall call-with-restart f))
          (dolist (f (reverse user-pointer-fns)) (funcall call-with-restart f))
          (dolist (f (reverse lisp-startup-fns)) (funcall call-with-restart f))))
      (setq *interrupt-level* 0)))
  nil)


(defun  restore-pascal-functions ()
  (when (simple-vector-p %pascal-functions%)
    (dotimes (i (length %pascal-functions%))
      (let ((pfe (%svref %pascal-functions% i)))
        (when (vectorp pfe)
          (let* ((name (pfe.sym pfe))
		 (descriptor (pfe.routine-descriptor pfe)))
	    (%revive-macptr descriptor)
	    (%setf-macptr descriptor (make-callback-trampoline i))
            (when name
              (set name descriptor))))))))

