;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

#+allow-in-package
(in-package "CCL")



; Write a simple-base-string to stderr's file descriptor (2).
(defsparclapfunction %string-to-stderr ((str %arg_z))
  (check-nargs 1)
  (save-lisp-context)
  (vpush %save0)
  (vpush %save1)
  (vpush %save2)
  (trap-unless-typecode= str arch::subtag-simple-base-string)
  (let ((size %imm0)
        (header %imm1)
        (length %save1)
        (ptr %save0)
        (string %save2))
    (mov str string)
    (vector-size string header size)
    (box-fixnum size length)
    ; we need 8 bytes for tsp header, 8 bytes for macptr, and need to
    ; round size up to a dword boundary.
    (add size (+ 8 8 7) %imm2)
    (andn %imm2 arch::fulltagmask %imm2) ; align to dword-boundary
    (neg %imm2 %imm2)
    (stwu %tsp %imm2 %tsp)
    (st %tsp (%tsp 4))                     ; not-lisp
    (mov (logior (ash 1 arch::num-subtag-bits) arch::subtag-macptr) %imm2)
    (add %tsp 16 %imm3)
    (st %imm2 (%tsp 8))
    (st %imm3 (%tsp 12))
    (add %tsp (+ 8 arch::fulltag-misc) ptr)
    (vpush string)                      ; source ivector
    (vpush %rzero)                       ; source-byte-offset
    (mov ptr %arg_x)                      ; dest macptr
    (mov 0 %arg_y)                        ; dest-byte-offset
    (mov length %arg_z)                   ; nbytes
    (call-symbol %copy-ivector-to-ptr)
      (set-nargs 5)
    (mov '2 %arg_x)
    (mov ptr %arg_y)
    (mov length %arg_z)
    (call-symbol fd-write)
      (set-nargs 3)
    (ld (%tsp) %tsp)
    (ld (%vsp) %save2)
    (ld (%vsp 4) %save1)
    (ld (%vsp 8) %save0)
    (restore-full-lisp-context)
    (retl)
      (nop)))





; Alice's cuter name
(defsparclapfunction dbg-paws ()
  (retl)
    (nop))

; end
