;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 2002 Clozure Associates
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

(in-package "CCL")			; for now.

(eval-when (:compile-toplevel :execute)
  (use-interface-dir :cocoa))

(require "COCOA")
;;; Alternately, one could
;;; (require "COCOA-INSPECTOR").  I haven't tried this yet, but think
;;; that it -should- work.

(defclass cocoa-application (lisp-development-system)
    ())

;;; If we're launched via the Finder, the only argument we'll
;;; get is of the form -psnXXXXXX.  That's meaningless to us;
;;; it's easier to pretend that we didn't get any arguments.
;;; (If it seems like some of this needs to be thought out a
;;; bit better ... I'd tend to agree.)
(defmethod parse-application-arguments ((a cocoa-application))
  (values nil nil nil))

;;; For some unknown (perhaps simple and obvious) reason, SAVE-APPLICATION
;;; isn't able to kill the Listener processes associcated with Cocoa
;;; Listener windows.  Unless they're killed manually (by clicking on
;;; their window's close box), they'll try to start up in the saved
;;; image.  Their interactive streams (*TERMINAL-IO* and synonyms) will
;;; be invalid, and they'll stack overflow trying to write to those
;;; streams to tell you about that.
(break "Close all  Cocoa Listeners now.")

;;; The saved image will be an instance of COCOA-APPLICATION (mostly
;;; so that it'll ignore its argument list.)  When it starts up, it'll
;;; run the Cocoa event loop in the initial Lisp process.
;;; If you use an init file ("home:openmcl-init"), it'll be loaded
;;; in an environment in which *STANDARD-INPUT* always generates EOF
;;; and where output and error streams are directed to the OSX console
;;; (see below).  If that causes problems, you may want to suppress
;;; the loading of your init file (via an :INIT-FILE nil arg to
;;; the call to SAVE-APPLICATION, below.)

(save-application "ccl:OpenMCL.app;Contents;MacOS;dppccl.image"
		  :toplevel-function
		  #'(lambda () (start-cocoa-application :event-process nil :bundle-path nil))
		  :application-class 'cocoa-application)

;;; Now, manually copy the lisp kernel from #p"ccl:dppccl" into
;;; #p"ccl:OpenMCL.app;Contents;MacOS;dppccl" (replacing the stub version
;;; of the file that's already there.)  If you copy the file in the
;;; shell, remember to use the "-p" argument to preserve the kernel's
;;; "execute" permission.
;;; Double-click on the "OpenMCL.app" bundle directory in the Finder
;;; (or do:
;;; % open OpenMCL.app
;;; in a shell), kick back, and enjoy.  (Well, as much as one can enjoy
;;; a barely-functional lisp development environment.)
;;; The "CCL" logical host won't have its translations set correctly
;;; (fixing this is left as an exercise), so REQUIRE and other things
;;; that depend on those logical pathname translations won't work right.
;;; If things go wrong, you might see some debugging information via
;;; the OSX console (/Applications/Utilities/Console.app.)  Standard
;;; and error output for the initial lisp process will be directed
;;; there.

  
