/*
 * ns-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/ns-srmv2.h,v 1.18 2002/02/03 03:05:47 lim Exp $
 */


#ifndef srmv2_ns_h
#define srmv2_ns_h

#include "srmv2/source-srmv2.h"
#include "srmv2/supp-srmv2.h"
#include "net/module.h"
#include "srmv2/srmv2.h"
#include "srmv2/supp-srmv2.h"
#include "common/hash.h"
class NS_Node;

#define MAX_LOGLEN 32
#define MAX_NLEN   16

/* 
 * An adubuf is a buffer that the application and SRMv2 share to exchange 
 * data while sending, receiving, etc. ADU's are of variable length and 
 * the length is unknown at the receiver until the last fragment arrives.
 */
class adubuf {
public:
	adubuf();
	adubuf(unsigned int length);
	~adubuf();
	void copy(unsigned char *buffer, int buflen);
	void append(unsigned *buffer, int buflen);
	void insert(SRMv2_pktbuf *pb);
	int  contiguous();
	int  concatenate();

	int len;		/* number of bytes that the app can read */
	int unused;
	unsigned int seqno;
	unsigned char *data;
	unsigned char *dp;
	SRMv2_pktbuf  *fraglist;
	int lastseen;
	int ignore;      /* Flag set ==> ignore losses in this ADU */

};


/*
 * NS_Node contains an array of pointers to ADU buffers used during
 * reassembly. adubuf is a structure for reassembly and passing
 * up to the application. 
 */
class NS_Node {

public:
	NS_Node(NS_Node* parent, unsigned int cid, unsigned int off, 
		unsigned int depth, int max_degree = 50, int max_dbufs = 100);
	~NS_Node();
	
	/* Used by the original source and receivers. */
	NS_Node*  calloc(unsigned int cid, unsigned int offset, 
			 int *created); /* alloc container */
	void      cid(unsigned id) { cid_ =  id; } /* FIXME assign an id */
	unsigned  int getcid() { return cid_; }	   /* return our cid */
	unsigned  int getpcid() { 
		if (parent()) {
			return parent()->getcid();
		}
		return 0;
	}

	//YYYadubuf*   get_nodeinfo();

	NS_Node*  is_child(unsigned int cid);   /* is this cid our child? */
	NS_Node*  child(unsigned int n);        /* Return child #n */
	unsigned int degree() { return degree_; }

	int  ignore_loss(unsigned int seqno) { return dbufs_[seqno].ignore; }

	/*
	 * Unclear what the semantics of ignore loss are. Are we
	 * allowed to reset to 0, and then set to 1 again?
	 */
	void ignore_loss(unsigned int seqno, int flag) {
		dbufs_[seqno].ignore = flag;
	}
	int lastseen(unsigned int seqno) { return dbufs_[seqno].lastseen; }
	void set_lastseen(unsigned int seqno) { dbufs_[seqno].lastseen = 1; }
	void request_missing(SRMv2_Source *src, SRMv2_Session *session,
			     unsigned int seqno);
	//int match_signature(SRMv2_Edge* signature);

	/* Used by receivers alone. */
	void writef(SRMv2_pktbuf *pb, SRMv2_Source* src,
		    SRMv2_Session* session, unsigned int seqno, Bool eoa,
		    u_short *ttl); /* write fragment */
	adubuf* reassemble(int seqno); /* reassemble fragment */
	void check_holes(SRMv2_Source* src, SRMv2_Session* session, 
			 const SRMv2_Edge& left_edge); 
	void compute_signature(int top_down=1);

	/* Use this to adjust bottom-up */
	void compute_signature_bottom_up() {
		if (parent() != 0) {
			parent_->compute_signature(0);
			parent_->compute_signature_bottom_up();
		}
	};

	void regadu(unsigned int seqno, unsigned int ebytes);
	void display(int indent);

	
	void sched_request(SRMv2_Request* r) { requests_.schedule(r); }
	void sched_reply  (SRMv2_Request* r) { replies_.schedule(r); }

	void sched_nsrequest(SRMv2_Request* r) { 
		nsrequests_.schedule(r); 
	}
	void sched_nsreply  (SRMv2_Request* r) { nsreplies_.schedule(r); }

	//void set_edge(unsigned int a, unsigned int b);
	void name(const unsigned char *name, int len) {
		if (name_ && name_len_) delete [] name_;
		name_ = new unsigned char [len+1];
		memcpy(name_, name, len);
		name_[len] = 0;
		name_len_ = len;
	}
	

	/* Request, Reply and Namespace Request and Reply output queues. */
	SRMv2_ReqQueue* requests() { return &requests_; }
	SRMv2_RepQueue* replies()  { return &replies_; }

	SRMv2_NSReqQueue* nsrequests() { return &nsrequests_; }
	SRMv2_NSRepQueue* nsreplies()  { return &nsreplies_; }

	const SRMv2_Signature &signature() { 
		return signature_; 
	}
	
	void signature(unsigned int c, unsigned int a, unsigned int b) {
		signature_.set(c, a, b);
		/*if (degree_ == 0) 
			expected_.set_edge(a, b); */
	}
	NS_Node* parent()     { return parent_; }
	unsigned int depth()  { return depth_; }
	unsigned int offset() { return off_; }
	int offset(unsigned int cid);
	const unsigned char *name() { return name_; }
	int name_len() { return name_len_; }
	void expand_dbufs(u_int32_t seqno);

private:
	int       degree_;	/* number of children */
	int       max_degree_;	/* max number of children before realloc */
	int       ndbufs_;	/* number of data buffers under me */
	int       max_dbufs_;	/* max number of data buffers */
	unsigned  int cid_;	/* container id */
	unsigned  int off_;	/* container id */
	unsigned  int depth_;   /* dist. from root, e.g., depth_(root) = 0 */
	
	SRMv2_Signature signature_;  /* unique fingerprint */
	NS_Node** child_;	/* array of children */
	NS_Node* parent_;       /* parent pointer. */
	adubuf*   dbufs_;       /* index into reassembly buffers */
	//SRMv2_Edge expected_;

	SRMv2_ReqQueue requests_;    /* pending (scheduled) repair requests */
	SRMv2_RepQueue replies_;     /* pending (scheduled) repairs */
	
	SRMv2_NSReqQueue nsrequests_;/*pending (scheduled) namespace requests*/
	SRMv2_NSRepQueue nsreplies_; /*pending (scheduled) namespace replies */

	unsigned char *name_;   /* App-specific name of this container */
	int name_len_;          /* and its length */
};

#define SRMv2_CLD 0
#define SRMv2_HOT 1
#define SRMv2_UNUSED 2
#define SRMv2_INIT_PRIO 1

typedef struct {
	unsigned char hot; /* Boolean, SRMv2_HOT ==> hot, SRMv2_CLD ==> cold, 
			    * SRMv2_UNUSED ==> unused */ 
	unsigned char selected; 
        int tix;
} activity;


class SRMv2_NameSpace {
public:
	SRMv2_NameSpace(unsigned int root = 0);
	~SRMv2_NameSpace();
	
	NS_Node* getnode(unsigned int id);
	void insert_node(unsigned int id, NS_Node* node);

	unsigned int calloc(unsigned int parent, unsigned int off, 
			    int *created, unsigned int cid=SRMv2_ALLOC);
	void hiprio(naddr **comps, int *count, int limit);
	void init_prio();
	void update_prio(unsigned int cid);
	void sort_prio(float* winner, int sz);

	void build_record(naddr* addr_record, unsigned int cid);
	void update_edge(unsigned int cid, unsigned int seqno, 
			 unsigned int ebytes);
	void update_namespace(naddr* comps, int len);
	void compute_signature();

	NS_Node *root() { return root_; }
	unsigned int cid() { return cid_; }
	void ancestors(unsigned int cid, naddr** path, unsigned int *count);
	void display(int lvl) { root_->display(lvl); }
	inline unsigned int next_seqno(unsigned int cid) {
		NS_Node* node = getnode(cid);
		if (node) return node->signature().edge.adu;
		else return SRMv2_ALLOC;
	}
	void dirty_signature() { dirty_sig_ = 1; }
private:
	NS_Node*    root_;
	NS_Node**   map_;
	timeval     generation_; 
	unsigned int cid_;

	HashTable nodes_;
	//NS_Node** nodes_;	/* cid --> NS_Node*. */
	activity* prio_; /* Weights to pick announcement records. */
	
	int dirty_sig_;
};

#endif

