/*
 * random.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/common/random.cc,v 1.5 2002/02/03 03:04:20 lim Exp $
 */


#ifndef _WIN32
#   include <sys/time.h>
#else
#   include "tclcl.h"
#endif

#include "random.h"

#if !defined(__svr4__) && !defined(__SVR4)
#   if defined(sun) || defined(WIN32)
extern "C" void srandom(int);
extern "C" int gettimeofday(struct timeval*, struct timezone*);
#   endif /* sun or win32 */
#endif /* svr4 */

void SRMv2_Random::seed(int s)
{
#if defined(__svr4__) || defined(__SVR4)
	srand48((long)s);
#else
	srandom(s);
#endif
}

int SRMv2_Random::seed_heuristically()
{
	timeval tv;
	gettimeofday(&tv, 0);        
	int s = (tv.tv_sec ^ tv.tv_usec) & 0x7fffffff;

	seed(s);
	return (s);
}
