/*
 * tgmb-canvcmd.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_TGMG_CANVCMD_H
#define MASH_TGMG_CANVCMD_H

#include "mb/mb-canv.h"
#include "tgmb-chunk.h"
#include "tgmb-enum.h"


class CanvasCmd {
public:
	CanvasCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd)
		: id_(id), seqNo_(seqNo), prev_link_(NULL), next_link_(NULL),
		  pCmd_(pCmd) { }
	virtual ~CanvasCmd() { }
	virtual CanvasCmdType getType()=0;
	MBCmd *getMBCmd() { return pCmd_; }

private:
	void ApplyEffects(ChunkFrag *frag, u_int32_t startSeqno);
	virtual Bool Apply(ChunkFrag *frag)=0;

	CanvItemId id_;
	u_long seqNo_;
	CanvasCmd *prev_link_;
	CanvasCmd *next_link_;

protected:
	MBCmd *pCmd_;

	friend class CanvasUndeleteCmd;
	friend class TGMB_Canvas;
};


class CanvasCreateCmd : public CanvasCmd {
public:
	CanvasCreateCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd)
		: CanvasCmd(id, seqNo, pCmd) { }
	~CanvasCreateCmd() { }
private:
	virtual CanvasCmdType getType() { return cmdCanvasCreate; }
	virtual Bool Apply(ChunkFrag *frag);
};


class CanvasMoveCmd : public CanvasCmd {
public:
	CanvasMoveCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd)
		: CanvasCmd(id, seqNo, pCmd) { }
	~CanvasMoveCmd() { }
private:
	virtual CanvasCmdType getType() { return cmdCanvasMove; }
	virtual Bool Apply(ChunkFrag *frag);
};


class CanvasDeleteCmd : public CanvasCmd {
public:
	CanvasDeleteCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd)
		: CanvasCmd(id, seqNo, pCmd) { }
	~CanvasDeleteCmd() { }
private:
	virtual CanvasCmdType getType() { return cmdCanvasDelete; }
	virtual Bool Apply(ChunkFrag *frag);
};


class CanvasUndeleteCmd : public CanvasCmd {
public:
	CanvasUndeleteCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd)
		: CanvasCmd(id, seqNo, pCmd) { }
	~CanvasUndeleteCmd() { }
private:
	virtual CanvasCmdType getType() { return cmdCanvasUndelete; }
	virtual Bool Apply(ChunkFrag *frag);
};


class CanvasConfigTextCmd : public CanvasCmd {
public:
	virtual CanvasCmdType getType() { return cmdCanvasConfigText; }
	const char *getText() { return text_; }
	CanvasConfigTextCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd,
			    const char* text)
		: CanvasCmd(id, seqNo, pCmd), text_(NULL) {
			AllocNCopy(&text_, text);
	}

	~CanvasConfigTextCmd() {
		delete [] text_;
	}

private:
	virtual Bool Apply(ChunkFrag *frag);
	char *text_;
};


class CanvasRaiseCmd : public CanvasCmd {
public:
	CanvasRaiseCmd(CanvItemId id, u_long seqNo, MBCmd *pCmd,
		       CanvItemId after)
		: CanvasCmd(id, seqNo, pCmd), after_(after) { }
	~CanvasRaiseCmd() { }

private:
	virtual CanvasCmdType getType() { return cmdCanvasRaise; }
	virtual Bool Apply(ChunkFrag *frag);
	CanvItemId after_;
};


#endif /* MASH_TGMG_CANVCMD_H */
