/*
 * tgmb-session.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-session.cc,v 1.6 2002/02/03 04:17:39 lim Exp $";
#endif


#include "tgmb-page.h"
#include "tgmb-session.h"
#include "tgmb-app.h"
#include "tgmb-resource.h"


TGMB_Session::TGMB_Session()
{
}


void
TGMB_Session::Start()
{
	as1Conn_.Start();

	srcId_.ss_uid  = 1; //user #1
	srcId_.ss_addr = (DWord)TG_NetworkApplication::GetLocalIP();
	APP->Book()->Open(APP->ScratchDB());
}


void
TGMB_Session::Stop()
{
	if (serventConn_.IsConnected()) serventConn_.Disconnect();
	APP->Book()->Close(1);
	as1Conn_.Stop();
}


void
TGMB_Session::ServentConnectionLost()
{
	serventConn_.Disconnect();
	APP->Canvas()->DrawCheckCross(0);
}


void
TGMB_Session::ToForm(FormPtr frm)
{
	FieldPtr fld;
	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, NSF_SessionAddrFld);
	TG_FldSetText(fld, (char*)as1Conn_.SessionAddr());
}


void
TGMB_Session::FromForm(FormPtr frm)
{
	FieldPtr fld;
	CharPtr  val;

	fld = (FieldPtr) TG_FrmGetObjectPtr(frm, NSF_SessionAddrFld);
	val = FldGetTextPtr(fld);
	as1Conn_.SessionAddr(val);
}


Boolean
TGMB_Session::ConnectToServent(const char *host, UShort port)
{
	if (StrCompare(serventIP_, host)==0 && serventPort_==port &&
	    serventConn_.IsConnected()) return true;
	if (!serventConn_.Connect(host, port)) return false;

	StrCopy(serventIP_, host);
	serventPort_ = port;

	// clear the book, so we can start afresh with the new servent
	APP->Book()->Close(1);
	APP->Book()->Open(APP->ScratchDB());
	APP->Book()->Refresh();

	// managed to connect to the servent
	// perform the initial handshake
	// This consists of a descrSrcName and a descrClientStatus
	char* cname = TGMB_Application::Instance()->Prefs()->userName_;
	Chunk chunk;

	// Metadata: type ContentTGMB_Control
	void *metadata = chunk.CreateAndLock(chunk.metadataHandle, 50);
	if (!metadata) return false;
	Word ms = chunk.InsertFrag(metadata, MetaContentType,
				   ContentTGMB_Control);
	chunk.Unlock(chunk.metadataHandle);

	// Data: descrSrcName(srcId_ + cname)
	void *data = chunk.CreateAndLock(chunk.dataHandle,
					 sizeof(Word[2]) +
					 sizeof(SrcId)   +
					 StrLen(cname)   + 2 +
					 sizeof(Word[2]) +
					 sizeof(DWord)   +
					 sizeof(PageId));
	if (!data) {
		chunk.Free(chunk.metadataHandle);
		return false;
	}
	Word ds;
	DWord zoom = APP->Book()->Zoom();
	PageId currPageId;
	if (APP->Book()->CurrentPage()) {
		currPageId = APP->Book()->CurrentPage()->Id();
	} else {
		currPageId.sid.ss_uid = currPageId.sid.ss_addr =
			currPageId.uid = 0;
	}
	ds  = chunk.InsertAnyFrag(data, descrSrcName,
				 &srcId_, Word(sizeof(SrcId)),
				 cname, Word(StrLen(cname) + 1),
				 ENDFRAG);
	ds += chunk.InsertAnyFrag(data+ds, descrClientStatus,
				  &zoom, Word(sizeof(DWord)),
				  &currPageId, Word(sizeof(PageId)),
				  ENDFRAG);
	chunk.Unlock(chunk.dataHandle);
	chunk.SetHeader(0, ms, ds);

	// Do the send
	if (serventConn_.Send(&chunk) != 0) {
		chunk.Free(chunk.dataHandle);
		chunk.Free(chunk.metadataHandle);
		serventConn_.Disconnect();
		return false;
	}
	chunk.Free(chunk.dataHandle);
	chunk.Free(chunk.metadataHandle);

	APP->Canvas()->DrawCheckCross(1);
	return true;
}



Boolean
TGMB_Session::HandleEvent(EventPtr evPtr)
{
	Err err;
	Boolean handled = false;

	switch (evPtr->eType) {
	case usrStartSession:
		Start();
		break;

	case usrStopSession:
		Stop();
		FrmGotoForm(Frm_StartupForm);
		break;

	case usrNetSelect:
	{
		EvtNetSelect evt;
		TG_GetUsrEvtObject(evPtr, &evt, sizeof(evt));
		((TGMB_Socket*)evt.clientData)->Receive();
		handled = true;
		break;
	}

	case usrTimeout:
	{
		EvtNetSelect evt;
		TG_GetUsrEvtObject(evPtr, &evt, sizeof(evt));
		((AS1_Connection*)evt.clientData)->Timeout();
#if 0
		// check if the connection is still up or not
		if (APP->ConnectionRefresh()!=0) {
			// we lost the connection!
			ServentConnectionLost();
		}
#endif
		handled = true;
		break;
	}

	case usrTGMBBytesReceived:
	{
		EvtBytesReceived evt;
		TG_GetUsrEvtObject(evPtr, &evt, sizeof(evt));
		if (evt.bytes<=0) {
			// the connection was lost
			APP->Canvas()->DrawCheckCross(0);
		}
		handled = true;
		break;
	}

	case usrTGMBChunkReceived:
	{
		EvtChunkReceived evt;
		Chunk *chunk;

		TG_GetUsrEvtObject(evPtr, &evt, sizeof(evt));

		chunk = (Chunk*) MemHandleLock(evt.chunkHandle);
		EvRMXChunkReceived(chunk);
		MemHandleUnlock(evt.chunkHandle);
		err = evt.conn->DestroyChunk(evt.chunkHandle);
		ErrFatalDisplayIf(err, "Failed to destroy net chunk");
		handled = true;
		break;
	}

	default:
		break;
	}

	return handled;
}


void
TGMB_Session::ParseMetadata(const VoidPtr metadata, DWord metadatasize,
			    Word &contentType)
{
	/* Parse incoming metadata */
	if (metadatasize <= 0) return;

	CharPtr metaptr, endptr;
	metaptr = CharPtr(metadata);
	endptr  = CharPtr(metaptr) + metadatasize;

	/* Keep scanning until we run off the buffer */
	while ( (metaptr+4) <= endptr) {
		unsigned int m_type, m_len;

		m_type = ((*metaptr) << 8) + (*(metaptr+1));
		metaptr+=2;
		m_len = ((*metaptr) << 8) + (*(metaptr+1));
		metaptr+=2;

		switch(m_type) {
		case MetaContentType:
			contentType = NetNToHS(*WordPtr(metaptr));
			break;
		default:
			break;
		}
		metaptr += m_len;
	}
}


void
TGMB_Session::EvRMXChunkReceived(Chunk *chunk)
{
	// parse out the metadata
	VoidPtr metadata;
	Word contentType;
	Boolean isNew;

	metadata = chunk->Lock(chunk->metadataHandle);
	ParseMetadata(metadata, chunk->hdr.metadataSize, contentType);
	chunk->Unlock(chunk->metadataHandle);

	switch(contentType) {
	case ContentTGMB_CanvasCmds:
	{
		if (chunk->hdr.dataSize <= sizeof(PageId)) {
			// this packet is too small; discard it
			break;
		}
		VoidPtr data = chunk->Lock(chunk->dataHandle);
		PageId pageId= *((PageId*)data);
		data = ((PageId*)data)+1;
		TGMB_Page *p = APP->Book()->FindPage(pageId, NULL);
		ULong len = chunk->hdr.dataSize-sizeof(PageId);
		p->ParsePacket(data, len, chunk->hdr.requestID);
		break;
	}

	case ContentTGMB_Control:
	{
		// for now, just extract the first page-id from the
		// packet (if there is one)
		// we need this to complete the initial handshake

		void *data = chunk->Lock(chunk->dataHandle), *end;
		ULong size = chunk->hdr.dataSize;
		Word got=0, descr;
		VoidPtr ptr;
		TGMB_Page *p;

		end = BytePtr(data) + size;
		while (data < end) {
			data = chunk->GetFrag(data, descr, ptr, got);
			switch (descr) {
			case descrNewPage:
				assert(got==sizeof(PageId));
				// create a new page object if necessary
				p = APP->Book()->FindPage(*((PageId*)ptr),
							  &isNew);
				if (isNew) {
					if (!APP->Book()->CurrentPage()) {
						// this is the first page we've
						// seen; switch to this page
						SwitchPage(p);
					}
				}
				break;
			case descrSrcName:
				// do nothing, for now
				break;
			}
		}
		chunk->Unlock(chunk->dataHandle);
		break;
	}

	default:
		break;
	}
}


void
TGMB_Session::SwitchPage(SWord dir)
{
	TGMB_Page *c = APP->Book()->CurrentPage();
	TGMB_Page *p = APP->Book()->CurrentPage(dir);
	if (p && c!=p) SwitchPage(p, 1, 0);
}


void
TGMB_Session::SwitchPage(TGMB_Page *p, Boolean doRefresh, Boolean isNewLocal)
{
	// in case there is a half completed command, notify the command object
	APP->Book()->Command()->SwitchPage();
	// set and draw the new current page
	APP->Book()->CurrentPage(p);
	PointType o = { 0, 0 };
	APP->Book()->Origin(o);
	if (p && doRefresh) p->Refresh();

	// send a clientStatus update to the RMX
	SendClientStatus(isNewLocal);

	// we might have changed the zoom level; check if we need any
	// new images

	// send ResendImage messages
	if (p) p->ResendImages();
}

void
TGMB_Session::SendClientStatus(Boolean isNewLocal)
{
	if (!serventConn_.IsConnected()) return;
	Chunk chunk;

	// Metadata: type ContentTGMB_Control
	void *metadata = chunk.CreateAndLock(chunk.metadataHandle, 50);
	if (!metadata) return;
	Word ms = chunk.InsertFrag(metadata, MetaContentType,
				   ContentTGMB_Control);
	chunk.Unlock(chunk.metadataHandle);

	Word more=0;
	if (isNewLocal) more = sizeof(Word[2]) + sizeof(PageId);
	void *data = chunk.CreateAndLock(chunk.dataHandle,
					 more +
					 sizeof(Word[2]) +
					 sizeof(DWord)   +
					 sizeof(PageId));
	if (!data) {
		chunk.Free(chunk.metadataHandle);
		return;
	}
	Word ds = 0;
	DWord zoom = APP->Book()->Zoom();
	TGMB_Page *p = APP->Book()->CurrentPage();
	PageId currPageId = { {0, 0}, 0 };
	if (p) currPageId = p->Id();
	if (isNewLocal) {
		ds += chunk.InsertAnyFrag(data+ds, descrNewPage,
					  &currPageId, Word(sizeof(PageId)),
					  ENDFRAG);
	}
	ds += chunk.InsertAnyFrag(data+ds, descrClientStatus,
				  &zoom, Word(sizeof(DWord)),
				  &currPageId, Word(sizeof(PageId)),
				  ENDFRAG);
	chunk.Unlock(chunk.dataHandle);
	chunk.SetHeader(0, ms, ds);

	// Do the send
	if (serventConn_.Send(&chunk) != 0) {
		ServentConnectionLost();
		// fall thru
	}

	chunk.Free(chunk.dataHandle);
	chunk.Free(chunk.metadataHandle);
}


void
TGMB_Session::SwitchZoom(Word zoom, Boolean doRefresh)
{
	if (APP->Book()->Zoom()==zoom) return; // do nothing
	APP->Book()->Zoom(zoom);

	// notify the command object
	APP->Book()->Command()->SwitchZoom(zoom);

	// send the new client status
	SendClientStatus();

	// send ResendImage messages
	TGMB_Page *p=APP->Book()->CurrentPage();
	if (p) p->ResendImages();

	// refresh the screen
	if (doRefresh) APP->Book()->Refresh();
}


void
TGMB_Session::ResendImage(const PageId &pid, TGMB_ObjectId id)
{
	if (!serventConn_.IsConnected()) return;
	Chunk chunk;

	// Metadata: type ContentTGMB_Control
	void *metadata = chunk.CreateAndLock(chunk.metadataHandle, 50);
	if (!metadata) return;
	Word ms = chunk.InsertFrag(metadata, MetaContentType,
				   ContentTGMB_Control);
	chunk.Unlock(chunk.metadataHandle);

	// Data: descrResendImage(pid + id)
	void *data = chunk.CreateAndLock(chunk.dataHandle,
					 sizeof(Word[2]) +
					 sizeof(PageId)  +
					 sizeof(TGMB_ObjectId));
	if (!data) {
		chunk.Free(chunk.metadataHandle);
		return;
	}
	Word ds;
	ds = chunk.InsertAnyFrag(data, descrResendImage,
				 &pid, Word(sizeof(PageId)),
				 &id, Word(sizeof(TGMB_ObjectId)),
				 ENDFRAG);
	chunk.Unlock(chunk.dataHandle);
	chunk.SetHeader(0, ms, ds);

	// Do the send
	if (serventConn_.Send(&chunk) != 0) {
		ServentConnectionLost();
		// fall thru
	}

	chunk.Free(chunk.dataHandle);
	chunk.Free(chunk.metadataHandle);
}

