/*
 * tgmb-page.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-page.h,v 1.5 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TGMB_PAGE_H
#define MASH_TGMB_PAGE_H


#include <Pilot.h>
#include "tg-hash.h"
#include "win-2bit.h"
#include "tgmb-defs.h"
#include "tgmb-cmd.h"
#define TGMB_CLIENT
#include "tgmb-enum.h"
#define TGMB_INVALID 0xFFFFFFFF


struct TGMB_PageDescr {
	PageId id;
	ULong firstChunkId;
};


struct TGMB_FullObjectDescr;
class TGMB_Book;
class CanvObj;
class TGMB_Page {
public:
	void Open(DmOpenRef db, const TGMB_PageDescr *descr);
	void Close(TGMB_PageDescr *descr, Boolean deleteAll=0);

	Boolean ParsePacket(VoidPtr data, ULong len, DWord requestId);
	void *CreateAndLockObject(TGMB_ObjectId id, Word size, Word type,
				  TG_Pointer *ptr,
				  Boolean setBelowAboveIds=1);
	void *FindAndLockObject(TGMB_ObjectId id, TG_Pointer *ptr);
	Boolean GrowLockedObject(VoidPtr &ptr, TG_Pointer &ptr, Word newSize);
	void DrawLockedObject(CanvObj *obj, WindowType *window,
			      AbsRectType *clip=NULL);
	void Book(TGMB_Book *b) { book_ = b; }
	TGMB_Book *Book() { return book_; }
	const PageId &Id() { return descr_.id; }

	void Refresh(AbsRectType *clip=NULL);
	Boolean IsVisible();

	void ResendImages();
	TGMB_ObjectId TopmostId() { return topmostId_; }

	Boolean CreateObject(TGMB_FullObjectDescr *descr, DWord requestId);
private:
	Word ParseFragment(VoidPtr data, ULong len, DWord requestId,
			   AbsRectType *refreshBox);

	Boolean DeleteObject(TGMB_ObjectId id, AbsRectType *bbox);
	Boolean MoveObject(TGMB_ObjectId id, const PointType *delta,
			   AbsRectType *bbox);
	Boolean ConfigTextObject(TGMB_ObjectId id, const char *newText);
	Boolean RaiseObject(TGMB_ObjectId id, TGMB_ObjectId after);

	void ClearOffscreen(AbsRectType *clip=NULL);
	void *CreateAndLockObject(VoidHand handle, TGMB_ObjectId id, Word size,
				  Word type, TG_Pointer *tgmbPtr,
				  Boolean setBelowAboveIds);
	Boolean RaiseLockedObject(TG_Pointer *tgmbPtr, VoidPtr ptr,
				  TGMB_ObjectId after);
	ULong InitializeChunk(ULong chunkId);
	Boolean CreateChunk();
	void MarkAsDeleted(void *ptr, Word offset);

	DmOpenRef db_;
	TGMB_PageDescr descr_;
	VoidHand *chunks_;
	Word numChunks_;
	TGMB_ObjectId topmostId_, bottommostId_;
	TGMB_Book *book_;
	TG_HashTable ht_objects_;
};


class TGMB_Book {
public:
	TGMB_Book();

	// a collection of pages
	void Init(WindowType *onscreenWindow, const AbsRectType &screenRect);
	void Open(DmOpenRef db, ULong pageDescrsId=TGMB_INVALID);
	ULong Close(Boolean deleteAll=0);
	TGMB_Page *FindPage(const PageId &pageId, Boolean *created=NULL);
	TGMB_Page *CreateNewPage();
	Boolean CreateObjectFromCommand(TGMB_ObjectId *idPtr);
	void Refresh(AbsRectType *clip=NULL);
	TGMB_Page *CurrentPage() { return current_; }
	void CurrentPage(TGMB_Page *p) { current_ = p; }
	TGMB_Page *CurrentPage(SWord dir) {
		if (!current_ || !pages_) return NULL;
		if (dir < 0) {
			if (current_-pages_ < -dir) current_ = pages_;
			else current_ = current_ + dir;
		} else {
			if (current_ + dir > pages_ + numPages_ - 1)
				current_ = pages_ + numPages_ - 1;
			else current_ = current_ + dir;
		}
		return current_;
	}

	void Scroll(SWord dx, SWord dy);
	void Origin(const PointType &o) { origin_ = o; }
	void Zoom(Word zoom) { zoom_ = zoom; }
	const PointType &Origin() { return origin_; }
	Word Zoom() { return zoom_; }
	WindowType *OnscreenWindow()  { return onscreenWindow_;  }
	WindowType *OffscreenWindow() { return offscreenWindow_; }
	TGMB_Command *Command() { return &command_; }

	void DefaultClip(AbsRectType *clip);

	void Screen2Page(const PointType *screen, PointType *page) {
		page->x = (SDWord(screen->x - screenRect_.left) * 100)/
			SDWord(zoom_) + origin_.x;
		page->y = (SDWord(screen->y - screenRect_.top) * 100)/
			SDWord(zoom_) + origin_.y;
	}
	void Page2Screen(const PointType *page, PointType *screen) {
		screen->x = (SDWord(page->x - origin_.x) * SDWord(zoom_))/100
			+ screenRect_.left;
		screen->y = (SDWord(page->y - origin_.y) * SDWord(zoom_))/100
			+ screenRect_.top;
	}
	const AbsRectType *ScreenRect() { return &screenRect_; }

private:
	TGMB_Page *NewPage(const PageId &pageId);

	DmOpenRef db_;
	TG_HashTable ht_pages_;
	ULong descrsId_;
	VoidHand descrs_;
	TGMB_Page *pages_;
	Word numPages_, maxPages_;
	DWord localPageId_;
	TGMB_ObjectId localObjId_; // local object id's have their MSB set

	TGMB_Page *current_;
	TGMB_Command command_;
	Word zoom_;
	PointType origin_;
	WindowType *onscreenWindow_, *offscreenWindow_;
	AbsRectType screenRect_;
};


#endif /* #ifdef MASH_TGMB_PAGE_H */
