/*
 * ts_old_b2a.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/time.h>
//#include "../../../../vd/audio/qm-files.h"
#include <sys/types.h>

// this is the old way to do it, without the ts value in the packetinfo field
struct QMHeader
{
  int numPackets;
  char reserved[396];
};

struct QMPacketInfo
{
  u_int16_t seqno;
  int index;
  struct timeval sysTime;
};

int main(int argc, char** argv)
{
  int x;
  FILE* infile;

  struct QMHeader hdr;
  struct QMPacketInfo info;

  if(argc != 2)
  {
    fprintf(stderr, "Usage: xxx <filename>\n");
    exit(1);
  }

  infile = fopen(argv[1], "r");

  if(infile == NULL)
  {
    fprintf(stderr, "Unable to open file %s\n", argv[1]);
    exit(1);
  }

  // header
  fread(&hdr, sizeof(struct QMHeader), 1, infile);
  printf("numPackets = %d\n", hdr.numPackets);
//  printf("postProcessed = %d\n", hdr.postProcessed);
//  printf("firstTs = %u\n", hdr.firstTs);
//  printf("lastTs = %u\n", hdr.lastTs);


  // packet infos
  for(x = 0; x < hdr.numPackets; ++x)
  {
    fread(&info, sizeof(struct QMPacketInfo), 1, infile);
//    if(info.seqno == 22000)
    {
//    printf("ts=%u\n", info.ts);
//    printf("\tflags=0x%x\n", info.flags);
      printf("seqno=%u\n", info.seqno);
      printf("\tindex=%d\n", info.index);
      printf("\tsysTime=%lu %lu\n", info.sysTime.tv_sec, info.sysTime.tv_usec);
    }
  }

  fclose(infile);

  return(0);
}
