# ui-loadProfile.tcl --
#
#       To save a new Server Profile
#
#       This file has the main ui component of the tgw application. Also, it
#       contains many of the slightly modified superclasses to make things
#       work... This is the main file with all the code in it.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import TopLevelWindow

Class ServerProfileSave -superclass TopLevelWindow -configuration { }

ServerProfileSave instproc init { } {
    $self next .serverProfileSave
}

ServerProfileSave instproc build w {
    global saveServerProfileName
    $self create-window $w "Server Profile Save"
    wm withdraw $w

    entry $w.nameEntry -textvariable saveServerProfileName -relief sunken
    frame $w.buttons
    button $w.buttons.ok -text OK -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle newvals"
    button $w.buttons.cancel -text Cancel -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle"
    pack $w.buttons.ok $w.buttons.cancel -side left
    pack $w.nameEntry $w.buttons
}

ServerProfileSave instproc toggle { { usevals 0 } } {
    global saveServerProfileName inputtedSName inputtedSPort inputtedUName inputtedPass
    
    if { $usevals != 0 } {
	if [catch {open ~/.mash/realServerProfiles a} fileID] {
	    puts "no ~/.mash/realServerProfiles file"
	} else {
	    puts $fileID "$saveServerProfileName:$inputtedSName:$inputtedSPort;$inputtedUName;$inputtedPass"
	    close $fileID
	}
    } else {
	set saveServerProfileName ""
    }
    $self next
}

# To save a new Stream Profile

Class StreamProfileSave -superclass TopLevelWindow -configuration { }

StreamProfileSave instproc init { } {
    $self next .streamProfileSave
}

StreamProfileSave instproc build w {
    global saveStreamProfileName
    $self create-window $w "Stream Profile Save"
    wm withdraw $w

    entry $w.nameEntry -textvariable saveStreamProfileName -relief sunken
    frame $w.buttons
    button $w.buttons.ok -text OK -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle newvals"
    button $w.buttons.cancel -text Cancel -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle"
    pack $w.buttons.ok $w.buttons.cancel -side left
    pack $w.nameEntry $w.buttons
}

StreamProfileSave instproc toggle { { usevals 0 } } {
    global saveStreamProfileName use56K use128K use256K use512K other otherInputted useSS outputFPS title author copyright sendtoRealServer streamName saveAsFile fileName sendAudio audioAddr
    
    if { $usevals != 0 } {
	if [catch {open ~/.mash/realStreamProfiles a} fileID] {
	    puts "no ~/.mash/realStreamProfiles file"
	} else {
	    puts $fileID "$saveStreamProfileName:$use56K;$use128K;$use256K;$use512K;$other;$otherInputted;$useSS;$outputFPS;$title;$author;$copyright;$sendtoRealServer;$streamName;$saveAsFile;$fileName;$sendAudio;$audioAddr"
	    close $fileID
	}
    } else {
	set saveStreamProfileName ""
    }
    $self next
}

proc Scroll_Set {scrollbar geoCmd offset size} {
    if {$offset != 0.0 || $size != 1.0} {
	eval $geoCmd
    }
    $scrollbar set $offset $size
}

proc Scrolled_listbox { f args } {
    frame $f
    listbox $f.list \
	    -xscrollcommand [list Scroll_Set $f.xscroll \
	     [list grid $f.xscroll -row 1 -column 0 -sticky we]] \
	    -yscrollcommand [list Scroll_Set $f.yscroll \
	     [list grid $f.yscroll -row 0 -column 1 -sticky ns]]
    eval {$f.list configure} $args
    scrollbar $f.xscroll -orient horizontal -command [list $f.list xview]
    scrollbar $f.yscroll -orient vertical -command [list $f.list yview]
    grid $f.list -sticky news
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1
    return $f.list
}

# displays the possible Server Profiles available

Class ServerProfileWindow -superclass TopLevelWindow -configuration { }

ServerProfileWindow instproc init { mainUI } {
    $self next .serverProfiles
    $self instvar ui_
    set ui_ $mainUI
}

ServerProfileWindow instproc build w {
    $self instvar listbox_
    $self create-window $w "Server Profiles"
    wm withdraw $w
    set listbox_ [Scrolled_listbox $w.listbox -width 15 -height 5 -selectmode single]
    $self refreshList
    frame $w.buttons
    button $w.buttons.ok -text OK -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle newvals"
    button $w.buttons.cancel -text Cancel -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle"
    pack $w.buttons.ok $w.buttons.cancel -side left
    pack $w.listbox $w.buttons
}

ServerProfileWindow instproc refreshList { } {
    $self instvar listbox_
    if [info exists listbox_] {
	$listbox_ delete 0 end
	if [catch {open ~/.mash/realServerProfiles r} fileID] {
	    puts "no ~/.mash/realServerProfiles file"
	} else {
	    while {![eof $fileID]} {
		set tempString [gets $fileID]
		$listbox_ insert end [string range $tempString 0 [expr [string first ":" $tempString] - 1]]
	    }
	    close $fileID
	}
    }
}

ServerProfileWindow instproc toggle { { usevals 0 } } {
    $self instvar ui_ listbox_
    
    if { $usevals != 0 } {
	$listbox_ get active
	if [catch {open ~/.mash/realServerProfiles r} fileID] {
	    puts "no ~/.mash/realServerProfiles file"
	} else {
	    while {![eof $fileID]} {
		set tempString [gets $fileID]
		set tempNum [string first ":" $tempString]
		if {[string compare [$listbox_ get [$listbox_ curselection]] [string range $tempString 0 [expr $tempNum - 1]]] == 0} {
		    incr tempNum
		    set tempString [string range $tempString $tempNum [string length $tempString]]
		    set sName [string range $tempString 0 [expr [string first ":" $tempString] - 1]]
		    set tempString [string range $tempString [expr 1 + [string first ":" $tempString]] [string length $tempString]]
		    set sPort [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr 1 + [string first ";" $tempString]] [string length $tempString]]
		    set uName [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr 1 + [string first ";" $tempString]] [string length $tempString]]
		    $ui_ setServerInfo $sName $sPort $uName $tempString
		    break
		}
	    }
	    close $fileID
	}
    } else {
	$self refreshList
    }
    $self next
}

# To load all the possible Stream Profiles

Class StreamProfileWindow -superclass TopLevelWindow -configuration { }

StreamProfileWindow instproc init { } {
    $self next .streamProfiles
}

StreamProfileWindow instproc build w {
    $self instvar listbox_
    $self create-window $w "Stream Profiles"
    wm withdraw $w
    set listbox_ [Scrolled_listbox $w.listbox -width 15 -height 5 -selectmode single]
    $self refreshList
    frame $w.buttons
    button $w.buttons.ok -text OK -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle newvals"
    button $w.buttons.cancel -text Cancel -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle"
    pack $w.buttons.ok $w.buttons.cancel -side left
    pack $w.listbox $w.buttons
}

StreamProfileWindow instproc refreshList { } {
    $self instvar listbox_
    if [info exists listbox_] {
	$listbox_ delete 0 end
	if [catch {open ~/.mash/realStreamProfiles r} fileID] {
	    puts "no ~/.mash/realStreamProfiles file"
	} else {
	    while {![eof $fileID]} {
		set tempString [gets $fileID]
		$listbox_ insert end [string range $tempString 0 [expr [string first ":" $tempString] - 1]]
	    }
	    close $fileID
	}
    }
}

StreamProfileWindow instproc toggle { { usevals 0 } } {
    global use56K use128K use256K use512K other otherInputted useSS outputFPS title author copyright sendtoRealServer streamName saveAsFile fileName sendAudio audioAddr
    $self instvar listbox_

    if { $usevals != 0 } {
	$listbox_ get active
	if [catch {open ~/.mash/realStreamProfiles r} fileID] {
	    puts "no ~/.mash/realStreamProfiles file"
	} else {
	    while {![eof $fileID]} {
		set tempString [gets $fileID]
		set tempNum [string first ":" $tempString]
		if {[string compare [$listbox_ get [$listbox_ curselection]] [string range $tempString 0 [expr $tempNum - 1]]] == 0} {
		    incr tempNum
		    set tempString [string range $tempString $tempNum [string length $tempString]]
		    set use56K [string range $tempString 0 0]
		    set use128K [string range $tempString 2 2]
		    set use256K [string range $tempString 4 4]
		    set use512K [string range $tempString 6 6]
		    set other [string range $tempString 8 8]
		    set tempString [string range $tempString 10 [string length $tempString]]
		    set otherInputted [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set useSS [string range $tempString 0 0]
		    set tempString [string range $tempString 2 [string length $tempString]]
		    set outputFPS [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set title [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set author [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set copyright [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set sendtoRealServer [string range $tempString 0 0]
		    set tempString [string range $tempString 2 [string length $tempString]]
		    set streamName [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set saveAsFile [string range $tempString 0 0]
		    set tempString [string range $tempString 2 [string length $tempString]]
		    set fileName [string range $tempString 0 [expr [string first ";" $tempString] - 1]]
		    set tempString [string range $tempString [expr [string first ";" $tempString] + 1] [string length $tempString]]
		    set sendAudio [string range $tempString 0 0]
		    set audioAddr [string range $tempString 2 [string length $tempString]]
		    break
		}
	    }
	    close $fileID
	}
    } else {
	$self refreshList
    }
    $self next
}

