# application-rvic.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rvic/application-rvic.tcl,v 1.6 2002/02/03 04:29:27 lim Exp $


import VicApplication RemoteVicUI
# WidgetClass VideoBox

# Remote-controleld Vic application
Class RemoteVicApplication -superclass VicApplication

#
# init adds ctrl spec option and then calls the parent init (vic's)
RemoteVicApplication instproc init {widgetPath argv} {
	set o [$self options]
	$o register_option -ctrl rvicCtrlSpec
	$o register_option -rendez rendezSpec
	$o register_option -audio audioMonitorSpec
	$o register_option -uniqid uniqid
	eval [list $self] next $widgetPath [list $argv]
}

#
# Build the remote vic "user interface".
# Creates a frame using the provided <i>widgetPath</i> and packs the
# rvic ui in it.
#
RemoteVicApplication instproc init_ui {widgetPath spec} {
	$self instvar agent_ vpipe_ local_chan_ glob_chan_

	set ctrlAddr [$self get_option rvicCtrlSpec]
	if {$ctrlAddr == ""} {
		puts "need to set rvic control address with -ctrl option..."
		exit
	}

	frame $widgetPath
	# FIXME
	$self add_option geometry 640x480
	set ui [new RemoteVicUI $widgetPath $local_chan_ $glob_chan_ \
			$agent_ $vpipe_ "$self exit" $spec]

	set raddr [$self get_option rendezSpec]
	if {$raddr != ""} {
		puts "starting Rendezvous messages on $raddr"
		$self instvar rv_
		set rv_ [new Rendezvous $raddr]
		if {[llength [split $ctrlAddr /]] < 2} {
			set ctrlAddr [localaddr]/$ctrlAddr
		}
		set rmsg "will-provide: mash-object=RemoteVicApplication\
				spec=$spec ctrlspec=$ctrlAddr"
		set uid [$self get_option uniqid]
		if {$uid != ""} {set rmsg "$rmsg uniqid=$uid"}
		$rv_ start $rmsg
	}
	pack $widgetPath -expand 1 -fill both

	return $ui
}


