# fx_spatial.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPApplication
import ScSpatialCombiner
import GraphComm

Class SpatApp -superclass RTPApplication

SpatApp instproc init args {
    $self next spat_app

    $self init_resources;

    [$self options] register_option -comm_id comm_id
    [$self options] register_option -cntrl_spec cntrl_spec
    [$self options] register_option -spatial_test_mode spatial_test_mode
    [$self options] register_option -reg_comm_spec reg_comm_spec

    eval [$self options] parse_args $args;

    $self instvar spat_obj_

    set spat_obj_ [new ScSpatialCombiner [$self get_option comm_id] [$self get_option cntrl_spec]];

    if {[$self get_option reg_comm_spec] != ""} {
	$self instvar reg_comm_obj_;

	set reg_comm_obj_ [new GraphComm/RegComm [$self get_option comm_id] [$self get_option reg_comm_spec] [$self get_option cntrl_spec]];
    }

}

SpatApp instproc init_resources {} {
    $self add_option network ip
    $self add_option mtu 1024
    $self add_option defaultTTL 32
    $self add_option sessionType rtpv2
    $self add_option maxVideoSessionBW 30000000
    $self add_option comm_id spat_comb
    $self add_option cntrl_spec 224.3.2.1/22334/16
    $self add_option spatial_test_mode "rate xcode"
    $self add_option reg_comm_spec "";
}

Class GraphComm/RegComm -superclass GraphComm;

GraphComm/RegComm instproc init {id reg_spec cntrl_spec} {

    set reg_spec [split $reg_spec "/"];

    set addr [lindex $reg_spec 0];
    set port [lindex $reg_spec 1];
    set ttl [lindex $reg_spec 2];

    $self next $id $addr $port $ttl

    $self instvar sess_map_ primary_sess_;

    set sess_map_($primary_sess_,inputs) 0;
    set sess_map_($primary_sess_,outputs) 0;
    set sess_map_($primary_sess_,parameters) 0;
    set sess_map_($primary_sess_,trigger_cmds) 0;
    set sess_map_($primary_sess_,map_cmds) 0;
    set sess_map_($primary_sess_,misc) 0;

    $self send_misc [list add_subgraph $cntrl_spec];
}

set app [new SpatApp $argv];

puts "SpatialCombiner running on [exec hostname]";

#if {![info exists tk_version]} {
#    vwait forever;
#}
