# ui-mboard.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
Class MBWidget

#
MBWidget instproc pack {args} {
	eval pack [$self set path_] $args
}

#
MBWidget instproc unpack {} {
	$self instvar path_
	pack forget [$self set path_]
}

import SrcList MBOptionMenu MBPageNavPanel MBUI_Print MBCanvas \
		MBMenu MBToolbar MBTimeBrowser Observer Configuration

# This class contains MediaBoard user-interface functions
Class MBUI -superclass Observer -configuration {
        canvWidth 500
        canvHeight 430
	showLocalOwnerTip 0
        drop 0
	psOrient portrait
	psColorMode gray
	psContent full
	statusbarOnTop 1
}

#
# Pack a mediaboard in the frame, <i>path</i>, which the caller is responsible for instantiating and packing.
#
MBUI instproc init {path mgr sender vis exitCmd} {
        $self instvar idleHandler_  mgr_ vis_ printUI_ srcList_
        set idleHandler_ {}
        set mgr_ $mgr
        set vis_ $vis
        set srcList_ [new SrcList]
	$srcList_ add_callback track "$self track"

	$self set tipsAsDrawn_ 1

	$self instvar mainframe_ tframe_ canvframe_ \
			canvframetext_ canvframebut_ bframe_ mframe_ menu_
        set mainframe_ $path

        set tframe_ [frame $mainframe_.tf -borderwidth 0 -relief raised]
        set canvframe_ [frame $tframe_.cf -borderwidth 2 -relief ridge]

        set canvframetext_ [label $canvframe_.l \
                        -text "\nWaiting for network specs.\n" ]
        set canvframebut_ [button $canvframe_.b \
                        -text "Create new page" -state disabled \
			-command "\[$self set menu_\] insert_page" ]

        if $vis_ {
                pack $canvframe_ -side left -fill both \
                                -expand true -padx 1 -pady 1
                pack $canvframetext_ -side top -anchor c \
                                -fill both -expand true
                pack $canvframebut_ -side top -anchor c \
                                -fill x -expand true -anchor s -pady 3 -padx 3
        }

        $self set bframe_ [frame $mainframe_.bf \
                        -borderwidth 0 -relief raised -height 22p]

        $self set mframe_ [frame $mainframe_.mf \
                        -borderwidth 1 -relief raised ]

        if $vis_ {
                pack $mframe_ -side top -fill x -expand false -anchor n
                pack propagate $bframe_ FALSE
        }

	$self instvar props_ toolbar_
        set props_ [new MBProps]
	$props_ draw_panel $bframe_
        $self draw_navPanel $bframe_
	$self tkvar statusbarOnTop_
	set statusbarOnTop_ [$self get_option statusbarOnTop]

	$self instvar debug_
	set debug_ [new MBDebugDlg $mgr_ $vis_]
	$mgr_ attach_debug $debug_
	set drop [$self get_option drop]
	$debug_ change_state $drop
        set menu_ [new MBMenu $self $mframe_ $mgr_ $exitCmd]
        set toolbar_ [new MBToolbar $self $tframe_ $mgr $sender ""]

	# add callback
	$toolbar_ trace_tool "$self tool_changed"

        if $vis_ {
                pack $tframe_ -side top -fill both -expand true -anchor nw
        }

        set geom [$self get_option geometry]
        if {$vis} {
                wm geometry . $geom
		global mash
		if { ![info exists mash(environ)] || $mash(environ)!="mplug"} {
			wm iconify .
			wm deiconify .
		}
#temporarily commenting out because if $path passed to this method is not packed already, this will hang forever
#		tkwait visibility $canvframebut_
#                focus $canvframebut_
        } else {
		global mash
		if { ![info exists mash(environ)] || $mash(environ)!="mplug"} {
			wm iconify .
			wm title . [lindex [split [info hostname] .] 0]
		}
        }

	set orient [$self get_option psOrient]
	set color [$self get_option psColorMode]
	set content [$self get_option psContent]

	set printUI_ [MBUI_Print .mbuiprint -colorMode $color \
			-orient $orient -content $content \
			-pageMgr [$mgr_ page_manager]]
	$printUI_ hide
	$self set browsePage_ {}
	[$mgr_ page_manager] attach_observer $self

        global mb
        set pswin [new MBPSProcessor .mbps]
        DbgOut [concat "Window ID for MBPSProcessor: " [winfo id .mbps]]
        set mb(gsinterp) [new MBPSInterp $pswin]
}

#
MBUI instproc reset { session } {
        # set the window & icon title from the conference name
	set prefix [$self get_option iconPrefix]
        set hostname [lindex [split [info hostname] .] 0]
        append prefix "@" $hostname ":"
        set conf [$self get_option conferenceName]
	if {$conf=={}} {
		set conf [[$session data-net] addr]
		append conf /
		append conf [[$session data-net] sport]
	}
	$self window_title $prefix $conf

        $self activate
}

#
MBUI instproc destroy {} {
}

#
MBUI instproc mgr {} {
	return [$self set mgr_]
}

#
MBUI instproc printUI {} { return [$self set printUI_] }

#
MBUI instproc window_title { prefix name } {
	$self instvar name_ prefix_
	set name_ $name
	set prefix_ $prefix
	wm iconname . "$prefix_$name_"
	wm title . "$prefix_$name_"
}

#
MBUI instproc activate {} {
	$self instvar canvframebut_ canvframetext_
	if [winfo exists $canvframebut_] {
		$canvframebut_ configure -state normal
	}
	if [winfo exists $canvframetext_] {
		$canvframetext_ configure \
				-text "\nPlease wait for data to arrive from the network\n or \nclick on the button below to create a new page.\n        "
	}
}

#
# toggle/display the position of the status bar
#
MBUI instproc redraw_statusbar {} {
	$self tkvar statusbarOnTop_
	$self instvar bframe_ tframe_
	if {$statusbarOnTop_} {
		pack $bframe_ -before $tframe_ \
				-side top -fill x -expand false -anchor s
	} else {
		pack $bframe_ -before $tframe_ \
				-side bottom -fill x -expand false -anchor s
	}

}

# packs the status bar as well as toolbar
MBUI instproc pack_panels {} {
	$self instvar canvframetext_ canvframebut_ toolbar_ canvframe_ vis_ \
			mgr_
        destroy $canvframetext_
        destroy $canvframebut_

        # pack the panel of buttons and the bottom status panel
	$self redraw_statusbar
	if $vis_ {
		$self show_toolbar 1
	}
}

#
MBUI instproc activity {src {page_id {}} {canv {}} {id {}}} {
        # -- c++ callback  ---
	$self instvar idleHandler_ srcList_ menu_ tipsAsDrawn_ \
			browsePage_ mgr_
	if {$src != {}} {
		$srcList_ hilit $src
		if {$idleHandler_=={}} {
			set idleHandler_ [after idle $self refresh]
		}
	}
	if { ($canv != {}) && $tipsAsDrawn_ && $id!=0} {
		$canv show_owner $id 0
	}
        if { ($page_id != {}) && [$menu_ followActivePage] == 1 \
			&& $browsePage_ == {}} {
		[$mgr_ page_manager] switch_page_later $page_id
	}
}

#
MBUI instproc notify_currPage {src page_id} {
	$self instvar mgr_
	mtrace trcVerbose "notify currpage $page_id"
	set pageMgr [$mgr_ page_manager]
	if {[$pageMgr current_page] != $page_id} {
		$pageMgr switch_page_later $page_id
	}
}

#
# executed when idle, does some background refreshing
#
MBUI instproc refresh {} {
        $self instvar idleHandler_ mgr_

	# adjusts size of canvas etc.
	set pagemgr [$mgr_ page_manager]
	if {[$pagemgr current_page] != {}} {
		[$pagemgr current_canvas] refreshScrReg
	}
        set idleHandler_ {}
}

#
# This command will be called by the MediaBoard objects,
#   to create a new canvas when a new page has been created
#
#   - creates new canvas if neccesary
#   - updates mapping if needed
#

# -- c++ callback  --- #
MBUI instproc create_canvas {page_id} {
        $self instvar vis_ mgr_
	set pageMgr [$mgr_ page_manager]

        if [$pageMgr has_page $page_id] {
                mtrace trcVerbose "returning old value: $pageMgr page2canv $page_id]"
                return [$pageMgr page2canv $page_id]
        }
        $self instvar canvframe_
        set fr $canvframe_

        if ![winfo exists $fr.xs] {
                scrollbar $fr.xs -orient horizontal -width 12
                scrollbar $fr.ys -orient vertical -width 12
        }

        set size [list 0 0]

	# If there's a total geometry spec, honor that first.
	if { [$self get_option geometry] != "" } {
		set g [split [$self get_option geometry] x]
		set canvWidth [expr [lindex $g 0] - 60]
		set canvHeight [expr [lindex $g 1] - 90]
	} else {
		set canvWidth [$self get_option canvWidth]
		set canvHeight [$self get_option canvHeight]
	}

        set size [list [lappend size $canvWidth $canvHeight]]

        set c [new MBCanvas]

	$c create_canvas $canvframe_ \
		    "-scrollregion $size -width $canvWidth \
		    -height $canvHeight -background white \
		    -takefocus 1"

	$c setsize $canvWidth $canvHeight

	if {[$self get_option showLocalOwnerTip]==0} {
		$c omitShowOwner [$mgr_ local_src]
	}

	$pageMgr add_page $page_id $c

        if {[$pageMgr current_page]=={}} {
		after idle "$self pack_first_canvas $c"
        }
        mtrace trcVerbose "created new page: $page_id"

	set w [$c get_win]
	$self instvar toolbar_
	set textTool [$toolbar_ tool text]
	# for people without B2
	bind $w <Shift-Button-1> \
		    "$textTool paste $c \[$c canvasxy %x %y\]; break"
	# common binding for paste
	bind $w <Button-2> [bind $w <Shift-Button-1>]
	bind $w <Control-v> "$textTool paste $c \[$c pointerxy\]; break"
	bind $w <Control-y> [bind $w <Control-v>]
	bind $w <Shift-Insert> [bind $w <Control-v>]
	bind $w <Button-3> "[$toolbar_ tool erase] erase_last \[$pageMgr current_page\]"

	# we want to be able to insert tabs into the canvas, but per window
	# focus seems to be broken...
	bind $w <Tab> "break"

        return $c
}

#
MBUI instproc pack_first_canvas {c} {
	$self instvar vis_ canvframe_ mgr_ menu_
	set pageMgr [$mgr_ page_manager]

	if {[$pageMgr current_page]!={}} {
		return
	}
	$c configure -xscrollcommand [list $canvframe_.xs set] \
			-yscrollcommand [list $canvframe_.ys set]

	$pageMgr switch_page_later [$pageMgr canv2page $c]
	if {$vis_} {
		after idle "$self pack_panels"
	}
	pack $canvframe_.xs -side bottom -fill x -expand false \
			-anchor n \
			-padx 1 -pady 1
	pack $canvframe_.ys -side left -fill y -expand false \
			-anchor w \
			-pady 1 -padx 1
	$canvframe_.xs configure -command \
			"\[$pageMgr current_canvas\] xview"
	$canvframe_.ys configure -command \
			"\[$pageMgr current_canvas\] yview"
}

#
MBUI instproc draw_navPanel {fr args} {
	$self instvar mgr_ pageNavPanel_ canvframe_
	if [$self set vis_ ] {
		set pageNavPanel_ [new MBPageNavPanel $fr [$mgr_ page_manager]]
		$pageNavPanel_ build_widgets {pagelist next prev zoom}
		$pageNavPanel_ pack -side right -fill y -anchor se -padx 2

		# update the zoom value when resizing the canvas
		bind $canvframe_ <Configure> "update idletasks; $pageNavPanel_ update_zoomscale"

	}
        return [$pageNavPanel_ set path_]
}

# returns current selected property of a tool
MBUI instproc property {tool} {
	return [[$self set props_] property $tool]
}

#
# Callback from toolbar when the tool has changed
#
MBUI instproc tool_changed {newtool} {
	eval [$self set props_] refresh_panel $newtool
}

#
# Callback when a page has been changed
MBUI instproc switch_page {page_id} {
	$self instvar toolbar_ menu_
	if {[$toolbar_ current_tool] == {}} {
		$toolbar_ select_tool freehand
	} else {
		$toolbar_ select_tool [$toolbar_ current_tool]
	}
	$menu_ tkvar browseTime_
	if {$browseTime_ == 1}  {
		# release previous page
		set browseTime_ 0
		$self browseTime browseTime_
		# browse new page
		set browseTime_ 1
		$self browseTime browseTime_
	}
}

# when tipping is 1, the owner tip will be displayed when there items
# are being created
MBUI instproc enable_tip_as_drawn {tipping} {
	$self set tipsAsDrawn_ $tipping
}

# -----------------------------------------------------------------------

# Class MBProps --
#    Manages the properties of the different objects can be created
#    Also manages the ui that displays/changes the properties
Class MBProps

#
MBProps instproc init_fonts {} {
	set o [$self options]

	# use unix lfd's for now so that older mb's will not break
if 1 {
	$o add_default font1 \
			-*-helvetica-bold-r-normal--*-120-75-75-*-*-*-*
	$o add_default font2 \
			-*-helvetica-bold-r-normal--*-140-75-75-*-*-*-*
	$o add_default font3 \
			-*-helvetica-bold-r-normal--*-180-75-75-*-*-*-*
	$o add_default font4 \
			-*-helvetica-bold-r-normal--*-240-75-75-*-*-*-*
	$o add_default font5 \
			-*-times-bold-r-normal--*-120-75-75-*-*-*-*
	$o add_default font6 \
			-*-times-bold-r-normal--*-140-75-75-*-*-*-*
	$o add_default font7 \
			-*-times-bold-r-normal--*-180-75-75-*-*-*-*
	$o add_default font8 \
			-*-times-bold-r-normal--*-240-75-75-*-*-*-*
	$o add_default font9 \
			-*-helvetica-bold-r-normal--*-360-*-*-*-*-*-*
	$o add_default font10 \
			-*-helvetica-bold-r-normal--*-480-*-*-*-*-*-*
	return
}
        # below not used for now
	$self add_default font1 {helvetica -12 bold}
	$self add_default font2 {helvetica -14 bold}
	$self add_default font3 [$o get_option helv18b]
	$self add_default font4 [$o get_option helv24b]
	$self add_default font5 [$o get_option times12b]
	$self add_default font6 [$o get_option times14b]
	$self add_default font7 [$o get_option times18b]
	$self add_default font8 [$o get_option times24b]
}

#
MBProps instproc init {} {
	$self tkvar props_

	$self init_fonts

	# format: {[-<label> <prop>]*}
        set props_(line) {-fill color -arrow arrow -width width}
        set props_(freehand) {-fill color -width width}
        set props_(plainline) $props_(freehand)
        set props_(rectangle) {-fill fill -outline outline -width width}
        set props_(oval) $props_(rectangle)
        set props_(text) {-fill color -font font}

        set props_(move) {}
	set props_(copy) {}
        set props_(erase) {}
        set props_(all)  {fill arrow outline color width font}

        # the following specfies the format of properties
        # see MBOptionMenu::init
        set props_(all,fill)  \
                        {colors 2 "custom" "" "none" "" White White \
			Black Black Red Red \
                        Orange Orange Yellow Yellow Green Green Blue Blue \
                        Magenta Magenta Violet Violet}
        set props_(all,outline) \
                        {colors 2 "custom" "" Black Black Red Red \
                        Orange Orange Yellow Yellow \
                        Green Green Blue Blue Magenta Magenta Violet Violet}
        set props_(all,color) \
                        {colors 2 "custom" "" Black Black Red Red \
                        Orange Orange Yellow Yellow \
                        Green Green Blue Blue Magenta Magenta Violet Violet}
        set props_(all,arrow) \
                        {text 1 "at the end" last "both ends" \
                        both "beginning" first "none" none}
        set props_(all,font) {font 1}
        set i 1
        while {""!=[set font [$self get_option font$i]]} {
                lappend props_(all,font) font$i
                lappend props_(all,font) $font
                incr i
        }
        set props_(all,width)  \
                        {text 2 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10}
}

#
# Refresh the properties-options panel
# Alert: props_(set) is of form {[-<label> <prop>]*}
#	so lsearch below will work since we use -exact => won't confuse
#	values of <label> and <props>
#
MBProps instproc refresh_panel {currentset} {
	$self instvar panel_
	$self tkvar props_

	if [info exists props_($currentset)] {
		set currProps $props_($currentset)
	} else {
		set currProps {}
	}
	if {[llength $currProps] == 0} {
		pack forget $panel_
		return
	}
	if ![winfo ismapped $panel_] {
		pack $panel_ -side left -expand FALSE -fill both
	}
	foreach elt $props_(all) {
		if {-1 == [lsearch -exact $currProps $elt]} {
			pack forget $panel_.$elt
		} else {
			pack $panel_.$elt -side left -padx 1 -pady 1
		}
	}
}

#
# Returns the current list of properties given the list of properties
#   to fill in, return format is suitable to append to a 'create'
#   or 'itemconfig' command
#
MBProps instproc property {prop_set} {
	$self tkvar props_

	set prop_list $props_($prop_set)
	set newprop ""
	foreach {param property} $prop_list {
		if {$props_($property)!=""} {
			append newprop " $param "
			append newprop [list $props_($property)]
		}
	}
	#DbgOut "newprop=$newprop"
	return $newprop
}

#
# Draws the properties-options panel
#
MBProps instproc draw_panel {fr args} {
	$self tkvar props_
	$self instvar panel_ vis_

        set font [[Application instance] resource medfont]
	set panel_ [eval frame $fr.op1 $args]
	set propsName [$self tkvarname props_]
	foreach elt $props_(all) {
		frame $panel_.$elt
		set str "$elt:"
		set label [string toupper \
				[string index $str 0]][string range $str 1 end]
		label $panel_.$elt.label -text $label -font $font
		new MBOptionMenu $panel_.$elt.menu \
				[set propsName]($elt) \
				[set propsName]($elt,currLabel) \
				$props_(all,$elt)
		pack $panel_.$elt.label -side left -expand FALSE
		pack $panel_.$elt.menu -side left -expand FALSE
	}
	$self refresh_panel freehand
}

#
MBUI instproc show_timepanel {on} {
	$self instvar timepanel_ mainframe_
	# turn into readonly mode when browsing
#puts "show_timepanel $on"
	$self readonly $on

	if ![info exists timepanel_] {
		$self instvar menu_
		set timepanel_ [new MBTimeBrowser $mainframe_ \
				[$menu_ tkvarname browseTime_]]
		$timepanel_ update_callBack "$self set_time"
		$timepanel_ stop_callBack "$self stopBrowseTime"
	}
	if {$on} {
		$timepanel_ pack -side bottom -fill x -expand 0
	} else {
		$timepanel_ unpack
	}
}

#
MBUI instproc show_toolbar {on} {
	$self instvar toolbar_ canvframe_
#puts "show_toolbar $on"
	if {$on} {
		$toolbar_ pack -before $canvframe_ \
				-side right -expand false -anchor e
	} else {
		$toolbar_ unpack
	}
}

#
MBUI instproc readonly {on} {
	$self show_toolbar [expr {$on ? 0 : 1}]
	[$self set menu_] readonly $on
}

#
MBUI instproc browseTime {varname} {
	upvar $varname browseOnVar
	$self instvar browsePage_ mgr_
	mtrace trcVerbose "$class browseTime $browseOnVar"
	set pageMgr [$mgr_ page_manager]
	if {$browseOnVar} {
		$self instvar timepanel_
		set curr_page [$pageMgr current_page]
		set range [$mgr_ time_range $curr_page]
		set retry 0
		# FIXME: wait for a while
		while {($range  == {}) && ($retry < 10)} {
			update
			incr retry
			set range [$mgr_ time_range $curr_page]
		}
		if {$range == {}} {
			set browseOnVar 0
			Dialog transient MessageBox -title "Empty Page" \
					-text "This page is currently empty. Reverting to normal mode." -type ok
		}
	}
	$self show_timepanel $browseOnVar
	if {$browseOnVar} {
		# set min and max to be slight over the boundary so that
		# we can browse the full range
		set mintime [lindex $range 0]
		set maxtime [lindex $range 1]
		$timepanel_ min_time [expr {$mintime - 1}]
		$timepanel_ max_time [expr {$maxtime + 1}]
		$timepanel_ goto [expr {$maxtime + 1}]
		set browsePage_ [$pageMgr current_page]
		$self set_time $maxtime
	} else {
		if {$browsePage_ != {}} {
			$mgr_ release_time $browsePage_
		}
		set browsePage_ {}
	}
}

#
MBUI instproc stopBrowseTime {} {
	$self instvar menu_
	$menu_ tkvar browseTime_
	set browseTime_ 0
	$self browseTime browseTime_
}

#
MBUI instproc set_time {newtime} {
#	puts "warping to [list [$self set timepanel_] format $newtime]"
	$self instvar mgr_ browsePage_
	$mgr_ warp_time $browsePage_ $newtime
}

#
# Track this $src if $trackIt is 1, untrack it if 0
#  When a source is being tracked, and it switches page, we will follow
#
# NOTE: right now we only handle one source at a time
MBUI instproc track {src trackIt} {
	$self instvar srcToTrack_ mgr_
	if {$trackIt} {
		set srcToTrack_ $src
	} else {
		set srcToTrack_ {}
	}
	$mgr_ track $src $trackIt
}


MBUI instproc source_list { } {
	return [$self set srcList_]
}
