# ui-dcthumbnailservice.tcl --
#
#       Stuff for what to do when a service is activated from the thumbnail
#       pane.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Class CDcUIThumbnail/Service -superclass CDcUIThumbnail

##############################################################################
#
# CDcUIThumbnail/Service public init { appDc uiMain winFrame } {
#
# Input:
# appDc - the dc application
# uiMain - the main ui object; in this case CDcUI
# winFrame - the frame in which to put everything into
#
# Output:
# none
#
# Description:
# construstor
# this object represents to thumbnail which will reside on the bottom half
# of the list of thumbnail.  I represents a none video Thumbnail and if
# clicked on will pop a window that will give controls to some service
#
##############################################################################
CDcUIThumbnail/Service public init { appDc uiMain winFrame } {
    $self next $appDc $uiMain $winFrame

    $self instvar m_service

    # intialize some variables
    set m_service 0
}

##############################################################################
#
# CDcUIThumbnail/Service public SynServiceImage { service } {
#
# Input:
# service - the service object to start
#
# Output:
# none
#
# Description:
# preliminarily called by CDcUIThumbnailFrame object, it will start the
# service.  In other words, call the service to start what ever it needs
# to do.
#
##############################################################################
CDcUIThumbnail/Service public StartService { service } {
    $self instvar m_service

    set m_service $service

    # I need to figure out how to represent this service
    # it can be as simple as a text that has the name of the service
    # or I can envision an animated gif

    # map the necessary messages
    $m_service MapMessage "SYN_SERVICE_IMAGE" $self "SynServiceImage"
    $m_service MapMessage "GET_UI_WINDOW" $self "BuildWindow"

    # send the request to start
    $m_service Send "SYN_SERVICE_IMAGE" ""
}


##############################################################################
#
# CDcUIThumbnail/Service public SynServiceImage { service arguments } {
#
# Input:
# service - the service that called this function
# arguments - the arguments that go along with this function call
#
# Output:
# none
#
# Description:
# A callback function.  It will essentially be called by the remote service.
# The main functionality is to set up the thumbnail image that represents
# this service object.
#
# The protocal will be as follow, the first word is the type of the image
# and if followed by other information depending on the type: ie. text Title
#
##############################################################################
CDcUIThumbnail/Service public SynServiceImage { service arguments } {
    $self instvar m_winFrame
    $self instvar m_service

    set type [lindex $arguments 0]
    set font [[$self options] get_option smallfont]

    switch -exact -- $type {
	text {
	    set frameButton [button $m_winFrame.thumbnail \
		    -text [lindex $arguments 1] \
		    -font $font \
		    -command "$self BuildWindow $m_service 0"]
	    pack $frameButton -side top -fill x
	}
    }
}

##############################################################################
#
# CDcUIThumbnail/Service public BuildWindow { service arguments}
#
# Input:
# service - the service object that called this function
# arguments - the arguments that come with the function call
#
# Output:
# none
#
# Description:
# Called by the remote service to build up the window for there service
#
##############################################################################
CDcUIThumbnail/Service public BuildWindow { service arguments} {
    $self instvar m_service
    $self instvar m_winFrame


    # first check arguments is 0
    if { $arguments == 0 } {
	$m_service Send "GET_UI_WINDOW" ""
	return
    }

    # ok now have the instructions for the window
    # delete the existing window if there is one

    # replace all .'s with _'s to I can have a unique top window name
    regsub -all -- {\.} $m_winFrame {_} winFrame

    if { [winfo exists $winFrame]} {
	destroy $winFrame
    }

    set winFrame [toplevel .$winFrame]
    set service $m_service
    eval $arguments
}



Class CDcUIThumbnail/Service/Replay -superclass CDcUIThumbnail/Service

CDcUIThumbnail/Service/Replay public init { appDc uiMain winFrame } {
    $self next $appDc $uiMain $winFrame
}

CDcUIThumbnail/Service/Replay public StartService { service } {
    $self next $service
}

##############################################################################
#
# CDcUIThumbnail/Service/Replay public BuildWindow { service arguments}
#
# Input:
# service - the service object that called this function
# arguments - the arguments that come with the function call
#
# Output:
# none
#
# Description:
# Called by the remote service to build up the window for there service
#
##############################################################################
CDcUIThumbnail/Service/Replay public BuildWindow { service arguments} {
    $self instvar m_service
    $self instvar m_winFrame

    # first check arguments is 0
    if { $arguments == 0 } {
	$m_service Send "GET_UI_WINDOW" ""
	return
    }

    # ok now have the instructions for the window
    # delete the existing window if there is one

    # replace all .'s with _'s to I can have a unique top window name
    regsub -all -- {\.} $m_winFrame {_} winFrame

    if { [winfo exists .$winFrame] } {
	destroy .$winFrame
    }

    set winFrame [toplevel .$winFrame]
    set service $m_service
    eval $arguments
}



Class CDcUIThumbnail/Service/SpecialFx -superclass CDcUIThumbnail/Service

CDcUIThumbnail/Service/SpecialFx public init { appDc uiMain winFrame } {
    $self next $appDc $uiMain $winFrame
}

CDcUIThumbnail/Service/SpecialFx public StartService { service } {
    $self next $service
}

##############################################################################
#
# CDcUIThumbnail/Service/SpecialFx public BuildWindow { service arguments}
#
# Input:
# service - the service object that called this function
# arguments - the arguments that come with the function call
#
# Output:
# none
#
# Description:
# Called by the remote service to build up the window for there service
#
##############################################################################
CDcUIThumbnail/Service/SpecialFx public BuildWindow { service arguments} {
    $self instvar m_uiMain
    $self instvar m_service
    $self instvar m_winFrame

    # first check arguments is 0
    if { $arguments == 0 } {
	$m_service Send "GET_UI_WINDOW" ""
	return
    }

    # get the list of source id's
    set uiThumbnailFrame [$m_uiMain set m_uiThumbnailFrame]
    set liSourceId [$uiThumbnailFrame GetSourceIDs]

    # ok now have the instructions for the window
    # delete the existing window if there is one

    # replace all .'s with _'s to I can have a unique top window name
    regsub -all -- {\.} $m_winFrame {_} winFrame

    if { [winfo exists .$winFrame] } {
	destroy .$winFrame
    }

    puts "length of liSourceID is [llength $liSourceId] \n"
    set winFrame [toplevel .$winFrame]
    set service $m_service
    eval $arguments
}

