# ui-mbv2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/mbv2/ui-mbv2.tcl,v 1.15 2002/02/03 04:21:59 lim Exp $


import MBv2Tools_ToolBar ImageTextButton MbIcons MBv2Properties DropDown \
		MBv2CanvasMgr Icons


Class MBv2UI

MBv2UI public init { path } {
	$self next
	$self init_default
	frame $path -class MBv2UI -width 600 -height 500
	pack propagate $path false

	$self instvar props_ canvmgr_ tools_toolbar_

	frame $path.props
	set props_ [new MBv2Properties $path.props]
	pack $path.props -fill x -side top

	set tools_toolbar_ [MBv2Tools_ToolBar $path.toolbar]
	pack $path.toolbar -side right -fill y

	set canvmgr_ [MBv2CanvasMgr $path.canvmgr -scrollbar both]
	$canvmgr_ build_toolbar $path.props
	#$canvmgr_ sender $FIXME
	pack $canvmgr_ -side left -fill both -expand 1

	# attach observers
	$canvmgr_ attach_observer $tools_toolbar_
	# notify the tools of the original canvas
	$tools_toolbar_ switch_canvas [$canvmgr_ get_canvas none] none

	$self set recv_only_ 0
	$self enable_session 0
}


MBv2UI public init_default { } {
	set cl MBv2UI
	option add *${cl}*Button*borderWidth 1
	option add *${cl}*Menubutton*borderWidth 1
	option add *${cl}*DropDown/Text*borderWidth 1

	option add *${cl}*Button*highlightThickness 1
	option add *${cl}*Menubutton*highlightThickness 1
	option add *${cl}*DropDown/Text.highlightThickness 1

	option add *${cl}*ImageTextButton*borderWidth 1
	option add *${cl}*ImageTextButton*Button*borderWidth 0
	option add *${cl}*ImageTextButton*highlightThickness 1
	option add *${cl}*ImageTextButton*Button*highlightThickness 0

	option add *Menu*font {Helvetica 10 bold}
	option add *Menu*borderWidth 1
	option add *Menu*activeBorderWidth 1
	option add *Menu*tearOff 0
	option add *Menu*padY 0
	option add *Menu*pady 0

	# the image in the About messagebox has been tuned for the
	# default Tk background of d9d9d9; so we must ensure that
	# the message box does pop up in that background
	option add *MessageBox*background \#d9d9d9
}


MBv2UI public recv_only { flag } {
	$self instvar recv_only_ canvmgr_
	if { $recv_only_ == $flag } return

	set recv_only_ $flag
	$canvmgr_ recv_only $flag
}


MBv2UI public enable_session { f } {
	$self instvar props_ canvmgr_ tools_toolbar_
	$props_ enable_session $f
	$canvmgr_ enable_session $f
	$tools_toolbar_ enable_session $f
}


MBv2UI public session { s } {
	$self instvar session_ sender_ canvmgr_ props_ tools_toolbar_ menu_
	set session_ $s
	set sender_ [$s sender]
	$canvmgr_ sender $sender_
	$tools_toolbar_ sender $sender_
	$tools_toolbar_ properties $props_

	$session_ canvasmgr $canvmgr_
	$session_ attach_observer $canvmgr_

	$self enable_session 1

	$session_ drop_probability 0.0
	if [info exists menu_] { $self enable_menu $menu_ }
}


MBv2UI public exit { } {
	exit
}


MBv2UI public create_menu { path } {
	$self instvar menu_

	# in mplug mode, if the toplevel is . we will have problems making
	# $path.menu the menu of the toplevel, so let's just make a menu
	# button for it
	global mash
	if { [info exists mash(environ)] && $mash(environ)=="mplug" && \
			[winfo toplevel $path]=="." } {
		set parent [winfo parent $path]
		menu $parent.menu -type menubar
		$self build_menu $parent.menu
		pack $parent.menu -side top -fill x
		set menu_ $parent.menu
	} else {
		set top [winfo toplevel $path]
		if { $top == "." } { set menu .menu } else {set menu $top.menu}
		menu $menu -type menubar
		$self build_menu $menu
		$top configure -menu $menu
		set menu_ $menu
	}
}


MBv2UI public build_menu { menu } {
	$self instvar tools_toolbar_ canvmgr_
	set select [$tools_toolbar_ tool MBv2SelectTool]

	$menu add cascade -label "File" -menu $menu.file
	menu $menu.file
	$menu.file add command -label "Save..." -state disabled
	$menu.file add command -label "Save as postscript..." -command \
			"$canvmgr_ save_as_postscript"
	$menu.file add separator
	$menu.file add command -label "Quit" -command "$self exit"


	$menu add cascade -label "Edit" -menu $menu.edit -state disabled
	menu $menu.edit -postcommand "$self configure_edit_menu $menu.edit"
	$menu.edit add command -label "Undo"   -accelerator <Ctl-Z> \
			-command "$tools_toolbar_ undo" -state disabled
	$menu.edit add command -label "Redo"   -accelerator <Shift-Ctl-Z> \
			-command "$tools_toolbar_ redo" -state disabled
	$menu.edit add separator
	$menu.edit add command -label "Cut"    -accelerator <Ctl-X> \
			-command "$select cut"   -state disabled
	$menu.edit add command -label "Copy"   -accelerator <Ctl-C> \
			-command "$select copy"  -state disabled
	$menu.edit add command -label "Paste"  -accelerator <Ctl-V> \
			-command "$select paste" -state disabled
	$menu.edit add command -label "Delete" -accelerator <Del>   \
			-command "$select delete" -state disabled
	$menu.edit add separator
	$menu.edit add cascade -label "Ordering" -menu $menu.edit.order \
			-state disabled

	menu $menu.edit.order
	$menu.edit.order add command -label "Bring to front"
	$menu.edit.order add command -label "Send to back"
	$menu.edit.order add command -label "Bring forward"
	$menu.edit.order add command -label "Send backward"


	$menu add cascade -label "Tools" -menu $menu.tools -state disabled
	menu $menu.tools
	$menu.tools add command -label "Freehand/Text" -command \
			"$tools_toolbar_ invoke MBv2DrawTextTool"
	$menu.tools add command -label "Arrow" -command \
			"$tools_toolbar_ invoke MBv2ArrowTool"
	$menu.tools add command -label "Rectangle" -command \
			"$tools_toolbar_ invoke MBv2RectTool"
	$menu.tools add command -label "Oval" -command \
			"$tools_toolbar_ invoke MBv2OvalTool"
	$menu.tools add command -label "Select" -command \
			"$tools_toolbar_ invoke MBv2SelectTool"
	$menu.tools add cascade -label "Insert..." -menu $menu.tools.insert

	menu $menu.tools.insert
	$menu.tools.insert add command -label "Image..." -command \
			"$self import image"
	$menu.tools.insert add command -label "Text..." -command \
			"$self import text"


	$menu add cascade -label "Options" -menu $menu.options -state disabled
	menu $menu.options -postcommand \
			"$self configure_options_menu $menu.options"
	$self tkvar show_lists_
	set show_lists_ 0
	$menu.options add checkbutton -label "Show member/page lists" \
			-variable [$self tkvarname show_lists_] -command\
			"$canvmgr_ show_lists \[set [$self tkvarname \
			show_lists_]\]"
	$self tkvar show_tips_dummy_
	set show_tips_ 1
	$menu.options add checkbutton -label "Show balloon help" \
			-variable [$self tkvarname show_tips_] \
			-command "TipManager enable \[set [$self tkvarname \
			show_tips_]\]"
	$menu.options add cascade -label "Show owner of item..." \
			-menu $menu.options.tips
	menu $menu.options.tips
	$self tkvar tips_when_drawn_ tips_under_cursor_
	$menu.options.tips add checkbutton -label "when drawn" \
			-variable [$self tkvarname tips_when_drawn_] -command \
			"$self show_owner_when_drawn \
			\[set [$self tkvarname tips_when_drawn_]\]"
	$menu.options.tips add checkbutton -label "under cursor (Select mode)"\
			-variable [$self tkvarname tips_under_cursor_] \
			-command "$self show_owner_under_cursor \
			\[set [$self tkvarname tips_under_cursor_]\]"
	set tips_when_drawn_   1; $self show_owner_when_drawn   1
	set tips_under_cursor_ 1; $self show_owner_under_cursor 1

	$menu.options add command -label "Simulate packet drop..." -command \
			"$self simulate_packet_drop"

	$menu add cascade -label "Help" -menu $menu.help
	menu $menu.help
	$menu.help add command -label "About..." -command "$self about"
}


MBv2UI public enable_menu { menu } {
	$self instvar session_
	$menu entryconfigure "Edit"    -state normal
	$menu entryconfigure "Tools"   -state normal
	$menu entryconfigure "Options" -state normal

	# check if we are in debug mode or not by trying to set the drop
	# probability; if the drop probability remains at 0.0, that means
	# the srm_set_drop_probability function is a nop (i.e. non-debug mode)
	set orig_drop [$session_ drop_probability 1.0]
	if { [$session_ drop_probability] == 0.0 } {
		# disable the "simulate packet drop" method
		$menu.options entryconfigure "Simulate packet drop*" \
				-state disabled
	}
	$session_ drop_probability $orig_drop
}


MBv2UI public simulate_packet_drop { } {
	$self instvar drop_dlg_ session_

	if ![info exists drop_dlg_] {
		set drop_dlg_ [Dialog/PacketDrop .dropdlg]
	}

	set drop [$session_ drop_probability]
	$drop_dlg_ drop $drop
	set drop [$drop_dlg_ invoke]
	if { $drop != {} } {
		$session_ drop_probability $drop
	}
}


#FIXME
MBv2UI public tools_toolbar { } {
	$self instvar tools_toolbar_
	return $tools_toolbar_
}


#FIXME
MBv2UI public canvmgr { } {
	$self instvar canvmgr_
	return $canvmgr_
}


MBv2UI public show_owner_when_drawn {f} {
	$self instvar canvmgr_
	$canvmgr_ show_owner_when_drawn $f
}


MBv2UI public show_owner_under_cursor {f} {
	$self instvar tools_toolbar_
	[$tools_toolbar_ tool MBv2SelectTool] show_owner_under_cursor $f
}


MBv2UI public configure_edit_menu { menu } {
	$self instvar tools_toolbar_

	set ur [$tools_toolbar_ get_undo_state]
	if [lindex $ur 0] { set state normal } else { set state disabled }
	$menu entryconfigure "Undo*" -state $state
	if [lindex $ur 1] { set state normal } else { set state disabled }
	$menu entryconfigure "Redo*" -state $state

	set t [$tools_toolbar_ tool MBv2SelectTool]
	set state [$t selection_available]
	if $state { set state normal } else { set state disabled }
	$menu entryconfigure "Cut*"      -state $state
	$menu entryconfigure "Copy*"     -state $state
	$menu entryconfigure "Delete*"   -state $state
	$menu entryconfigure "Ordering*" -state $state

	set state [$t clipboard_available]
	if $state { set state normal } else { set state disabled }
	$menu entryconfigure "Paste*" -state $state
}


MBv2UI public configure_options_menu { menu } {
	$self instvar canvmgr_ tools_toolbar_

	$self tkvar show_lists_ show_tips_ tips_when_drawn_ tips_under_cursor_
	set show_lists_ [$canvmgr_ show_lists]
	set show_tips_  [TipManager is_enabled]
	set tips_when_drawn_ [$canvmgr_ show_owner_when_drawn]
	set tips_under_cursor_ [[$tools_toolbar_ tool MBv2SelectTool] \
			show_owner_under_cursor]
}


MBv2UI public import { what } {
	$self instvar tools_toolbar_
	set t [$tools_toolbar_ tool MBv2ImportTool]
	$t next_import_as $what
	$t invoke
}


MBv2UI public about { } {
	global mash
	if [info exists mash(version)] {
		set v $mash(version)
	} else {
		set v ?
	}
	set text "The Mash MediaBoard v2.0\
			\nMash Version $v\
			\nOpen Mash Consortium\
			\n\n<http://www.openmash.org/>"
	set cnt 0
	while [winfo exists .about$cnt] { incr cnt }
	set about .about$cnt
	MessageBox $about -image MbIcons(logo) -text $text \
			-options { {text.wraplength 0 } } \
			-title "About MediaBoard..."
	pack configure [$about subwidget image] -padx 10 -pady 10
	pack configure [$about subwidget text ] -padx 10 -pady 10
	pack configure [$about subwidget ok   ] -pady 10
	$about invoke
	destroy $about
}



WidgetClass Dialog/PacketDrop -superclass Dialog -default {
	{ .title "Simulate packet drop" }
	{ *ImageTextButton.borderWidth 1 }
	{ *Entry.borderWidth 1 }
}


Dialog/PacketDrop public build_widget { path } {
	frame $path.f1
	frame $path.f2
	frame $path.sep -bd 2 -height 2 -relief ridge
	label $path.label -text "Drop probability\n(0.0 - 1.0)" -justify left \
			-anchor w
	entry $path.entry -width 6 -textvariable [$self tkvarname drop_]
	ImageTextButton $path.ok -text "Ok" -image Icons(check) \
			-command "$self ok"
	ImageTextButton $path.cancel -text "Cancel" -image Icons(cross) \
			-command "$self cancel"
	pack $path.label -in $path.f1 -anchor n -side left -padx 3
	pack $path.entry -in $path.f1 -anchor n -side left -fill x -expand 1 \
			-padx 3
	pack $path.ok $path.cancel -padx 3 -in $path.f2 -side left

	pack $path.f1 -fill both -expand 1 -padx 10 -pady 10
	pack propagate $path.sep false
	pack $path.sep -fill x -padx 2
	pack $path.f2 -anchor e -padx 5 -pady 10

	bind $path <Key-Return> "$self ok"
	bind $path <Key-Escape> "$self cancel"
}


Dialog/PacketDrop public drop { d } {
	$self tkvar drop_
	set drop_ $d
}


Dialog/PacketDrop public ok { } {
	$self tkvar drop_
	if { [regexp {^[0-9]+$} $drop_] || ([regexp {^[0-9]*.[0-9]*$} $drop_] \
			&& $drop_ != ".") } {
		if { $drop_ > 1.0 } {
			set drop_ 1.0
		}

		$self configure -result $drop_
	} else {
		set drop_ 0.0
	}
}
