# application-cam-srvr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/camera-server/application-cam-srvr.tcl,v 1.4 2002/02/03 04:21:42 lim Exp $


import CameraServer

Class CameraServerApplication -superclass Application


CameraServerApplication public init {argv} {
	$self next cameraserver
	global argv0

	set o [$self options]
	$o register_option -camtype camtype
	$o add_default camtype SerialChannel/Camera-Sony-EVID30
	$o register_option -serialdevice serialdevice
	$o add_default serialdevice /dev/cuac00
	$o register_option -rendez rendez
	$o register_option -uniqid uniqid
	$o register_option -camname camname
	$o add_default camname "[localaddr]"
	set argv [$o parse_args $argv]

	if {$argv == "" || [llength $argv] != 1} {
		puts "Usage: $argv0 address_spec"
		foreach arg [$o arg_info] {
			puts $arg
		}
		exit
	}

	set camtype [$self get_option camtype]
	set serialdevice [$self get_option serialdevice]
	puts "CameraServer $argv $serialdevice $camtype"
	set srvr_ [new CameraServer $argv $serialdevice $camtype]

	set rendez [$self get_option rendez]
	if {$rendez != ""} {
		$srvr_ start_rendezvous_ads $rendez $argv
	}
}

