/*
 * pktbuf-srm.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <tclcl.h>

#include "config.h"
#include "pktbuf-srm.h"
#include "rtp.h"
#include "source-srm.h"
#include "ntp-time.h"
#include "pktbuf.h"


static class SRM_BufferPoolClass : public TclClass {
public:
    SRM_BufferPoolClass() : TclClass("BufferPool/SRM") {}
    virtual TclObject* create(int /*argc*/, const char*const* /*argv*/) {
	return (new SRM_BufferPool);
    }
} srm_bp_matcher;


/*
 *FIXME
 * Sequence numbers are static so when we change the encoding (which causes
 * new encoder to be allocated) we don't reset the sequence counter.
 * Otherwise, receivers will get confused, reset their stats, and generate
 * odd looking streams of reception reports (i.e., the packet counts will
 * drop back to 0).
 */
u_int16_t SRM_BufferPool::seqno_[NLAYER];


SRM_BufferPool::SRM_BufferPool() : sm_(0)
{
    for (int i = 0; i < NLAYER; ++i)
	seqno_[i] = 1;
}


int
SRM_BufferPool::command(int argc, const char*const* argv)
{
    if (argc == 3) {
	if (strcmp(argv[1], "source-manager") == 0) {
	    sm_ = (SRM_SourceManager*)TclObject::lookup(argv[2]);
	    return (TCL_OK);
	}
    }

    return (BufferPool::command(argc, argv));
}


void
SRM_BufferPool::seqno(u_int16_t s)
{
    /*FIXME*/
    for (int i = 0; i < NLAYER; ++i)
	seqno_[i] = s;
}


/*void SRM_BufferPool::initpkt(pktbuf *pb, u_int32_t ts,
                             int fmt, int layer)
{
    srmhdr* sh = (srmhdr*)pb->data;
    u_int16_t proto = SRM_PROTO << 14;
    u_int16_t flags = SRM_VERSION << 12 | proto;
    sh->sh_flags = htons(flags);
    sh->sh_seqno = htons(seqno_[0]);
    ++seqno_[0];
//	printf("Time now is %ul\n", ntptime());
    sh->sh_ts = htonl(ntptime());
//	printf("NTP time of packet number %d = %ul\n", seqno_[0], (u_int32_t)ntohl(sh->sh_ts));
    sh->sh_src.ss_uid = htonl(sm_->localsrc()->uid());
    // note: addr is always in network byte order
    sh->sh_src.ss_addr = sm_->localsrc()->addr();
    pb->dp = pb->data + sizeof(srmhdr);
}*/


void
SRM_BufferPool::inithdr(pktbuf *pb)
{
    srmhdr *sh = (srmhdr*)pb->data;

    u_int16_t flags = SRM_VERSION << 6|SRM_PROTO << 14|SRM_COMPAT_BIT << 12;
    sh->sh_flags = htons(flags);
    sh->sh_seqno = htons(seqno_[0]);
    ++seqno_[0];
    sh->sh_ts = htonl(ntptime());
    pb->dp = pb->data + sizeof(srmhdr);
}


void
SRM_BufferPool::sethdr(pktbuf *pb, const srm_src &sid, u_int16_t type)
{
    srmhdr *sh = (srmhdr*)pb->data;
    /*
     * Version and proto are already filled in by
     * the inithdr() function
     */
    u_int16_t flags    = ntohs(sh->sh_flags) & 0xF0FF;
    sh->sh_flags       = htons(flags | (type << 8));
    sh->sh_ts          = htonl(ntptime());
    sh->sh_src.ss_uid  = htonl(sid.ss_uid);
    sh->sh_src.ss_addr = sid.ss_addr;
}
